/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.schema.comparators;

import org.apache.directory.shared.asn1.primitives.OID;
import org.apache.directory.shared.ldap.schema.LdapComparator;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectIdentifierFirstComponentComparator
extends LdapComparator<String> {
    private static final Logger LOG = LoggerFactory.getLogger(ObjectIdentifierFirstComponentComparator.class);
    private static final long serialVersionUID = 1L;

    public ObjectIdentifierFirstComponentComparator(String oid) {
        super(oid);
    }

    private String getNumericOid(String s) {
        int pos = 0;
        if (!StringTools.isCharASCII(s, pos++, '(')) {
            return null;
        }
        while (StringTools.isCharASCII(s, pos, ' ')) {
            ++pos;
        }
        int start = pos;
        while (StringTools.isDigit(s, pos) || StringTools.isCharASCII(s, pos, '.')) {
            ++pos;
        }
        String numericOid = s.substring(start, pos);
        if (OID.isOID((String)numericOid)) {
            return numericOid;
        }
        return null;
    }

    @Override
    public int compare(String s1, String s2) {
        LOG.debug("comparing ObjectIdentifierFirstComponent objects '{}' with '{}'", (Object)s1, (Object)s2);
        if (s1 == null) {
            return s2 == null ? 0 : -1;
        }
        if (s2 == null) {
            return -1;
        }
        if (s1.equals(s2)) {
            return 0;
        }
        String oid1 = this.getNumericOid(s1);
        if (oid1 == null) {
            return -1;
        }
        String oid2 = this.getNumericOid(s2);
        if (oid2 == null) {
            return -1;
        }
        if (oid1.equals(oid2)) {
            return 0;
        }
        return -1;
    }
}

