/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.name;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.directory.shared.ldap.name.AVA;
import org.apache.directory.shared.ldap.name.AVASerializer;
import org.apache.directory.shared.ldap.name.RDN;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RdnSerializer {
    protected static final Logger LOG = LoggerFactory.getLogger(RdnSerializer.class);

    public static void serialize(RDN rdn, ObjectOutput out) throws IOException {
        out.writeInt(rdn.getNbAtavs());
        out.writeUTF(rdn.getName());
        out.writeUTF(rdn.getNormName());
        out.writeInt(rdn.getStart());
        out.writeInt(rdn.getLength());
        switch (rdn.getNbAtavs()) {
            case 0: {
                break;
            }
            case 1: {
                AVASerializer.serialize(rdn.getAtav(), out);
                break;
            }
            default: {
                for (AVA atav : rdn) {
                    AVASerializer.serialize(atav, out);
                }
            }
        }
    }

    public static RDN deserialize(ObjectInput in) throws IOException {
        int nbAtavs = in.readInt();
        String upName = in.readUTF();
        String normName = in.readUTF();
        if (StringTools.isEmpty(normName)) {
            normName = upName;
        }
        int start = in.readInt();
        int length = in.readInt();
        RDN rdn = new RDN(length, start, upName, normName);
        switch (nbAtavs) {
            case 0: {
                return rdn;
            }
            case 1: {
                AVA atav = AVASerializer.deserialize(in);
                rdn.addAttributeTypeAndValue(atav);
                return rdn;
            }
        }
        for (int i = 0; i < nbAtavs; ++i) {
            AVA atav = AVASerializer.deserialize(in);
            rdn.addAttributeTypeAndValue(atav);
        }
        return rdn;
    }
}

