/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.exception;

import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.exception.LdapOperationException;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;

public class LdapServiceUnavailableException
extends LdapOperationException {
    static final long serialVersionUID = 1L;

    public LdapServiceUnavailableException(ResultCodeEnum resultCode, String message) {
        super(message);
        this.checkResultCode(resultCode);
        this.resultCode = resultCode;
    }

    public LdapServiceUnavailableException(ResultCodeEnum resultCode) {
        super((String)null);
        this.checkResultCode(resultCode);
        this.resultCode = resultCode;
    }

    private void checkResultCode(ResultCodeEnum resultCode) {
        switch (resultCode) {
            case BUSY: 
            case UNAVAILABLE: {
                return;
            }
        }
        throw new IllegalArgumentException(I18n.err((String)"ERR_04140", (Object[])new Object[]{resultCode}));
    }
}

