/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.entry;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.entry.AbstractValue;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.exception.LdapException;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.LdapComparator;
import org.apache.directory.shared.ldap.schema.Normalizer;
import org.apache.directory.shared.ldap.schema.comparators.ByteArrayComparator;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinaryValue
extends AbstractValue<byte[]> {
    protected static final long serialVersionUID = 2L;
    protected static final Logger LOG = LoggerFactory.getLogger(BinaryValue.class);

    public BinaryValue() {
        this.wrappedValue = null;
        this.normalized = false;
        this.valid = null;
        this.normalizedValue = null;
    }

    public BinaryValue(AttributeType attributeType) {
        if (attributeType == null) {
            throw new IllegalArgumentException(I18n.err((String)"ERR_04442", (Object[])new Object[0]));
        }
        if (attributeType.getSyntax() == null) {
            throw new IllegalArgumentException(I18n.err((String)"ERR_04445", (Object[])new Object[0]));
        }
        if (attributeType.getSyntax().isHumanReadable()) {
            LOG.warn("Treating a value of a human readible attribute {} as binary: ", (Object)attributeType.getName());
        }
        this.attributeType = attributeType;
    }

    public BinaryValue(byte[] value) {
        if (value != null) {
            this.wrappedValue = new byte[value.length];
            System.arraycopy(value, 0, this.wrappedValue, 0, value.length);
        } else {
            this.wrappedValue = null;
        }
        this.normalized = false;
        this.valid = null;
        this.normalizedValue = null;
    }

    public BinaryValue(AttributeType attributeType, byte[] value) {
        this(attributeType);
        this.wrappedValue = value;
    }

    @Override
    public byte[] getNormalizedValueCopy() {
        if (this.isNull()) {
            return null;
        }
        if (!this.normalized) {
            try {
                this.normalize();
            }
            catch (LdapException ne) {
                String message = "Cannot normalize the value :" + ne.getLocalizedMessage();
                LOG.warn(message);
                this.normalized = false;
            }
        }
        if (this.normalizedValue != null) {
            byte[] copy = new byte[((byte[])this.normalizedValue).length];
            System.arraycopy(this.normalizedValue, 0, copy, 0, ((byte[])this.normalizedValue).length);
            return copy;
        }
        return StringTools.EMPTY_BYTES;
    }

    @Override
    public byte[] getNormalizedValueReference() {
        if (this.isNull()) {
            return null;
        }
        if (!this.isNormalized()) {
            try {
                this.normalize();
            }
            catch (LdapException ne) {
                String message = "Cannot normalize the value :" + ne.getLocalizedMessage();
                LOG.warn(message);
                this.normalized = false;
            }
        }
        if (this.normalizedValue != null) {
            return (byte[])this.normalizedValue;
        }
        return (byte[])this.wrappedValue;
    }

    @Override
    public byte[] getNormalizedValue() {
        return this.getNormalizedValueCopy();
    }

    @Override
    public final void normalize(Normalizer normalizer) throws LdapException {
        if (normalizer != null) {
            if (this.wrappedValue == null) {
                this.normalizedValue = this.wrappedValue;
                this.normalized = true;
                this.same = true;
            } else {
                this.normalizedValue = normalizer.normalize(this).getBytes();
                this.normalized = true;
                this.same = Arrays.equals((byte[])this.wrappedValue, (byte[])this.normalizedValue);
            }
        } else {
            this.normalizedValue = this.wrappedValue;
            this.normalized = false;
            this.same = true;
        }
    }

    @Override
    public void normalize() throws LdapException {
        if (this.isNormalized()) {
            return;
        }
        if (this.attributeType != null) {
            Normalizer normalizer = this.getNormalizer();
            this.normalize(normalizer);
        } else {
            this.normalizedValue = this.wrappedValue;
            this.normalized = true;
            this.same = true;
        }
    }

    @Override
    public int compareTo(Value<byte[]> value) {
        if (this.isNull()) {
            if (value == null || value.isNull()) {
                return 0;
            }
            return -1;
        }
        if (value == null || value.isNull()) {
            return 1;
        }
        BinaryValue binaryValue = (BinaryValue)value;
        if (this.attributeType != null) {
            try {
                LdapComparator<byte[]> comparator = this.getLdapComparator();
                if (comparator != null) {
                    return comparator.compare(this.getNormalizedValueReference(), binaryValue.getNormalizedValueReference());
                }
                return new ByteArrayComparator(null).compare(this.getNormalizedValueReference(), binaryValue.getNormalizedValueReference());
            }
            catch (LdapException e) {
                String msg = I18n.err((String)"ERR_04443", (Object[])new Object[]{Arrays.toString((byte[])this.getReference()), value});
                LOG.error(msg, (Throwable)e);
                throw new IllegalStateException(msg, e);
            }
        }
        return new ByteArrayComparator(null).compare(this.getNormalizedValue(), binaryValue.getNormalizedValue());
    }

    public int hashCode() {
        if (this.isNull()) {
            return 0;
        }
        byte[] normalizedValue = this.getNormalizedValueReference();
        int h = Arrays.hashCode(normalizedValue);
        return h;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BinaryValue)) {
            return false;
        }
        BinaryValue other = (BinaryValue)obj;
        if (this.isNull()) {
            return other.isNull();
        }
        if (this.attributeType != null) {
            if (other.attributeType != null) {
                if (!this.attributeType.equals(other.attributeType)) {
                    return false;
                }
            } else {
                other.attributeType = this.attributeType;
            }
        } else if (other.attributeType != null) {
            this.attributeType = other.attributeType;
        }
        if (Arrays.equals((byte[])this.wrappedValue, (byte[])other.wrappedValue)) {
            return true;
        }
        if (this.attributeType != null) {
            try {
                LdapComparator<byte[]> comparator = this.getLdapComparator();
                if (comparator == null) {
                    return Arrays.equals(this.getNormalizedValueReference(), other.getNormalizedValueReference());
                }
                return comparator.compare(this.getNormalizedValueReference(), other.getNormalizedValueReference()) == 0;
            }
            catch (LdapException ne) {
                return false;
            }
        }
        return Arrays.equals(this.getNormalizedValueReference(), other.getNormalizedValueReference());
    }

    @Override
    public BinaryValue clone() {
        BinaryValue clone = (BinaryValue)super.clone();
        if (this.normalizedValue != null) {
            clone.normalizedValue = new byte[((byte[])this.normalizedValue).length];
            System.arraycopy(this.normalizedValue, 0, clone.normalizedValue, 0, ((byte[])this.normalizedValue).length);
        }
        if (this.wrappedValue != null) {
            clone.wrappedValue = new byte[((byte[])this.wrappedValue).length];
            System.arraycopy(this.wrappedValue, 0, clone.wrappedValue, 0, ((byte[])this.wrappedValue).length);
        }
        return clone;
    }

    @Override
    public byte[] get() {
        if (this.wrappedValue == null) {
            return null;
        }
        byte[] copy = new byte[((byte[])this.wrappedValue).length];
        System.arraycopy(this.wrappedValue, 0, copy, 0, ((byte[])this.wrappedValue).length);
        return copy;
    }

    @Override
    public boolean isBinary() {
        return true;
    }

    @Override
    public int length() {
        return this.wrappedValue != null ? ((byte[])this.wrappedValue).length : 0;
    }

    @Override
    public byte[] getBytes() {
        return this.get();
    }

    @Override
    public String getString() {
        return StringTools.utf8ToString((byte[])this.wrappedValue);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int normalizedLength;
        int wrappedLength = in.readInt();
        if (wrappedLength >= 0) {
            this.wrappedValue = new byte[wrappedLength];
            if (wrappedLength > 0) {
                in.read((byte[])this.wrappedValue);
            }
        }
        this.normalized = in.readBoolean();
        if (this.normalized && (normalizedLength = in.readInt()) >= 0) {
            this.normalizedValue = new byte[normalizedLength];
            if (normalizedLength > 0) {
                in.read((byte[])this.normalizedValue);
            }
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        if (this.wrappedValue != null) {
            out.writeInt(((byte[])this.wrappedValue).length);
            if (((byte[])this.wrappedValue).length > 0) {
                out.write((byte[])this.wrappedValue, 0, ((byte[])this.wrappedValue).length);
            }
        } else {
            out.writeInt(-1);
        }
        if (this.normalized) {
            out.writeBoolean(true);
            if (this.normalizedValue != null) {
                out.writeInt(((byte[])this.normalizedValue).length);
                if (((byte[])this.normalizedValue).length > 0) {
                    out.write((byte[])this.normalizedValue, 0, ((byte[])this.normalizedValue).length);
                }
            } else {
                out.writeInt(-1);
            }
        } else {
            out.writeBoolean(false);
        }
    }

    public void serialize(ObjectOutput out) throws IOException {
        if (this.wrappedValue != null) {
            out.writeInt(((byte[])this.wrappedValue).length);
            if (((byte[])this.wrappedValue).length > 0) {
                out.write((byte[])this.wrappedValue);
                try {
                    this.normalize();
                    if (!this.normalized) {
                        out.writeBoolean(false);
                    } else {
                        out.writeBoolean(true);
                        if (Arrays.equals((byte[])this.getReference(), (byte[])this.normalizedValue)) {
                            out.writeBoolean(true);
                        } else {
                            out.writeBoolean(false);
                            out.writeInt(((byte[])this.normalizedValue).length);
                            if (((byte[])this.normalizedValue).length > 0) {
                                out.write((byte[])this.normalizedValue);
                            }
                        }
                    }
                }
                catch (LdapException ne) {
                    this.normalizedValue = null;
                    out.writeBoolean(false);
                }
            }
        } else {
            out.writeInt(-1);
        }
    }

    public void deserialize(ObjectInput in) throws IOException, ClassNotFoundException {
        int wrappedLength = in.readInt();
        if (wrappedLength == -1) {
            this.same = true;
            this.wrappedValue = null;
        } else if (wrappedLength == 0) {
            this.wrappedValue = StringTools.EMPTY_BYTES;
            this.same = true;
            this.normalized = true;
            this.normalizedValue = this.wrappedValue;
        } else {
            this.wrappedValue = new byte[wrappedLength];
            in.readFully((byte[])this.wrappedValue);
            this.normalized = in.readBoolean();
            if (this.normalized) {
                this.same = in.readBoolean();
                if (!this.same) {
                    int normalizedLength = in.readInt();
                    if (normalizedLength > 0) {
                        this.normalizedValue = new byte[normalizedLength];
                        in.read((byte[])this.normalizedValue, 0, normalizedLength);
                    } else {
                        this.normalizedValue = StringTools.EMPTY_BYTES;
                    }
                } else {
                    this.normalizedValue = new byte[wrappedLength];
                    System.arraycopy(this.wrappedValue, 0, this.normalizedValue, 0, wrappedLength);
                }
            }
        }
    }

    public String toString() {
        if (this.wrappedValue == null) {
            return "null";
        }
        if (((byte[])this.wrappedValue).length > 16) {
            byte[] copy = new byte[16];
            System.arraycopy(this.wrappedValue, 0, copy, 0, 16);
            return "'" + StringTools.dumpBytes(copy) + "...'";
        }
        return "'" + StringTools.dumpBytes((byte[])this.wrappedValue) + "'";
    }
}

