/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.helpers.FileUtils;
import org.apache.cxf.helpers.XMLUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class JAXBUtils {
    private JAXBUtils() {
    }

    private static Node innerJaxbBinding(Element schema) {
        String schemaNamespace = schema.getNamespaceURI();
        List annoList = DOMUtils.findAllElementsByTagNameNS((Element)schema, (String)schemaNamespace, (String)"annotation");
        Element annotation = null;
        annotation = annoList.size() > 0 ? (Element)annoList.get(0) : schema.getOwnerDocument().createElementNS(schemaNamespace, "annotation");
        List appList = DOMUtils.findAllElementsByTagNameNS((Element)annotation, (String)schemaNamespace, (String)"appinfo");
        Element appInfo = null;
        if (appList.size() > 0) {
            appInfo = (Element)appList.get(0);
        } else {
            appInfo = schema.getOwnerDocument().createElementNS(schemaNamespace, "appinfo");
            annotation.appendChild(appInfo);
        }
        Element jaxbBindings = null;
        List jaxbList = DOMUtils.findAllElementsByTagNameNS((Element)schema, (String)"http://java.sun.com/xml/ns/jaxb", (String)"schemaBindings");
        if (jaxbList.size() > 0) {
            jaxbBindings = (Element)jaxbList.get(0);
        } else {
            jaxbBindings = schema.getOwnerDocument().createElementNS("http://java.sun.com/xml/ns/jaxb", "schemaBindings");
            appInfo.appendChild(jaxbBindings);
        }
        return jaxbBindings;
    }

    public static Node innerJaxbPackageBinding(Element schema, String packagevalue) {
        Document doc = schema.getOwnerDocument();
        if (!XMLUtils.hasAttribute((Element)schema, (String)"http://java.sun.com/xml/ns/jaxb")) {
            Attr attr = schema.getOwnerDocument().createAttributeNS("http://java.sun.com/xml/ns/jaxb", "version");
            attr.setValue("2.0");
            schema.setAttributeNodeNS(attr);
        }
        Node schemaBindings = JAXBUtils.innerJaxbBinding(schema);
        List pkgList = DOMUtils.findAllElementsByTagNameNS((Element)schema, (String)"http://java.sun.com/xml/ns/jaxb", (String)"package");
        Element packagename = null;
        packagename = pkgList.size() > 0 ? (Element)pkgList.get(0) : doc.createElementNS("http://java.sun.com/xml/ns/jaxb", "package");
        packagename.setAttribute("name", packagevalue);
        schemaBindings.appendChild(packagename);
        return schemaBindings.getParentNode().getParentNode();
    }

    public static File getPackageMappingSchemaBindingFile(String namespace, String pkgName) {
        Document doc = DOMUtils.createDocument();
        Element rootElement = doc.createElement("schema");
        rootElement.setAttribute("xmlns", "http://www.w3.org/2001/XMLSchema");
        rootElement.setAttribute("xmlns:jaxb", "http://java.sun.com/xml/ns/jaxb");
        rootElement.setAttribute("jaxb:version", "2.0");
        rootElement.setAttribute("targetNamespace", namespace);
        Element annoElement = doc.createElement("annotation");
        Element appInfo = doc.createElement("appinfo");
        Element schemaBindings = doc.createElement("jaxb:schemaBindings");
        Element pkgElement = doc.createElement("jaxb:package");
        pkgElement.setAttribute("name", pkgName);
        annoElement.appendChild(appInfo);
        appInfo.appendChild(schemaBindings);
        schemaBindings.appendChild(pkgElement);
        rootElement.appendChild(annoElement);
        File tmpFile = null;
        try {
            tmpFile = FileUtils.createTempFile((String)"customzied", (String)".xsd");
            FileOutputStream fout = new FileOutputStream(tmpFile);
            DOMUtils.writeXml((Node)rootElement, (OutputStream)fout);
            fout.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return tmpFile;
    }
}

