/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2;

import org.apache.commons.vfs2.FileSelectInfo;
import org.apache.commons.vfs2.FileSelector;

public class FileDepthSelector
implements FileSelector {
    private final int minDepth;
    private final int maxDepth;

    public FileDepthSelector(int minDepth, int maxDepth) {
        this.minDepth = minDepth;
        this.maxDepth = maxDepth;
    }

    public FileDepthSelector(int minMaxDepth) {
        this(minMaxDepth, minMaxDepth);
    }

    public FileDepthSelector() {
        this(0, 0);
    }

    @Override
    public boolean includeFile(FileSelectInfo fileInfo) throws Exception {
        int depth = fileInfo.getDepth();
        return this.minDepth <= depth && depth <= this.maxDepth;
    }

    @Override
    public boolean traverseDescendents(FileSelectInfo fileInfo) throws Exception {
        return fileInfo.getDepth() < this.maxDepth;
    }
}

