/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.vertx.kafka;

import io.vertx.kafka.client.producer.KafkaProducer;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.vertx.kafka.VertxKafkaEndpoint;
import org.apache.camel.component.vertx.kafka.configuration.VertxKafkaConfiguration;
import org.apache.camel.component.vertx.kafka.operations.VertxKafkaProducerOperations;
import org.apache.camel.support.DefaultAsyncProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VertxKafkaProducer
extends DefaultAsyncProducer {
    private static final Logger LOG = LoggerFactory.getLogger(VertxKafkaProducer.class);
    private KafkaProducer<Object, Object> kafkaProducer;
    private VertxKafkaProducerOperations producerOperations;

    public VertxKafkaProducer(VertxKafkaEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    protected void doStart() {
        String brokers = this.getEndpoint().getComponent().getVertxKafkaClientFactory().getBootstrapBrokers(this.getConfiguration());
        if (brokers != null) {
            LOG.debug("Creating KafkaConsumer connecting to BootstrapBrokers: {}", (Object)brokers);
        }
        this.kafkaProducer = this.getEndpoint().getComponent().getVertxKafkaClientFactory().getVertxKafkaProducer(this.getEndpoint().getVertx(), this.getConfiguration().createProducerConfiguration());
        this.producerOperations = new VertxKafkaProducerOperations(this.kafkaProducer, this.getConfiguration());
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        try {
            return this.producerOperations.sendEvents(exchange.getIn(), recordMetadata -> exchange.getMessage().setHeader("CamelVertxKafkaRecordMetadata", recordMetadata), callback);
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
            callback.done(true);
            return true;
        }
    }

    protected void doStop() throws Exception {
        if (this.kafkaProducer != null) {
            this.kafkaProducer.close();
        }
        super.doStop();
    }

    public VertxKafkaEndpoint getEndpoint() {
        return (VertxKafkaEndpoint)super.getEndpoint();
    }

    public VertxKafkaConfiguration getConfiguration() {
        return this.getEndpoint().getConfiguration();
    }
}

