/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kubernetes.pods;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class KubernetesPodsEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":masterUrl";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;
    private static final Set<String> MULTI_VALUE_PREFIXES;

    public boolean isEnabled(String scheme) {
        return "kubernetes-pods".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax = scheme + BASE;
        Object uri = syntax;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, (String)uri, "masterUrl", null, true, copy);
        uri = this.buildQueryParameters((String)uri, copy, encode);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public Set<String> multiValuePrefixes() {
        return MULTI_VALUE_PREFIXES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(34);
        props.add("crdScope");
        props.add("crdVersion");
        props.add("portProtocol");
        props.add("caCertData");
        props.add("portName");
        props.add("dnsDomain");
        props.add("password");
        props.add("apiVersion");
        props.add("bridgeErrorHandler");
        props.add("clientCertData");
        props.add("caCertFile");
        props.add("clientKeyFile");
        props.add("connectionTimeout");
        props.add("kubernetesClient");
        props.add("crdPlural");
        props.add("poolSize");
        props.add("exchangePattern");
        props.add("resourceName");
        props.add("oauthToken");
        props.add("clientKeyAlgo");
        props.add("clientCertFile");
        props.add("lazyStartProducer");
        props.add("clientKeyData");
        props.add("masterUrl");
        props.add("crdGroup");
        props.add("crdName");
        props.add("namespace");
        props.add("labelValue");
        props.add("labelKey");
        props.add("exceptionHandler");
        props.add("operation");
        props.add("clientKeyPassphrase");
        props.add("trustCerts");
        props.add("username");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        HashSet<String> secretProps = new HashSet<String>(12);
        secretProps.add("password");
        secretProps.add("clientKeyData");
        secretProps.add("caCertData");
        secretProps.add("clientCertData");
        secretProps.add("caCertFile");
        secretProps.add("clientKeyFile");
        secretProps.add("oauthToken");
        secretProps.add("clientKeyPassphrase");
        secretProps.add("clientKeyAlgo");
        secretProps.add("clientCertFile");
        secretProps.add("trustCerts");
        secretProps.add("username");
        SECRET_PROPERTY_NAMES = Collections.unmodifiableSet(secretProps);
        MULTI_VALUE_PREFIXES = Collections.emptySet();
    }
}

