/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kubernetes.nodes;

import io.fabric8.kubernetes.api.model.Node;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.WatcherException;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import java.util.concurrent.ExecutorService;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.kubernetes.AbstractKubernetesEndpoint;
import org.apache.camel.component.kubernetes.KubernetesHelper;
import org.apache.camel.component.kubernetes.consumer.common.NodeEvent;
import org.apache.camel.support.DefaultConsumer;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesNodesConsumer
extends DefaultConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesNodesConsumer.class);
    private final Processor processor;
    private ExecutorService executor;
    private NodesConsumerTask nodesWatcher;

    public KubernetesNodesConsumer(AbstractKubernetesEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.processor = processor;
    }

    public AbstractKubernetesEndpoint getEndpoint() {
        return (AbstractKubernetesEndpoint)super.getEndpoint();
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.executor = this.getEndpoint().createExecutor();
        this.nodesWatcher = new NodesConsumerTask();
        this.executor.submit(this.nodesWatcher);
    }

    protected void doStop() throws Exception {
        super.doStop();
        LOG.debug("Stopping Kubernetes Nodes Consumer");
        if (this.executor != null) {
            KubernetesHelper.close(this.nodesWatcher, this.nodesWatcher::getWatch);
            if (this.getEndpoint() != null && this.getEndpoint().getCamelContext() != null) {
                this.getEndpoint().getCamelContext().getExecutorServiceManager().shutdownNow(this.executor);
            } else {
                this.executor.shutdownNow();
            }
        }
        this.executor = null;
    }

    class NodesConsumerTask
    implements Runnable {
        private Watch watch;

        NodesConsumerTask() {
        }

        @Override
        public void run() {
            NonNamespaceOperation w = KubernetesNodesConsumer.this.getEndpoint().getKubernetesClient().nodes();
            if (ObjectHelper.isNotEmpty((Object)KubernetesNodesConsumer.this.getEndpoint().getKubernetesConfiguration().getLabelKey()) && ObjectHelper.isNotEmpty((Object)KubernetesNodesConsumer.this.getEndpoint().getKubernetesConfiguration().getLabelValue())) {
                w.withLabel(KubernetesNodesConsumer.this.getEndpoint().getKubernetesConfiguration().getLabelKey(), KubernetesNodesConsumer.this.getEndpoint().getKubernetesConfiguration().getLabelValue());
            }
            ObjectHelper.ifNotEmpty((Object)KubernetesNodesConsumer.this.getEndpoint().getKubernetesConfiguration().getResourceName(), arg_0 -> ((NonNamespaceOperation)w).withName(arg_0));
            this.watch = w.watch((Object)new Watcher<Node>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void eventReceived(Watcher.Action action, Node resource) {
                    NodeEvent ne = new NodeEvent(action, resource);
                    Exchange exchange = KubernetesNodesConsumer.this.createExchange(false);
                    exchange.getIn().setBody((Object)ne.getNode());
                    exchange.getIn().setHeader("CamelKubernetesEventAction", (Object)ne.getAction());
                    exchange.getIn().setHeader("CamelKubernetesEventTimestamp", (Object)System.currentTimeMillis());
                    try {
                        KubernetesNodesConsumer.this.processor.process(exchange);
                    }
                    catch (Exception e) {
                        KubernetesNodesConsumer.this.getExceptionHandler().handleException("Error during processing", exchange, (Throwable)e);
                    }
                    finally {
                        KubernetesNodesConsumer.this.releaseExchange(exchange, false);
                    }
                }

                public void onClose(WatcherException cause) {
                    if (cause != null) {
                        LOG.error(cause.getMessage(), (Throwable)cause);
                    }
                }
            });
        }

        public Watch getWatch() {
            return this.watch;
        }

        public void setWatch(Watch watch) {
            this.watch = watch;
        }
    }
}

