/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.openshift.build_configs;

import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.FilterWatchListMultiDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.openshift.api.model.BuildConfig;
import io.fabric8.openshift.api.model.BuildConfigList;
import io.fabric8.openshift.client.OpenShiftClient;
import io.fabric8.openshift.client.dsl.BuildConfigResource;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.kubernetes.AbstractKubernetesEndpoint;
import org.apache.camel.component.kubernetes.KubernetesHelper;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenshiftBuildConfigsProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(OpenshiftBuildConfigsProducer.class);

    public OpenshiftBuildConfigsProducer(AbstractKubernetesEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    public AbstractKubernetesEndpoint getEndpoint() {
        return (AbstractKubernetesEndpoint)super.getEndpoint();
    }

    public void process(Exchange exchange) throws Exception {
        String operation;
        switch (operation = KubernetesHelper.extractOperation(this.getEndpoint(), exchange)) {
            case "listBuildConfigs": {
                this.doList(exchange);
                break;
            }
            case "listBuildConfigsByLabels": {
                this.doListBuildConfigsByLabels(exchange);
                break;
            }
            case "getBuildConfig": {
                this.doGetBuildConfig(exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation " + operation);
            }
        }
    }

    protected void doList(Exchange exchange) {
        BuildConfigList buildConfigsList = (BuildConfigList)((FilterWatchListMultiDeletable)((OpenShiftClient)this.getEndpoint().getKubernetesClient().adapt(OpenShiftClient.class)).buildConfigs().inAnyNamespace()).list();
        exchange.getMessage().setBody((Object)buildConfigsList.getItems());
    }

    protected void doListBuildConfigsByLabels(Exchange exchange) {
        BuildConfigList buildConfigsList = null;
        Map labels = (Map)exchange.getIn().getHeader("CamelKubernetesBuildConfigsLabels", Map.class);
        String namespaceName = (String)exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        buildConfigsList = !ObjectHelper.isEmpty((Object)namespaceName) ? (BuildConfigList)((FilterWatchListDeletable)((NonNamespaceOperation)((OpenShiftClient)this.getEndpoint().getKubernetesClient().adapt(OpenShiftClient.class)).buildConfigs().inNamespace(namespaceName)).withLabels(labels)).list() : (BuildConfigList)((FilterWatchListDeletable)((FilterWatchListMultiDeletable)((OpenShiftClient)this.getEndpoint().getKubernetesClient().adapt(OpenShiftClient.class)).buildConfigs().inAnyNamespace()).withLabels(labels)).list();
        KubernetesHelper.prepareOutboundMessage(exchange, buildConfigsList.getItems());
    }

    protected void doGetBuildConfig(Exchange exchange) {
        BuildConfig buildConfig = null;
        String buildConfigName = (String)exchange.getIn().getHeader("CamelKubernetesBuildConfigName", String.class);
        String namespaceName = (String)exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        if (ObjectHelper.isEmpty((Object)buildConfigName)) {
            LOG.error("Get a specific Build Config require specify a Build Config name");
            throw new IllegalArgumentException("Get a specific Build Config require specify a Build Config name");
        }
        if (ObjectHelper.isEmpty((Object)namespaceName)) {
            LOG.error("Get a specific Build Config require specify a namespace name");
            throw new IllegalArgumentException("Get a specific Build Config require specify a namespace name");
        }
        buildConfig = (BuildConfig)((BuildConfigResource)((NonNamespaceOperation)((OpenShiftClient)this.getEndpoint().getKubernetesClient().adapt(OpenShiftClient.class)).buildConfigs().inNamespace(namespaceName)).withName(buildConfigName)).get();
        KubernetesHelper.prepareOutboundMessage(exchange, buildConfig);
    }
}

