/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kubernetes.service_accounts;

import io.fabric8.kubernetes.api.model.ServiceAccount;
import io.fabric8.kubernetes.api.model.ServiceAccountList;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.FilterWatchListMultiDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.kubernetes.AbstractKubernetesEndpoint;
import org.apache.camel.component.kubernetes.KubernetesHelper;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesServiceAccountsProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesServiceAccountsProducer.class);

    public KubernetesServiceAccountsProducer(AbstractKubernetesEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    public AbstractKubernetesEndpoint getEndpoint() {
        return (AbstractKubernetesEndpoint)super.getEndpoint();
    }

    public void process(Exchange exchange) throws Exception {
        String operation;
        switch (operation = KubernetesHelper.extractOperation(this.getEndpoint(), exchange)) {
            case "listServiceAccounts": {
                this.doList(exchange);
                break;
            }
            case "listServiceAccountsByLabels": {
                this.doListServiceAccountsByLabels(exchange);
                break;
            }
            case "getSecret": {
                this.doGetServiceAccount(exchange);
                break;
            }
            case "createServiceAccount": {
                this.doCreateServiceAccount(exchange);
                break;
            }
            case "deleteServiceAccount": {
                this.doDeleteServiceAccount(exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation " + operation);
            }
        }
    }

    protected void doList(Exchange exchange) {
        ServiceAccountList saList = (ServiceAccountList)((FilterWatchListMultiDeletable)this.getEndpoint().getKubernetesClient().serviceAccounts().inAnyNamespace()).list();
        KubernetesHelper.prepareOutboundMessage(exchange, saList.getItems());
    }

    protected void doListServiceAccountsByLabels(Exchange exchange) {
        ServiceAccountList saList = null;
        Map labels = (Map)exchange.getIn().getHeader("CamelKubernetesServiceAccountsLabels", Map.class);
        String namespaceName = (String)exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        saList = !ObjectHelper.isEmpty((Object)namespaceName) ? (ServiceAccountList)((FilterWatchListDeletable)((NonNamespaceOperation)this.getEndpoint().getKubernetesClient().serviceAccounts().inNamespace(namespaceName)).withLabels(labels)).list() : (ServiceAccountList)((FilterWatchListDeletable)((FilterWatchListMultiDeletable)this.getEndpoint().getKubernetesClient().serviceAccounts().inAnyNamespace()).withLabels(labels)).list();
        KubernetesHelper.prepareOutboundMessage(exchange, saList.getItems());
    }

    protected void doGetServiceAccount(Exchange exchange) {
        ServiceAccount sa = null;
        String saName = (String)exchange.getIn().getHeader("CamelKubernetesServiceAccountName", String.class);
        String namespaceName = (String)exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        if (ObjectHelper.isEmpty((Object)saName)) {
            LOG.error("Get a specific Service Account require specify a Service Account name");
            throw new IllegalArgumentException("Get a specific Service Account require specify a Service Account name");
        }
        if (ObjectHelper.isEmpty((Object)namespaceName)) {
            LOG.error("Get a specific Service Account require specify a namespace name");
            throw new IllegalArgumentException("Get a specific Service Account require specify a namespace name");
        }
        sa = (ServiceAccount)((Resource)((NonNamespaceOperation)this.getEndpoint().getKubernetesClient().serviceAccounts().inNamespace(namespaceName)).withName(saName)).get();
        KubernetesHelper.prepareOutboundMessage(exchange, sa);
    }

    protected void doCreateServiceAccount(Exchange exchange) {
        ServiceAccount sa = null;
        String namespaceName = (String)exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        ServiceAccount saToCreate = (ServiceAccount)exchange.getIn().getHeader("CamelKubernetesServiceAccount", ServiceAccount.class);
        if (ObjectHelper.isEmpty((Object)namespaceName)) {
            LOG.error("Create a specific Service Account require specify a namespace name");
            throw new IllegalArgumentException("Create a specific Service Account require specify a namespace name");
        }
        if (ObjectHelper.isEmpty((Object)saToCreate)) {
            LOG.error("Create a specific Service Account require specify a Service Account bean");
            throw new IllegalArgumentException("Create a specific Service Account require specify a Service Account bean");
        }
        sa = (ServiceAccount)((NonNamespaceOperation)this.getEndpoint().getKubernetesClient().serviceAccounts().inNamespace(namespaceName)).create((Object)saToCreate);
        KubernetesHelper.prepareOutboundMessage(exchange, sa);
    }

    protected void doDeleteServiceAccount(Exchange exchange) {
        String saName = (String)exchange.getIn().getHeader("CamelKubernetesServiceAccountName", String.class);
        String namespaceName = (String)exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        if (ObjectHelper.isEmpty((Object)saName)) {
            LOG.error("Delete a specific Service Account require specify a Service Account name");
            throw new IllegalArgumentException("Delete a specific Service Account require specify a Service Account name");
        }
        if (ObjectHelper.isEmpty((Object)namespaceName)) {
            LOG.error("Delete a specific Service Account require specify a namespace name");
            throw new IllegalArgumentException("Delete a specific Service Account require specify a namespace name");
        }
        boolean saDeleted = ((Resource)((NonNamespaceOperation)this.getEndpoint().getKubernetesClient().serviceAccounts().inNamespace(namespaceName)).withName(saName)).delete();
        KubernetesHelper.prepareOutboundMessage(exchange, saDeleted);
    }
}

