/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kubernetes;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.Watch;
import java.util.function.Supplier;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.kubernetes.AbstractKubernetesEndpoint;
import org.apache.camel.component.kubernetes.KubernetesConfiguration;
import org.apache.camel.support.MessageHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KubernetesHelper {
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesHelper.class);

    private KubernetesHelper() {
    }

    public static KubernetesClient getKubernetesClient(KubernetesConfiguration configuration) {
        if (configuration.getKubernetesClient() != null) {
            return configuration.getKubernetesClient();
        }
        if (configuration.getMasterUrl() != null) {
            return KubernetesHelper.createKubernetesClient(configuration);
        }
        LOG.info("Creating default kubernetes client without applying configuration");
        return new DefaultKubernetesClient();
    }

    private static KubernetesClient createKubernetesClient(KubernetesConfiguration configuration) {
        LOG.debug("Create Kubernetes client with the following Configuration: {}", (Object)configuration);
        ConfigBuilder builder = new ConfigBuilder();
        builder.withMasterUrl(configuration.getMasterUrl());
        if (ObjectHelper.isNotEmpty((Object)configuration.getUsername()) && ObjectHelper.isNotEmpty((Object)configuration.getPassword()) && ObjectHelper.isEmpty((Object)configuration.getOauthToken())) {
            builder.withUsername(configuration.getUsername());
            builder.withPassword(configuration.getPassword());
        }
        ObjectHelper.ifNotEmpty((Object)configuration.getOauthToken(), arg_0 -> ((ConfigBuilder)builder).withOauthToken(arg_0));
        ObjectHelper.ifNotEmpty((Object)configuration.getCaCertData(), arg_0 -> ((ConfigBuilder)builder).withCaCertData(arg_0));
        ObjectHelper.ifNotEmpty((Object)configuration.getCaCertFile(), arg_0 -> ((ConfigBuilder)builder).withCaCertFile(arg_0));
        ObjectHelper.ifNotEmpty((Object)configuration.getClientCertData(), arg_0 -> ((ConfigBuilder)builder).withClientCertData(arg_0));
        ObjectHelper.ifNotEmpty((Object)configuration.getClientCertFile(), arg_0 -> ((ConfigBuilder)builder).withClientCertFile(arg_0));
        ObjectHelper.ifNotEmpty((Object)configuration.getApiVersion(), arg_0 -> ((ConfigBuilder)builder).withApiVersion(arg_0));
        ObjectHelper.ifNotEmpty((Object)configuration.getClientKeyAlgo(), arg_0 -> ((ConfigBuilder)builder).withClientKeyAlgo(arg_0));
        ObjectHelper.ifNotEmpty((Object)configuration.getClientKeyData(), arg_0 -> ((ConfigBuilder)builder).withClientKeyData(arg_0));
        ObjectHelper.ifNotEmpty((Object)configuration.getClientKeyFile(), arg_0 -> ((ConfigBuilder)builder).withClientKeyFile(arg_0));
        ObjectHelper.ifNotEmpty((Object)configuration.getClientKeyPassphrase(), arg_0 -> ((ConfigBuilder)builder).withClientKeyPassphrase(arg_0));
        ObjectHelper.ifNotEmpty((Object)configuration.getTrustCerts(), arg_0 -> ((ConfigBuilder)builder).withTrustCerts(arg_0));
        ObjectHelper.ifNotEmpty((Object)configuration.getConnectionTimeout(), arg_0 -> ((ConfigBuilder)builder).withConnectionTimeout(arg_0));
        ObjectHelper.ifNotEmpty((Object)configuration.getNamespace(), arg_0 -> ((ConfigBuilder)builder).withNamespace(arg_0));
        Config conf = builder.build();
        return new DefaultKubernetesClient(conf);
    }

    public static void close(Runnable runnable, Supplier<Watch> watchGetter) {
        Watch watch;
        if (runnable != null && (watch = watchGetter.get()) != null) {
            watch.close();
        }
    }

    public static String extractOperation(AbstractKubernetesEndpoint endpoint, Exchange exchange) {
        String operation = ObjectHelper.isEmpty((Object)endpoint.getKubernetesConfiguration().getOperation()) ? (String)exchange.getIn().getHeader("CamelKubernetesOperation", String.class) : endpoint.getKubernetesConfiguration().getOperation();
        if (ObjectHelper.isEmpty((Object)operation)) {
            throw new IllegalArgumentException("The kubernetes producer for this component requires a operation to proceed");
        }
        return operation;
    }

    public static void prepareOutboundMessage(Exchange exchange, Object body) {
        MessageHelper.copyHeaders((Message)exchange.getIn(), (Message)exchange.getMessage(), (boolean)true);
        exchange.getMessage().setBody(body);
    }
}

