/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.djl.model;

import ai.djl.Model;
import ai.djl.inference.Predictor;
import ai.djl.modality.Classifications;
import ai.djl.modality.cv.Image;
import ai.djl.modality.cv.ImageFactory;
import ai.djl.translate.TranslateException;
import ai.djl.translate.Translator;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.djl.model.AbstractPredictor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomImageClassificationPredictor
extends AbstractPredictor {
    private static final Logger LOG = LoggerFactory.getLogger(CustomImageClassificationPredictor.class);
    private final String modelName;
    private final String translatorName;

    public CustomImageClassificationPredictor(String modelName, String translatorName) {
        this.modelName = modelName;
        this.translatorName = translatorName;
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        Model model = (Model)exchange.getContext().getRegistry().lookupByNameAndType(this.modelName, Model.class);
        Translator translator = (Translator)exchange.getContext().getRegistry().lookupByNameAndType(this.translatorName, Translator.class);
        if (exchange.getIn().getBody() instanceof byte[]) {
            byte[] bytes = (byte[])exchange.getIn().getBody(byte[].class);
            Map<String, Float> result = this.classify(model, translator, new ByteArrayInputStream(bytes));
            exchange.getIn().setBody(result);
        } else if (exchange.getIn().getBody() instanceof File) {
            Map<String, Float> result = this.classify(model, translator, (File)exchange.getIn().getBody(File.class));
            exchange.getIn().setBody(result);
        } else if (exchange.getIn().getBody() instanceof InputStream) {
            Map<String, Float> result = this.classify(model, translator, (InputStream)exchange.getIn().getBody(InputStream.class));
            exchange.getIn().setBody(result);
        } else {
            throw new RuntimeCamelException("Data type is not supported. Body should be byte[], InputStream or File");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, Float> classify(Model model, Translator translator, File input) {
        try (FileInputStream fileInputStream = new FileInputStream(input);){
            Image image = ImageFactory.getInstance().fromInputStream((InputStream)fileInputStream);
            Map<String, Float> map = this.classify(model, translator, image);
            return map;
        }
        catch (IOException e) {
            LOG.error("Couldn't transform input into a BufferedImage");
            throw new RuntimeCamelException("Couldn't transform input into a BufferedImage", (Throwable)e);
        }
    }

    private Map<String, Float> classify(Model model, Translator translator, InputStream input) {
        try {
            Image image = ImageFactory.getInstance().fromInputStream(input);
            return this.classify(model, translator, image);
        }
        catch (IOException e) {
            LOG.error("Couldn't transform input into a BufferedImage");
            throw new RuntimeCamelException("Couldn't transform input into a BufferedImage", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, Float> classify(Model model, Translator translator, Image image) {
        try (Predictor predictor = model.newPredictor(translator);){
            Classifications classifications = (Classifications)predictor.predict((Object)image);
            List list = classifications.items();
            Map<String, Float> map = list.stream().collect(Collectors.toMap(Classifications.Classification::getClassName, x -> Float.valueOf((float)x.getProbability())));
            return map;
        }
        catch (TranslateException e) {
            LOG.error("Could not process input or output", (Throwable)e);
            throw new RuntimeCamelException("Could not process input or output", (Throwable)e);
        }
    }
}

