/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.beanstalk;

import com.surftools.BeanstalkClient.BeanstalkException;
import com.surftools.BeanstalkClient.Client;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.beanstalk.BeanstalkEndpoint;
import org.apache.camel.component.beanstalk.processors.Command;
import org.apache.camel.support.DefaultAsyncProducer;

public class BeanstalkProducer
extends DefaultAsyncProducer {
    private ExecutorService executor;
    private Client client;
    private final Command command;

    public BeanstalkProducer(BeanstalkEndpoint endpoint, Command command) {
        super((Endpoint)endpoint);
        this.command = command;
    }

    public Command getCommand() {
        return this.command;
    }

    public void process(Exchange exchange) throws Exception {
        Future<?> f = this.executor.submit(new RunCommand(exchange));
        f.get();
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        try {
            this.executor.submit(new RunCommand(exchange, callback));
        }
        catch (Exception t) {
            exchange.setException((Throwable)t);
            callback.done(true);
            return true;
        }
        return false;
    }

    protected void resetClient() {
        this.closeClient();
        this.initClient();
    }

    protected void closeClient() {
        if (this.client != null) {
            this.client.close();
        }
    }

    protected void initClient() {
        this.client = this.getEndpoint().getConnection().newWritingClient();
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.executor = this.getEndpoint().getCamelContext().getExecutorServiceManager().newSingleThreadExecutor((Object)this, "Beanstalk-Producer");
        this.executor.execute(() -> this.initClient());
    }

    protected void doStop() throws Exception {
        this.getEndpoint().getCamelContext().getExecutorServiceManager().shutdown(this.executor);
        this.closeClient();
        super.doStop();
    }

    public BeanstalkEndpoint getEndpoint() {
        return (BeanstalkEndpoint)super.getEndpoint();
    }

    class RunCommand
    implements Runnable {
        private final Exchange exchange;
        private final AsyncCallback callback;

        RunCommand(Exchange exchange) {
            this(exchange, null);
        }

        RunCommand(Exchange exchange, AsyncCallback callback) {
            this.exchange = exchange;
            this.callback = callback;
        }

        @Override
        public void run() {
            try {
                this.doRun();
            }
            catch (Exception t) {
                this.exchange.setException((Throwable)t);
            }
            finally {
                if (this.callback != null) {
                    this.callback.done(false);
                }
            }
        }

        private void doRun() throws Exception {
            try {
                BeanstalkProducer.this.command.act(BeanstalkProducer.this.client, this.exchange);
            }
            catch (BeanstalkException e) {
                BeanstalkProducer.this.resetClient();
                BeanstalkProducer.this.command.act(BeanstalkProducer.this.client, this.exchange);
            }
        }
    }
}

