/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.csv;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.linq4j.tree.Primitive;
import org.apache.calcite.rel.type.RelDataType;

enum CsvFieldType {
    STRING(String.class, "string"),
    BOOLEAN(Primitive.BOOLEAN),
    BYTE(Primitive.BYTE),
    CHAR(Primitive.CHAR),
    SHORT(Primitive.SHORT),
    INT(Primitive.INT),
    LONG(Primitive.LONG),
    FLOAT(Primitive.FLOAT),
    DOUBLE(Primitive.DOUBLE),
    DATE(Date.class, "date"),
    TIME(Time.class, "time"),
    TIMESTAMP(Timestamp.class, "timestamp");

    private final Class clazz;
    private final String simpleName;
    private static final Map<String, CsvFieldType> MAP;

    private CsvFieldType(Primitive primitive) {
        this(primitive.boxClass, primitive.primitiveClass.getSimpleName());
    }

    private CsvFieldType(Class clazz, String simpleName) {
        this.clazz = clazz;
        this.simpleName = simpleName;
    }

    public RelDataType toType(JavaTypeFactory typeFactory) {
        RelDataType javaType = typeFactory.createJavaType(this.clazz);
        RelDataType sqlType = typeFactory.createSqlType(javaType.getSqlTypeName());
        return typeFactory.createTypeWithNullability(sqlType, true);
    }

    public static CsvFieldType of(String typeString) {
        return MAP.get(typeString);
    }

    static {
        MAP = new HashMap<String, CsvFieldType>();
        for (CsvFieldType value : CsvFieldType.values()) {
            MAP.put(value.simpleName, value);
        }
    }
}

