/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.deployment;

import java.io.File;
import java.io.FileInputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.Deployer;
import org.apache.axis2.deployment.DeploymentEngine;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.deployment.repository.util.DeploymentFileData;
import org.apache.axis2.deployment.util.Utils;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.util.Loader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jam.JAnnotation;
import org.codehaus.jam.JClass;
import org.codehaus.jam.JamClassIterator;
import org.codehaus.jam.JamService;
import org.codehaus.jam.JamServiceFactory;
import org.codehaus.jam.JamServiceParams;

public class POJODeployer
implements Deployer {
    private static Log log = LogFactory.getLog((Class)POJODeployer.class);
    private ConfigurationContext configCtx;

    public void init(ConfigurationContext configCtx) {
        this.configCtx = configCtx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deploy(DeploymentFileData deploymentFileData) {
        ClassLoader threadClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            block22: {
                try {
                    ArrayList<String> classList;
                    FileInputStream fin;
                    block23: {
                        String extension = DeploymentFileData.getFileExtension(deploymentFileData.getName());
                        if ("class".equals(extension)) {
                            File file = deploymentFileData.getFile();
                            File parentFile = file.getParentFile();
                            if (file != null) {
                                ClassLoader classLoader = Utils.getClassLoader(this.configCtx.getAxisConfiguration().getSystemClassLoader(), parentFile);
                                Thread.currentThread().setContextClassLoader(classLoader);
                                String className = file.getName();
                                className = className.replaceAll(".class", "");
                                log.info((Object)Messages.getMessage("deployingpojo", className, deploymentFileData.getFile().getAbsolutePath()));
                                JamServiceFactory factory = JamServiceFactory.getInstance();
                                JamServiceParams jamServiceParams = factory.createServiceParams();
                                jamServiceParams.addClassLoader(classLoader);
                                jamServiceParams.includeClass(className);
                                JamService service = factory.createService(jamServiceParams);
                                JamClassIterator jClassIter = service.getClasses();
                                while (jClassIter.hasNext()) {
                                    AxisService axisService;
                                    JClass jclass = (JClass)jClassIter.next();
                                    if (!jclass.getQualifiedName().equals(className)) continue;
                                    JAnnotation annotation = jclass.getAnnotation("javax.jws.WebService");
                                    if (annotation != null) {
                                        axisService = this.createAxisService(classLoader, className, deploymentFileData.getFile().toURL());
                                        this.configCtx.getAxisConfiguration().addService(axisService);
                                        continue;
                                    }
                                    axisService = this.createAxisServiceUsingAnnogen(className, classLoader, deploymentFileData.getFile().toURL());
                                    this.configCtx.getAxisConfiguration().addService(axisService);
                                }
                            }
                            break block22;
                        }
                        if (!"jar".equals(extension)) break block22;
                        fin = null;
                        ZipInputStream zin = null;
                        try {
                            try {
                                ZipEntry entry;
                                fin = new FileInputStream(deploymentFileData.getAbsolutePath());
                                zin = new ZipInputStream(fin);
                                classList = new ArrayList<String>();
                                while ((entry = zin.getNextEntry()) != null) {
                                    String name = entry.getName();
                                    if (!name.endsWith(".class")) continue;
                                    classList.add(name);
                                }
                                zin.close();
                                fin.close();
                            }
                            catch (Exception e) {
                                log.debug((Object)Messages.getMessage("deployingexception", e.getMessage()), (Throwable)e);
                                throw new DeploymentException(e);
                            }
                            Object var16_33 = null;
                            if (zin == null) break block23;
                        }
                        catch (Throwable throwable) {
                            Object var16_34 = null;
                            if (zin != null) {
                                zin.close();
                            }
                            if (fin == null) throw throwable;
                            fin.close();
                            throw throwable;
                        }
                        zin.close();
                    }
                    if (fin != null) {
                        fin.close();
                    }
                    ArrayList<AxisService> axisServiceList = new ArrayList<AxisService>();
                    for (int i = 0; i < classList.size(); ++i) {
                        String className = (String)classList.get(i);
                        ArrayList<URL> urls = new ArrayList<URL>();
                        urls.add(deploymentFileData.getFile().toURL());
                        urls.add(this.configCtx.getAxisConfiguration().getRepository());
                        String webLocation = DeploymentEngine.getWebLocationString();
                        if (webLocation != null) {
                            urls.add(new File(webLocation).toURL());
                        }
                        ClassLoader classLoader = Utils.createClassLoader(urls, this.configCtx.getAxisConfiguration().getSystemClassLoader(), true, (File)this.configCtx.getAxisConfiguration().getParameterValue("artifactsDIR"));
                        Thread.currentThread().setContextClassLoader(classLoader);
                        className = className.replaceAll(".class", "");
                        className = className.replaceAll("/", ".");
                        JamServiceFactory factory = JamServiceFactory.getInstance();
                        JamServiceParams jamServiceParams = factory.createServiceParams();
                        jamServiceParams.addClassLoader(classLoader);
                        jamServiceParams.includeClass(className);
                        JamService service = factory.createService(jamServiceParams);
                        JamClassIterator jClassIter = service.getClasses();
                        while (jClassIter.hasNext()) {
                            JClass jclass = (JClass)jClassIter.next();
                            if (!jclass.getQualifiedName().equals(className)) continue;
                            JAnnotation annotation = jclass.getAnnotation("javax.jws.WebService");
                            if (annotation == null) {
                                annotation = jclass.getAnnotation("javax.xml.ws.WebServiceProvider");
                            }
                            if (annotation == null) continue;
                            AxisService axisService = this.createAxisService(classLoader, className, deploymentFileData.getFile().toURL());
                            axisServiceList.add(axisService);
                        }
                    }
                    if (axisServiceList.size() > 0) {
                        AxisServiceGroup serviceGroup = new AxisServiceGroup();
                        serviceGroup.setServiceGroupName(deploymentFileData.getName());
                        for (int i = 0; i < axisServiceList.size(); ++i) {
                            AxisService axisService = (AxisService)axisServiceList.get(i);
                            serviceGroup.addService(axisService);
                        }
                        this.configCtx.getAxisConfiguration().addServiceGroup(serviceGroup);
                        break block22;
                    }
                    String msg = "Error:\n No annotated classes found in the jar: " + deploymentFileData.getFile().getName() + ". Service deployment failed.";
                    log.error((Object)msg);
                    this.configCtx.getAxisConfiguration().getFaultyServices().put(deploymentFileData.getFile().getAbsolutePath(), msg);
                }
                catch (Exception e) {
                    log.debug((Object)Messages.getMessage("stroringfaultyservice", e.getMessage()), (Throwable)e);
                    this.storeFaultyService(deploymentFileData, e);
                    Object var21_41 = null;
                    if (threadClassLoader == null) return;
                    Thread.currentThread().setContextClassLoader(threadClassLoader);
                    return;
                }
                catch (Throwable t) {
                    log.debug((Object)Messages.getMessage("stroringfaultyservice", t.getMessage()), t);
                    this.storeFaultyService(deploymentFileData, t);
                    Object var21_42 = null;
                    if (threadClassLoader == null) return;
                    Thread.currentThread().setContextClassLoader(threadClassLoader);
                    return;
                }
            }
            Object var21_40 = null;
            if (threadClassLoader == null) return;
            Thread.currentThread().setContextClassLoader(threadClassLoader);
            return;
        }
        catch (Throwable throwable) {
            Object var21_43 = null;
            if (threadClassLoader == null) throw throwable;
            Thread.currentThread().setContextClassLoader(threadClassLoader);
            throw throwable;
        }
    }

    private void storeFaultyService(DeploymentFileData deploymentFileData, Throwable t) {
        StringWriter errorWriter = new StringWriter();
        PrintWriter ptintWriter = new PrintWriter(errorWriter);
        t.printStackTrace(ptintWriter);
        String error = "Error:\n" + errorWriter.toString();
        this.configCtx.getAxisConfiguration().getFaultyServices().put(deploymentFileData.getFile().getAbsolutePath(), error);
    }

    private AxisService createAxisService(ClassLoader classLoader, String className, URL serviceLocation) throws ClassNotFoundException, InstantiationException, IllegalAccessException, AxisFault {
        AxisService axisService;
        try {
            Class<?> claxx = Class.forName("org.apache.axis2.jaxws.description.DescriptionFactory");
            Method mthod = claxx.getMethod("createAxisService", Class.class);
            Class pojoClass = Loader.loadClass(classLoader, className);
            axisService = (AxisService)mthod.invoke(claxx, pojoClass);
            if (axisService != null) {
                Iterator operations = axisService.getOperations();
                while (operations.hasNext()) {
                    AxisOperation axisOperation = (AxisOperation)operations.next();
                    if (axisOperation.getMessageReceiver() != null) continue;
                    try {
                        Class jaxwsMR = Loader.loadClass("org.apache.axis2.jaxws.server.JAXWSMessageReceiver");
                        MessageReceiver jaxwsMRInstance = (MessageReceiver)jaxwsMR.newInstance();
                        axisOperation.setMessageReceiver(jaxwsMRInstance);
                    }
                    catch (Exception e) {
                        log.debug((Object)("Error occurde while loading JAXWSMessageReceiver for " + className));
                    }
                }
            }
            axisService.setElementFormDefault(false);
            axisService.setFileName(serviceLocation);
            Utils.fillAxisService(axisService, this.configCtx.getAxisConfiguration(), new ArrayList(), new ArrayList());
        }
        catch (Exception e) {
            log.info((Object)Messages.getMessage("jaxwsjarsmissing", e.getMessage()), (Throwable)e);
            axisService = this.createAxisServiceUsingAnnogen(className, classLoader, serviceLocation);
        }
        return axisService;
    }

    private AxisService createAxisServiceUsingAnnogen(String className, ClassLoader classLoader, URL serviceLocation) throws ClassNotFoundException, InstantiationException, IllegalAccessException, AxisFault {
        HashMap<String, MessageReceiver> messageReciverMap = new HashMap<String, MessageReceiver>();
        Class inOnlyMessageReceiver = Loader.loadClass("org.apache.axis2.rpc.receivers.RPCInOnlyMessageReceiver");
        MessageReceiver messageReceiver = (MessageReceiver)inOnlyMessageReceiver.newInstance();
        messageReciverMap.put("http://www.w3.org/ns/wsdl/in-only", messageReceiver);
        Class inoutMessageReceiver = Loader.loadClass("org.apache.axis2.rpc.receivers.RPCMessageReceiver");
        MessageReceiver inOutmessageReceiver = (MessageReceiver)inoutMessageReceiver.newInstance();
        messageReciverMap.put("http://www.w3.org/ns/wsdl/in-out", inOutmessageReceiver);
        messageReciverMap.put("http://www.w3.org/ns/wsdl/robust-in-only", inOutmessageReceiver);
        AxisService axisService = AxisService.createService(className, this.configCtx.getAxisConfiguration(), messageReciverMap, null, null, classLoader);
        axisService.setFileName(serviceLocation);
        return axisService;
    }

    public void setMessageReceivers(AxisService service) {
        Iterator iterator = service.getOperations();
        while (iterator.hasNext()) {
            AxisOperation operation = (AxisOperation)iterator.next();
            String MEP = operation.getMessageExchangePattern();
            if (MEP == null) continue;
            try {
                if ("http://www.w3.org/2006/01/wsdl/in-only".equals(MEP) || "http://www.w3.org/2004/08/wsdl/in-only".equals(MEP) || "http://www.w3.org/ns/wsdl/in-only".equals(MEP)) {
                    Class inOnlyMessageReceiver = Loader.loadClass("org.apache.axis2.rpc.receivers.RPCInOnlyMessageReceiver");
                    MessageReceiver messageReceiver = (MessageReceiver)inOnlyMessageReceiver.newInstance();
                    operation.setMessageReceiver(messageReceiver);
                    continue;
                }
                Class inoutMessageReceiver = Loader.loadClass("org.apache.axis2.rpc.receivers.RPCMessageReceiver");
                MessageReceiver inOutmessageReceiver = (MessageReceiver)inoutMessageReceiver.newInstance();
                operation.setMessageReceiver(inOutmessageReceiver);
            }
            catch (ClassNotFoundException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (InstantiationException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public void setDirectory(String directory) {
    }

    public void setExtension(String extension) {
    }

    public void unDeploy(String fileName) {
        if ((fileName = Utils.getShortFileName(fileName)).endsWith(".class")) {
            String className = fileName.replaceAll(".class", "");
            try {
                AxisServiceGroup serviceGroup = this.configCtx.getAxisConfiguration().removeServiceGroup(className);
                this.configCtx.removeServiceGroupContext(serviceGroup);
                log.info((Object)Messages.getMessage("serviceremoved", fileName));
            }
            catch (AxisFault axisFault) {
                log.debug((Object)Messages.getMessage("faultyserviceremoval", axisFault.getMessage()), (Throwable)axisFault);
                this.configCtx.getAxisConfiguration().removeFaultyService(fileName);
            }
        } else if (fileName.endsWith(".jar")) {
            try {
                AxisServiceGroup serviceGroup = this.configCtx.getAxisConfiguration().removeServiceGroup(fileName);
                this.configCtx.removeServiceGroupContext(serviceGroup);
                log.info((Object)Messages.getMessage("serviceremoved", fileName));
            }
            catch (AxisFault axisFault) {
                log.debug((Object)Messages.getMessage("faultyserviceremoval", axisFault.getMessage()), (Throwable)axisFault);
                this.configCtx.getAxisConfiguration().removeFaultyService(fileName);
            }
        }
    }
}

