/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.model.instance;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasObjectId;
import org.apache.atlas.model.instance.AtlasRelationship;
import org.apache.atlas.model.instance.AtlasStruct;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.PROPERTY)
public class AtlasRelatedObjectId
extends AtlasObjectId
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String KEY_RELATIONSHIP_TYPE = "relationshipType";
    public static final String KEY_RELATIONSHIP_GUID = "relationshipGuid";
    public static final String KEY_RELATIONSHIP_STATUS = "relationshipStatus";
    public static final String KEY_RELATIONSHIP_ATTRIBUTES = "relationshipAttributes";
    private AtlasEntity.Status entityStatus = null;
    private String displayText = null;
    private String relationshipType = null;
    private String relationshipGuid = null;
    private AtlasRelationship.Status relationshipStatus = null;
    private AtlasStruct relationshipAttributes = null;

    public AtlasRelatedObjectId() {
    }

    public AtlasRelatedObjectId(String guid, String typeName, AtlasEntity.Status entityStatus, String relationshipGuid, AtlasRelationship.Status relationshipStatus, AtlasStruct relationshipAttributes) {
        super(guid, typeName);
        this.setEntityStatus(entityStatus);
        this.setRelationshipGuid(relationshipGuid);
        this.setRelationshipStatus(relationshipStatus);
        this.setRelationshipAttributes(relationshipAttributes);
    }

    public AtlasRelatedObjectId(String guid, String typeName, AtlasEntity.Status entityStatus, Map<String, Object> uniqueAttributes, String displayText, String relationshipGuid, AtlasRelationship.Status relationshipStatus, AtlasStruct relationshipAttributes) {
        super(guid, typeName, uniqueAttributes);
        this.setEntityStatus(entityStatus);
        this.setRelationshipGuid(relationshipGuid);
        this.setRelationshipStatus(relationshipStatus);
        this.setDisplayText(displayText);
        this.setRelationshipAttributes(relationshipAttributes);
    }

    public AtlasRelatedObjectId(AtlasObjectId other) {
        super(other);
    }

    public AtlasRelatedObjectId(AtlasObjectId objId, String relationshipType) {
        this(objId);
        this.setRelationshipType(relationshipType);
    }

    public AtlasRelatedObjectId(Map objIdMap) {
        super(objIdMap);
        if (objIdMap != null) {
            Object g = objIdMap.get(KEY_RELATIONSHIP_GUID);
            Object t = objIdMap.get(KEY_RELATIONSHIP_TYPE);
            Object a = objIdMap.get(KEY_RELATIONSHIP_ATTRIBUTES);
            Object s = objIdMap.get(KEY_RELATIONSHIP_STATUS);
            if (g != null) {
                this.setRelationshipGuid(g.toString());
            }
            if (a instanceof Map) {
                this.setRelationshipAttributes(new AtlasStruct((Map)a));
            } else if (a instanceof AtlasStruct) {
                this.setRelationshipAttributes(new AtlasStruct((AtlasStruct)a));
            }
            if (t != null) {
                this.setRelationshipType(t.toString());
            }
            if (s != null) {
                this.setRelationshipStatus(AtlasRelationship.Status.valueOf(s.toString()));
            }
        }
    }

    public AtlasEntity.Status getEntityStatus() {
        return this.entityStatus;
    }

    public void setEntityStatus(AtlasEntity.Status entityStatus) {
        this.entityStatus = entityStatus;
    }

    public String getDisplayText() {
        return this.displayText;
    }

    public void setDisplayText(String displayText) {
        this.displayText = displayText;
    }

    public String getRelationshipType() {
        return this.relationshipType;
    }

    public void setRelationshipType(String relationshipType) {
        this.relationshipType = relationshipType;
    }

    public String getRelationshipGuid() {
        return this.relationshipGuid;
    }

    public void setRelationshipGuid(String relationshipGuid) {
        this.relationshipGuid = relationshipGuid;
    }

    public AtlasRelationship.Status getRelationshipStatus() {
        return this.relationshipStatus;
    }

    public void setRelationshipStatus(AtlasRelationship.Status relationshipStatus) {
        this.relationshipStatus = relationshipStatus;
    }

    public AtlasStruct getRelationshipAttributes() {
        return this.relationshipAttributes;
    }

    public void setRelationshipAttributes(AtlasStruct relationshipAttributes) {
        this.relationshipAttributes = relationshipAttributes;
        if (relationshipAttributes != null && relationshipAttributes.getTypeName() != null) {
            this.setRelationshipType(relationshipAttributes.getTypeName());
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AtlasRelatedObjectId that = (AtlasRelatedObjectId)o;
        return Objects.equals((Object)this.entityStatus, (Object)that.entityStatus) && Objects.equals(this.displayText, that.displayText) && Objects.equals(this.relationshipType, that.relationshipType) && Objects.equals(this.relationshipGuid, that.relationshipGuid) && Objects.equals((Object)this.relationshipStatus, (Object)that.relationshipStatus) && Objects.equals(this.relationshipAttributes, that.relationshipAttributes);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.displayText, this.relationshipType, this.relationshipGuid, this.relationshipStatus, this.relationshipAttributes});
    }

    @Override
    public String toString() {
        return this.toString(new StringBuilder()).toString();
    }

    @Override
    public StringBuilder toString(StringBuilder sb) {
        if (sb == null) {
            sb = new StringBuilder();
        }
        sb.append("AtlasRelatedObjectId{");
        super.toString(sb);
        sb.append("entityStatus='").append((Object)this.entityStatus).append('\'');
        sb.append(", displayText='").append(this.displayText).append('\'');
        sb.append(", relationshipType='").append(this.relationshipType).append('\'');
        sb.append(", relationshipGuid='").append(this.relationshipGuid).append('\'');
        sb.append(", relationshipStatus='").append((Object)this.relationshipStatus).append('\'');
        sb.append(", relationshipAttributes=").append(this.relationshipAttributes);
        sb.append('}');
        return sb;
    }
}

