/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.vector.pojo;

import com.google.flatbuffers.FlatBufferBuilder;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.apache.arrow.flatbuf.Schema;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.util.Collections2;
import org.apache.arrow.vector.complex.FixedSizeListVector;
import org.apache.arrow.vector.complex.ListVector;
import org.apache.arrow.vector.types.FloatingPointPrecision;
import org.apache.arrow.vector.types.TimeUnit;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.UnionMode;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.junit.Assert;
import org.junit.Test;

public class TestConvert {
    @Test
    public void simple() {
        Field initialField = new Field("a", FieldType.nullable((ArrowType)new ArrowType.Int(32, true)), null);
        this.run(initialField);
    }

    @Test
    public void complex() {
        ArrayList<Field> children = new ArrayList<Field>();
        children.add(new Field("child1", FieldType.nullable((ArrowType)ArrowType.Utf8.INSTANCE), null));
        children.add(new Field("child2", FieldType.nullable((ArrowType)new ArrowType.FloatingPoint(FloatingPointPrecision.SINGLE)), Collections.emptyList()));
        Field initialField = new Field("a", FieldType.nullable((ArrowType)ArrowType.Struct.INSTANCE), children);
        this.run(initialField);
    }

    @Test
    public void list() throws Exception {
        ArrayList<Field> children = new ArrayList<Field>();
        try (RootAllocator allocator = new RootAllocator(Long.MAX_VALUE);
             ListVector writeVector = ListVector.empty((String)"list", (BufferAllocator)allocator);
             FixedSizeListVector writeFixedVector = FixedSizeListVector.empty((String)"fixedlist", (int)5, (BufferAllocator)allocator);){
            Field listVectorField = writeVector.getField();
            children.add(listVectorField);
            Field listFixedVectorField = writeFixedVector.getField();
            children.add(listFixedVectorField);
        }
        Field initialField = new Field("a", FieldType.nullable((ArrowType)ArrowType.Struct.INSTANCE), children);
        ArrayList<Field> parent = new ArrayList<Field>();
        parent.add(initialField);
        FlatBufferBuilder builder = new FlatBufferBuilder();
        builder.finish(initialField.getField(builder));
        org.apache.arrow.flatbuf.Field flatBufField = org.apache.arrow.flatbuf.Field.getRootAsField((ByteBuffer)builder.dataBuffer());
        Field finalField = Field.convertField((org.apache.arrow.flatbuf.Field)flatBufField);
        Assert.assertEquals((Object)initialField, (Object)finalField);
        Assert.assertFalse((boolean)finalField.toString().contains("[DEFAULT]"));
        org.apache.arrow.vector.types.pojo.Schema initialSchema = new org.apache.arrow.vector.types.pojo.Schema(parent);
        String jsonSchema = initialSchema.toJson();
        String modifiedSchema = jsonSchema.replace("$data$", "[DEFAULT]");
        org.apache.arrow.vector.types.pojo.Schema tempSchema = org.apache.arrow.vector.types.pojo.Schema.fromJSON((String)modifiedSchema);
        FlatBufferBuilder schemaBuilder = new FlatBufferBuilder();
        org.apache.arrow.vector.types.pojo.Schema schema = new org.apache.arrow.vector.types.pojo.Schema((Iterable)tempSchema.getFields());
        schemaBuilder.finish(schema.getSchema(schemaBuilder));
        org.apache.arrow.vector.types.pojo.Schema finalSchema = org.apache.arrow.vector.types.pojo.Schema.deserialize((ByteBuffer)ByteBuffer.wrap(schemaBuilder.sizedByteArray()));
        Assert.assertFalse((boolean)finalSchema.toString().contains("[DEFAULT]"));
    }

    @Test
    public void schema() {
        ArrayList<Field> children = new ArrayList<Field>();
        children.add(new Field("child1", FieldType.nullable((ArrowType)ArrowType.Utf8.INSTANCE), null));
        children.add(new Field("child2", FieldType.nullable((ArrowType)new ArrowType.FloatingPoint(FloatingPointPrecision.SINGLE)), Collections.emptyList()));
        org.apache.arrow.vector.types.pojo.Schema initialSchema = new org.apache.arrow.vector.types.pojo.Schema(children);
        this.run(initialSchema);
    }

    @Test
    public void schemaMetadata() {
        ArrayList<Field> children = new ArrayList<Field>();
        children.add(new Field("child1", FieldType.nullable((ArrowType)ArrowType.Utf8.INSTANCE), null));
        children.add(new Field("child2", FieldType.nullable((ArrowType)new ArrowType.FloatingPoint(FloatingPointPrecision.SINGLE)), Collections.emptyList()));
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("key1", "value1");
        metadata.put("key2", "value2");
        org.apache.arrow.vector.types.pojo.Schema initialSchema = new org.apache.arrow.vector.types.pojo.Schema(children, metadata);
        this.run(initialSchema);
    }

    @Test
    public void nestedSchema() {
        ArrayList<Field> children = new ArrayList<Field>();
        children.add(new Field("child1", FieldType.nullable((ArrowType)ArrowType.Utf8.INSTANCE), null));
        children.add(new Field("child2", FieldType.nullable((ArrowType)new ArrowType.FloatingPoint(FloatingPointPrecision.SINGLE)), Collections.emptyList()));
        children.add(new Field("child3", FieldType.nullable((ArrowType)new ArrowType.Struct()), Collections2.asImmutableList((Object[])new Field[]{new Field("child3.1", FieldType.nullable((ArrowType)ArrowType.Utf8.INSTANCE), null), new Field("child3.2", FieldType.nullable((ArrowType)new ArrowType.FloatingPoint(FloatingPointPrecision.DOUBLE)), Collections.emptyList())})));
        children.add(new Field("child4", FieldType.nullable((ArrowType)new ArrowType.List()), Collections2.asImmutableList((Object[])new Field[]{new Field("child4.1", FieldType.nullable((ArrowType)ArrowType.Utf8.INSTANCE), null)})));
        children.add(new Field("child5", FieldType.nullable((ArrowType)new ArrowType.Union(UnionMode.Sparse, new int[]{Types.MinorType.TIMESTAMPMILLI.ordinal(), Types.MinorType.FLOAT8.ordinal()})), Collections2.asImmutableList((Object[])new Field[]{new Field("child5.1", FieldType.nullable((ArrowType)new ArrowType.Timestamp(TimeUnit.MILLISECOND, null)), null), new Field("child5.2", FieldType.nullable((ArrowType)new ArrowType.FloatingPoint(FloatingPointPrecision.DOUBLE)), Collections.emptyList()), new Field("child5.3", true, (ArrowType)new ArrowType.Timestamp(TimeUnit.MILLISECOND, "UTC"), null)})));
        org.apache.arrow.vector.types.pojo.Schema initialSchema = new org.apache.arrow.vector.types.pojo.Schema(children);
        this.run(initialSchema);
    }

    private void run(Field initialField) {
        FlatBufferBuilder builder = new FlatBufferBuilder();
        builder.finish(initialField.getField(builder));
        org.apache.arrow.flatbuf.Field flatBufField = org.apache.arrow.flatbuf.Field.getRootAsField((ByteBuffer)builder.dataBuffer());
        Field finalField = Field.convertField((org.apache.arrow.flatbuf.Field)flatBufField);
        Assert.assertEquals((Object)initialField, (Object)finalField);
    }

    private void run(org.apache.arrow.vector.types.pojo.Schema initialSchema) {
        FlatBufferBuilder builder = new FlatBufferBuilder();
        builder.finish(initialSchema.getSchema(builder));
        Schema flatBufSchema = Schema.getRootAsSchema((ByteBuffer)builder.dataBuffer());
        org.apache.arrow.vector.types.pojo.Schema finalSchema = org.apache.arrow.vector.types.pojo.Schema.convertSchema((Schema)flatBufSchema);
        Assert.assertEquals((Object)initialSchema, (Object)finalSchema);
    }
}

