/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.vector.ipc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.util.Collections;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.TinyIntVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.ipc.ArrowReader;
import org.apache.arrow.vector.ipc.ArrowStreamReader;
import org.apache.arrow.vector.ipc.ArrowStreamWriter;
import org.apache.arrow.vector.ipc.ArrowWriter;
import org.apache.arrow.vector.ipc.BaseFileTest;
import org.apache.arrow.vector.ipc.MessageSerializerTest;
import org.apache.arrow.vector.types.pojo.Schema;
import org.junit.Assert;
import org.junit.Test;

public class TestArrowStream
extends BaseFileTest {
    @Test
    public void testEmptyStream() throws IOException {
        Schema schema = MessageSerializerTest.testSchema();
        VectorSchemaRoot root = VectorSchemaRoot.create((Schema)schema, (BufferAllocator)this.allocator);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ArrowStreamWriter writer = new ArrowStreamWriter(root, null, (OutputStream)out);
        writer.close();
        Assert.assertTrue((out.size() > 0 ? 1 : 0) != 0);
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        try (ArrowStreamReader reader = new ArrowStreamReader((InputStream)in, this.allocator);){
            Assert.assertEquals((Object)schema, (Object)reader.getVectorSchemaRoot().getSchema());
            Assert.assertFalse((boolean)reader.loadNextBatch());
            Assert.assertEquals((long)0L, (long)reader.getVectorSchemaRoot().getRowCount());
            Assert.assertFalse((boolean)reader.loadNextBatch());
            Assert.assertEquals((long)0L, (long)reader.getVectorSchemaRoot().getRowCount());
        }
    }

    @Test
    public void testStreamZeroLengthBatch() throws IOException {
        VectorSchemaRoot root;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try (IntVector vector = new IntVector("foo", this.allocator);){
            Schema schema = new Schema(Collections.singletonList(vector.getField()));
            root = new VectorSchemaRoot(schema, Collections.singletonList(vector), vector.getValueCount());
            Throwable throwable = null;
            try (ArrowStreamWriter writer = new ArrowStreamWriter(root, null, Channels.newChannel(os));){
                vector.setValueCount(0);
                root.setRowCount(0);
                writer.writeBatch();
                writer.end();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                TestArrowStream.$closeResource(throwable, (AutoCloseable)root);
            }
        }
        ByteArrayInputStream in = new ByteArrayInputStream(os.toByteArray());
        try (ArrowStreamReader reader = new ArrowStreamReader((InputStream)in, this.allocator);){
            root = reader.getVectorSchemaRoot();
            IntVector vector = (IntVector)root.getFieldVectors().get(0);
            reader.loadNextBatch();
            Assert.assertEquals((long)vector.getValueCount(), (long)0L);
            Assert.assertEquals((long)root.getRowCount(), (long)0L);
        }
    }

    @Test
    public void testReadWrite() throws IOException {
        Schema schema = MessageSerializerTest.testSchema();
        try (VectorSchemaRoot root = VectorSchemaRoot.create((Schema)schema, (BufferAllocator)this.allocator);){
            int numBatches = 1;
            ((FieldVector)root.getFieldVectors().get(0)).allocateNew();
            TinyIntVector vector = (TinyIntVector)root.getFieldVectors().get(0);
            for (int i = 0; i < 16; ++i) {
                vector.set(i, i < 8 ? 1 : 0, (byte)(i + 1));
            }
            vector.setValueCount(16);
            root.setRowCount(16);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            long bytesWritten = 0L;
            try (ArrowStreamWriter writer = new ArrowStreamWriter(root, null, (OutputStream)out);){
                writer.start();
                for (int i = 0; i < numBatches; ++i) {
                    writer.writeBatch();
                }
                writer.end();
                bytesWritten = writer.bytesWritten();
            }
            ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
            try (ArrowStreamReader reader = new ArrowStreamReader((InputStream)in, this.allocator);){
                Schema readSchema = reader.getVectorSchemaRoot().getSchema();
                Assert.assertEquals((Object)schema, (Object)readSchema);
                for (int i = 0; i < numBatches; ++i) {
                    Assert.assertTrue((boolean)reader.loadNextBatch());
                }
                Assert.assertEquals((long)bytesWritten, (long)(reader.bytesRead() + 8L));
                Assert.assertFalse((boolean)reader.loadNextBatch());
                Assert.assertEquals((long)0L, (long)reader.getVectorSchemaRoot().getRowCount());
            }
        }
    }

    @Test
    public void testReadWriteMultipleBatches() throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try (IntVector vector = new IntVector("foo", this.allocator);){
            Schema schema = new Schema(Collections.singletonList(vector.getField()));
            try (VectorSchemaRoot root = new VectorSchemaRoot(schema, Collections.singletonList(vector), vector.getValueCount());
                 ArrowStreamWriter writer = new ArrowStreamWriter(root, null, Channels.newChannel(os));){
                this.writeBatchData((ArrowWriter)writer, vector, root);
            }
        }
        ByteArrayInputStream in = new ByteArrayInputStream(os.toByteArray());
        try (ArrowStreamReader reader = new ArrowStreamReader((InputStream)in, this.allocator);){
            IntVector vector = (IntVector)reader.getVectorSchemaRoot().getFieldVectors().get(0);
            this.validateBatchData((ArrowReader)reader, vector);
        }
    }
}

