/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.vector.compare;

import java.nio.charset.Charset;
import java.util.Arrays;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.Float4Vector;
import org.apache.arrow.vector.Float8Vector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.LargeVarCharVector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.ZeroVector;
import org.apache.arrow.vector.compare.ApproxEqualsVisitor;
import org.apache.arrow.vector.compare.Range;
import org.apache.arrow.vector.compare.RangeEqualsVisitor;
import org.apache.arrow.vector.compare.TypeEqualsVisitor;
import org.apache.arrow.vector.compare.VectorEqualsVisitor;
import org.apache.arrow.vector.compare.VectorValueEqualizer;
import org.apache.arrow.vector.compare.VectorVisitor;
import org.apache.arrow.vector.compare.util.ValueEpsilonEqualizers;
import org.apache.arrow.vector.complex.DenseUnionVector;
import org.apache.arrow.vector.complex.FixedSizeListVector;
import org.apache.arrow.vector.complex.ListVector;
import org.apache.arrow.vector.complex.StructVector;
import org.apache.arrow.vector.complex.UnionVector;
import org.apache.arrow.vector.complex.impl.NullableStructWriter;
import org.apache.arrow.vector.complex.impl.UnionFixedSizeListWriter;
import org.apache.arrow.vector.complex.impl.UnionListWriter;
import org.apache.arrow.vector.holders.NullableBigIntHolder;
import org.apache.arrow.vector.holders.NullableFloat4Holder;
import org.apache.arrow.vector.holders.NullableFloat8Holder;
import org.apache.arrow.vector.holders.NullableIntHolder;
import org.apache.arrow.vector.holders.NullableUInt4Holder;
import org.apache.arrow.vector.testing.ValueVectorDataPopulator;
import org.apache.arrow.vector.types.FloatingPointPrecision;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class TestRangeEqualsVisitor {
    private BufferAllocator allocator;
    private static final Charset utf8Charset = Charset.forName("UTF-8");
    private static final byte[] STR1 = "AAAAA1".getBytes(utf8Charset);
    private static final byte[] STR2 = "BBBBBBBBB2".getBytes(utf8Charset);
    private static final byte[] STR3 = "CCCC3".getBytes(utf8Charset);

    @Before
    public void init() {
        this.allocator = new RootAllocator(Long.MAX_VALUE);
    }

    @After
    public void terminate() throws Exception {
        this.allocator.close();
    }

    @Test
    public void testIntVectorEqualsWithNull() {
        try (IntVector vector1 = new IntVector("int", this.allocator);
             IntVector vector2 = new IntVector("int", this.allocator);){
            ValueVectorDataPopulator.setVector(vector1, 1, 2);
            ValueVectorDataPopulator.setVector(vector2, 1, null);
            Assert.assertFalse((boolean)VectorEqualsVisitor.vectorEquals((ValueVector)vector1, (ValueVector)vector2));
        }
    }

    @Test
    public void testEqualsWithTypeChange() {
        try (IntVector vector1 = new IntVector("vector", this.allocator);
             IntVector vector2 = new IntVector("vector", this.allocator);
             BigIntVector vector3 = new BigIntVector("vector", this.allocator);){
            ValueVectorDataPopulator.setVector(vector1, 1, 2);
            ValueVectorDataPopulator.setVector(vector2, 1, 2);
            RangeEqualsVisitor visitor = new RangeEqualsVisitor((ValueVector)vector1, (ValueVector)vector2);
            Range range = new Range(0, 0, 2);
            Assert.assertTrue((boolean)((Boolean)vector1.accept((VectorVisitor)visitor, (Object)range)));
            Assert.assertFalse((boolean)((Boolean)vector3.accept((VectorVisitor)visitor, (Object)range)));
        }
    }

    @Test
    public void testBaseFixedWidthVectorRangeEqual() {
        try (IntVector vector1 = new IntVector("int", this.allocator);
             IntVector vector2 = new IntVector("int", this.allocator);){
            ValueVectorDataPopulator.setVector(vector1, 1, 2, 3, 4, 5);
            ValueVectorDataPopulator.setVector(vector2, 11, 2, 3, 4, 55);
            RangeEqualsVisitor visitor = new RangeEqualsVisitor((ValueVector)vector1, (ValueVector)vector2);
            Assert.assertTrue((boolean)visitor.rangeEquals(new Range(1, 1, 3)));
        }
    }

    @Test
    public void testBaseVariableVectorRangeEquals() {
        try (VarCharVector vector1 = new VarCharVector("varchar", this.allocator);
             VarCharVector vector2 = new VarCharVector("varchar", this.allocator);){
            ValueVectorDataPopulator.setVector(vector1, (byte[][])new byte[][]{STR1, STR2, STR3, STR2, STR1});
            ValueVectorDataPopulator.setVector(vector2, (byte[][])new byte[][]{STR1, STR2, STR3, STR2, STR1});
            RangeEqualsVisitor visitor = new RangeEqualsVisitor((ValueVector)vector1, (ValueVector)vector2);
            Assert.assertTrue((boolean)visitor.rangeEquals(new Range(1, 1, 3)));
        }
    }

    @Test
    public void testListVectorWithDifferentChild() {
        try (ListVector vector1 = ListVector.empty((String)"list", (BufferAllocator)this.allocator);
             ListVector vector2 = ListVector.empty((String)"list", (BufferAllocator)this.allocator);){
            vector1.allocateNew();
            vector1.initializeChildrenFromFields(Arrays.asList(Field.nullable((String)"child", (ArrowType)new ArrowType.Int(32, true))));
            vector2.allocateNew();
            vector2.initializeChildrenFromFields(Arrays.asList(Field.nullable((String)"child", (ArrowType)new ArrowType.Int(64, true))));
            RangeEqualsVisitor visitor = new RangeEqualsVisitor((ValueVector)vector1, (ValueVector)vector2);
            Assert.assertFalse((boolean)visitor.rangeEquals(new Range(0, 0, 0)));
        }
    }

    @Test
    public void testListVectorRangeEquals() {
        try (ListVector vector1 = ListVector.empty((String)"list", (BufferAllocator)this.allocator);
             ListVector vector2 = ListVector.empty((String)"list", (BufferAllocator)this.allocator);){
            UnionListWriter writer1 = vector1.getWriter();
            writer1.allocate();
            this.writeListVector(writer1, new int[]{1, 2});
            this.writeListVector(writer1, new int[]{3, 4});
            this.writeListVector(writer1, new int[]{5, 6});
            this.writeListVector(writer1, new int[]{7, 8});
            this.writeListVector(writer1, new int[]{9, 10});
            writer1.setValueCount(5);
            UnionListWriter writer2 = vector2.getWriter();
            writer2.allocate();
            this.writeListVector(writer2, new int[]{0, 0});
            this.writeListVector(writer2, new int[]{3, 4});
            this.writeListVector(writer2, new int[]{5, 6});
            this.writeListVector(writer2, new int[]{7, 8});
            this.writeListVector(writer2, new int[]{0, 0});
            writer2.setValueCount(5);
            RangeEqualsVisitor visitor = new RangeEqualsVisitor((ValueVector)vector1, (ValueVector)vector2);
            Assert.assertTrue((boolean)visitor.rangeEquals(new Range(1, 1, 3)));
        }
    }

    @Test
    public void testFixedSizeListVectorRangeEquals() {
        try (FixedSizeListVector vector1 = FixedSizeListVector.empty((String)"list", (int)2, (BufferAllocator)this.allocator);
             FixedSizeListVector vector2 = FixedSizeListVector.empty((String)"list", (int)2, (BufferAllocator)this.allocator);){
            UnionFixedSizeListWriter writer1 = vector1.getWriter();
            writer1.allocate();
            this.writeFixedSizeListVector(writer1, new int[]{1, 2});
            this.writeFixedSizeListVector(writer1, new int[]{3, 4});
            this.writeFixedSizeListVector(writer1, new int[]{5, 6});
            this.writeFixedSizeListVector(writer1, new int[]{7, 8});
            this.writeFixedSizeListVector(writer1, new int[]{9, 10});
            writer1.setValueCount(5);
            UnionFixedSizeListWriter writer2 = vector2.getWriter();
            writer2.allocate();
            this.writeFixedSizeListVector(writer2, new int[]{0, 0});
            this.writeFixedSizeListVector(writer2, new int[]{3, 4});
            this.writeFixedSizeListVector(writer2, new int[]{5, 6});
            this.writeFixedSizeListVector(writer2, new int[]{7, 8});
            this.writeFixedSizeListVector(writer2, new int[]{0, 0});
            writer2.setValueCount(5);
            RangeEqualsVisitor visitor = new RangeEqualsVisitor((ValueVector)vector1, (ValueVector)vector2);
            Assert.assertTrue((boolean)visitor.rangeEquals(new Range(1, 1, 3)));
            Assert.assertFalse((boolean)visitor.rangeEquals(new Range(0, 0, 5)));
        }
    }

    @Test
    public void testLargeVariableWidthVectorRangeEquals() {
        try (LargeVarCharVector vector1 = new LargeVarCharVector("vector1", this.allocator);
             LargeVarCharVector vector2 = new LargeVarCharVector("vector2", this.allocator);){
            ValueVectorDataPopulator.setVector(vector1, "aaa", "bbb", "ccc", null, "ddd");
            ValueVectorDataPopulator.setVector(vector2, "ccc", "aaa", "bbb", null, "ddd");
            RangeEqualsVisitor visitor = new RangeEqualsVisitor((ValueVector)vector1, (ValueVector)vector2, (v1, v2) -> new TypeEqualsVisitor(v2, false, false).equals(v1));
            Assert.assertFalse((boolean)visitor.rangeEquals(new Range(0, 0, 1)));
            Assert.assertTrue((boolean)visitor.rangeEquals(new Range(0, 1, 1)));
            Assert.assertFalse((boolean)visitor.rangeEquals(new Range(0, 0, 3)));
            Assert.assertTrue((boolean)visitor.rangeEquals(new Range(0, 1, 2)));
            Assert.assertTrue((boolean)visitor.rangeEquals(new Range(3, 3, 1)));
            Assert.assertTrue((boolean)visitor.rangeEquals(new Range(3, 3, 2)));
            Assert.assertFalse((boolean)visitor.rangeEquals(new Range(2, 2, 2)));
        }
    }

    @Test
    public void testStructVectorRangeEquals() {
        try (StructVector vector1 = StructVector.empty((String)"struct", (BufferAllocator)this.allocator);
             StructVector vector2 = StructVector.empty((String)"struct", (BufferAllocator)this.allocator);){
            vector1.addOrGet("f0", FieldType.nullable((ArrowType)new ArrowType.Int(32, true)), IntVector.class);
            vector1.addOrGet("f1", FieldType.nullable((ArrowType)new ArrowType.Int(64, true)), BigIntVector.class);
            vector2.addOrGet("f0", FieldType.nullable((ArrowType)new ArrowType.Int(32, true)), IntVector.class);
            vector2.addOrGet("f1", FieldType.nullable((ArrowType)new ArrowType.Int(64, true)), BigIntVector.class);
            NullableStructWriter writer1 = vector1.getWriter();
            writer1.allocate();
            this.writeStructVector(writer1, 1, 10L);
            this.writeStructVector(writer1, 2, 20L);
            this.writeStructVector(writer1, 3, 30L);
            this.writeStructVector(writer1, 4, 40L);
            this.writeStructVector(writer1, 5, 50L);
            writer1.setValueCount(5);
            NullableStructWriter writer2 = vector2.getWriter();
            writer2.allocate();
            this.writeStructVector(writer2, 0, 0L);
            this.writeStructVector(writer2, 2, 20L);
            this.writeStructVector(writer2, 3, 30L);
            this.writeStructVector(writer2, 4, 40L);
            this.writeStructVector(writer2, 0, 0L);
            writer2.setValueCount(5);
            RangeEqualsVisitor visitor = new RangeEqualsVisitor((ValueVector)vector1, (ValueVector)vector2);
            Assert.assertTrue((boolean)visitor.rangeEquals(new Range(1, 1, 3)));
        }
    }

    @Test
    public void testUnionVectorRangeEquals() {
        try (UnionVector vector1 = new UnionVector("union", this.allocator, null);
             UnionVector vector2 = new UnionVector("union", this.allocator, null);){
            NullableUInt4Holder uInt4Holder = new NullableUInt4Holder();
            uInt4Holder.value = 10;
            uInt4Holder.isSet = 1;
            NullableIntHolder intHolder = new NullableIntHolder();
            uInt4Holder.value = 20;
            uInt4Holder.isSet = 1;
            vector1.setType(0, Types.MinorType.UINT4);
            vector1.setSafe(0, uInt4Holder);
            vector1.setType(1, Types.MinorType.INT);
            vector1.setSafe(1, intHolder);
            vector1.setType(2, Types.MinorType.INT);
            vector1.setSafe(2, intHolder);
            vector1.setValueCount(3);
            vector2.setType(0, Types.MinorType.UINT4);
            vector2.setSafe(0, uInt4Holder);
            vector2.setType(1, Types.MinorType.INT);
            vector2.setSafe(1, intHolder);
            vector2.setType(2, Types.MinorType.INT);
            vector2.setSafe(2, intHolder);
            vector2.setValueCount(3);
            RangeEqualsVisitor visitor = new RangeEqualsVisitor((ValueVector)vector1, (ValueVector)vector2);
            Assert.assertTrue((boolean)visitor.rangeEquals(new Range(1, 1, 2)));
        }
    }

    @Test
    public void testUnionVectorSubRangeEquals() {
        try (UnionVector vector1 = new UnionVector("union", this.allocator, null, null);
             UnionVector vector2 = new UnionVector("union", this.allocator, null, null);){
            NullableUInt4Holder uInt4Holder = new NullableUInt4Holder();
            uInt4Holder.value = 10;
            uInt4Holder.isSet = 1;
            NullableIntHolder intHolder = new NullableIntHolder();
            intHolder.value = 20;
            intHolder.isSet = 1;
            vector1.setType(0, Types.MinorType.UINT4);
            vector1.setSafe(0, uInt4Holder);
            vector1.setType(1, Types.MinorType.INT);
            vector1.setSafe(1, intHolder);
            vector1.setType(2, Types.MinorType.INT);
            vector1.setSafe(2, intHolder);
            vector1.setType(3, Types.MinorType.INT);
            vector1.setSafe(3, intHolder);
            vector1.setValueCount(4);
            vector2.setType(0, Types.MinorType.UINT4);
            vector2.setSafe(0, uInt4Holder);
            vector2.setType(1, Types.MinorType.INT);
            vector2.setSafe(1, intHolder);
            vector2.setType(2, Types.MinorType.INT);
            vector2.setSafe(2, intHolder);
            vector2.setType(3, Types.MinorType.UINT4);
            vector2.setSafe(3, uInt4Holder);
            vector2.setValueCount(4);
            RangeEqualsVisitor visitor = new RangeEqualsVisitor((ValueVector)vector1, (ValueVector)vector2);
            Assert.assertFalse((boolean)visitor.rangeEquals(new Range(0, 0, 4)));
            Assert.assertTrue((boolean)visitor.rangeEquals(new Range(1, 1, 2)));
        }
    }

    @Test
    public void testDenseUnionVectorEquals() {
        NullableIntHolder intHolder = new NullableIntHolder();
        intHolder.isSet = 1;
        intHolder.value = 100;
        NullableBigIntHolder bigIntHolder = new NullableBigIntHolder();
        bigIntHolder.isSet = 1;
        bigIntHolder.value = 200L;
        NullableFloat4Holder float4Holder = new NullableFloat4Holder();
        float4Holder.isSet = 1;
        float4Holder.value = 400.0f;
        NullableFloat8Holder float8Holder = new NullableFloat8Holder();
        float8Holder.isSet = 1;
        float8Holder.value = 800.0;
        try (DenseUnionVector vector1 = new DenseUnionVector("vector1", this.allocator, null, null);
             DenseUnionVector vector2 = new DenseUnionVector("vector2", this.allocator, null, null);){
            vector1.allocateNew();
            vector2.allocateNew();
            byte intTypeId = vector1.registerNewTypeId(Field.nullable((String)"int", (ArrowType)Types.MinorType.INT.getType()));
            byte longTypeId = vector1.registerNewTypeId(Field.nullable((String)"long", (ArrowType)Types.MinorType.BIGINT.getType()));
            byte floatTypeId = vector1.registerNewTypeId(Field.nullable((String)"float", (ArrowType)Types.MinorType.FLOAT4.getType()));
            byte doubleTypeId = vector1.registerNewTypeId(Field.nullable((String)"double", (ArrowType)Types.MinorType.FLOAT8.getType()));
            vector1.setTypeId(0, intTypeId);
            vector1.setSafe(0, intHolder);
            vector1.setTypeId(1, longTypeId);
            vector1.setSafe(1, bigIntHolder);
            vector1.setTypeId(3, floatTypeId);
            vector1.setSafe(3, float4Holder);
            vector1.setTypeId(4, doubleTypeId);
            vector1.setSafe(4, float8Holder);
            vector1.setValueCount(5);
            intTypeId = vector2.registerNewTypeId(Field.nullable((String)"int", (ArrowType)Types.MinorType.INT.getType()));
            longTypeId = vector2.registerNewTypeId(Field.nullable((String)"long", (ArrowType)Types.MinorType.BIGINT.getType()));
            floatTypeId = vector2.registerNewTypeId(Field.nullable((String)"float", (ArrowType)Types.MinorType.FLOAT4.getType()));
            doubleTypeId = vector2.registerNewTypeId(Field.nullable((String)"double", (ArrowType)Types.MinorType.FLOAT8.getType()));
            vector2.setTypeId(0, floatTypeId);
            vector2.setSafe(0, float4Holder);
            vector2.setTypeId(2, longTypeId);
            vector2.setSafe(2, bigIntHolder);
            vector2.setTypeId(4, floatTypeId);
            vector2.setSafe(4, float4Holder);
            vector2.setTypeId(5, doubleTypeId);
            vector2.setSafe(5, float8Holder);
            vector2.setTypeId(6, intTypeId);
            vector2.setSafe(6, intHolder);
            vector2.setValueCount(7);
            TypeEqualsVisitor typeVisitor = new TypeEqualsVisitor((ValueVector)vector2, false, true);
            RangeEqualsVisitor equalsVisitor = new RangeEqualsVisitor((ValueVector)vector1, (ValueVector)vector2, (left, right) -> typeVisitor.equals(left));
            Assert.assertFalse((boolean)equalsVisitor.rangeEquals(new Range(0, 0, 2)));
            Assert.assertFalse((boolean)equalsVisitor.rangeEquals(new Range(3, 5, 2)));
            Assert.assertTrue((boolean)equalsVisitor.rangeEquals(new Range(1, 2, 4)));
            Assert.assertTrue((boolean)equalsVisitor.rangeEquals(new Range(3, 4, 2)));
            Assert.assertTrue((boolean)equalsVisitor.rangeEquals(new Range(2, 3, 1)));
            Assert.assertTrue((boolean)equalsVisitor.rangeEquals(new Range(0, 6, 1)));
            Assert.assertFalse((boolean)equalsVisitor.rangeEquals(new Range(0, 2, 1)));
        }
    }

    @Ignore
    @Test
    public void testEqualsWithOutTypeCheck() {
        try (IntVector intVector = new IntVector("int", this.allocator);
             ZeroVector zeroVector = new ZeroVector();){
            Assert.assertTrue((boolean)VectorEqualsVisitor.vectorEquals((ValueVector)intVector, (ValueVector)zeroVector, null));
            Assert.assertTrue((boolean)VectorEqualsVisitor.vectorEquals((ValueVector)zeroVector, (ValueVector)intVector, null));
        }
    }

    @Test
    public void testFloat4ApproxEquals() {
        try (Float4Vector vector1 = new Float4Vector("float", this.allocator);
             Float4Vector vector2 = new Float4Vector("float", this.allocator);
             Float4Vector vector3 = new Float4Vector("float", this.allocator);){
            float epsilon = 1.0E-6f;
            ValueVectorDataPopulator.setVector(vector1, Float.valueOf(1.1f), Float.valueOf(2.2f));
            ValueVectorDataPopulator.setVector(vector2, Float.valueOf(1.1000005f), Float.valueOf(2.2000005f));
            ValueVectorDataPopulator.setVector(vector3, Float.valueOf(1.100002f), Float.valueOf(2.200002f));
            Range range = new Range(0, 0, vector1.getValueCount());
            ApproxEqualsVisitor visitor12 = new ApproxEqualsVisitor((ValueVector)vector1, (ValueVector)vector2, 1.0E-6f, (double)1.0E-6f);
            Assert.assertTrue((boolean)visitor12.rangeEquals(range));
            ApproxEqualsVisitor visitor13 = new ApproxEqualsVisitor((ValueVector)vector1, (ValueVector)vector3, 1.0E-6f, (double)1.0E-6f);
            Assert.assertFalse((boolean)visitor13.rangeEquals(range));
        }
    }

    @Test
    public void testFloat8ApproxEquals() {
        try (Float8Vector vector1 = new Float8Vector("float", this.allocator);
             Float8Vector vector2 = new Float8Vector("float", this.allocator);
             Float8Vector vector3 = new Float8Vector("float", this.allocator);){
            float epsilon = 1.0E-6f;
            ValueVectorDataPopulator.setVector(vector1, 1.1, 2.2);
            ValueVectorDataPopulator.setVector(vector2, 1.1000004999999988, 2.200000499999999);
            ValueVectorDataPopulator.setVector(vector3, 1.100001999999995, 2.200001999999995);
            Range range = new Range(0, 0, vector1.getValueCount());
            Assert.assertTrue((boolean)new ApproxEqualsVisitor((ValueVector)vector1, (ValueVector)vector2, 1.0E-6f, (double)1.0E-6f).rangeEquals(range));
            Assert.assertFalse((boolean)new ApproxEqualsVisitor((ValueVector)vector1, (ValueVector)vector3, 1.0E-6f, (double)1.0E-6f).rangeEquals(range));
        }
    }

    @Test
    public void testStructVectorApproxEquals() {
        try (StructVector right = StructVector.empty((String)"struct", (BufferAllocator)this.allocator);
             StructVector left1 = StructVector.empty((String)"struct", (BufferAllocator)this.allocator);
             StructVector left2 = StructVector.empty((String)"struct", (BufferAllocator)this.allocator);){
            right.addOrGet("f0", FieldType.nullable((ArrowType)new ArrowType.FloatingPoint(FloatingPointPrecision.SINGLE)), Float4Vector.class);
            right.addOrGet("f1", FieldType.nullable((ArrowType)new ArrowType.FloatingPoint(FloatingPointPrecision.DOUBLE)), Float8Vector.class);
            left1.addOrGet("f0", FieldType.nullable((ArrowType)new ArrowType.FloatingPoint(FloatingPointPrecision.SINGLE)), Float4Vector.class);
            left1.addOrGet("f1", FieldType.nullable((ArrowType)new ArrowType.FloatingPoint(FloatingPointPrecision.DOUBLE)), Float8Vector.class);
            left2.addOrGet("f0", FieldType.nullable((ArrowType)new ArrowType.FloatingPoint(FloatingPointPrecision.SINGLE)), Float4Vector.class);
            left2.addOrGet("f1", FieldType.nullable((ArrowType)new ArrowType.FloatingPoint(FloatingPointPrecision.DOUBLE)), Float8Vector.class);
            float epsilon = 1.0E-6f;
            NullableStructWriter rightWriter = right.getWriter();
            rightWriter.allocate();
            this.writeStructVector(rightWriter, 1.1f, 2.2);
            this.writeStructVector(rightWriter, 2.02f, 4.04);
            rightWriter.setValueCount(2);
            NullableStructWriter leftWriter1 = left1.getWriter();
            leftWriter1.allocate();
            this.writeStructVector(leftWriter1, 1.1000005f, 2.200000499999999);
            this.writeStructVector(leftWriter1, 2.0199995f, 4.039999500000001);
            leftWriter1.setValueCount(2);
            NullableStructWriter leftWriter2 = left2.getWriter();
            leftWriter2.allocate();
            this.writeStructVector(leftWriter2, 1.100002f, 2.200001999999995);
            this.writeStructVector(leftWriter2, 2.019998f, 4.039998000000005);
            leftWriter2.setValueCount(2);
            Range range = new Range(0, 0, right.getValueCount());
            Assert.assertTrue((boolean)new ApproxEqualsVisitor((ValueVector)left1, (ValueVector)right, 1.0E-6f, (double)1.0E-6f).rangeEquals(range));
            Assert.assertFalse((boolean)new ApproxEqualsVisitor((ValueVector)left2, (ValueVector)right, 1.0E-6f, (double)1.0E-6f).rangeEquals(range));
        }
    }

    @Test
    public void testUnionVectorApproxEquals() {
        try (UnionVector right = new UnionVector("union", this.allocator, null);
             UnionVector left1 = new UnionVector("union", this.allocator, null);
             UnionVector left2 = new UnionVector("union", this.allocator, null);){
            NullableFloat4Holder float4Holder = new NullableFloat4Holder();
            float4Holder.value = 1.01f;
            float4Holder.isSet = 1;
            NullableFloat8Holder float8Holder = new NullableFloat8Holder();
            float8Holder.value = 2.02f;
            float8Holder.isSet = 1;
            float epsilon = 1.0E-6f;
            right.setType(0, Types.MinorType.FLOAT4);
            right.setSafe(0, float4Holder);
            right.setType(1, Types.MinorType.FLOAT8);
            right.setSafe(1, float8Holder);
            right.setValueCount(2);
            float4Holder.value += 5.0E-7f;
            float8Holder.value += (double)5.0E-7f;
            left1.setType(0, Types.MinorType.FLOAT4);
            left1.setSafe(0, float4Holder);
            left1.setType(1, Types.MinorType.FLOAT8);
            left1.setSafe(1, float8Holder);
            left1.setValueCount(2);
            float4Holder.value += 2.0E-6f;
            float8Holder.value += (double)2.0E-6f;
            left2.setType(0, Types.MinorType.FLOAT4);
            left2.setSafe(0, float4Holder);
            left2.setType(1, Types.MinorType.FLOAT8);
            left2.setSafe(1, float8Holder);
            left2.setValueCount(2);
            Range range = new Range(0, 0, right.getValueCount());
            Assert.assertTrue((boolean)new ApproxEqualsVisitor((ValueVector)left1, (ValueVector)right, 1.0E-6f, (double)1.0E-6f).rangeEquals(range));
            Assert.assertFalse((boolean)new ApproxEqualsVisitor((ValueVector)left2, (ValueVector)right, 1.0E-6f, (double)1.0E-6f).rangeEquals(range));
        }
    }

    @Test
    public void testDenseUnionVectorApproxEquals() {
        NullableFloat4Holder float4Holder = new NullableFloat4Holder();
        float4Holder.isSet = 1;
        NullableFloat8Holder float8Holder = new NullableFloat8Holder();
        float8Holder.isSet = 1;
        float floatEpsilon = 0.02f;
        double doubleEpsilon = 0.02;
        try (DenseUnionVector vector1 = new DenseUnionVector("vector1", this.allocator, null, null);
             DenseUnionVector vector2 = new DenseUnionVector("vector2", this.allocator, null, null);
             DenseUnionVector vector3 = new DenseUnionVector("vector2", this.allocator, null, null);){
            vector1.allocateNew();
            vector2.allocateNew();
            vector3.allocateNew();
            byte floatTypeId = vector1.registerNewTypeId(Field.nullable((String)"float", (ArrowType)Types.MinorType.FLOAT4.getType()));
            byte doubleTypeId = vector1.registerNewTypeId(Field.nullable((String)"double", (ArrowType)Types.MinorType.FLOAT8.getType()));
            float4Holder.value = 1.0f;
            vector1.setTypeId(0, floatTypeId);
            vector1.setSafe(0, float4Holder);
            float8Holder.value = 2.0;
            vector1.setTypeId(1, doubleTypeId);
            vector1.setSafe(1, float8Holder);
            vector1.setValueCount(2);
            floatTypeId = vector2.registerNewTypeId(Field.nullable((String)"float", (ArrowType)Types.MinorType.FLOAT4.getType()));
            doubleTypeId = vector2.registerNewTypeId(Field.nullable((String)"double", (ArrowType)Types.MinorType.FLOAT8.getType()));
            float4Holder.value = 1.01f;
            vector2.setTypeId(0, floatTypeId);
            vector2.setSafe(0, float4Holder);
            float8Holder.value = 2.01;
            vector2.setTypeId(1, doubleTypeId);
            vector2.setSafe(1, float8Holder);
            vector2.setValueCount(2);
            floatTypeId = vector3.registerNewTypeId(Field.nullable((String)"float", (ArrowType)Types.MinorType.FLOAT4.getType()));
            doubleTypeId = vector3.registerNewTypeId(Field.nullable((String)"double", (ArrowType)Types.MinorType.FLOAT8.getType()));
            float4Holder.value = 1.05f;
            vector3.setTypeId(0, floatTypeId);
            vector3.setSafe(0, float4Holder);
            float8Holder.value = 2.05;
            vector3.setTypeId(1, doubleTypeId);
            vector3.setSafe(1, float8Holder);
            vector3.setValueCount(2);
            Range range = new Range(0, 0, 2);
            ApproxEqualsVisitor approxEqualsVisitor = new ApproxEqualsVisitor((ValueVector)vector1, (ValueVector)vector2, (VectorValueEqualizer)new ValueEpsilonEqualizers.Float4EpsilonEqualizer(0.02f), (VectorValueEqualizer)new ValueEpsilonEqualizers.Float8EpsilonEqualizer(0.02), (v1, v2) -> new TypeEqualsVisitor(v2, false, true).equals(v1));
            Assert.assertTrue((boolean)approxEqualsVisitor.rangeEquals(range));
            approxEqualsVisitor = new ApproxEqualsVisitor((ValueVector)vector1, (ValueVector)vector3, (VectorValueEqualizer)new ValueEpsilonEqualizers.Float4EpsilonEqualizer(0.02f), (VectorValueEqualizer)new ValueEpsilonEqualizers.Float8EpsilonEqualizer(0.02), (v1, v2) -> new TypeEqualsVisitor(v2, false, true).equals(v1));
            Assert.assertFalse((boolean)approxEqualsVisitor.rangeEquals(range));
        }
    }

    @Test
    public void testListVectorApproxEquals() {
        try (ListVector right = ListVector.empty((String)"list", (BufferAllocator)this.allocator);
             ListVector left1 = ListVector.empty((String)"list", (BufferAllocator)this.allocator);
             ListVector left2 = ListVector.empty((String)"list", (BufferAllocator)this.allocator);){
            float epsilon = 1.0E-6f;
            UnionListWriter rightWriter = right.getWriter();
            rightWriter.allocate();
            this.writeListVector(rightWriter, new double[]{1.0, 2.0});
            this.writeListVector(rightWriter, new double[]{1.01, 2.02});
            rightWriter.setValueCount(2);
            UnionListWriter leftWriter1 = left1.getWriter();
            leftWriter1.allocate();
            this.writeListVector(leftWriter1, new double[]{1.0, 2.0});
            this.writeListVector(leftWriter1, new double[]{1.0100004999999987, 2.0199995000000013});
            leftWriter1.setValueCount(2);
            UnionListWriter leftWriter2 = left2.getWriter();
            leftWriter2.allocate();
            this.writeListVector(leftWriter2, new double[]{1.0, 2.0});
            this.writeListVector(leftWriter2, new double[]{1.010001999999995, 2.019998000000005});
            leftWriter2.setValueCount(2);
            Range range = new Range(0, 0, right.getValueCount());
            Assert.assertTrue((boolean)new ApproxEqualsVisitor((ValueVector)left1, (ValueVector)right, 1.0E-6f, (double)1.0E-6f).rangeEquals(range));
            Assert.assertFalse((boolean)new ApproxEqualsVisitor((ValueVector)left2, (ValueVector)right, 1.0E-6f, (double)1.0E-6f).rangeEquals(range));
        }
    }

    private void writeStructVector(NullableStructWriter writer, int value1, long value2) {
        writer.start();
        writer.integer("f0").writeInt(value1);
        writer.bigInt("f1").writeBigInt(value2);
        writer.end();
    }

    private void writeStructVector(NullableStructWriter writer, float value1, double value2) {
        writer.start();
        writer.float4("f0").writeFloat4(value1);
        writer.float8("f1").writeFloat8(value2);
        writer.end();
    }

    private void writeListVector(UnionListWriter writer, int[] values) {
        writer.startList();
        for (int v : values) {
            writer.integer().writeInt(v);
        }
        writer.endList();
    }

    private void writeFixedSizeListVector(UnionFixedSizeListWriter writer, int[] values) {
        writer.startList();
        for (int v : values) {
            writer.integer().writeInt(v);
        }
        writer.endList();
    }

    private void writeListVector(UnionListWriter writer, double[] values) {
        writer.startList();
        for (double v : values) {
            writer.float8().writeFloat8(v);
        }
        writer.endList();
    }
}

