/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.vector;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.memory.rounding.DefaultRoundingPolicy;
import org.apache.arrow.memory.util.ArrowBufPointer;
import org.apache.arrow.memory.util.CommonUtil;
import org.apache.arrow.vector.BaseFixedWidthVector;
import org.apache.arrow.vector.BaseValueVector;
import org.apache.arrow.vector.BaseVariableWidthVector;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.BitVector;
import org.apache.arrow.vector.BitVectorHelper;
import org.apache.arrow.vector.DecimalVector;
import org.apache.arrow.vector.Float4Vector;
import org.apache.arrow.vector.Float8Vector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.TestUtils;
import org.apache.arrow.vector.UInt1Vector;
import org.apache.arrow.vector.UInt2Vector;
import org.apache.arrow.vector.UInt4Vector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.VarBinaryVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.VectorLoader;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.VectorUnloader;
import org.apache.arrow.vector.ZeroVector;
import org.apache.arrow.vector.compare.Range;
import org.apache.arrow.vector.compare.RangeEqualsVisitor;
import org.apache.arrow.vector.compare.VectorEqualsVisitor;
import org.apache.arrow.vector.complex.DenseUnionVector;
import org.apache.arrow.vector.complex.FixedSizeListVector;
import org.apache.arrow.vector.complex.ListVector;
import org.apache.arrow.vector.complex.StructVector;
import org.apache.arrow.vector.complex.UnionVector;
import org.apache.arrow.vector.complex.impl.NullableStructWriter;
import org.apache.arrow.vector.complex.impl.UnionListWriter;
import org.apache.arrow.vector.holders.NullableIntHolder;
import org.apache.arrow.vector.holders.NullableUInt4Holder;
import org.apache.arrow.vector.holders.NullableVarBinaryHolder;
import org.apache.arrow.vector.holders.NullableVarCharHolder;
import org.apache.arrow.vector.ipc.message.ArrowRecordBatch;
import org.apache.arrow.vector.testing.ValueVectorDataPopulator;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.arrow.vector.util.OversizedAllocationException;
import org.apache.arrow.vector.util.Text;
import org.apache.arrow.vector.util.TransferPair;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestValueVector {
    private static final String EMPTY_SCHEMA_PATH = "";
    private BufferAllocator allocator;
    private static final Charset utf8Charset = Charset.forName("UTF-8");
    private static final byte[] STR1 = "AAAAA1".getBytes(utf8Charset);
    private static final byte[] STR2 = "BBBBBBBBB2".getBytes(utf8Charset);
    private static final byte[] STR3 = "CCCC3".getBytes(utf8Charset);
    private static final byte[] STR4 = "DDDDDDDD4".getBytes(utf8Charset);
    private static final byte[] STR5 = "EEE5".getBytes(utf8Charset);
    private static final byte[] STR6 = "FFFFF6".getBytes(utf8Charset);
    private static final int MAX_VALUE_COUNT = Integer.getInteger("arrow.vector.max_allocation_bytes", Integer.MAX_VALUE) / 7;
    private static final int MAX_VALUE_COUNT_8BYTE = MAX_VALUE_COUNT / 2;

    @Before
    public void init() {
        this.allocator = new RootAllocator(Long.MAX_VALUE);
    }

    @After
    public void terminate() throws Exception {
        this.allocator.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFixedType1() {
        try (UInt4Vector vector = new UInt4Vector(EMPTY_SCHEMA_PATH, this.allocator);){
            boolean error = false;
            int initialCapacity = 0;
            vector.allocateNew(1024);
            initialCapacity = vector.getValueCapacity();
            Assert.assertTrue((initialCapacity >= 1024 ? 1 : 0) != 0);
            vector.setSafe(0, 100);
            vector.setSafe(1, 101);
            vector.setSafe(100, 102);
            vector.setSafe(1022, 103);
            vector.setSafe(1023, 104);
            Assert.assertEquals((long)100L, (long)vector.get(0));
            Assert.assertEquals((long)101L, (long)vector.get(1));
            Assert.assertEquals((long)102L, (long)vector.get(100));
            Assert.assertEquals((long)103L, (long)vector.get(1022));
            Assert.assertEquals((long)104L, (long)vector.get(1023));
            try {
                vector.set(initialCapacity, 10000);
            }
            catch (IndexOutOfBoundsException ie) {
                error = true;
            }
            finally {
                Assert.assertTrue((boolean)error);
                error = false;
            }
            try {
                vector.get(initialCapacity);
            }
            catch (IndexOutOfBoundsException ie) {
                error = true;
            }
            finally {
                Assert.assertTrue((boolean)error);
                error = false;
            }
            vector.setSafe(initialCapacity, 10000);
            Assert.assertTrue((vector.getValueCapacity() >= 2 * initialCapacity ? 1 : 0) != 0);
            Assert.assertEquals((long)100L, (long)vector.get(0));
            Assert.assertEquals((long)101L, (long)vector.get(1));
            Assert.assertEquals((long)102L, (long)vector.get(100));
            Assert.assertEquals((long)103L, (long)vector.get(1022));
            Assert.assertEquals((long)104L, (long)vector.get(1023));
            Assert.assertEquals((long)10000L, (long)vector.get(initialCapacity));
            int capacityBeforeReset = vector.getValueCapacity();
            vector.reset();
            Assert.assertEquals((long)capacityBeforeReset, (long)vector.getValueCapacity());
            for (int i = 0; i < capacityBeforeReset; ++i) {
                Assert.assertEquals((String)("non-zero data not expected at index: " + i), (Object)true, (Object)vector.isNull(i));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFixedType2() {
        try (IntVector intVector = new IntVector(EMPTY_SCHEMA_PATH, this.allocator);){
            boolean error = false;
            int initialCapacity = 16;
            intVector.setInitialCapacity(MAX_VALUE_COUNT - 1);
            intVector.setInitialCapacity(MAX_VALUE_COUNT);
            try {
                intVector.setInitialCapacity(MAX_VALUE_COUNT * 2);
            }
            catch (OversizedAllocationException oe) {
                error = true;
            }
            finally {
                Assert.assertTrue((boolean)error);
                error = false;
            }
            intVector.setInitialCapacity(initialCapacity);
            Assert.assertEquals((long)0L, (long)intVector.getValueCapacity());
            intVector.allocateNew();
            Assert.assertTrue((intVector.getValueCapacity() >= initialCapacity ? 1 : 0) != 0);
            initialCapacity = intVector.getValueCapacity();
            int j = 1;
            for (int i = 0; i < initialCapacity; i += 2) {
                intVector.set(i, j);
                ++j;
            }
            try {
                intVector.set(initialCapacity, j);
            }
            catch (IndexOutOfBoundsException ie) {
                error = true;
            }
            finally {
                Assert.assertTrue((boolean)error);
                error = false;
            }
            j = 1;
            for (int i = 0; i < initialCapacity; i += 2) {
                Assert.assertEquals((String)("unexpected value at index: " + i), (long)j, (long)intVector.get(i));
                ++j;
            }
            try {
                intVector.get(initialCapacity);
            }
            catch (IndexOutOfBoundsException ie) {
                error = true;
            }
            finally {
                Assert.assertTrue((boolean)error);
                error = false;
            }
            intVector.setSafe(initialCapacity, j);
            Assert.assertTrue((intVector.getValueCapacity() >= initialCapacity * 2 ? 1 : 0) != 0);
            j = 1;
            for (int i = 0; i <= initialCapacity; i += 2) {
                Assert.assertEquals((String)("unexpected value at index: " + i), (long)j, (long)intVector.get(i));
                ++j;
            }
            int capacityBeforeRealloc = intVector.getValueCapacity();
            intVector.reset();
            Assert.assertEquals((long)capacityBeforeRealloc, (long)intVector.getValueCapacity());
            for (int i = 0; i < capacityBeforeRealloc; ++i) {
                Assert.assertEquals((String)("non-zero data not expected at index: " + i), (Object)true, (Object)intVector.isNull(i));
            }
        }
    }

    @Test
    public void testSizeOfValueBuffer() {
        try (VarCharVector vector = new VarCharVector(EMPTY_SCHEMA_PATH, this.allocator);){
            int valueCount = 100;
            int currentSize = 0;
            vector.setInitialCapacity(valueCount);
            vector.allocateNew();
            vector.setValueCount(valueCount);
            for (int i = 0; i < valueCount; ++i) {
                currentSize += i;
                vector.setSafe(i, new byte[i]);
            }
            Assert.assertEquals((long)currentSize, (long)vector.sizeOfValueBuffer());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFixedType3() {
        try (Float4Vector floatVector = new Float4Vector(EMPTY_SCHEMA_PATH, this.allocator);){
            boolean error = false;
            int initialCapacity = 16;
            floatVector.setInitialCapacity(MAX_VALUE_COUNT - 1);
            floatVector.setInitialCapacity(MAX_VALUE_COUNT);
            try {
                floatVector.setInitialCapacity(MAX_VALUE_COUNT * 2);
            }
            catch (OversizedAllocationException oe) {
                error = true;
            }
            finally {
                Assert.assertTrue((boolean)error);
                error = false;
            }
            floatVector.setInitialCapacity(initialCapacity);
            Assert.assertEquals((long)0L, (long)floatVector.getValueCapacity());
            floatVector.allocateNew();
            Assert.assertTrue((floatVector.getValueCapacity() >= initialCapacity ? 1 : 0) != 0);
            initialCapacity = floatVector.getValueCapacity();
            floatVector.zeroVector();
            floatVector.set(0, 1.5f);
            floatVector.set(2, 2.5f);
            floatVector.set(4, 3.3f);
            floatVector.set(6, 4.8f);
            floatVector.set(8, 5.6f);
            floatVector.set(10, 6.6f);
            floatVector.set(12, 7.8f);
            floatVector.set(14, 8.5f);
            try {
                floatVector.set(initialCapacity, 9.5f);
            }
            catch (IndexOutOfBoundsException ie) {
                error = true;
            }
            finally {
                Assert.assertTrue((boolean)error);
                error = false;
            }
            Assert.assertEquals((float)1.5f, (float)floatVector.get(0), (float)0.0f);
            Assert.assertEquals((float)2.5f, (float)floatVector.get(2), (float)0.0f);
            Assert.assertEquals((float)3.3f, (float)floatVector.get(4), (float)0.0f);
            Assert.assertEquals((float)4.8f, (float)floatVector.get(6), (float)0.0f);
            Assert.assertEquals((float)5.6f, (float)floatVector.get(8), (float)0.0f);
            Assert.assertEquals((float)6.6f, (float)floatVector.get(10), (float)0.0f);
            Assert.assertEquals((float)7.8f, (float)floatVector.get(12), (float)0.0f);
            Assert.assertEquals((float)8.5f, (float)floatVector.get(14), (float)0.0f);
            try {
                floatVector.get(initialCapacity);
            }
            catch (IndexOutOfBoundsException ie) {
                error = true;
            }
            finally {
                Assert.assertTrue((boolean)error);
                error = false;
            }
            floatVector.setSafe(initialCapacity, 9.5f);
            Assert.assertTrue((floatVector.getValueCapacity() >= initialCapacity * 2 ? 1 : 0) != 0);
            Assert.assertEquals((float)1.5f, (float)floatVector.get(0), (float)0.0f);
            Assert.assertEquals((float)2.5f, (float)floatVector.get(2), (float)0.0f);
            Assert.assertEquals((float)3.3f, (float)floatVector.get(4), (float)0.0f);
            Assert.assertEquals((float)4.8f, (float)floatVector.get(6), (float)0.0f);
            Assert.assertEquals((float)5.6f, (float)floatVector.get(8), (float)0.0f);
            Assert.assertEquals((float)6.6f, (float)floatVector.get(10), (float)0.0f);
            Assert.assertEquals((float)7.8f, (float)floatVector.get(12), (float)0.0f);
            Assert.assertEquals((float)8.5f, (float)floatVector.get(14), (float)0.0f);
            Assert.assertEquals((float)9.5f, (float)floatVector.get(initialCapacity), (float)0.0f);
            int capacityBeforeReset = floatVector.getValueCapacity();
            floatVector.reset();
            Assert.assertEquals((long)capacityBeforeReset, (long)floatVector.getValueCapacity());
            for (int i = 0; i < capacityBeforeReset; ++i) {
                Assert.assertEquals((String)("non-zero data not expected at index: " + i), (Object)true, (Object)floatVector.isNull(i));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFixedType4() {
        try (Float8Vector floatVector = new Float8Vector(EMPTY_SCHEMA_PATH, this.allocator);){
            boolean error = false;
            int initialCapacity = 16;
            floatVector.setInitialCapacity(MAX_VALUE_COUNT_8BYTE - 1);
            floatVector.setInitialCapacity(MAX_VALUE_COUNT_8BYTE);
            try {
                floatVector.setInitialCapacity(MAX_VALUE_COUNT_8BYTE * 2);
            }
            catch (OversizedAllocationException oe) {
                error = true;
            }
            finally {
                Assert.assertTrue((boolean)error);
                error = false;
            }
            floatVector.setInitialCapacity(initialCapacity);
            Assert.assertEquals((long)0L, (long)floatVector.getValueCapacity());
            floatVector.allocateNew();
            Assert.assertTrue((floatVector.getValueCapacity() >= initialCapacity ? 1 : 0) != 0);
            initialCapacity = floatVector.getValueCapacity();
            floatVector.set(0, 1.55);
            floatVector.set(2, 2.53);
            floatVector.set(4, 3.36);
            floatVector.set(6, 4.82);
            floatVector.set(8, 5.67);
            floatVector.set(10, 6.67);
            floatVector.set(12, 7.87);
            floatVector.set(14, 8.56);
            try {
                floatVector.set(initialCapacity, 9.53);
            }
            catch (IndexOutOfBoundsException ie) {
                error = true;
            }
            finally {
                Assert.assertTrue((boolean)error);
                error = false;
            }
            Assert.assertEquals((double)1.55, (double)floatVector.get(0), (double)0.0);
            Assert.assertEquals((double)2.53, (double)floatVector.get(2), (double)0.0);
            Assert.assertEquals((double)3.36, (double)floatVector.get(4), (double)0.0);
            Assert.assertEquals((double)4.82, (double)floatVector.get(6), (double)0.0);
            Assert.assertEquals((double)5.67, (double)floatVector.get(8), (double)0.0);
            Assert.assertEquals((double)6.67, (double)floatVector.get(10), (double)0.0);
            Assert.assertEquals((double)7.87, (double)floatVector.get(12), (double)0.0);
            Assert.assertEquals((double)8.56, (double)floatVector.get(14), (double)0.0);
            try {
                floatVector.get(initialCapacity);
            }
            catch (IndexOutOfBoundsException ie) {
                error = true;
            }
            finally {
                Assert.assertTrue((boolean)error);
                error = false;
            }
            floatVector.setSafe(initialCapacity, 9.53);
            Assert.assertTrue((floatVector.getValueCapacity() >= initialCapacity * 2 ? 1 : 0) != 0);
            Assert.assertEquals((double)1.55, (double)floatVector.get(0), (double)0.0);
            Assert.assertEquals((double)2.53, (double)floatVector.get(2), (double)0.0);
            Assert.assertEquals((double)3.36, (double)floatVector.get(4), (double)0.0);
            Assert.assertEquals((double)4.82, (double)floatVector.get(6), (double)0.0);
            Assert.assertEquals((double)5.67, (double)floatVector.get(8), (double)0.0);
            Assert.assertEquals((double)6.67, (double)floatVector.get(10), (double)0.0);
            Assert.assertEquals((double)7.87, (double)floatVector.get(12), (double)0.0);
            Assert.assertEquals((double)8.56, (double)floatVector.get(14), (double)0.0);
            Assert.assertEquals((double)9.53, (double)floatVector.get(initialCapacity), (double)0.0);
            int capacityBeforeReset = floatVector.getValueCapacity();
            floatVector.reset();
            Assert.assertEquals((long)capacityBeforeReset, (long)floatVector.getValueCapacity());
            for (int i = 0; i < capacityBeforeReset; ++i) {
                Assert.assertEquals((String)("non-zero data not expected at index: " + i), (Object)true, (Object)floatVector.isNull(i));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNullableFixedType1() {
        try (UInt4Vector vector = TestUtils.newVector(UInt4Vector.class, EMPTY_SCHEMA_PATH, (ArrowType)new ArrowType.Int(32, false), this.allocator);){
            int j;
            boolean error = false;
            int initialCapacity = 1024;
            vector.setInitialCapacity(initialCapacity);
            Assert.assertEquals((long)0L, (long)vector.getValueCapacity());
            vector.allocateNew();
            Assert.assertTrue((vector.getValueCapacity() >= initialCapacity ? 1 : 0) != 0);
            initialCapacity = vector.getValueCapacity();
            vector.set(0, 100);
            vector.set(1, 101);
            vector.set(100, 102);
            vector.set(initialCapacity - 2, 103);
            vector.set(initialCapacity - 1, 104);
            Assert.assertEquals((long)100L, (long)vector.get(0));
            Assert.assertEquals((long)101L, (long)vector.get(1));
            Assert.assertEquals((long)102L, (long)vector.get(100));
            Assert.assertEquals((long)103L, (long)vector.get(initialCapacity - 2));
            Assert.assertEquals((long)104L, (long)vector.get(initialCapacity - 1));
            boolean val = false;
            int i = 2;
            for (j = 101; i <= 99 || j <= initialCapacity - 3; ++i, ++j) {
                if (i <= 99) {
                    Assert.assertTrue((boolean)vector.isNull(i));
                }
                if (j > initialCapacity - 3) continue;
                Assert.assertTrue((boolean)vector.isNull(j));
            }
            try {
                vector.set(initialCapacity, 10000);
            }
            catch (IndexOutOfBoundsException ie) {
                error = true;
            }
            finally {
                Assert.assertTrue((boolean)error);
                error = false;
            }
            try {
                vector.get(initialCapacity);
            }
            catch (IndexOutOfBoundsException ie) {
                error = true;
            }
            finally {
                Assert.assertTrue((boolean)error);
                error = false;
            }
            vector.setSafe(initialCapacity, 10000);
            Assert.assertTrue((vector.getValueCapacity() >= initialCapacity * 2 ? 1 : 0) != 0);
            Assert.assertEquals((long)100L, (long)vector.get(0));
            Assert.assertEquals((long)101L, (long)vector.get(1));
            Assert.assertEquals((long)102L, (long)vector.get(100));
            Assert.assertEquals((long)103L, (long)vector.get(initialCapacity - 2));
            Assert.assertEquals((long)104L, (long)vector.get(initialCapacity - 1));
            Assert.assertEquals((long)10000L, (long)vector.get(initialCapacity));
            val = false;
            i = 2;
            for (j = 101; i < 99 || j < initialCapacity - 3; ++i, ++j) {
                if (i <= 99) {
                    Assert.assertTrue((boolean)vector.isNull(i));
                }
                if (j > initialCapacity - 3) continue;
                Assert.assertTrue((boolean)vector.isNull(j));
            }
            int capacityBeforeReset = vector.getValueCapacity();
            vector.reset();
            Assert.assertEquals((long)capacityBeforeReset, (long)vector.getValueCapacity());
            for (int i2 = 0; i2 < capacityBeforeReset; ++i2) {
                Assert.assertTrue((String)("non-null data not expected at index: " + i2), (boolean)vector.isNull(i2));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNullableFixedType2() {
        try (Float4Vector vector = TestUtils.newVector(Float4Vector.class, EMPTY_SCHEMA_PATH, Types.MinorType.FLOAT4, this.allocator);){
            boolean error = false;
            int initialCapacity = 16;
            vector.setInitialCapacity(initialCapacity);
            Assert.assertEquals((long)0L, (long)vector.getValueCapacity());
            vector.allocateNew();
            Assert.assertTrue((vector.getValueCapacity() >= initialCapacity ? 1 : 0) != 0);
            initialCapacity = vector.getValueCapacity();
            vector.set(0, 100.5f);
            vector.set(2, 201.5f);
            vector.set(4, 300.3f);
            vector.set(6, 423.8f);
            vector.set(8, 555.6f);
            vector.set(10, 66.6f);
            vector.set(12, 78.8f);
            vector.set(14, 89.5f);
            try {
                vector.set(initialCapacity, 90.5f);
            }
            catch (IndexOutOfBoundsException ie) {
                error = true;
            }
            finally {
                Assert.assertTrue((boolean)error);
                error = false;
            }
            Assert.assertEquals((float)100.5f, (float)vector.get(0), (float)0.0f);
            Assert.assertTrue((boolean)vector.isNull(1));
            Assert.assertEquals((float)201.5f, (float)vector.get(2), (float)0.0f);
            Assert.assertTrue((boolean)vector.isNull(3));
            Assert.assertEquals((float)300.3f, (float)vector.get(4), (float)0.0f);
            Assert.assertTrue((boolean)vector.isNull(5));
            Assert.assertEquals((float)423.8f, (float)vector.get(6), (float)0.0f);
            Assert.assertTrue((boolean)vector.isNull(7));
            Assert.assertEquals((float)555.6f, (float)vector.get(8), (float)0.0f);
            Assert.assertTrue((boolean)vector.isNull(9));
            Assert.assertEquals((float)66.6f, (float)vector.get(10), (float)0.0f);
            Assert.assertTrue((boolean)vector.isNull(11));
            Assert.assertEquals((float)78.8f, (float)vector.get(12), (float)0.0f);
            Assert.assertTrue((boolean)vector.isNull(13));
            Assert.assertEquals((float)89.5f, (float)vector.get(14), (float)0.0f);
            Assert.assertTrue((boolean)vector.isNull(15));
            try {
                vector.get(initialCapacity);
            }
            catch (IndexOutOfBoundsException ie) {
                error = true;
            }
            finally {
                Assert.assertTrue((boolean)error);
                error = false;
            }
            vector.setSafe(initialCapacity, 90.5f);
            Assert.assertTrue((vector.getValueCapacity() >= 2 * initialCapacity ? 1 : 0) != 0);
            Assert.assertEquals((float)100.5f, (float)vector.get(0), (float)0.0f);
            Assert.assertTrue((boolean)vector.isNull(1));
            Assert.assertEquals((float)201.5f, (float)vector.get(2), (float)0.0f);
            Assert.assertTrue((boolean)vector.isNull(3));
            Assert.assertEquals((float)300.3f, (float)vector.get(4), (float)0.0f);
            Assert.assertTrue((boolean)vector.isNull(5));
            Assert.assertEquals((float)423.8f, (float)vector.get(6), (float)0.0f);
            Assert.assertTrue((boolean)vector.isNull(7));
            Assert.assertEquals((float)555.6f, (float)vector.get(8), (float)0.0f);
            Assert.assertTrue((boolean)vector.isNull(9));
            Assert.assertEquals((float)66.6f, (float)vector.get(10), (float)0.0f);
            Assert.assertTrue((boolean)vector.isNull(11));
            Assert.assertEquals((float)78.8f, (float)vector.get(12), (float)0.0f);
            Assert.assertTrue((boolean)vector.isNull(13));
            Assert.assertEquals((float)89.5f, (float)vector.get(14), (float)0.0f);
            Assert.assertTrue((boolean)vector.isNull(15));
            int capacityBeforeReset = vector.getValueCapacity();
            vector.reset();
            Assert.assertEquals((long)capacityBeforeReset, (long)vector.getValueCapacity());
            for (int i = 0; i < capacityBeforeReset; ++i) {
                Assert.assertTrue((String)("non-null data not expected at index: " + i), (boolean)vector.isNull(i));
            }
        }
    }

    @Test
    public void testNullableFixedType3() {
        try (IntVector vector = TestUtils.newVector(IntVector.class, EMPTY_SCHEMA_PATH, Types.MinorType.INT, this.allocator);){
            int i;
            int i2;
            boolean error = false;
            int initialCapacity = 1024;
            Assert.assertEquals((long)0L, (long)vector.getValueCapacity());
            vector.allocateNew(initialCapacity);
            Assert.assertTrue((vector.getValueCapacity() >= initialCapacity ? 1 : 0) != 0);
            initialCapacity = vector.getValueCapacity();
            vector.set(0, 1);
            vector.set(1, 2);
            vector.set(100, 3);
            vector.set(1022, 4);
            vector.set(1023, 5);
            int j = 1;
            for (int i3 = 0; i3 <= 1023; ++i3) {
                if (i3 >= 2 && i3 <= 99 || i3 >= 101 && i3 <= 1021) {
                    Assert.assertTrue((String)("non-null data not expected at index: " + i3), (boolean)vector.isNull(i3));
                    continue;
                }
                Assert.assertFalse((String)("null data not expected at index: " + i3), (boolean)vector.isNull(i3));
                Assert.assertEquals((String)("unexpected value at index: " + i3), (long)j, (long)vector.get(i3));
                ++j;
            }
            vector.setValueCount(1024);
            Field field = vector.getField();
            List buffers = vector.getFieldBuffers();
            Assert.assertEquals((long)2L, (long)buffers.size());
            ArrowBuf validityVectorBuf = (ArrowBuf)buffers.get(0);
            Assert.assertTrue((validityVectorBuf.readableBytes() >= 128L ? 1 : 0) != 0);
            Assert.assertEquals((long)3L, (long)validityVectorBuf.getByte(0L));
            for (i2 = 1; i2 < 12; ++i2) {
                Assert.assertEquals((long)0L, (long)validityVectorBuf.getByte((long)i2));
            }
            Assert.assertEquals((long)16L, (long)validityVectorBuf.getByte(12L));
            for (i2 = 13; i2 < 127; ++i2) {
                Assert.assertEquals((long)0L, (long)validityVectorBuf.getByte((long)i2));
            }
            Assert.assertEquals((long)-64L, (long)validityVectorBuf.getByte(127L));
            vector.setSafe(initialCapacity, 6);
            Assert.assertTrue((vector.getValueCapacity() >= 2 * initialCapacity ? 1 : 0) != 0);
            j = 1;
            for (i2 = 0; i2 < initialCapacity * 2; ++i2) {
                if (i2 > 1023 && i2 != initialCapacity || i2 >= 2 && i2 <= 99 || i2 >= 101 && i2 <= 1021) {
                    Assert.assertTrue((String)("non-null data not expected at index: " + i2), (boolean)vector.isNull(i2));
                    continue;
                }
                Assert.assertFalse((String)("null data not expected at index: " + i2), (boolean)vector.isNull(i2));
                Assert.assertEquals((String)("unexpected value at index: " + i2), (long)j, (long)vector.get(i2));
                ++j;
            }
            int capacityBeforeReset = vector.getValueCapacity();
            vector.reset();
            Assert.assertEquals((long)capacityBeforeReset, (long)vector.getValueCapacity());
            for (i = 0; i < capacityBeforeReset; ++i) {
                Assert.assertTrue((String)("non-null data not expected at index: " + i), (boolean)vector.isNull(i));
            }
            vector.allocateNew(initialCapacity * 4);
            for (i = 0; i < initialCapacity * 4; ++i) {
                Assert.assertTrue((String)("non-null data not expected at index: " + i), (boolean)vector.isNull(i));
            }
        }
    }

    @Test
    public void testNullableFixedType4() {
        try (IntVector vector = TestUtils.newVector(IntVector.class, EMPTY_SCHEMA_PATH, Types.MinorType.INT, this.allocator);){
            int i;
            Assert.assertEquals((long)0L, (long)vector.getValueCapacity());
            vector.allocateNew();
            int valueCapacity = vector.getValueCapacity();
            Assert.assertEquals((long)3970L, (long)valueCapacity);
            int baseValue = 20000;
            for (i = 0; i < valueCapacity; ++i) {
                if ((i & 1) != 1) continue;
                vector.set(i, baseValue + i);
            }
            for (i = 0; i < valueCapacity; ++i) {
                if ((i & 1) == 1) {
                    Assert.assertFalse((String)("unexpected null value at index: " + i), (boolean)vector.isNull(i));
                    Assert.assertEquals((String)("unexpected value at index: " + i), (long)(baseValue + i), (long)vector.get(i));
                    continue;
                }
                Assert.assertTrue((String)("unexpected non-null value at index: " + i), (boolean)vector.isNull(i));
            }
            vector.setSafe(valueCapacity, 20000000);
            Assert.assertTrue((vector.getValueCapacity() >= valueCapacity * 2 ? 1 : 0) != 0);
            for (i = 0; i < vector.getValueCapacity(); ++i) {
                if (i == valueCapacity) {
                    Assert.assertFalse((String)("unexpected null value at index: " + i), (boolean)vector.isNull(i));
                    Assert.assertEquals((String)("unexpected value at index: " + i), (long)20000000L, (long)vector.get(i));
                    continue;
                }
                if (i < valueCapacity) {
                    if ((i & 1) != 1) continue;
                    Assert.assertFalse((String)("unexpected null value at index: " + i), (boolean)vector.isNull(i));
                    Assert.assertEquals((String)("unexpected value at index: " + i), (long)(baseValue + i), (long)vector.get(i));
                    continue;
                }
                Assert.assertTrue((String)("unexpected non-null value at index: " + i), (boolean)vector.isNull(i));
            }
            vector.zeroVector();
            for (i = 0; i < vector.getValueCapacity(); i += 2) {
                vector.set(i, baseValue + i);
            }
            for (i = 0; i < vector.getValueCapacity(); ++i) {
                if (i % 2 == 0) {
                    Assert.assertFalse((String)("unexpected null value at index: " + i), (boolean)vector.isNull(i));
                    Assert.assertEquals((String)("unexpected value at index: " + i), (long)(baseValue + i), (long)vector.get(i));
                    continue;
                }
                Assert.assertTrue((String)("unexpected non-null value at index: " + i), (boolean)vector.isNull(i));
            }
            int valueCapacityBeforeRealloc = vector.getValueCapacity();
            vector.setSafe(valueCapacityBeforeRealloc + 1000, 400000000);
            Assert.assertTrue((vector.getValueCapacity() >= valueCapacity * 4 ? 1 : 0) != 0);
            for (int i2 = 0; i2 < vector.getValueCapacity(); ++i2) {
                if (i2 == valueCapacityBeforeRealloc + 1000) {
                    Assert.assertFalse((String)("unexpected null value at index: " + i2), (boolean)vector.isNull(i2));
                    Assert.assertEquals((String)("unexpected value at index: " + i2), (long)400000000L, (long)vector.get(i2));
                    continue;
                }
                if (i2 < valueCapacityBeforeRealloc && i2 % 2 == 0) {
                    Assert.assertFalse((String)("unexpected null value at index: " + i2), (boolean)vector.isNull(i2));
                    Assert.assertEquals((String)("unexpected value at index: " + i2), (long)(baseValue + i2), (long)vector.get(i2));
                    continue;
                }
                Assert.assertTrue((String)("unexpected non-null value at index: " + i2), (boolean)vector.isNull(i2));
            }
            int valueCapacityBeforeReset = vector.getValueCapacity();
            vector.reset();
            Assert.assertEquals((long)valueCapacityBeforeReset, (long)vector.getValueCapacity());
            for (int i3 = 0; i3 < valueCapacityBeforeReset; ++i3) {
                Assert.assertTrue((String)("non-null data not expected at index: " + i3), (boolean)vector.isNull(i3));
            }
        }
    }

    @Test
    public void testSplitAndTransfer1() {
        try (VarCharVector targetVector = TestUtils.newVarCharVector("split-target", this.allocator);){
            try (VarCharVector sourceVector = TestUtils.newVarCharVector(EMPTY_SCHEMA_PATH, this.allocator);){
                sourceVector.allocateNew(10240L, 1024);
                sourceVector.set(0, STR1);
                sourceVector.set(1, STR2);
                sourceVector.set(2, STR3);
                sourceVector.setValueCount(3);
                long allocatedMem = this.allocator.getAllocatedMemory();
                int validityRefCnt = sourceVector.getValidityBuffer().refCnt();
                int offsetRefCnt = sourceVector.getOffsetBuffer().refCnt();
                int dataRefCnt = sourceVector.getDataBuffer().refCnt();
                sourceVector.splitAndTransferTo(0, 2, (BaseVariableWidthVector)targetVector);
                Assert.assertEquals((long)allocatedMem, (long)this.allocator.getAllocatedMemory());
                Assert.assertEquals((long)(validityRefCnt + 2), (long)sourceVector.getValidityBuffer().refCnt());
                Assert.assertEquals((long)(offsetRefCnt + 2), (long)sourceVector.getOffsetBuffer().refCnt());
                Assert.assertEquals((long)(dataRefCnt + 1), (long)sourceVector.getDataBuffer().refCnt());
            }
            Assert.assertArrayEquals((byte[])STR1, (byte[])targetVector.get(0));
            Assert.assertArrayEquals((byte[])STR2, (byte[])targetVector.get(1));
        }
    }

    @Test
    public void testSplitAndTransfer2() {
        try (VarCharVector sourceVector = TestUtils.newVarCharVector(EMPTY_SCHEMA_PATH, this.allocator);){
            try (VarCharVector targetVector = TestUtils.newVarCharVector("split-target", this.allocator);){
                sourceVector.allocateNew(10240L, 1024);
                sourceVector.set(0, STR1);
                sourceVector.set(1, STR2);
                sourceVector.set(2, STR3);
                sourceVector.setValueCount(3);
                long allocatedMem = this.allocator.getAllocatedMemory();
                int validityRefCnt = sourceVector.getValidityBuffer().refCnt();
                int offsetRefCnt = sourceVector.getOffsetBuffer().refCnt();
                int dataRefCnt = sourceVector.getDataBuffer().refCnt();
                sourceVector.splitAndTransferTo(0, 2, (BaseVariableWidthVector)targetVector);
                Assert.assertEquals((long)allocatedMem, (long)this.allocator.getAllocatedMemory());
                Assert.assertEquals((long)(validityRefCnt + 2), (long)sourceVector.getValidityBuffer().refCnt());
                Assert.assertEquals((long)(offsetRefCnt + 2), (long)sourceVector.getOffsetBuffer().refCnt());
                Assert.assertEquals((long)(dataRefCnt + 1), (long)sourceVector.getDataBuffer().refCnt());
            }
            Assert.assertArrayEquals((byte[])STR1, (byte[])sourceVector.get(0));
            Assert.assertArrayEquals((byte[])STR2, (byte[])sourceVector.get(1));
            Assert.assertArrayEquals((byte[])STR3, (byte[])sourceVector.get(2));
        }
    }

    @Test
    public void testSplitAndTransfer3() {
        try (VarCharVector targetVector = TestUtils.newVarCharVector("split-target", this.allocator);
             VarCharVector sourceVector = TestUtils.newVarCharVector(EMPTY_SCHEMA_PATH, this.allocator);){
            sourceVector.allocateNew(10240L, 1024);
            sourceVector.set(0, new byte[0]);
            sourceVector.setNull(1);
            sourceVector.set(2, STR1);
            sourceVector.set(3, STR2);
            sourceVector.set(4, STR3);
            sourceVector.setValueCount(5);
            long allocatedMem = this.allocator.getAllocatedMemory();
            int validityRefCnt = sourceVector.getValidityBuffer().refCnt();
            int offsetRefCnt = sourceVector.getOffsetBuffer().refCnt();
            int dataRefCnt = sourceVector.getDataBuffer().refCnt();
            sourceVector.splitAndTransferTo(2, 2, (BaseVariableWidthVector)targetVector);
            long validitySize = DefaultRoundingPolicy.DEFAULT_ROUNDING_POLICY.getRoundedSize((long)BaseValueVector.getValidityBufferSizeFromCount((int)2));
            Assert.assertEquals((long)(allocatedMem + validitySize), (long)this.allocator.getAllocatedMemory());
            Assert.assertEquals((long)(validityRefCnt + 1), (long)sourceVector.getValidityBuffer().refCnt());
            Assert.assertEquals((long)(offsetRefCnt + 1), (long)sourceVector.getOffsetBuffer().refCnt());
            Assert.assertEquals((long)(dataRefCnt + 1), (long)sourceVector.getDataBuffer().refCnt());
            Assert.assertArrayEquals((byte[])STR1, (byte[])targetVector.get(0));
            Assert.assertArrayEquals((byte[])STR2, (byte[])targetVector.get(1));
        }
    }

    @Test
    public void testSplitAndTransfer4() {
        try (BufferAllocator targetAllocator = this.allocator.newChildAllocator("target-alloc", 256L, 256L);
             VarCharVector targetVector = TestUtils.newVarCharVector("split-target", targetAllocator);){
            try (BufferAllocator sourceAllocator = this.allocator.newChildAllocator("source-alloc", 256L, 256L);
                 VarCharVector sourceVector = TestUtils.newVarCharVector(EMPTY_SCHEMA_PATH, sourceAllocator);){
                sourceVector.allocateNew(50L, 3);
                sourceVector.set(0, STR1);
                sourceVector.set(1, STR2);
                sourceVector.set(2, STR3);
                sourceVector.setValueCount(3);
                long allocatedMem = this.allocator.getAllocatedMemory();
                int validityRefCnt = sourceVector.getValidityBuffer().refCnt();
                int offsetRefCnt = sourceVector.getOffsetBuffer().refCnt();
                int dataRefCnt = sourceVector.getDataBuffer().refCnt();
                sourceVector.splitAndTransferTo(0, 2, (BaseVariableWidthVector)targetVector);
                Assert.assertEquals((long)allocatedMem, (long)this.allocator.getAllocatedMemory());
                Assert.assertEquals((long)validityRefCnt, (long)sourceVector.getValidityBuffer().refCnt());
                Assert.assertEquals((long)offsetRefCnt, (long)sourceVector.getOffsetBuffer().refCnt());
                Assert.assertEquals((long)dataRefCnt, (long)sourceVector.getDataBuffer().refCnt());
            }
            Assert.assertArrayEquals((byte[])STR1, (byte[])targetVector.get(0));
            Assert.assertArrayEquals((byte[])STR2, (byte[])targetVector.get(1));
        }
    }

    @Test
    public void testNullableVarType1() {
        try (VarCharVector vector = TestUtils.newVarCharVector(EMPTY_SCHEMA_PATH, this.allocator);){
            vector.allocateNew(10240L, 1024);
            vector.set(0, STR1);
            vector.set(1, STR2);
            vector.set(2, STR3);
            vector.setSafe(3, STR3, 1, STR3.length - 1);
            vector.setSafe(4, STR3, 2, STR3.length - 2);
            ByteBuffer str3ByteBuffer = ByteBuffer.wrap(STR3);
            vector.setSafe(5, str3ByteBuffer, 1, STR3.length - 1);
            vector.setSafe(6, str3ByteBuffer, 2, STR3.length - 2);
            Text txt = new Text("foo");
            vector.setSafe(7, txt);
            Assert.assertArrayEquals((byte[])STR1, (byte[])vector.get(0));
            Assert.assertArrayEquals((byte[])STR2, (byte[])vector.get(1));
            Assert.assertArrayEquals((byte[])STR3, (byte[])vector.get(2));
            Assert.assertArrayEquals((byte[])Arrays.copyOfRange(STR3, 1, STR3.length), (byte[])vector.get(3));
            Assert.assertArrayEquals((byte[])Arrays.copyOfRange(STR3, 2, STR3.length), (byte[])vector.get(4));
            Assert.assertArrayEquals((byte[])Arrays.copyOfRange(STR3, 1, STR3.length), (byte[])vector.get(5));
            Assert.assertArrayEquals((byte[])Arrays.copyOfRange(STR3, 2, STR3.length), (byte[])vector.get(6));
            Assert.assertEquals((Object)txt, (Object)vector.getObject(7));
            boolean b = false;
            Assert.assertNull((Object)vector.get(8));
        }
    }

    @Test
    public void testNullableVarType2() {
        try (VarBinaryVector vector = TestUtils.newVarBinaryVector(EMPTY_SCHEMA_PATH, this.allocator);){
            vector.allocateNew(10240L, 1024);
            vector.set(0, STR1);
            vector.set(1, STR2);
            vector.set(2, STR3);
            vector.setSafe(3, STR3, 1, STR3.length - 1);
            vector.setSafe(4, STR3, 2, STR3.length - 2);
            ByteBuffer str3ByteBuffer = ByteBuffer.wrap(STR3);
            vector.setSafe(5, str3ByteBuffer, 1, STR3.length - 1);
            vector.setSafe(6, str3ByteBuffer, 2, STR3.length - 2);
            Assert.assertArrayEquals((byte[])STR1, (byte[])vector.get(0));
            Assert.assertArrayEquals((byte[])STR2, (byte[])vector.get(1));
            Assert.assertArrayEquals((byte[])STR3, (byte[])vector.get(2));
            Assert.assertArrayEquals((byte[])Arrays.copyOfRange(STR3, 1, STR3.length), (byte[])vector.get(3));
            Assert.assertArrayEquals((byte[])Arrays.copyOfRange(STR3, 2, STR3.length), (byte[])vector.get(4));
            Assert.assertArrayEquals((byte[])Arrays.copyOfRange(STR3, 1, STR3.length), (byte[])vector.get(5));
            Assert.assertArrayEquals((byte[])Arrays.copyOfRange(STR3, 2, STR3.length), (byte[])vector.get(6));
            Assert.assertNull((Object)vector.get(7));
        }
    }

    @Test
    public void testReallocAfterVectorTransfer1() {
        try (Float8Vector vector = new Float8Vector(EMPTY_SCHEMA_PATH, this.allocator);){
            int i;
            int i2;
            int i3;
            int initialCapacity = 4096;
            boolean error = false;
            vector.setInitialCapacity(initialCapacity);
            vector.allocateNew();
            Assert.assertTrue((vector.getValueCapacity() >= initialCapacity ? 1 : 0) != 0);
            initialCapacity = vector.getValueCapacity();
            double baseValue = 100.375;
            for (i3 = 0; i3 < initialCapacity; ++i3) {
                vector.setSafe(i3, baseValue + (double)i3);
            }
            Assert.assertEquals((long)initialCapacity, (long)vector.getValueCapacity());
            for (i3 = 0; i3 < initialCapacity; ++i3) {
                double value = vector.get(i3);
                Assert.assertEquals((double)(baseValue + (double)i3), (double)value, (double)0.0);
            }
            vector.setSafe(initialCapacity, baseValue + (double)initialCapacity);
            Assert.assertTrue((vector.getValueCapacity() >= initialCapacity * 2 ? 1 : 0) != 0);
            int capacityAfterRealloc1 = vector.getValueCapacity();
            for (i2 = initialCapacity + 1; i2 < capacityAfterRealloc1; ++i2) {
                vector.setSafe(i2, baseValue + (double)i2);
            }
            for (i2 = 0; i2 < capacityAfterRealloc1; ++i2) {
                double value = vector.get(i2);
                Assert.assertEquals((double)(baseValue + (double)i2), (double)value, (double)0.0);
            }
            vector.setSafe(capacityAfterRealloc1, baseValue + (double)capacityAfterRealloc1);
            Assert.assertTrue((vector.getValueCapacity() >= initialCapacity * 4 ? 1 : 0) != 0);
            int capacityAfterRealloc2 = vector.getValueCapacity();
            for (i = capacityAfterRealloc1 + 1; i < capacityAfterRealloc2; ++i) {
                vector.setSafe(i, baseValue + (double)i);
            }
            for (i = 0; i < capacityAfterRealloc2; ++i) {
                double value = vector.get(i);
                Assert.assertEquals((double)(baseValue + (double)i), (double)value, (double)0.0);
            }
            TransferPair transferPair = vector.getTransferPair(this.allocator);
            transferPair.transfer();
            Float8Vector toVector = (Float8Vector)transferPair.getTo();
            toVector.reAlloc();
            Assert.assertTrue((toVector.getValueCapacity() >= initialCapacity * 8 ? 1 : 0) != 0);
            for (int i4 = 0; i4 < toVector.getValueCapacity(); ++i4) {
                if (i4 < capacityAfterRealloc2) {
                    Assert.assertEquals((double)(baseValue + (double)i4), (double)toVector.get(i4), (double)0.0);
                    continue;
                }
                Assert.assertTrue((boolean)toVector.isNull(i4));
            }
            toVector.close();
        }
    }

    @Test
    public void testReallocAfterVectorTransfer2() {
        try (Float8Vector vector = new Float8Vector(EMPTY_SCHEMA_PATH, this.allocator);){
            double value;
            int i;
            int i2;
            int i3;
            int i4;
            int initialCapacity = 4096;
            boolean error = false;
            vector.allocateNew(initialCapacity);
            Assert.assertTrue((vector.getValueCapacity() >= initialCapacity ? 1 : 0) != 0);
            initialCapacity = vector.getValueCapacity();
            double baseValue = 100.375;
            for (i4 = 0; i4 < initialCapacity; ++i4) {
                vector.setSafe(i4, baseValue + (double)i4);
            }
            Assert.assertEquals((long)initialCapacity, (long)vector.getValueCapacity());
            for (i4 = 0; i4 < initialCapacity; ++i4) {
                double value2 = vector.get(i4);
                Assert.assertEquals((double)(baseValue + (double)i4), (double)value2, (double)0.0);
            }
            vector.setSafe(initialCapacity, baseValue + (double)initialCapacity);
            Assert.assertTrue((vector.getValueCapacity() >= initialCapacity * 2 ? 1 : 0) != 0);
            int capacityAfterRealloc1 = vector.getValueCapacity();
            for (i3 = initialCapacity + 1; i3 < capacityAfterRealloc1; ++i3) {
                vector.setSafe(i3, baseValue + (double)i3);
            }
            for (i3 = 0; i3 < capacityAfterRealloc1; ++i3) {
                double value3 = vector.get(i3);
                Assert.assertEquals((double)(baseValue + (double)i3), (double)value3, (double)0.0);
            }
            vector.setSafe(capacityAfterRealloc1, baseValue + (double)capacityAfterRealloc1);
            Assert.assertTrue((vector.getValueCapacity() >= initialCapacity * 4 ? 1 : 0) != 0);
            int capacityAfterRealloc2 = vector.getValueCapacity();
            for (i2 = capacityAfterRealloc1 + 1; i2 < capacityAfterRealloc2; ++i2) {
                vector.setSafe(i2, baseValue + (double)i2);
            }
            for (i2 = 0; i2 < capacityAfterRealloc2; ++i2) {
                double value4 = vector.get(i2);
                Assert.assertEquals((double)(baseValue + (double)i2), (double)value4, (double)0.0);
            }
            TransferPair transferPair = vector.getTransferPair(this.allocator);
            transferPair.transfer();
            Float8Vector toVector = (Float8Vector)transferPair.getTo();
            for (i = 0; i < toVector.getValueCapacity(); ++i) {
                Assert.assertFalse((String)("unexpected null value at index: " + i), (boolean)toVector.isNull(i));
                value = toVector.get(i);
                Assert.assertEquals((String)("unexpected value at index: " + i), (double)(baseValue + (double)i), (double)value, (double)0.0);
            }
            toVector.reAlloc();
            Assert.assertTrue((toVector.getValueCapacity() >= initialCapacity * 8 ? 1 : 0) != 0);
            for (i = 0; i < toVector.getValueCapacity(); ++i) {
                if (i < capacityAfterRealloc2) {
                    Assert.assertFalse((String)("unexpected null value at index: " + i), (boolean)toVector.isNull(i));
                    value = toVector.get(i);
                    Assert.assertEquals((String)("unexpected value at index: " + i), (double)(baseValue + (double)i), (double)value, (double)0.0);
                    continue;
                }
                Assert.assertTrue((String)("unexpected non-null value at index: " + i), (boolean)toVector.isNull(i));
            }
            toVector.close();
        }
    }

    @Test
    public void testReallocAfterVectorTransfer3() {
        try (VarCharVector vector = new VarCharVector(EMPTY_SCHEMA_PATH, this.allocator);){
            int i;
            vector.allocateNew(40960L, 4096);
            int valueCapacity = vector.getValueCapacity();
            Assert.assertTrue((valueCapacity >= 4096 ? 1 : 0) != 0);
            for (i = 0; i < valueCapacity; ++i) {
                if ((i & 1) == 1) {
                    vector.set(i, STR1);
                    continue;
                }
                vector.set(i, STR2);
            }
            for (i = 0; i < valueCapacity; ++i) {
                if ((i & 1) == 1) {
                    Assert.assertArrayEquals((byte[])STR1, (byte[])vector.get(i));
                    continue;
                }
                Assert.assertArrayEquals((byte[])STR2, (byte[])vector.get(i));
            }
            vector.setSafe(valueCapacity, STR2, 0, STR2.length);
            Assert.assertTrue((vector.getValueCapacity() >= 2 * valueCapacity ? 1 : 0) != 0);
            while (vector.getByteCapacity() < 10 * vector.getValueCapacity()) {
                vector.reallocDataBuffer();
            }
            for (i = valueCapacity; i < vector.getValueCapacity(); ++i) {
                if ((i & 1) == 1) {
                    vector.set(i, STR1);
                    continue;
                }
                vector.set(i, STR2);
            }
            valueCapacity = vector.getValueCapacity();
            for (i = 0; i < valueCapacity; ++i) {
                if ((i & 1) == 1) {
                    Assert.assertArrayEquals((byte[])STR1, (byte[])vector.get(i));
                    continue;
                }
                Assert.assertArrayEquals((byte[])STR2, (byte[])vector.get(i));
            }
            vector.setSafe(valueCapacity + 10, STR2, 0, STR2.length);
            Assert.assertTrue((vector.getValueCapacity() >= 2 * valueCapacity ? 1 : 0) != 0);
            while (vector.getByteCapacity() < 10 * vector.getValueCapacity()) {
                vector.reallocDataBuffer();
            }
            for (i = valueCapacity; i < vector.getValueCapacity(); ++i) {
                if ((i & 1) == 1) {
                    vector.set(i, STR1);
                    continue;
                }
                vector.set(i, STR2);
            }
            valueCapacity = vector.getValueCapacity();
            for (i = 0; i < valueCapacity; ++i) {
                if ((i & 1) == 1) {
                    Assert.assertArrayEquals((byte[])STR1, (byte[])vector.get(i));
                    continue;
                }
                Assert.assertArrayEquals((byte[])STR2, (byte[])vector.get(i));
            }
            TransferPair transferPair = vector.getTransferPair(this.allocator);
            transferPair.transfer();
            VarCharVector toVector = (VarCharVector)transferPair.getTo();
            valueCapacity = toVector.getValueCapacity();
            for (int i2 = 0; i2 < valueCapacity; ++i2) {
                if ((i2 & 1) == 1) {
                    Assert.assertArrayEquals((byte[])STR1, (byte[])toVector.get(i2));
                    continue;
                }
                Assert.assertArrayEquals((byte[])STR2, (byte[])toVector.get(i2));
            }
            toVector.close();
        }
    }

    @Test
    public void testReallocAfterVectorTransfer4() {
        try (IntVector vector = new IntVector(EMPTY_SCHEMA_PATH, this.allocator);){
            int i;
            vector.allocateNew(4096);
            int valueCapacity = vector.getValueCapacity();
            Assert.assertTrue((valueCapacity >= 4096 ? 1 : 0) != 0);
            int baseValue = 1000;
            for (i = 0; i < valueCapacity; ++i) {
                if ((i & 1) != 0) continue;
                vector.set(i, 1000 + i);
            }
            for (i = 0; i < valueCapacity; ++i) {
                if ((i & 1) == 0) {
                    Assert.assertEquals((long)(1000 + i), (long)vector.get(i));
                    continue;
                }
                Assert.assertTrue((boolean)vector.isNull(i));
            }
            vector.setSafe(valueCapacity, 10000000);
            Assert.assertTrue((vector.getValueCapacity() >= valueCapacity * 2 ? 1 : 0) != 0);
            for (i = valueCapacity; i < vector.getValueCapacity(); ++i) {
                if ((i & 1) != 0) continue;
                vector.set(i, 1000 + i);
            }
            valueCapacity = vector.getValueCapacity();
            for (i = 0; i < valueCapacity; ++i) {
                if ((i & 1) == 0) {
                    Assert.assertEquals((long)(1000 + i), (long)vector.get(i));
                    continue;
                }
                Assert.assertTrue((boolean)vector.isNull(i));
            }
            vector.setSafe(valueCapacity, 10000000);
            Assert.assertTrue((vector.getValueCapacity() >= valueCapacity * 2 ? 1 : 0) != 0);
            for (i = valueCapacity; i < vector.getValueCapacity(); ++i) {
                if ((i & 1) != 0) continue;
                vector.set(i, 1000 + i);
            }
            valueCapacity = vector.getValueCapacity();
            for (i = 0; i < valueCapacity; ++i) {
                if ((i & 1) == 0) {
                    Assert.assertEquals((long)(1000 + i), (long)vector.get(i));
                    continue;
                }
                Assert.assertTrue((boolean)vector.isNull(i));
            }
            TransferPair transferPair = vector.getTransferPair(this.allocator);
            transferPair.transfer();
            IntVector toVector = (IntVector)transferPair.getTo();
            Assert.assertEquals((long)valueCapacity, (long)toVector.getValueCapacity());
            for (int i2 = 0; i2 < valueCapacity; ++i2) {
                if ((i2 & 1) == 0) {
                    Assert.assertEquals((long)(1000 + i2), (long)toVector.get(i2));
                    continue;
                }
                Assert.assertTrue((boolean)toVector.isNull(i2));
            }
            toVector.close();
        }
    }

    @Test
    public void testReAllocFixedWidthVector() {
        try (Float4Vector vector = TestUtils.newVector(Float4Vector.class, EMPTY_SCHEMA_PATH, Types.MinorType.FLOAT4, this.allocator);){
            vector.allocateNew(1024);
            Assert.assertTrue((vector.getValueCapacity() >= 1024 ? 1 : 0) != 0);
            int initialCapacity = vector.getValueCapacity();
            vector.setSafe(0, 100.1f);
            vector.setSafe(100, 102.3f);
            vector.setSafe(1023, 104.5f);
            vector.setSafe(2000, 105.5f);
            Assert.assertTrue((vector.getValueCapacity() >= 2 * initialCapacity ? 1 : 0) != 0);
            Assert.assertEquals((float)100.1f, (float)vector.get(0), (float)0.0f);
            Assert.assertEquals((float)102.3f, (float)vector.get(100), (float)0.0f);
            Assert.assertEquals((float)104.5f, (float)vector.get(1023), (float)0.0f);
            Assert.assertEquals((float)105.5f, (float)vector.get(2000), (float)0.0f);
            vector.setValueCount(vector.getValueCapacity() + 200);
        }
    }

    @Test
    public void testReAllocVariableWidthVector() {
        try (VarCharVector vector = TestUtils.newVector(VarCharVector.class, EMPTY_SCHEMA_PATH, Types.MinorType.VARCHAR, this.allocator);){
            vector.setInitialCapacity(4095);
            vector.allocateNew();
            int initialCapacity = vector.getValueCapacity();
            Assert.assertTrue((initialCapacity >= 4095 ? 1 : 0) != 0);
            vector.setSafe(0, STR1, 0, STR1.length);
            vector.setSafe(initialCapacity - 1, STR2, 0, STR2.length);
            Assert.assertEquals((long)initialCapacity, (long)vector.getValueCapacity());
            vector.setSafe(initialCapacity + 200, STR3, 0, STR3.length);
            Assert.assertTrue((initialCapacity * 2 <= vector.getValueCapacity() ? 1 : 0) != 0);
            Assert.assertArrayEquals((byte[])STR1, (byte[])vector.get(0));
            Assert.assertArrayEquals((byte[])STR2, (byte[])vector.get(initialCapacity - 1));
            Assert.assertArrayEquals((byte[])STR3, (byte[])vector.get(initialCapacity + 200));
            vector.setValueCount(vector.getValueCapacity() + 200);
        }
    }

    @Test
    public void testFillEmptiesNotOverfill() {
        try (VarCharVector vector = TestUtils.newVector(VarCharVector.class, EMPTY_SCHEMA_PATH, Types.MinorType.VARCHAR, this.allocator);){
            vector.setInitialCapacity(4095);
            vector.allocateNew();
            int initialCapacity = vector.getValueCapacity();
            Assert.assertTrue((initialCapacity >= 4095 ? 1 : 0) != 0);
            vector.setSafe(4094, "hello".getBytes(), 0, 5);
            Assert.assertEquals((long)initialCapacity, (long)vector.getValueCapacity());
            long bufSizeBefore = ((ArrowBuf)vector.getFieldBuffers().get(1)).capacity();
            vector.setValueCount(initialCapacity);
            Assert.assertEquals((long)bufSizeBefore, (long)((ArrowBuf)vector.getFieldBuffers().get(1)).capacity());
            Assert.assertEquals((long)initialCapacity, (long)vector.getValueCapacity());
        }
    }

    @Test
    public void testSetSafeWithArrowBufNoExcessAllocs() {
        int numValues = 7940;
        byte[] valueBytes = "hello world".getBytes();
        int valueBytesLength = valueBytes.length;
        boolean isSet = true;
        try (VarCharVector fromVector = TestUtils.newVector(VarCharVector.class, EMPTY_SCHEMA_PATH, Types.MinorType.VARCHAR, this.allocator);
             VarCharVector toVector = TestUtils.newVector(VarCharVector.class, EMPTY_SCHEMA_PATH, Types.MinorType.VARCHAR, this.allocator);){
            fromVector.setInitialCapacity(7940);
            fromVector.allocateNew();
            for (int i = 0; i < 7940; ++i) {
                fromVector.setSafe(i, valueBytes, 0, valueBytesLength);
            }
            fromVector.setValueCount(7940);
            ArrowBuf fromDataBuffer = fromVector.getDataBuffer();
            Assert.assertTrue(((long)(7940 * valueBytesLength) <= fromDataBuffer.capacity() ? 1 : 0) != 0);
            toVector.setInitialCapacity(7940);
            toVector.allocateNew();
            for (int i = 0; i < 7940; ++i) {
                int start = fromVector.getStartOffset(i);
                int end = fromVector.getStartOffset(i + 1);
                toVector.setSafe(i, 1, start, end, fromDataBuffer);
            }
            Assert.assertEquals((long)fromDataBuffer.capacity(), (long)toVector.getDataBuffer().capacity());
        }
    }

    @Test
    public void testCopyFromWithNulls() {
        try (VarCharVector vector = TestUtils.newVector(VarCharVector.class, EMPTY_SCHEMA_PATH, Types.MinorType.VARCHAR, this.allocator);
             VarCharVector vector2 = TestUtils.newVector(VarCharVector.class, EMPTY_SCHEMA_PATH, Types.MinorType.VARCHAR, this.allocator);){
            int i;
            int i2;
            vector.setInitialCapacity(4095);
            vector.allocateNew();
            int capacity = vector.getValueCapacity();
            Assert.assertTrue((capacity >= 4095 ? 1 : 0) != 0);
            for (i2 = 0; i2 < capacity; ++i2) {
                if (i2 % 3 == 0) continue;
                byte[] b = Integer.toString(i2).getBytes();
                vector.setSafe(i2, b, 0, b.length);
            }
            Assert.assertEquals((long)capacity, (long)vector.getValueCapacity());
            vector.setValueCount(capacity);
            for (i2 = 0; i2 < capacity; ++i2) {
                if (i2 % 3 == 0) {
                    Assert.assertNull((Object)vector.getObject(i2));
                    continue;
                }
                Assert.assertEquals((String)("unexpected value at index: " + i2), (Object)Integer.toString(i2), (Object)vector.getObject(i2).toString());
            }
            vector2.setInitialCapacity(4095);
            vector2.allocateNew();
            int capacity2 = vector2.getValueCapacity();
            Assert.assertEquals((long)capacity2, (long)capacity);
            for (i = 0; i < capacity; ++i) {
                vector2.copyFromSafe(i, i, (ValueVector)vector);
                if (i % 3 == 0) {
                    Assert.assertNull((Object)vector2.getObject(i));
                    continue;
                }
                Assert.assertEquals((String)("unexpected value at index: " + i), (Object)Integer.toString(i), (Object)vector2.getObject(i).toString());
            }
            Assert.assertEquals((long)capacity, (long)vector2.getValueCapacity());
            vector2.setValueCount(capacity);
            for (i = 0; i < capacity; ++i) {
                if (i % 3 == 0) {
                    Assert.assertNull((Object)vector2.getObject(i));
                    continue;
                }
                Assert.assertEquals((String)("unexpected value at index: " + i), (Object)Integer.toString(i), (Object)vector2.getObject(i).toString());
            }
        }
    }

    @Test
    public void testCopyFromWithNulls1() {
        try (VarCharVector vector = TestUtils.newVector(VarCharVector.class, EMPTY_SCHEMA_PATH, Types.MinorType.VARCHAR, this.allocator);
             VarCharVector vector2 = TestUtils.newVector(VarCharVector.class, EMPTY_SCHEMA_PATH, Types.MinorType.VARCHAR, this.allocator);){
            int i;
            int i2;
            vector.setInitialCapacity(4095);
            vector.allocateNew();
            int capacity = vector.getValueCapacity();
            Assert.assertTrue((capacity >= 4095 ? 1 : 0) != 0);
            for (i2 = 0; i2 < capacity; ++i2) {
                if (i2 % 3 == 0) continue;
                byte[] b = Integer.toString(i2).getBytes();
                vector.setSafe(i2, b, 0, b.length);
            }
            Assert.assertEquals((long)capacity, (long)vector.getValueCapacity());
            vector.setValueCount(capacity);
            for (i2 = 0; i2 < capacity; ++i2) {
                if (i2 % 3 == 0) {
                    Assert.assertNull((Object)vector.getObject(i2));
                    continue;
                }
                Assert.assertEquals((String)("unexpected value at index: " + i2), (Object)Integer.toString(i2), (Object)vector.getObject(i2).toString());
            }
            vector2.allocateNew(10240L, 1024);
            int capacity2 = vector2.getValueCapacity();
            Assert.assertTrue((capacity2 >= 1024 ? 1 : 0) != 0);
            Assert.assertTrue((capacity2 <= capacity ? 1 : 0) != 0);
            for (i = 0; i < capacity; ++i) {
                vector2.copyFromSafe(i, i, (ValueVector)vector);
                if (i % 3 == 0) {
                    Assert.assertNull((Object)vector2.getObject(i));
                    continue;
                }
                Assert.assertEquals((String)("unexpected value at index: " + i), (Object)Integer.toString(i), (Object)vector2.getObject(i).toString());
            }
            Assert.assertEquals((long)capacity, (long)vector2.getValueCapacity());
            vector2.setValueCount(capacity);
            for (i = 0; i < capacity; ++i) {
                if (i % 3 == 0) {
                    Assert.assertNull((Object)vector2.getObject(i));
                    continue;
                }
                Assert.assertEquals((String)("unexpected value at index: " + i), (Object)Integer.toString(i), (Object)vector2.getObject(i).toString());
            }
        }
    }

    @Test
    public void testSetLastSetUsage() {
        try (VarCharVector vector = new VarCharVector("myvector", this.allocator);){
            vector.allocateNew(10240L, 1024);
            TestValueVector.setBytes(0, STR1, vector);
            TestValueVector.setBytes(1, STR2, vector);
            TestValueVector.setBytes(2, STR3, vector);
            TestValueVector.setBytes(3, STR4, vector);
            TestValueVector.setBytes(4, STR5, vector);
            TestValueVector.setBytes(5, STR6, vector);
            Assert.assertEquals((long)-1L, (long)vector.getLastSet());
            Assert.assertArrayEquals((byte[])STR1, (byte[])vector.get(0));
            Assert.assertArrayEquals((byte[])STR2, (byte[])vector.get(1));
            Assert.assertArrayEquals((byte[])STR3, (byte[])vector.get(2));
            Assert.assertArrayEquals((byte[])STR4, (byte[])vector.get(3));
            Assert.assertArrayEquals((byte[])STR5, (byte[])vector.get(4));
            Assert.assertArrayEquals((byte[])STR6, (byte[])vector.get(5));
            vector.setLastSet(5);
            vector.setValueCount(20);
            Assert.assertEquals((long)19L, (long)vector.getLastSet());
            Assert.assertArrayEquals((byte[])STR1, (byte[])vector.get(0));
            Assert.assertArrayEquals((byte[])STR2, (byte[])vector.get(1));
            Assert.assertArrayEquals((byte[])STR3, (byte[])vector.get(2));
            Assert.assertArrayEquals((byte[])STR4, (byte[])vector.get(3));
            Assert.assertArrayEquals((byte[])STR5, (byte[])vector.get(4));
            Assert.assertArrayEquals((byte[])STR6, (byte[])vector.get(5));
            Assert.assertEquals((long)0L, (long)vector.getValueLength(6));
            Assert.assertEquals((long)0L, (long)vector.getValueLength(7));
            Assert.assertEquals((long)0L, (long)vector.getValueLength(8));
            Assert.assertEquals((long)0L, (long)vector.getValueLength(9));
            Assert.assertEquals((long)0L, (long)vector.getValueLength(10));
            Assert.assertEquals((long)0L, (long)vector.getValueLength(11));
            Assert.assertEquals((long)0L, (long)vector.getValueLength(12));
            Assert.assertEquals((long)0L, (long)vector.getValueLength(13));
            Assert.assertEquals((long)0L, (long)vector.getValueLength(14));
            Assert.assertEquals((long)0L, (long)vector.getValueLength(15));
            Assert.assertEquals((long)0L, (long)vector.getValueLength(16));
            Assert.assertEquals((long)0L, (long)vector.getValueLength(17));
            Assert.assertEquals((long)0L, (long)vector.getValueLength(18));
            Assert.assertEquals((long)0L, (long)vector.getValueLength(19));
            Assert.assertEquals((long)0L, (long)vector.offsetBuffer.getInt(0L));
            Assert.assertEquals((long)6L, (long)vector.offsetBuffer.getInt(4L));
            Assert.assertEquals((long)16L, (long)vector.offsetBuffer.getInt(8L));
            Assert.assertEquals((long)21L, (long)vector.offsetBuffer.getInt(12L));
            Assert.assertEquals((long)30L, (long)vector.offsetBuffer.getInt(16L));
            Assert.assertEquals((long)34L, (long)vector.offsetBuffer.getInt(20L));
            Assert.assertEquals((long)40L, (long)vector.offsetBuffer.getInt(24L));
            Assert.assertEquals((long)40L, (long)vector.offsetBuffer.getInt(28L));
            Assert.assertEquals((long)40L, (long)vector.offsetBuffer.getInt(32L));
            Assert.assertEquals((long)40L, (long)vector.offsetBuffer.getInt(36L));
            Assert.assertEquals((long)40L, (long)vector.offsetBuffer.getInt(40L));
            Assert.assertEquals((long)40L, (long)vector.offsetBuffer.getInt(44L));
            Assert.assertEquals((long)40L, (long)vector.offsetBuffer.getInt(48L));
            Assert.assertEquals((long)40L, (long)vector.offsetBuffer.getInt(52L));
            Assert.assertEquals((long)40L, (long)vector.offsetBuffer.getInt(56L));
            Assert.assertEquals((long)40L, (long)vector.offsetBuffer.getInt(60L));
            Assert.assertEquals((long)40L, (long)vector.offsetBuffer.getInt(64L));
            Assert.assertEquals((long)40L, (long)vector.offsetBuffer.getInt(68L));
            Assert.assertEquals((long)40L, (long)vector.offsetBuffer.getInt(72L));
            Assert.assertEquals((long)40L, (long)vector.offsetBuffer.getInt(76L));
            vector.set(19, STR6);
            Assert.assertArrayEquals((byte[])STR6, (byte[])vector.get(19));
            Assert.assertEquals((long)40L, (long)vector.offsetBuffer.getInt(76L));
            Assert.assertEquals((long)46L, (long)vector.offsetBuffer.getInt(80L));
        }
    }

    @Test
    public void testVectorLoadUnload() {
        try (VarCharVector vector1 = new VarCharVector("myvector", this.allocator);){
            ValueVectorDataPopulator.setVector(vector1, (byte[][])new byte[][]{STR1, STR2, STR3, STR4, STR5, STR6});
            Assert.assertEquals((long)5L, (long)vector1.getLastSet());
            vector1.setValueCount(15);
            Assert.assertEquals((long)14L, (long)vector1.getLastSet());
            Assert.assertArrayEquals((byte[])STR1, (byte[])vector1.get(0));
            Assert.assertArrayEquals((byte[])STR2, (byte[])vector1.get(1));
            Assert.assertArrayEquals((byte[])STR3, (byte[])vector1.get(2));
            Assert.assertArrayEquals((byte[])STR4, (byte[])vector1.get(3));
            Assert.assertArrayEquals((byte[])STR5, (byte[])vector1.get(4));
            Assert.assertArrayEquals((byte[])STR6, (byte[])vector1.get(5));
            Field field = vector1.getField();
            String fieldName = field.getName();
            ArrayList<Field> fields = new ArrayList<Field>();
            ArrayList<VarCharVector> fieldVectors = new ArrayList<VarCharVector>();
            fields.add(field);
            fieldVectors.add(vector1);
            Schema schema = new Schema(fields);
            VectorSchemaRoot schemaRoot1 = new VectorSchemaRoot(schema, fieldVectors, vector1.getValueCount());
            VectorUnloader vectorUnloader = new VectorUnloader(schemaRoot1);
            try (ArrowRecordBatch recordBatch = vectorUnloader.getRecordBatch();
                 BufferAllocator finalVectorsAllocator = this.allocator.newChildAllocator("new vector", 0L, Long.MAX_VALUE);
                 VectorSchemaRoot schemaRoot2 = VectorSchemaRoot.create((Schema)schema, (BufferAllocator)finalVectorsAllocator);){
                VectorLoader vectorLoader = new VectorLoader(schemaRoot2);
                vectorLoader.load(recordBatch);
                VarCharVector vector2 = (VarCharVector)schemaRoot2.getVector(fieldName);
                Assert.assertEquals((long)14L, (long)vector2.getLastSet());
                vector2.setValueCount(25);
                Assert.assertEquals((long)24L, (long)vector2.getLastSet());
                Assert.assertArrayEquals((byte[])STR1, (byte[])vector2.get(0));
                Assert.assertArrayEquals((byte[])STR2, (byte[])vector2.get(1));
                Assert.assertArrayEquals((byte[])STR3, (byte[])vector2.get(2));
                Assert.assertArrayEquals((byte[])STR4, (byte[])vector2.get(3));
                Assert.assertArrayEquals((byte[])STR5, (byte[])vector2.get(4));
                Assert.assertArrayEquals((byte[])STR6, (byte[])vector2.get(5));
            }
        }
    }

    @Test
    public void testFillEmptiesUsage() {
        try (VarCharVector vector = new VarCharVector("myvector", this.allocator);){
            vector.allocateNew(10240L, 1024);
            TestValueVector.setBytes(0, STR1, vector);
            TestValueVector.setBytes(1, STR2, vector);
            TestValueVector.setBytes(2, STR3, vector);
            TestValueVector.setBytes(3, STR4, vector);
            TestValueVector.setBytes(4, STR5, vector);
            TestValueVector.setBytes(5, STR6, vector);
            Assert.assertEquals((long)-1L, (long)vector.getLastSet());
            Assert.assertArrayEquals((byte[])STR1, (byte[])vector.get(0));
            Assert.assertArrayEquals((byte[])STR2, (byte[])vector.get(1));
            Assert.assertArrayEquals((byte[])STR3, (byte[])vector.get(2));
            Assert.assertArrayEquals((byte[])STR4, (byte[])vector.get(3));
            Assert.assertArrayEquals((byte[])STR5, (byte[])vector.get(4));
            Assert.assertArrayEquals((byte[])STR6, (byte[])vector.get(5));
            vector.setLastSet(5);
            vector.fillEmpties(10);
            Assert.assertEquals((long)9L, (long)vector.getLastSet());
            Assert.assertArrayEquals((byte[])STR1, (byte[])vector.get(0));
            Assert.assertArrayEquals((byte[])STR2, (byte[])vector.get(1));
            Assert.assertArrayEquals((byte[])STR3, (byte[])vector.get(2));
            Assert.assertArrayEquals((byte[])STR4, (byte[])vector.get(3));
            Assert.assertArrayEquals((byte[])STR5, (byte[])vector.get(4));
            Assert.assertArrayEquals((byte[])STR6, (byte[])vector.get(5));
            Assert.assertEquals((long)0L, (long)vector.getValueLength(6));
            Assert.assertEquals((long)0L, (long)vector.getValueLength(7));
            Assert.assertEquals((long)0L, (long)vector.getValueLength(8));
            Assert.assertEquals((long)0L, (long)vector.getValueLength(9));
            TestValueVector.setBytes(10, STR1, vector);
            TestValueVector.setBytes(11, STR2, vector);
            vector.setLastSet(11);
            vector.setValueCount(15);
            Assert.assertEquals((long)14L, (long)vector.getLastSet());
            Assert.assertArrayEquals((byte[])STR1, (byte[])vector.get(0));
            Assert.assertArrayEquals((byte[])STR2, (byte[])vector.get(1));
            Assert.assertArrayEquals((byte[])STR3, (byte[])vector.get(2));
            Assert.assertArrayEquals((byte[])STR4, (byte[])vector.get(3));
            Assert.assertArrayEquals((byte[])STR5, (byte[])vector.get(4));
            Assert.assertArrayEquals((byte[])STR6, (byte[])vector.get(5));
            Assert.assertEquals((long)0L, (long)vector.getValueLength(6));
            Assert.assertEquals((long)0L, (long)vector.getValueLength(7));
            Assert.assertEquals((long)0L, (long)vector.getValueLength(8));
            Assert.assertEquals((long)0L, (long)vector.getValueLength(9));
            Assert.assertArrayEquals((byte[])STR1, (byte[])vector.get(10));
            Assert.assertArrayEquals((byte[])STR2, (byte[])vector.get(11));
            Assert.assertEquals((long)0L, (long)vector.getValueLength(12));
            Assert.assertEquals((long)0L, (long)vector.getValueLength(13));
            Assert.assertEquals((long)0L, (long)vector.getValueLength(14));
            Assert.assertEquals((long)0L, (long)vector.offsetBuffer.getInt(0L));
            Assert.assertEquals((long)6L, (long)vector.offsetBuffer.getInt(4L));
            Assert.assertEquals((long)16L, (long)vector.offsetBuffer.getInt(8L));
            Assert.assertEquals((long)21L, (long)vector.offsetBuffer.getInt(12L));
            Assert.assertEquals((long)30L, (long)vector.offsetBuffer.getInt(16L));
            Assert.assertEquals((long)34L, (long)vector.offsetBuffer.getInt(20L));
            Assert.assertEquals((long)40L, (long)vector.offsetBuffer.getInt(24L));
            Assert.assertEquals((long)40L, (long)vector.offsetBuffer.getInt(28L));
            Assert.assertEquals((long)40L, (long)vector.offsetBuffer.getInt(32L));
            Assert.assertEquals((long)40L, (long)vector.offsetBuffer.getInt(36L));
            Assert.assertEquals((long)40L, (long)vector.offsetBuffer.getInt(40L));
            Assert.assertEquals((long)46L, (long)vector.offsetBuffer.getInt(44L));
            Assert.assertEquals((long)56L, (long)vector.offsetBuffer.getInt(48L));
            Assert.assertEquals((long)56L, (long)vector.offsetBuffer.getInt(52L));
            Assert.assertEquals((long)56L, (long)vector.offsetBuffer.getInt(56L));
            Assert.assertEquals((long)56L, (long)vector.offsetBuffer.getInt(60L));
        }
    }

    @Test
    public void testGetBufferAddress1() {
        try (VarCharVector vector = new VarCharVector("myvector", this.allocator);){
            ValueVectorDataPopulator.setVector(vector, (byte[][])new byte[][]{STR1, STR2, STR3, STR4, STR5, STR6});
            vector.setValueCount(15);
            Assert.assertArrayEquals((byte[])STR1, (byte[])vector.get(0));
            Assert.assertArrayEquals((byte[])STR2, (byte[])vector.get(1));
            Assert.assertArrayEquals((byte[])STR3, (byte[])vector.get(2));
            Assert.assertArrayEquals((byte[])STR4, (byte[])vector.get(3));
            Assert.assertArrayEquals((byte[])STR5, (byte[])vector.get(4));
            Assert.assertArrayEquals((byte[])STR6, (byte[])vector.get(5));
            List buffers = vector.getFieldBuffers();
            long bitAddress = vector.getValidityBufferAddress();
            long offsetAddress = vector.getOffsetBufferAddress();
            long dataAddress = vector.getDataBufferAddress();
            Assert.assertEquals((long)3L, (long)buffers.size());
            Assert.assertEquals((long)bitAddress, (long)((ArrowBuf)buffers.get(0)).memoryAddress());
            Assert.assertEquals((long)offsetAddress, (long)((ArrowBuf)buffers.get(1)).memoryAddress());
            Assert.assertEquals((long)dataAddress, (long)((ArrowBuf)buffers.get(2)).memoryAddress());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetBufferAddress2() {
        try (IntVector vector = new IntVector("myvector", this.allocator);){
            int i;
            boolean error = false;
            vector.allocateNew(16);
            for (i = 0; i < 16; i += 2) {
                vector.set(i, i + 10);
            }
            for (i = 0; i < 16; i += 2) {
                Assert.assertEquals((long)(i + 10), (long)vector.get(i));
            }
            List buffers = vector.getFieldBuffers();
            long bitAddress = vector.getValidityBufferAddress();
            long dataAddress = vector.getDataBufferAddress();
            try {
                long l = vector.getOffsetBufferAddress();
            }
            catch (UnsupportedOperationException ue) {
                error = true;
            }
            finally {
                Assert.assertTrue((boolean)error);
            }
            Assert.assertEquals((long)2L, (long)buffers.size());
            Assert.assertEquals((long)bitAddress, (long)((ArrowBuf)buffers.get(0)).memoryAddress());
            Assert.assertEquals((long)dataAddress, (long)((ArrowBuf)buffers.get(1)).memoryAddress());
        }
    }

    @Test
    public void testMultipleClose() {
        BufferAllocator vectorAllocator = this.allocator.newChildAllocator("vector_allocator", 0L, Long.MAX_VALUE);
        IntVector vector = TestUtils.newVector(IntVector.class, EMPTY_SCHEMA_PATH, Types.MinorType.INT, vectorAllocator);
        vector.close();
        vectorAllocator.close();
        vector.close();
        vectorAllocator.close();
    }

    public static void setBytes(int index, byte[] bytes, VarCharVector vector) {
        int currentOffset = vector.offsetBuffer.getInt((long)(index * 4));
        BitVectorHelper.setBit((ArrowBuf)vector.validityBuffer, (long)index);
        vector.offsetBuffer.setInt((long)((index + 1) * 4), currentOffset + bytes.length);
        vector.valueBuffer.setBytes((long)currentOffset, bytes, 0, (long)bytes.length);
    }

    @Test
    public void testSetInitialCapacity() {
        try (VarCharVector vector = new VarCharVector(EMPTY_SCHEMA_PATH, this.allocator);){
            int defaultCapacity = 3969;
            vector.setInitialCapacity(defaultCapacity);
            vector.allocateNew();
            Assert.assertEquals((long)defaultCapacity, (long)vector.getValueCapacity());
            Assert.assertEquals((long)CommonUtil.nextPowerOfTwo((int)(defaultCapacity * 8)), (long)vector.getDataBuffer().capacity());
            vector.setInitialCapacity(defaultCapacity, 1.0);
            vector.allocateNew();
            Assert.assertEquals((long)defaultCapacity, (long)vector.getValueCapacity());
            Assert.assertEquals((long)CommonUtil.nextPowerOfTwo((int)defaultCapacity), (long)vector.getDataBuffer().capacity());
            vector.setInitialCapacity(defaultCapacity, 0.1);
            vector.allocateNew();
            Assert.assertEquals((long)defaultCapacity, (long)vector.getValueCapacity());
            Assert.assertEquals((long)CommonUtil.nextPowerOfTwo((int)((int)((double)defaultCapacity * 0.1))), (long)vector.getDataBuffer().capacity());
            vector.setInitialCapacity(defaultCapacity, 0.01);
            vector.allocateNew();
            Assert.assertEquals((long)defaultCapacity, (long)vector.getValueCapacity());
            Assert.assertEquals((long)CommonUtil.nextPowerOfTwo((int)((int)((double)defaultCapacity * 0.01))), (long)vector.getDataBuffer().capacity());
            vector.setInitialCapacity(5, 0.01);
            vector.allocateNew();
            Assert.assertEquals((long)5L, (long)vector.getValueCapacity());
            Assert.assertEquals((long)2L, (long)vector.getDataBuffer().capacity());
        }
    }

    @Test
    public void testDefaultAllocNewAll() {
        int defaultCapacity = 3970;
        try (BufferAllocator childAllocator = this.allocator.newChildAllocator("defaultAllocs", 0L, Long.MAX_VALUE);
             IntVector intVector = new IntVector(EMPTY_SCHEMA_PATH, childAllocator);
             BigIntVector bigIntVector = new BigIntVector(EMPTY_SCHEMA_PATH, childAllocator);
             BitVector bitVector = new BitVector(EMPTY_SCHEMA_PATH, childAllocator);
             DecimalVector decimalVector = new DecimalVector(EMPTY_SCHEMA_PATH, childAllocator, 38, 6);
             VarCharVector varCharVector = new VarCharVector(EMPTY_SCHEMA_PATH, childAllocator);){
            long beforeSize = childAllocator.getAllocatedMemory();
            intVector.allocateNew();
            Assert.assertTrue((intVector.getValueCapacity() >= defaultCapacity ? 1 : 0) != 0);
            int expectedSize = defaultCapacity * 4 + BaseFixedWidthVector.getValidityBufferSizeFromCount((int)defaultCapacity);
            Assert.assertTrue(((double)(childAllocator.getAllocatedMemory() - beforeSize) <= (double)expectedSize * 1.05 ? 1 : 0) != 0);
            beforeSize = childAllocator.getAllocatedMemory();
            bigIntVector.allocateNew();
            Assert.assertTrue((bigIntVector.getValueCapacity() >= defaultCapacity ? 1 : 0) != 0);
            expectedSize = defaultCapacity * 8 + BaseFixedWidthVector.getValidityBufferSizeFromCount((int)defaultCapacity);
            Assert.assertTrue(((double)(childAllocator.getAllocatedMemory() - beforeSize) <= (double)expectedSize * 1.05 ? 1 : 0) != 0);
            beforeSize = childAllocator.getAllocatedMemory();
            decimalVector.allocateNew();
            Assert.assertTrue((decimalVector.getValueCapacity() >= defaultCapacity ? 1 : 0) != 0);
            expectedSize = defaultCapacity * 16 + BaseFixedWidthVector.getValidityBufferSizeFromCount((int)defaultCapacity);
            Assert.assertTrue(((double)(childAllocator.getAllocatedMemory() - beforeSize) <= (double)expectedSize * 1.05 ? 1 : 0) != 0);
            beforeSize = childAllocator.getAllocatedMemory();
            varCharVector.allocateNew();
            Assert.assertTrue((varCharVector.getValueCapacity() >= defaultCapacity - 1 ? 1 : 0) != 0);
            expectedSize = defaultCapacity * 4 + BaseFixedWidthVector.getValidityBufferSizeFromCount((int)defaultCapacity) + defaultCapacity * 8;
            Assert.assertTrue(((double)(childAllocator.getAllocatedMemory() - beforeSize) <= (double)expectedSize * 1.05 ? 1 : 0) != 0);
            beforeSize = childAllocator.getAllocatedMemory();
            bitVector.allocateNew();
            Assert.assertTrue((bitVector.getValueCapacity() >= defaultCapacity ? 1 : 0) != 0);
            expectedSize = BaseFixedWidthVector.getValidityBufferSizeFromCount((int)defaultCapacity) * 2;
            Assert.assertTrue(((double)(childAllocator.getAllocatedMemory() - beforeSize) <= (double)expectedSize * 1.05 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testSetNullableVarCharHolder() {
        try (VarCharVector vector = new VarCharVector(EMPTY_SCHEMA_PATH, this.allocator);){
            vector.allocateNew(100L, 10);
            NullableVarCharHolder nullHolder = new NullableVarCharHolder();
            nullHolder.isSet = 0;
            NullableVarCharHolder stringHolder = new NullableVarCharHolder();
            stringHolder.isSet = 1;
            String str = "hello";
            ArrowBuf buf = this.allocator.buffer(16L);
            buf.setBytes(0L, str.getBytes());
            stringHolder.start = 0;
            stringHolder.end = str.length();
            stringHolder.buffer = buf;
            vector.set(0, nullHolder);
            vector.set(1, stringHolder);
            Assert.assertTrue((boolean)vector.isNull(0));
            Assert.assertEquals((Object)str, (Object)new String(vector.get(1)));
            buf.close();
        }
    }

    @Test
    public void testSetNullableVarCharHolderSafe() {
        try (VarCharVector vector = new VarCharVector(EMPTY_SCHEMA_PATH, this.allocator);){
            vector.allocateNew(5L, 1);
            NullableVarCharHolder nullHolder = new NullableVarCharHolder();
            nullHolder.isSet = 0;
            NullableVarCharHolder stringHolder = new NullableVarCharHolder();
            stringHolder.isSet = 1;
            String str = "hello world";
            ArrowBuf buf = this.allocator.buffer(16L);
            buf.setBytes(0L, str.getBytes());
            stringHolder.start = 0;
            stringHolder.end = str.length();
            stringHolder.buffer = buf;
            vector.setSafe(0, stringHolder);
            vector.setSafe(1, nullHolder);
            Assert.assertEquals((Object)str, (Object)new String(vector.get(0)));
            Assert.assertTrue((boolean)vector.isNull(1));
            buf.close();
        }
    }

    @Test
    public void testSetNullableVarBinaryHolder() {
        try (VarBinaryVector vector = new VarBinaryVector(EMPTY_SCHEMA_PATH, this.allocator);){
            vector.allocateNew(100L, 10);
            NullableVarBinaryHolder nullHolder = new NullableVarBinaryHolder();
            nullHolder.isSet = 0;
            NullableVarBinaryHolder binHolder = new NullableVarBinaryHolder();
            binHolder.isSet = 1;
            String str = "hello";
            ArrowBuf buf = this.allocator.buffer(16L);
            buf.setBytes(0L, str.getBytes());
            binHolder.start = 0;
            binHolder.end = str.length();
            binHolder.buffer = buf;
            vector.set(0, nullHolder);
            vector.set(1, binHolder);
            Assert.assertTrue((boolean)vector.isNull(0));
            Assert.assertEquals((Object)str, (Object)new String(vector.get(1)));
            buf.close();
        }
    }

    @Test
    public void testSetNullableVarBinaryHolderSafe() {
        try (VarBinaryVector vector = new VarBinaryVector(EMPTY_SCHEMA_PATH, this.allocator);){
            vector.allocateNew(5L, 1);
            NullableVarBinaryHolder nullHolder = new NullableVarBinaryHolder();
            nullHolder.isSet = 0;
            NullableVarBinaryHolder binHolder = new NullableVarBinaryHolder();
            binHolder.isSet = 1;
            String str = "hello world";
            ArrowBuf buf = this.allocator.buffer(16L);
            buf.setBytes(0L, str.getBytes());
            binHolder.start = 0;
            binHolder.end = str.length();
            binHolder.buffer = buf;
            vector.setSafe(0, binHolder);
            vector.setSafe(1, nullHolder);
            Assert.assertEquals((Object)str, (Object)new String(vector.get(0)));
            Assert.assertTrue((boolean)vector.isNull(1));
            buf.close();
        }
    }

    @Test
    public void testGetPointerFixedWidth() {
        int vectorLength = 100;
        try (IntVector vec1 = new IntVector("vec1", this.allocator);
             IntVector vec2 = new IntVector("vec2", this.allocator);){
            vec1.allocateNew(100);
            vec2.allocateNew(100);
            for (int i = 0; i < 100; ++i) {
                if (i % 10 == 0) {
                    vec1.setNull(i);
                    vec2.setNull(i);
                    continue;
                }
                vec1.set(i, i * 1234);
                vec2.set(i, i * 1234);
            }
            ArrowBufPointer ptr1 = new ArrowBufPointer();
            ArrowBufPointer ptr2 = new ArrowBufPointer();
            for (int i = 0; i < 100; ++i) {
                vec1.getDataPointer(i, ptr1);
                vec2.getDataPointer(i, ptr2);
                if (i % 10 == 0) {
                    Assert.assertNull((Object)ptr1.getBuf());
                    Assert.assertNull((Object)ptr2.getBuf());
                }
                Assert.assertTrue((boolean)ptr1.equals((Object)ptr2));
                Assert.assertTrue((boolean)ptr2.equals((Object)ptr2));
            }
        }
    }

    @Test
    public void testGetPointerVariableWidth() {
        String[] sampleData = new String[]{"abc", "123", "def", null, "hello", "aaaaa", "world", "2019", null, "0717"};
        try (VarCharVector vec1 = new VarCharVector("vec1", this.allocator);
             VarCharVector vec2 = new VarCharVector("vec2", this.allocator);){
            vec1.allocateNew((long)(sampleData.length * 10), sampleData.length);
            vec2.allocateNew((long)(sampleData.length * 10), sampleData.length);
            for (int i = 0; i < sampleData.length; ++i) {
                String str = sampleData[i];
                if (str != null) {
                    vec1.set(i, sampleData[i].getBytes());
                    vec2.set(i, sampleData[i].getBytes());
                    continue;
                }
                vec1.setNull(i);
                vec2.setNull(i);
            }
            ArrowBufPointer ptr1 = new ArrowBufPointer();
            ArrowBufPointer ptr2 = new ArrowBufPointer();
            for (int i = 0; i < sampleData.length; ++i) {
                vec1.getDataPointer(i, ptr1);
                vec2.getDataPointer(i, ptr2);
                Assert.assertTrue((boolean)ptr1.equals((Object)ptr2));
                Assert.assertTrue((boolean)ptr2.equals((Object)ptr2));
            }
        }
    }

    @Test
    public void testGetNullFromVariableWidthVector() {
        try (VarCharVector varCharVector = new VarCharVector("varcharvec", this.allocator);
             VarBinaryVector varBinaryVector = new VarBinaryVector("varbinary", this.allocator);){
            varCharVector.allocateNew(10L, 1);
            varBinaryVector.allocateNew(10L, 1);
            varCharVector.setNull(0);
            varBinaryVector.setNull(0);
            Assert.assertNull((Object)varCharVector.get(0));
            Assert.assertNull((Object)varBinaryVector.get(0));
        }
    }

    @Test
    public void testZeroVectorEquals() {
        try (ZeroVector vector1 = new ZeroVector();
             ZeroVector vector2 = new ZeroVector();){
            VectorEqualsVisitor visitor = new VectorEqualsVisitor();
            Assert.assertTrue((boolean)VectorEqualsVisitor.vectorEquals((ValueVector)vector1, (ValueVector)vector2));
        }
    }

    @Test
    public void testZeroVectorNotEquals() {
        try (IntVector intVector = new IntVector("int", this.allocator);
             ZeroVector zeroVector = new ZeroVector();){
            VectorEqualsVisitor zeroVisitor = new VectorEqualsVisitor();
            Assert.assertFalse((boolean)VectorEqualsVisitor.vectorEquals((ValueVector)intVector, (ValueVector)zeroVector));
            VectorEqualsVisitor intVisitor = new VectorEqualsVisitor();
            Assert.assertFalse((boolean)VectorEqualsVisitor.vectorEquals((ValueVector)zeroVector, (ValueVector)intVector));
        }
    }

    @Test
    public void testIntVectorEqualsWithNull() {
        try (IntVector vector1 = new IntVector("int", this.allocator);
             IntVector vector2 = new IntVector("int", this.allocator);){
            ValueVectorDataPopulator.setVector(vector1, 1, 2);
            ValueVectorDataPopulator.setVector(vector2, 1, null);
            VectorEqualsVisitor visitor = new VectorEqualsVisitor();
            Assert.assertFalse((boolean)VectorEqualsVisitor.vectorEquals((ValueVector)vector1, (ValueVector)vector2));
        }
    }

    @Test
    public void testIntVectorEquals() {
        try (IntVector vector1 = new IntVector("int", this.allocator);
             IntVector vector2 = new IntVector("int", this.allocator);){
            ValueVectorDataPopulator.setVector(vector1, 1, 2, 3);
            ValueVectorDataPopulator.setVector(vector2, 1, 2, null);
            VectorEqualsVisitor visitor = new VectorEqualsVisitor();
            Assert.assertFalse((boolean)VectorEqualsVisitor.vectorEquals((ValueVector)vector1, (ValueVector)vector2));
            vector2.setValueCount(3);
            vector2.setSafe(2, 2);
            Assert.assertFalse((boolean)vector1.equals(vector2));
            vector2.setSafe(2, 3);
            Assert.assertTrue((boolean)VectorEqualsVisitor.vectorEquals((ValueVector)vector1, (ValueVector)vector2));
        }
    }

    @Test
    public void testDecimalVectorEquals() {
        try (DecimalVector vector1 = new DecimalVector("decimal", this.allocator, 3, 3);
             DecimalVector vector2 = new DecimalVector("decimal", this.allocator, 3, 3);
             DecimalVector vector3 = new DecimalVector("decimal", this.allocator, 3, 2);){
            ValueVectorDataPopulator.setVector(vector1, 100L, 200L);
            ValueVectorDataPopulator.setVector(vector2, 100L, 200L);
            ValueVectorDataPopulator.setVector(vector3, 100L, 200L);
            VectorEqualsVisitor visitor1 = new VectorEqualsVisitor();
            VectorEqualsVisitor visitor2 = new VectorEqualsVisitor();
            Assert.assertTrue((boolean)VectorEqualsVisitor.vectorEquals((ValueVector)vector1, (ValueVector)vector2));
            Assert.assertFalse((boolean)VectorEqualsVisitor.vectorEquals((ValueVector)vector1, (ValueVector)vector3));
        }
    }

    @Test
    public void testVarcharVectorEqualsWithNull() {
        try (VarCharVector vector1 = new VarCharVector("varchar", this.allocator);
             VarCharVector vector2 = new VarCharVector("varchar", this.allocator);){
            ValueVectorDataPopulator.setVector(vector1, (byte[][])new byte[][]{STR1, STR2});
            ValueVectorDataPopulator.setVector(vector2, (byte[][])new byte[][]{STR1, null});
            VectorEqualsVisitor visitor = new VectorEqualsVisitor();
            Assert.assertFalse((boolean)VectorEqualsVisitor.vectorEquals((ValueVector)vector1, (ValueVector)vector2));
        }
    }

    @Test
    public void testVarcharVectorEquals() {
        try (VarCharVector vector1 = new VarCharVector("varchar", this.allocator);
             VarCharVector vector2 = new VarCharVector("varchar", this.allocator);){
            ValueVectorDataPopulator.setVector(vector1, (byte[][])new byte[][]{STR1, STR2, STR3});
            ValueVectorDataPopulator.setVector(vector2, (byte[][])new byte[][]{STR1, STR2});
            VectorEqualsVisitor visitor = new VectorEqualsVisitor();
            Assert.assertFalse((boolean)VectorEqualsVisitor.vectorEquals((ValueVector)vector1, (ValueVector)vector2));
            vector2.setSafe(2, STR3, 0, STR3.length);
            vector2.setValueCount(3);
            Assert.assertTrue((boolean)VectorEqualsVisitor.vectorEquals((ValueVector)vector1, (ValueVector)vector2));
        }
    }

    @Test
    public void testVarBinaryVectorEquals() {
        try (VarBinaryVector vector1 = new VarBinaryVector("binary", this.allocator);
             VarBinaryVector vector2 = new VarBinaryVector("binary", this.allocator);){
            ValueVectorDataPopulator.setVector(vector1, (byte[][])new byte[][]{STR1, STR2, STR3});
            ValueVectorDataPopulator.setVector(vector2, (byte[][])new byte[][]{STR1, STR2});
            VectorEqualsVisitor visitor = new VectorEqualsVisitor();
            Assert.assertFalse((boolean)VectorEqualsVisitor.vectorEquals((ValueVector)vector1, (ValueVector)vector2));
            vector2.setSafe(2, STR3, 0, STR3.length);
            vector2.setValueCount(3);
            Assert.assertTrue((boolean)VectorEqualsVisitor.vectorEquals((ValueVector)vector1, (ValueVector)vector2));
        }
    }

    @Test
    public void testListVectorEqualsWithNull() {
        try (ListVector vector1 = ListVector.empty((String)"list", (BufferAllocator)this.allocator);
             ListVector vector2 = ListVector.empty((String)"list", (BufferAllocator)this.allocator);){
            UnionListWriter writer1 = vector1.getWriter();
            writer1.allocate();
            this.writeListVector(writer1, new int[]{1, 2});
            this.writeListVector(writer1, new int[]{3, 4});
            this.writeListVector(writer1, new int[0]);
            writer1.setValueCount(3);
            UnionListWriter writer2 = vector2.getWriter();
            writer2.allocate();
            this.writeListVector(writer2, new int[]{1, 2});
            this.writeListVector(writer2, new int[]{3, 4});
            writer2.setValueCount(3);
            VectorEqualsVisitor visitor = new VectorEqualsVisitor();
            Assert.assertFalse((boolean)VectorEqualsVisitor.vectorEquals((ValueVector)vector1, (ValueVector)vector2));
        }
    }

    @Test
    public void testListVectorEquals() {
        try (ListVector vector1 = ListVector.empty((String)"list", (BufferAllocator)this.allocator);
             ListVector vector2 = ListVector.empty((String)"list", (BufferAllocator)this.allocator);){
            UnionListWriter writer1 = vector1.getWriter();
            writer1.allocate();
            this.writeListVector(writer1, new int[]{1, 2});
            this.writeListVector(writer1, new int[]{3, 4});
            this.writeListVector(writer1, new int[]{5, 6});
            writer1.setValueCount(3);
            UnionListWriter writer2 = vector2.getWriter();
            writer2.allocate();
            this.writeListVector(writer2, new int[]{1, 2});
            this.writeListVector(writer2, new int[]{3, 4});
            writer2.setValueCount(2);
            VectorEqualsVisitor visitor = new VectorEqualsVisitor();
            Assert.assertFalse((boolean)VectorEqualsVisitor.vectorEquals((ValueVector)vector1, (ValueVector)vector2));
            this.writeListVector(writer2, new int[]{5, 6});
            writer2.setValueCount(3);
            Assert.assertTrue((boolean)VectorEqualsVisitor.vectorEquals((ValueVector)vector1, (ValueVector)vector2));
        }
    }

    @Test
    public void testStructVectorEqualsWithNull() {
        try (StructVector vector1 = StructVector.empty((String)"struct", (BufferAllocator)this.allocator);
             StructVector vector2 = StructVector.empty((String)"struct", (BufferAllocator)this.allocator);){
            vector1.addOrGet("f0", FieldType.nullable((ArrowType)new ArrowType.Int(32, true)), IntVector.class);
            vector1.addOrGet("f1", FieldType.nullable((ArrowType)new ArrowType.Int(64, true)), BigIntVector.class);
            vector2.addOrGet("f0", FieldType.nullable((ArrowType)new ArrowType.Int(32, true)), IntVector.class);
            vector2.addOrGet("f1", FieldType.nullable((ArrowType)new ArrowType.Int(64, true)), BigIntVector.class);
            NullableStructWriter writer1 = vector1.getWriter();
            writer1.allocate();
            this.writeStructVector(writer1, 1, 10L);
            this.writeStructVector(writer1, 2, 20L);
            this.writeStructVector(writer1, 3, 30L);
            writer1.setValueCount(3);
            NullableStructWriter writer2 = vector2.getWriter();
            writer2.allocate();
            this.writeStructVector(writer2, 1, 10L);
            this.writeStructVector(writer2, 3, 30L);
            writer2.setValueCount(3);
            VectorEqualsVisitor visitor = new VectorEqualsVisitor();
            Assert.assertFalse((boolean)VectorEqualsVisitor.vectorEquals((ValueVector)vector1, (ValueVector)vector2));
        }
    }

    @Test
    public void testStructVectorEquals() {
        try (StructVector vector1 = StructVector.empty((String)"struct", (BufferAllocator)this.allocator);
             StructVector vector2 = StructVector.empty((String)"struct", (BufferAllocator)this.allocator);){
            vector1.addOrGet("f0", FieldType.nullable((ArrowType)new ArrowType.Int(32, true)), IntVector.class);
            vector1.addOrGet("f1", FieldType.nullable((ArrowType)new ArrowType.Int(64, true)), BigIntVector.class);
            vector2.addOrGet("f0", FieldType.nullable((ArrowType)new ArrowType.Int(32, true)), IntVector.class);
            vector2.addOrGet("f1", FieldType.nullable((ArrowType)new ArrowType.Int(64, true)), BigIntVector.class);
            NullableStructWriter writer1 = vector1.getWriter();
            writer1.allocate();
            this.writeStructVector(writer1, 1, 10L);
            this.writeStructVector(writer1, 2, 20L);
            this.writeStructVector(writer1, 3, 30L);
            writer1.setValueCount(3);
            NullableStructWriter writer2 = vector2.getWriter();
            writer2.allocate();
            this.writeStructVector(writer2, 1, 10L);
            this.writeStructVector(writer2, 2, 20L);
            writer2.setValueCount(2);
            VectorEqualsVisitor visitor = new VectorEqualsVisitor();
            Assert.assertFalse((boolean)VectorEqualsVisitor.vectorEquals((ValueVector)vector1, (ValueVector)vector2));
            this.writeStructVector(writer2, 3, 30L);
            writer2.setValueCount(3);
            Assert.assertTrue((boolean)VectorEqualsVisitor.vectorEquals((ValueVector)vector1, (ValueVector)vector2));
        }
    }

    @Test
    public void testStructVectorEqualsWithDiffChild() {
        try (StructVector vector1 = StructVector.empty((String)"struct", (BufferAllocator)this.allocator);
             StructVector vector2 = StructVector.empty((String)"struct", (BufferAllocator)this.allocator);){
            vector1.addOrGet("f0", FieldType.nullable((ArrowType)new ArrowType.Int(32, true)), IntVector.class);
            vector1.addOrGet("f1", FieldType.nullable((ArrowType)new ArrowType.Int(64, true)), BigIntVector.class);
            vector2.addOrGet("f0", FieldType.nullable((ArrowType)new ArrowType.Int(32, true)), IntVector.class);
            vector2.addOrGet("f10", FieldType.nullable((ArrowType)new ArrowType.Int(64, true)), BigIntVector.class);
            NullableStructWriter writer1 = vector1.getWriter();
            writer1.allocate();
            this.writeStructVector(writer1, 1, 10L);
            this.writeStructVector(writer1, 2, 20L);
            writer1.setValueCount(2);
            NullableStructWriter writer2 = vector2.getWriter();
            writer2.allocate();
            this.writeStructVector(writer2, 1, 10L);
            this.writeStructVector(writer2, 2, 20L);
            writer2.setValueCount(2);
            VectorEqualsVisitor visitor = new VectorEqualsVisitor();
            Assert.assertFalse((boolean)VectorEqualsVisitor.vectorEquals((ValueVector)vector1, (ValueVector)vector2));
        }
    }

    @Test
    public void testUnionVectorEquals() {
        try (UnionVector vector1 = new UnionVector("union", this.allocator, null);
             UnionVector vector2 = new UnionVector("union", this.allocator, null);){
            NullableUInt4Holder uInt4Holder = new NullableUInt4Holder();
            uInt4Holder.value = 10;
            uInt4Holder.isSet = 1;
            NullableIntHolder intHolder = new NullableIntHolder();
            uInt4Holder.value = 20;
            uInt4Holder.isSet = 1;
            vector1.setType(0, Types.MinorType.UINT4);
            vector1.setSafe(0, uInt4Holder);
            vector1.setType(1, Types.MinorType.INT);
            vector1.setSafe(1, intHolder);
            vector1.setValueCount(2);
            vector2.setType(0, Types.MinorType.UINT4);
            vector2.setSafe(0, uInt4Holder);
            vector2.setType(1, Types.MinorType.INT);
            vector2.setSafe(1, intHolder);
            vector2.setValueCount(2);
            VectorEqualsVisitor visitor = new VectorEqualsVisitor();
            Assert.assertTrue((boolean)VectorEqualsVisitor.vectorEquals((ValueVector)vector1, (ValueVector)vector2));
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testEqualsWithIndexOutOfRange() {
        try (IntVector vector1 = new IntVector("int", this.allocator);
             IntVector vector2 = new IntVector("int", this.allocator);){
            ValueVectorDataPopulator.setVector(vector1, 1, 2);
            ValueVectorDataPopulator.setVector(vector2, 1, 2);
            Assert.assertTrue((boolean)new RangeEqualsVisitor((ValueVector)vector1, (ValueVector)vector2).rangeEquals(new Range(2, 3, 1)));
        }
    }

    @Test
    public void testFixedWidthVectorNullHashCode() {
        try (IntVector intVec = new IntVector("int vector", this.allocator);){
            intVec.allocateNew(1);
            intVec.setValueCount(1);
            intVec.set(0, 100);
            intVec.setNull(0);
            Assert.assertEquals((long)0L, (long)intVec.hashCode(0));
        }
    }

    @Test
    public void testVariableWidthVectorNullHashCode() {
        try (VarCharVector varChVec = new VarCharVector("var char vector", this.allocator);){
            varChVec.allocateNew(100L, 1);
            varChVec.setValueCount(1);
            varChVec.set(0, "abc".getBytes());
            varChVec.setNull(0);
            Assert.assertEquals((long)0L, (long)varChVec.hashCode(0));
        }
    }

    @Test
    public void testUnionNullHashCode() {
        try (UnionVector srcVector = new UnionVector(EMPTY_SCHEMA_PATH, this.allocator, null);){
            srcVector.allocateNew();
            NullableIntHolder holder = new NullableIntHolder();
            holder.isSet = 0;
            srcVector.setType(0, Types.MinorType.INT);
            srcVector.setSafe(0, holder);
            Assert.assertEquals((long)0L, (long)srcVector.hashCode(0));
        }
    }

    @Test
    public void testToString() {
        try (IntVector intVector = new IntVector("intVector", this.allocator);
             ListVector listVector = ListVector.empty((String)"listVector", (BufferAllocator)this.allocator);
             StructVector structVector = StructVector.empty((String)"structVector", (BufferAllocator)this.allocator);){
            Assert.assertEquals((Object)"[]", (Object)intVector.toString());
            intVector.setValueCount(3);
            intVector.setSafe(0, 1);
            intVector.setSafe(1, 2);
            intVector.setSafe(2, 3);
            Assert.assertEquals((Object)"[1, 2, 3]", (Object)intVector.toString());
            intVector.setValueCount(100);
            for (int i = 0; i < 100; ++i) {
                intVector.setSafe(i, i);
            }
            Assert.assertEquals((Object)"[0, 1, 2, 3, 4, 5, 6, 7, 8, 9, ... 90, 91, 92, 93, 94, 95, 96, 97, 98, 99]", (Object)intVector.toString());
            listVector.allocateNewSafe();
            listVector.initializeChildrenFromFields(Collections.singletonList(Field.nullable((String)"child", (ArrowType)ArrowType.Utf8.INSTANCE)));
            VarCharVector dataVector = (VarCharVector)listVector.getDataVector();
            listVector.startNewValue(0);
            dataVector.setSafe(0, "aaa".getBytes(StandardCharsets.UTF_8));
            dataVector.setSafe(1, "bbb".getBytes(StandardCharsets.UTF_8));
            listVector.endValue(0, 2);
            listVector.startNewValue(1);
            dataVector.setSafe(2, "ccc".getBytes(StandardCharsets.UTF_8));
            dataVector.setSafe(3, "ddd".getBytes(StandardCharsets.UTF_8));
            listVector.endValue(1, 2);
            listVector.setValueCount(2);
            Assert.assertEquals((Object)"[[\"aaa\",\"bbb\"], [\"ccc\",\"ddd\"]]", (Object)listVector.toString());
            structVector.addOrGet("f0", FieldType.nullable((ArrowType)new ArrowType.Int(32, true)), IntVector.class);
            structVector.addOrGet("f1", FieldType.nullable((ArrowType)new ArrowType.Int(64, true)), BigIntVector.class);
            NullableStructWriter structWriter = structVector.getWriter();
            structWriter.allocate();
            this.writeStructVector(structWriter, 1, 10L);
            this.writeStructVector(structWriter, 2, 20L);
            structWriter.setValueCount(2);
            Assert.assertEquals((Object)"[{\"f0\":1,\"f1\":10}, {\"f0\":2,\"f1\":20}]", (Object)structVector.toString());
        }
    }

    @Test
    public void testUnloadVariableWidthVector() {
        try (VarCharVector varCharVector = new VarCharVector("var char", this.allocator);){
            varCharVector.allocateNew(5L, 2);
            varCharVector.setValueCount(2);
            varCharVector.set(0, "abcd".getBytes());
            List bufs = varCharVector.getFieldBuffers();
            Assert.assertEquals((long)3L, (long)bufs.size());
            ArrowBuf offsetBuf = (ArrowBuf)bufs.get(1);
            ArrowBuf dataBuf = (ArrowBuf)bufs.get(2);
            Assert.assertEquals((long)12L, (long)offsetBuf.writerIndex());
            Assert.assertEquals((long)4L, (long)offsetBuf.getInt(4L));
            Assert.assertEquals((long)4L, (long)offsetBuf.getInt(8L));
            Assert.assertEquals((long)4L, (long)dataBuf.writerIndex());
        }
    }

    private void writeStructVector(NullableStructWriter writer, int value1, long value2) {
        writer.start();
        writer.integer("f0").writeInt(value1);
        writer.bigInt("f1").writeBigInt(value2);
        writer.end();
    }

    private void writeListVector(UnionListWriter writer, int[] values) {
        writer.startList();
        for (int v : values) {
            writer.integer().writeInt(v);
        }
        writer.endList();
    }

    @Test
    public void testVariableVectorGetEndOffset() {
        try (VarCharVector vector1 = new VarCharVector("v1", this.allocator);
             VarBinaryVector vector2 = new VarBinaryVector("v2", this.allocator);){
            ValueVectorDataPopulator.setVector(vector1, (byte[][])new byte[][]{STR1, null, STR2});
            ValueVectorDataPopulator.setVector(vector2, (byte[][])new byte[][]{STR1, STR2, STR3});
            Assert.assertEquals((long)0L, (long)vector1.getStartOffset(0));
            Assert.assertEquals((long)STR1.length, (long)vector1.getEndOffset(0));
            Assert.assertEquals((long)STR1.length, (long)vector1.getStartOffset(1));
            Assert.assertEquals((long)STR1.length, (long)vector1.getEndOffset(1));
            Assert.assertEquals((long)STR1.length, (long)vector1.getStartOffset(2));
            Assert.assertEquals((long)(STR1.length + STR2.length), (long)vector1.getEndOffset(2));
            Assert.assertEquals((long)0L, (long)vector2.getStartOffset(0));
            Assert.assertEquals((long)STR1.length, (long)vector2.getEndOffset(0));
            Assert.assertEquals((long)STR1.length, (long)vector2.getStartOffset(1));
            Assert.assertEquals((long)(STR1.length + STR2.length), (long)vector2.getEndOffset(1));
            Assert.assertEquals((long)(STR1.length + STR2.length), (long)vector2.getStartOffset(2));
            Assert.assertEquals((long)(STR1.length + STR2.length + STR3.length), (long)vector2.getEndOffset(2));
        }
    }

    @Test
    public void testEmptyBufBehavior() {
        int valueCount = 10;
        try (IntVector vector = new IntVector("v", this.allocator);){
            Assert.assertEquals((long)1L, (long)vector.getDataBuffer().refCnt());
            Assert.assertEquals((long)1L, (long)vector.getValidityBuffer().refCnt());
            Assert.assertEquals((long)0L, (long)vector.getDataBuffer().capacity());
            Assert.assertEquals((long)0L, (long)vector.getValidityBuffer().capacity());
            vector.allocateNew(10);
            Assert.assertEquals((long)2L, (long)vector.getDataBuffer().refCnt());
            Assert.assertEquals((long)2L, (long)vector.getValidityBuffer().refCnt());
            Assert.assertEquals((long)56L, (long)vector.getDataBuffer().capacity());
            Assert.assertEquals((long)8L, (long)vector.getValidityBuffer().capacity());
            vector.close();
            Assert.assertEquals((long)1L, (long)vector.getDataBuffer().refCnt());
            Assert.assertEquals((long)1L, (long)vector.getValidityBuffer().refCnt());
            Assert.assertEquals((long)0L, (long)vector.getDataBuffer().capacity());
            Assert.assertEquals((long)0L, (long)vector.getValidityBuffer().capacity());
        }
        vector = new VarCharVector("v", this.allocator);
        var3_3 = null;
        try {
            Assert.assertEquals((long)1L, (long)vector.getDataBuffer().refCnt());
            Assert.assertEquals((long)1L, (long)vector.getValidityBuffer().refCnt());
            Assert.assertEquals((long)1L, (long)vector.getOffsetBuffer().refCnt());
            Assert.assertEquals((long)0L, (long)vector.getDataBuffer().capacity());
            Assert.assertEquals((long)0L, (long)vector.getValidityBuffer().capacity());
            Assert.assertEquals((long)0L, (long)vector.getOffsetBuffer().capacity());
            vector.allocateNew(10);
            Assert.assertEquals((long)1L, (long)vector.getDataBuffer().refCnt());
            Assert.assertEquals((long)2L, (long)vector.getValidityBuffer().refCnt());
            Assert.assertEquals((long)2L, (long)vector.getOffsetBuffer().refCnt());
            Assert.assertEquals((long)32768L, (long)vector.getDataBuffer().capacity());
            Assert.assertEquals((long)8L, (long)vector.getValidityBuffer().capacity());
            Assert.assertEquals((long)56L, (long)vector.getOffsetBuffer().capacity());
            vector.close();
            Assert.assertEquals((long)1L, (long)vector.getDataBuffer().refCnt());
            Assert.assertEquals((long)1L, (long)vector.getValidityBuffer().refCnt());
            Assert.assertEquals((long)1L, (long)vector.getOffsetBuffer().refCnt());
            Assert.assertEquals((long)0L, (long)vector.getDataBuffer().capacity());
            Assert.assertEquals((long)0L, (long)vector.getValidityBuffer().capacity());
            Assert.assertEquals((long)0L, (long)vector.getOffsetBuffer().capacity());
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            TestValueVector.$closeResource(var3_3, (AutoCloseable)vector);
        }
        vector = ListVector.empty((String)"v", (BufferAllocator)this.allocator);
        var3_3 = null;
        try {
            Assert.assertEquals((long)1L, (long)vector.getValidityBuffer().refCnt());
            Assert.assertEquals((long)1L, (long)vector.getOffsetBuffer().refCnt());
            Assert.assertEquals((long)0L, (long)vector.getValidityBuffer().capacity());
            Assert.assertEquals((long)0L, (long)vector.getOffsetBuffer().capacity());
            vector.setValueCount(10);
            vector.allocateNewSafe();
            Assert.assertEquals((long)1L, (long)vector.getValidityBuffer().refCnt());
            Assert.assertEquals((long)1L, (long)vector.getOffsetBuffer().refCnt());
            Assert.assertEquals((long)512L, (long)vector.getValidityBuffer().capacity());
            Assert.assertEquals((long)16384L, (long)vector.getOffsetBuffer().capacity());
            vector.close();
            Assert.assertEquals((long)1L, (long)vector.getValidityBuffer().refCnt());
            Assert.assertEquals((long)1L, (long)vector.getOffsetBuffer().refCnt());
            Assert.assertEquals((long)0L, (long)vector.getValidityBuffer().capacity());
            Assert.assertEquals((long)0L, (long)vector.getOffsetBuffer().capacity());
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (vector != null) {
                TestValueVector.$closeResource(var3_3, (AutoCloseable)vector);
            }
        }
        vector = FixedSizeListVector.empty((String)"v", (int)2, (BufferAllocator)this.allocator);
        var3_3 = null;
        try {
            Assert.assertEquals((long)1L, (long)vector.getValidityBuffer().refCnt());
            Assert.assertEquals((long)0L, (long)vector.getValidityBuffer().capacity());
            vector.setValueCount(10);
            vector.allocateNewSafe();
            Assert.assertEquals((long)1L, (long)vector.getValidityBuffer().refCnt());
            Assert.assertEquals((long)512L, (long)vector.getValidityBuffer().capacity());
            vector.close();
            Assert.assertEquals((long)1L, (long)vector.getValidityBuffer().refCnt());
            Assert.assertEquals((long)0L, (long)vector.getValidityBuffer().capacity());
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (vector != null) {
                TestValueVector.$closeResource(var3_3, (AutoCloseable)vector);
            }
        }
        vector = StructVector.empty((String)"v", (BufferAllocator)this.allocator);
        var3_3 = null;
        try {
            Assert.assertEquals((long)1L, (long)vector.getValidityBuffer().refCnt());
            Assert.assertEquals((long)0L, (long)vector.getValidityBuffer().capacity());
            vector.setValueCount(10);
            vector.allocateNewSafe();
            Assert.assertEquals((long)1L, (long)vector.getValidityBuffer().refCnt());
            Assert.assertEquals((long)512L, (long)vector.getValidityBuffer().capacity());
            vector.close();
            Assert.assertEquals((long)1L, (long)vector.getValidityBuffer().refCnt());
            Assert.assertEquals((long)0L, (long)vector.getValidityBuffer().capacity());
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (vector != null) {
                TestValueVector.$closeResource(var3_3, (AutoCloseable)vector);
            }
        }
        vector = UnionVector.empty((String)"v", (BufferAllocator)this.allocator);
        var3_3 = null;
        try {
            Assert.assertEquals((long)1L, (long)vector.getTypeBuffer().refCnt());
            Assert.assertEquals((long)0L, (long)vector.getTypeBuffer().capacity());
            vector.setValueCount(10);
            vector.allocateNewSafe();
            Assert.assertEquals((long)1L, (long)vector.getTypeBuffer().refCnt());
            Assert.assertEquals((long)4096L, (long)vector.getTypeBuffer().capacity());
            vector.close();
            Assert.assertEquals((long)1L, (long)vector.getTypeBuffer().refCnt());
            Assert.assertEquals((long)0L, (long)vector.getTypeBuffer().capacity());
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (vector != null) {
                TestValueVector.$closeResource(var3_3, (AutoCloseable)vector);
            }
        }
        vector = DenseUnionVector.empty((String)"v", (BufferAllocator)this.allocator);
        var3_3 = null;
        try {
            Assert.assertEquals((long)1L, (long)vector.getTypeBuffer().refCnt());
            Assert.assertEquals((long)1L, (long)vector.getOffsetBuffer().refCnt());
            Assert.assertEquals((long)0L, (long)vector.getTypeBuffer().capacity());
            Assert.assertEquals((long)0L, (long)vector.getOffsetBuffer().capacity());
            vector.setValueCount(10);
            vector.allocateNew();
            Assert.assertEquals((long)1L, (long)vector.getTypeBuffer().refCnt());
            Assert.assertEquals((long)1L, (long)vector.getOffsetBuffer().refCnt());
            Assert.assertEquals((long)4096L, (long)vector.getTypeBuffer().capacity());
            Assert.assertEquals((long)16384L, (long)vector.getOffsetBuffer().capacity());
            vector.close();
            Assert.assertEquals((long)1L, (long)vector.getTypeBuffer().refCnt());
            Assert.assertEquals((long)1L, (long)vector.getOffsetBuffer().refCnt());
            Assert.assertEquals((long)0L, (long)vector.getTypeBuffer().capacity());
            Assert.assertEquals((long)0L, (long)vector.getOffsetBuffer().capacity());
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (vector != null) {
                TestValueVector.$closeResource(var3_3, (AutoCloseable)vector);
            }
        }
    }

    @Test
    public void testSetGetUInt1() {
        try (UInt1Vector vector = new UInt1Vector("vector", this.allocator);){
            vector.allocateNew(2);
            vector.setWithPossibleTruncate(0, -1L);
            vector.setUnsafeWithPossibleTruncate(1, -1L);
            vector.setValueCount(2);
            Assert.assertEquals((long)255L, (long)vector.getValueAsLong(0));
            Assert.assertEquals((long)255L, (long)vector.getValueAsLong(1));
        }
    }

    @Test
    public void testSetGetUInt2() {
        try (UInt2Vector vector = new UInt2Vector("vector", this.allocator);){
            vector.allocateNew(2);
            vector.setWithPossibleTruncate(0, 65535L);
            vector.setUnsafeWithPossibleTruncate(1, 65535L);
            vector.setValueCount(2);
            Assert.assertEquals((long)65535L, (long)vector.getValueAsLong(0));
            Assert.assertEquals((long)65535L, (long)vector.getValueAsLong(1));
        }
    }

    @Test
    public void testSetGetUInt4() {
        try (UInt4Vector vector = new UInt4Vector("vector", this.allocator);){
            vector.allocateNew(2);
            vector.setWithPossibleTruncate(0, -1L);
            vector.setUnsafeWithPossibleTruncate(1, -1L);
            vector.setValueCount(2);
            long expected = 0xFFFFFFFFL;
            Assert.assertEquals((long)expected, (long)vector.getValueAsLong(0));
            Assert.assertEquals((long)expected, (long)vector.getValueAsLong(1));
        }
    }
}

