/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.vector;

import org.apache.arrow.vector.TypeLayout;
import org.apache.arrow.vector.types.DateUnit;
import org.apache.arrow.vector.types.FloatingPointPrecision;
import org.apache.arrow.vector.types.IntervalUnit;
import org.apache.arrow.vector.types.TimeUnit;
import org.apache.arrow.vector.types.UnionMode;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.junit.Assert;
import org.junit.Test;

public class TestTypeLayout {
    @Test
    public void testTypeBufferCount() {
        ArrowType.Int type = new ArrowType.Int(8, true);
        Assert.assertEquals((long)TypeLayout.getTypeBufferCount((ArrowType)type), (long)TypeLayout.getTypeLayout((ArrowType)type).getBufferLayouts().size());
        type = new ArrowType.Union(UnionMode.Sparse, new int[2]);
        Assert.assertEquals((long)TypeLayout.getTypeBufferCount((ArrowType)type), (long)TypeLayout.getTypeLayout((ArrowType)type).getBufferLayouts().size());
        type = new ArrowType.Union(UnionMode.Dense, new int[1]);
        Assert.assertEquals((long)TypeLayout.getTypeBufferCount((ArrowType)type), (long)TypeLayout.getTypeLayout((ArrowType)type).getBufferLayouts().size());
        type = new ArrowType.Struct();
        Assert.assertEquals((long)TypeLayout.getTypeBufferCount((ArrowType)type), (long)TypeLayout.getTypeLayout((ArrowType)type).getBufferLayouts().size());
        type = new ArrowType.Timestamp(TimeUnit.MILLISECOND, null);
        Assert.assertEquals((long)TypeLayout.getTypeBufferCount((ArrowType)type), (long)TypeLayout.getTypeLayout((ArrowType)type).getBufferLayouts().size());
        type = new ArrowType.List();
        Assert.assertEquals((long)TypeLayout.getTypeBufferCount((ArrowType)type), (long)TypeLayout.getTypeLayout((ArrowType)type).getBufferLayouts().size());
        type = new ArrowType.FixedSizeList(5);
        Assert.assertEquals((long)TypeLayout.getTypeBufferCount((ArrowType)type), (long)TypeLayout.getTypeLayout((ArrowType)type).getBufferLayouts().size());
        type = new ArrowType.Map(false);
        Assert.assertEquals((long)TypeLayout.getTypeBufferCount((ArrowType)type), (long)TypeLayout.getTypeLayout((ArrowType)type).getBufferLayouts().size());
        type = new ArrowType.FloatingPoint(FloatingPointPrecision.SINGLE);
        Assert.assertEquals((long)TypeLayout.getTypeBufferCount((ArrowType)type), (long)TypeLayout.getTypeLayout((ArrowType)type).getBufferLayouts().size());
        type = new ArrowType.FloatingPoint(FloatingPointPrecision.DOUBLE);
        Assert.assertEquals((long)TypeLayout.getTypeBufferCount((ArrowType)type), (long)TypeLayout.getTypeLayout((ArrowType)type).getBufferLayouts().size());
        type = new ArrowType.Decimal(10, 10, 128);
        Assert.assertEquals((long)TypeLayout.getTypeBufferCount((ArrowType)type), (long)TypeLayout.getTypeLayout((ArrowType)type).getBufferLayouts().size());
        type = new ArrowType.Decimal(10, 10, 256);
        Assert.assertEquals((long)TypeLayout.getTypeBufferCount((ArrowType)type), (long)TypeLayout.getTypeLayout((ArrowType)type).getBufferLayouts().size());
        type = new ArrowType.FixedSizeBinary(5);
        Assert.assertEquals((long)TypeLayout.getTypeBufferCount((ArrowType)type), (long)TypeLayout.getTypeLayout((ArrowType)type).getBufferLayouts().size());
        type = new ArrowType.Bool();
        Assert.assertEquals((long)TypeLayout.getTypeBufferCount((ArrowType)type), (long)TypeLayout.getTypeLayout((ArrowType)type).getBufferLayouts().size());
        type = new ArrowType.Binary();
        Assert.assertEquals((long)TypeLayout.getTypeBufferCount((ArrowType)type), (long)TypeLayout.getTypeLayout((ArrowType)type).getBufferLayouts().size());
        type = new ArrowType.Utf8();
        Assert.assertEquals((long)TypeLayout.getTypeBufferCount((ArrowType)type), (long)TypeLayout.getTypeLayout((ArrowType)type).getBufferLayouts().size());
        type = new ArrowType.Null();
        Assert.assertEquals((long)TypeLayout.getTypeBufferCount((ArrowType)type), (long)TypeLayout.getTypeLayout((ArrowType)type).getBufferLayouts().size());
        type = new ArrowType.Date(DateUnit.DAY);
        Assert.assertEquals((long)TypeLayout.getTypeBufferCount((ArrowType)type), (long)TypeLayout.getTypeLayout((ArrowType)type).getBufferLayouts().size());
        type = new ArrowType.Time(TimeUnit.MILLISECOND, 32);
        Assert.assertEquals((long)TypeLayout.getTypeBufferCount((ArrowType)type), (long)TypeLayout.getTypeLayout((ArrowType)type).getBufferLayouts().size());
        type = new ArrowType.Interval(IntervalUnit.DAY_TIME);
        Assert.assertEquals((long)TypeLayout.getTypeBufferCount((ArrowType)type), (long)TypeLayout.getTypeLayout((ArrowType)type).getBufferLayouts().size());
        type = new ArrowType.Duration(TimeUnit.MILLISECOND);
        Assert.assertEquals((long)TypeLayout.getTypeBufferCount((ArrowType)type), (long)TypeLayout.getTypeLayout((ArrowType)type).getBufferLayouts().size());
    }
}

