/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.vector;

import java.util.HashMap;
import java.util.List;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.DirtyRootAllocator;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.SmallIntVector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.complex.ListVector;
import org.apache.arrow.vector.complex.StructVector;
import org.apache.arrow.vector.complex.UnionVector;
import org.apache.arrow.vector.holders.ComplexHolder;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestStructVector {
    private BufferAllocator allocator;

    @Before
    public void init() {
        this.allocator = new DirtyRootAllocator(Long.MAX_VALUE, 100);
    }

    @After
    public void terminate() throws Exception {
        this.allocator.close();
    }

    @Test
    public void testFieldMetadata() throws Exception {
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("k1", "v1");
        FieldType type = new FieldType(true, (ArrowType)ArrowType.Struct.INSTANCE, null, metadata);
        try (StructVector vector = new StructVector("struct", this.allocator, type, null);){
            Assert.assertEquals((Object)vector.getField().getMetadata(), (Object)type.getMetadata());
        }
    }

    @Test
    public void testMakeTransferPair() {
        try (StructVector s1 = StructVector.empty((String)"s1", (BufferAllocator)this.allocator);
             StructVector s2 = StructVector.empty((String)"s2", (BufferAllocator)this.allocator);){
            s1.addOrGet("struct_child", FieldType.nullable((ArrowType)Types.MinorType.INT.getType()), IntVector.class);
            s1.makeTransferPair((ValueVector)s2);
            FieldVector child = s1.getChild("struct_child");
            FieldVector toChild = s2.addOrGet("struct_child", child.getField().getFieldType(), child.getClass());
            Assert.assertEquals((long)0L, (long)toChild.getValueCapacity());
            Assert.assertEquals((long)0L, (long)toChild.getDataBuffer().capacity());
            Assert.assertEquals((long)0L, (long)toChild.getValidityBuffer().capacity());
        }
    }

    @Test
    public void testAllocateAfterReAlloc() throws Exception {
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("k1", "v1");
        FieldType type = new FieldType(true, (ArrowType)ArrowType.Struct.INSTANCE, null, metadata);
        try (StructVector vector = new StructVector("struct", this.allocator, type, null);){
            Types.MinorType childtype = Types.MinorType.INT;
            vector.addOrGet("intchild", FieldType.nullable((ArrowType)childtype.getType()), IntVector.class);
            vector.allocateNewSafe();
            vector.reAlloc();
            long savedValidityBufferCapacity = vector.getValidityBuffer().capacity();
            int savedValueCapacity = vector.getValueCapacity();
            vector.clear();
            vector.allocateNewSafe();
            Assert.assertEquals((long)vector.getValidityBuffer().capacity(), (long)savedValidityBufferCapacity);
            Assert.assertEquals((long)vector.getValueCapacity(), (long)savedValueCapacity);
        }
    }

    @Test
    public void testReadNullValue() {
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("k1", "v1");
        FieldType type = new FieldType(true, (ArrowType)ArrowType.Struct.INSTANCE, null, metadata);
        try (StructVector vector = new StructVector("struct", this.allocator, type, null);){
            Types.MinorType childtype = Types.MinorType.INT;
            vector.addOrGet("intchild", FieldType.nullable((ArrowType)childtype.getType()), IntVector.class);
            vector.setValueCount(2);
            IntVector intVector = (IntVector)vector.getChild("intchild");
            intVector.setSafe(0, 100);
            vector.setIndexDefined(0);
            intVector.setNull(1);
            vector.setNull(1);
            ComplexHolder holder = new ComplexHolder();
            vector.get(0, holder);
            Assert.assertNotEquals((long)0L, (long)holder.isSet);
            Assert.assertNotNull((Object)holder.reader);
            vector.get(1, holder);
            Assert.assertEquals((long)0L, (long)holder.isSet);
            Assert.assertNull((Object)holder.reader);
        }
    }

    @Test
    public void testGetPrimitiveVectors() {
        FieldType type = new FieldType(true, (ArrowType)ArrowType.Struct.INSTANCE, null, null);
        try (StructVector vector = new StructVector("struct", this.allocator, type, null);){
            vector.addOrGet("list", FieldType.nullable((ArrowType)Types.MinorType.LIST.getType()), ListVector.class);
            ListVector listVector = vector.addOrGetList("list");
            listVector.addOrGetVector(FieldType.nullable((ArrowType)Types.MinorType.INT.getType()));
            vector.addOrGet("union", FieldType.nullable((ArrowType)Types.MinorType.UNION.getType()), UnionVector.class);
            UnionVector unionVector = vector.addOrGetUnion("union");
            unionVector.addVector((FieldVector)new BigIntVector("bigInt", this.allocator));
            unionVector.addVector((FieldVector)new SmallIntVector("smallInt", this.allocator));
            vector.addOrGet("varchar", FieldType.nullable((ArrowType)Types.MinorType.VARCHAR.getType()), VarCharVector.class);
            List primitiveVectors = vector.getPrimitiveVectors();
            Assert.assertEquals((long)4L, (long)primitiveVectors.size());
            Assert.assertEquals((Object)Types.MinorType.INT, (Object)((ValueVector)primitiveVectors.get(0)).getMinorType());
            Assert.assertEquals((Object)Types.MinorType.BIGINT, (Object)((ValueVector)primitiveVectors.get(1)).getMinorType());
            Assert.assertEquals((Object)Types.MinorType.SMALLINT, (Object)((ValueVector)primitiveVectors.get(2)).getMinorType());
            Assert.assertEquals((Object)Types.MinorType.VARCHAR, (Object)((ValueVector)primitiveVectors.get(3)).getMinorType());
        }
    }

    @Test
    public void testAddOrGetComplexChildVectors() {
        FieldType type = new FieldType(true, (ArrowType)ArrowType.Struct.INSTANCE, null, null);
        try (StructVector vector = new StructVector("struct", this.allocator, type, null);){
            vector.addOrGetList("list");
            vector.addOrGetFixedSizeList("fixedList", 2);
            vector.addOrGetUnion("union");
            vector.addOrGetStruct("struct");
            vector.addOrGetMap("map", true);
            List childrens = vector.getChildrenFromFields();
            Assert.assertEquals((long)5L, (long)childrens.size());
            Assert.assertEquals((Object)Types.MinorType.LIST, (Object)((FieldVector)childrens.get(0)).getMinorType());
            Assert.assertEquals((Object)Types.MinorType.FIXED_SIZE_LIST, (Object)((FieldVector)childrens.get(1)).getMinorType());
            Assert.assertEquals((Object)Types.MinorType.UNION, (Object)((FieldVector)childrens.get(2)).getMinorType());
            Assert.assertEquals((Object)Types.MinorType.STRUCT, (Object)((FieldVector)childrens.get(3)).getMinorType());
            Assert.assertEquals((Object)Types.MinorType.MAP, (Object)((FieldVector)childrens.get(4)).getMinorType());
        }
    }
}

