/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.vector;

import java.lang.reflect.Field;
import java.net.URLClassLoader;
import org.junit.Assert;
import org.junit.Test;

public class TestNullCheckingForGet {
    private ClassLoader copyClassLoader() {
        ClassLoader curClassLoader = this.getClass().getClassLoader();
        if (curClassLoader instanceof URLClassLoader) {
            return new URLClassLoader(((URLClassLoader)curClassLoader).getURLs(), null);
        }
        return null;
    }

    private boolean getFlagValue(ClassLoader classLoader) throws Exception {
        Class<?> clazz = classLoader.loadClass("org.apache.arrow.vector.NullCheckingForGet");
        Field field = clazz.getField("NULL_CHECKING_ENABLED");
        return (Boolean)field.get(null);
    }

    @Test
    public void testDefaultValue() throws Exception {
        ClassLoader classLoader = this.copyClassLoader();
        if (classLoader != null) {
            boolean nullCheckingEnabled = this.getFlagValue(classLoader);
            Assert.assertTrue((boolean)nullCheckingEnabled);
        }
    }

    @Test
    public void testEnableSysProperty() throws Exception {
        String sysProperty = System.getProperty("arrow.enable_null_check_for_get");
        System.setProperty("arrow.enable_null_check_for_get", "false");
        ClassLoader classLoader = this.copyClassLoader();
        if (classLoader != null) {
            boolean nullCheckingEnabled = this.getFlagValue(classLoader);
            Assert.assertFalse((boolean)nullCheckingEnabled);
        }
        if (sysProperty != null) {
            System.setProperty("arrow.enable_null_check_for_get", sysProperty);
        } else {
            System.clearProperty("arrow.enable_null_check_for_get");
        }
    }
}

