/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.vector;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.AddOrGetResult;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.DirtyRootAllocator;
import org.apache.arrow.vector.Float8Vector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.complex.MapVector;
import org.apache.arrow.vector.complex.StructVector;
import org.apache.arrow.vector.complex.impl.UnionMapReader;
import org.apache.arrow.vector.complex.impl.UnionMapWriter;
import org.apache.arrow.vector.complex.writer.BaseWriter;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.util.JsonStringArrayList;
import org.apache.arrow.vector.util.TransferPair;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestMapVector {
    private BufferAllocator allocator;

    @Before
    public void init() {
        this.allocator = new DirtyRootAllocator(Long.MAX_VALUE, 100);
    }

    @After
    public void terminate() throws Exception {
        this.allocator.close();
    }

    public <T> T getResultKey(Map<?, T> resultStruct) {
        Assert.assertTrue((boolean)resultStruct.containsKey("key"));
        return resultStruct.get("key");
    }

    public <T> T getResultValue(Map<?, T> resultStruct) {
        Assert.assertTrue((boolean)resultStruct.containsKey("value"));
        return resultStruct.get("value");
    }

    @Test
    public void testBasicOperation() {
        int count = 5;
        try (MapVector mapVector = MapVector.empty((String)"map", (BufferAllocator)this.allocator, (boolean)false);){
            mapVector.allocateNew();
            UnionMapWriter mapWriter = mapVector.getWriter();
            for (int i = 0; i < count; ++i) {
                mapWriter.startMap();
                for (int j = 0; j < i + 1; ++j) {
                    mapWriter.startEntry();
                    mapWriter.key().bigInt().writeBigInt((long)j);
                    mapWriter.value().integer().writeInt(j);
                    mapWriter.endEntry();
                }
                mapWriter.endMap();
            }
            mapWriter.setValueCount(count);
            UnionMapReader mapReader = mapVector.getReader();
            for (int i = 0; i < count; ++i) {
                mapReader.setPosition(i);
                for (int j = 0; j < i + 1; ++j) {
                    mapReader.next();
                    Assert.assertEquals((String)("record: " + i), (long)j, (long)mapReader.key().readLong());
                    Assert.assertEquals((long)j, (long)mapReader.value().readInteger().intValue());
                }
            }
        }
    }

    @Test
    public void testBasicOperationNulls() {
        int count = 6;
        try (MapVector mapVector = MapVector.empty((String)"map", (BufferAllocator)this.allocator, (boolean)false);){
            mapVector.allocateNew();
            UnionMapWriter mapWriter = mapVector.getWriter();
            for (int i = 0; i < count; ++i) {
                if (i == 1) continue;
                mapWriter.setPosition(i);
                mapWriter.startMap();
                if (i != 3) {
                    for (int j = 0; j < i + 1; ++j) {
                        mapWriter.startEntry();
                        mapWriter.key().bigInt().writeBigInt((long)j);
                        if (i != 5) {
                            mapWriter.value().integer().writeInt(j);
                        }
                        mapWriter.endEntry();
                    }
                }
                mapWriter.endMap();
            }
            mapWriter.setValueCount(count);
            UnionMapReader mapReader = mapVector.getReader();
            for (int i = 0; i < count; ++i) {
                mapReader.setPosition(i);
                if (i == 1) {
                    Assert.assertFalse((boolean)mapReader.isSet());
                    continue;
                }
                if (i == 3) {
                    JsonStringArrayList result = (JsonStringArrayList)mapReader.readObject();
                    Assert.assertTrue((boolean)result.isEmpty());
                    continue;
                }
                for (int j = 0; j < i + 1; ++j) {
                    mapReader.next();
                    Assert.assertEquals((String)("record: " + i), (long)j, (long)mapReader.key().readLong());
                    if (i == 5) {
                        Assert.assertFalse((boolean)mapReader.value().isSet());
                        continue;
                    }
                    Assert.assertEquals((long)j, (long)mapReader.value().readInteger().intValue());
                }
            }
        }
    }

    @Test
    public void testCopyFrom() throws Exception {
        try (MapVector inVector = MapVector.empty((String)"input", (BufferAllocator)this.allocator, (boolean)false);
             MapVector outVector = MapVector.empty((String)"output", (BufferAllocator)this.allocator, (boolean)false);){
            UnionMapWriter writer = inVector.getWriter();
            writer.allocate();
            writer.setPosition(0);
            writer.startMap();
            writer.startEntry();
            writer.key().bigInt().writeBigInt(1L);
            writer.value().bigInt().writeBigInt(11L);
            writer.endEntry();
            writer.startEntry();
            writer.key().bigInt().writeBigInt(2L);
            writer.value().bigInt().writeBigInt(22L);
            writer.endEntry();
            writer.startEntry();
            writer.key().bigInt().writeBigInt(3L);
            writer.value().bigInt().writeBigInt(33L);
            writer.endEntry();
            writer.endMap();
            writer.setPosition(2);
            writer.startMap();
            writer.startEntry();
            writer.key().bigInt().writeBigInt(2L);
            writer.endEntry();
            writer.endMap();
            writer.setValueCount(3);
            outVector.allocateNew();
            for (int i = 0; i < 3; ++i) {
                outVector.copyFrom(i, i, (ValueVector)inVector);
            }
            outVector.setValueCount(3);
            UnionMapReader reader = outVector.getReader();
            Assert.assertTrue((String)"shouldn't be null", (boolean)reader.isSet());
            reader.setPosition(1);
            Assert.assertFalse((String)"should be null", (boolean)reader.isSet());
            reader.setPosition(2);
            Assert.assertTrue((String)"shouldn't be null", (boolean)reader.isSet());
            List result = outVector.getObject(0);
            ArrayList resultSet = (ArrayList)result;
            Assert.assertEquals((long)3L, (long)resultSet.size());
            Map resultStruct = (Map)resultSet.get(0);
            Assert.assertEquals((Object)1L, this.getResultKey(resultStruct));
            Assert.assertEquals((Object)11L, this.getResultValue(resultStruct));
            resultStruct = (Map)resultSet.get(1);
            Assert.assertEquals((Object)2L, this.getResultKey(resultStruct));
            Assert.assertEquals((Object)22L, this.getResultValue(resultStruct));
            resultStruct = (Map)resultSet.get(2);
            Assert.assertEquals((Object)3L, this.getResultKey(resultStruct));
            Assert.assertEquals((Object)33L, this.getResultValue(resultStruct));
            result = outVector.getObject(1);
            Assert.assertNull((Object)result);
            result = outVector.getObject(2);
            resultSet = (ArrayList)result;
            Assert.assertEquals((long)1L, (long)resultSet.size());
            resultStruct = (Map)resultSet.get(0);
            Assert.assertEquals((Object)2L, this.getResultKey(resultStruct));
            Assert.assertFalse((boolean)resultStruct.containsKey("value"));
        }
    }

    @Test
    public void testSplitAndTransfer() throws Exception {
        try (MapVector mapVector = MapVector.empty((String)"sourceVector", (BufferAllocator)this.allocator, (boolean)false);){
            FieldType type = new FieldType(false, (ArrowType)ArrowType.Struct.INSTANCE, null, null);
            AddOrGetResult addResult = mapVector.addOrGetVector(type);
            FieldType keyType = new FieldType(false, Types.MinorType.BIGINT.getType(), null, null);
            FieldType valueType = FieldType.nullable((ArrowType)Types.MinorType.FLOAT8.getType());
            ((StructVector)addResult.getVector()).addOrGet("key", keyType, BigIntVector.class);
            ((StructVector)addResult.getVector()).addOrGet("value", valueType, Float8Vector.class);
            UnionMapWriter mapWriter = mapVector.getWriter();
            mapWriter.allocate();
            mapWriter.setPosition(0);
            mapWriter.startMap();
            mapWriter.startEntry();
            mapWriter.key().bigInt().writeBigInt(10L);
            mapWriter.value().float8().writeFloat8(1.0);
            mapWriter.endEntry();
            mapWriter.startEntry();
            mapWriter.key().bigInt().writeBigInt(11L);
            mapWriter.value().float8().writeFloat8(1.1);
            mapWriter.endEntry();
            mapWriter.startEntry();
            mapWriter.key().bigInt().writeBigInt(12L);
            mapWriter.value().float8().writeFloat8(1.2);
            mapWriter.endEntry();
            mapWriter.endMap();
            mapWriter.setPosition(1);
            mapWriter.startMap();
            mapWriter.startEntry();
            mapWriter.key().bigInt().writeBigInt(13L);
            mapWriter.value().float8().writeFloat8(1.3);
            mapWriter.endEntry();
            mapWriter.startEntry();
            mapWriter.key().bigInt().writeBigInt(14L);
            mapWriter.value().float8().writeFloat8(1.4);
            mapWriter.endEntry();
            mapWriter.endMap();
            mapWriter.setPosition(2);
            mapWriter.startMap();
            mapWriter.startEntry();
            mapWriter.key().bigInt().writeBigInt(15L);
            mapWriter.value().float8().writeFloat8(1.5);
            mapWriter.endEntry();
            mapWriter.startEntry();
            mapWriter.key().bigInt().writeBigInt(16L);
            mapWriter.value().float8().writeFloat8(1.6);
            mapWriter.endEntry();
            mapWriter.startEntry();
            mapWriter.key().bigInt().writeBigInt(17L);
            mapWriter.value().float8().writeFloat8(1.7);
            mapWriter.endEntry();
            mapWriter.startEntry();
            mapWriter.key().bigInt().writeBigInt(18L);
            mapWriter.value().float8().writeFloat8(1.8);
            mapWriter.endEntry();
            mapWriter.endMap();
            mapWriter.setPosition(3);
            mapWriter.startMap();
            mapWriter.startEntry();
            mapWriter.key().bigInt().writeBigInt(19L);
            mapWriter.value().float8().writeFloat8(1.9);
            mapWriter.endEntry();
            mapWriter.endMap();
            mapWriter.setPosition(4);
            mapWriter.startMap();
            mapWriter.startEntry();
            mapWriter.key().bigInt().writeBigInt(20L);
            mapWriter.value().float8().writeFloat8(2.0);
            mapWriter.endEntry();
            mapWriter.startEntry();
            mapWriter.key().bigInt().writeBigInt(21L);
            mapWriter.value().float8().writeFloat8(2.1);
            mapWriter.endEntry();
            mapWriter.startEntry();
            mapWriter.key().bigInt().writeBigInt(22L);
            mapWriter.value().float8().writeFloat8(2.2);
            mapWriter.endEntry();
            mapWriter.startEntry();
            mapWriter.key().bigInt().writeBigInt(23L);
            mapWriter.value().float8().writeFloat8(2.3);
            mapWriter.endEntry();
            mapWriter.endMap();
            mapVector.setValueCount(5);
            Assert.assertEquals((long)4L, (long)mapVector.getLastSet());
            ArrowBuf offsetBuffer = mapVector.getOffsetBuffer();
            StructVector dataVector = (StructVector)mapVector.getDataVector();
            int index = 0;
            int offset = 0;
            Map result = null;
            Assert.assertFalse((boolean)mapVector.isNull(index));
            offset = offsetBuffer.getInt((long)(index * 4));
            Assert.assertEquals((Object)Integer.toString(0), (Object)Integer.toString(offset));
            result = dataVector.getObject(offset);
            Assert.assertEquals((Object)10L, this.getResultKey(result));
            Assert.assertEquals((Object)1.0, this.getResultValue(result));
            result = dataVector.getObject(++offset);
            Assert.assertEquals((Object)11L, this.getResultKey(result));
            Assert.assertEquals((Object)1.1, this.getResultValue(result));
            result = dataVector.getObject(++offset);
            Assert.assertEquals((Object)12L, this.getResultKey(result));
            Assert.assertEquals((Object)1.2, this.getResultValue(result));
            Assert.assertFalse((boolean)mapVector.isNull(++index));
            offset = offsetBuffer.getInt((long)(index * 4));
            Assert.assertEquals((Object)Integer.toString(3), (Object)Integer.toString(offset));
            result = dataVector.getObject(offset);
            Assert.assertEquals((Object)13L, this.getResultKey(result));
            Assert.assertEquals((Object)1.3, this.getResultValue(result));
            result = dataVector.getObject(++offset);
            Assert.assertEquals((Object)14L, this.getResultKey(result));
            Assert.assertEquals((Object)1.4, this.getResultValue(result));
            Assert.assertFalse((boolean)mapVector.isNull(++index));
            offset = offsetBuffer.getInt((long)(index * 4));
            Assert.assertEquals((Object)Integer.toString(5), (Object)Integer.toString(offset));
            result = dataVector.getObject(offset);
            Assert.assertEquals((Object)15L, this.getResultKey(result));
            Assert.assertEquals((Object)1.5, this.getResultValue(result));
            result = dataVector.getObject(++offset);
            Assert.assertEquals((Object)16L, this.getResultKey(result));
            Assert.assertEquals((Object)1.6, this.getResultValue(result));
            result = dataVector.getObject(++offset);
            Assert.assertEquals((Object)17L, this.getResultKey(result));
            Assert.assertEquals((Object)1.7, this.getResultValue(result));
            result = dataVector.getObject(++offset);
            Assert.assertEquals((Object)18L, this.getResultKey(result));
            Assert.assertEquals((Object)1.8, this.getResultValue(result));
            Assert.assertFalse((boolean)mapVector.isNull(++index));
            offset = offsetBuffer.getInt((long)(index * 4));
            Assert.assertEquals((Object)Integer.toString(9), (Object)Integer.toString(offset));
            result = dataVector.getObject(offset);
            Assert.assertEquals((Object)19L, this.getResultKey(result));
            Assert.assertEquals((Object)1.9, this.getResultValue(result));
            Assert.assertFalse((boolean)mapVector.isNull(++index));
            offset = offsetBuffer.getInt((long)(index * 4));
            Assert.assertEquals((Object)Integer.toString(10), (Object)Integer.toString(offset));
            result = dataVector.getObject(offset);
            Assert.assertEquals((Object)20L, this.getResultKey(result));
            Assert.assertEquals((Object)2.0, this.getResultValue(result));
            result = dataVector.getObject(++offset);
            Assert.assertEquals((Object)21L, this.getResultKey(result));
            Assert.assertEquals((Object)2.1, this.getResultValue(result));
            result = dataVector.getObject(++offset);
            Assert.assertEquals((Object)22L, this.getResultKey(result));
            Assert.assertEquals((Object)2.2, this.getResultValue(result));
            result = dataVector.getObject(++offset);
            Assert.assertEquals((Object)23L, this.getResultKey(result));
            Assert.assertEquals((Object)2.3, this.getResultValue(result));
            Assert.assertTrue((boolean)mapVector.isNull(++index));
            offset = offsetBuffer.getInt((long)(index * 4));
            Assert.assertEquals((Object)Integer.toString(14), (Object)Integer.toString(offset));
            try (MapVector toVector = MapVector.empty((String)"toVector", (BufferAllocator)this.allocator, (boolean)false);){
                int[][] transferLengths;
                TransferPair transferPair = mapVector.makeTransferPair((ValueVector)toVector);
                for (int[] transferLength : transferLengths = new int[][]{{0, 2}, {3, 1}, {4, 1}}) {
                    int start = transferLength[0];
                    int splitLength = transferLength[1];
                    int dataLength1 = 0;
                    int dataLength2 = 0;
                    int offset1 = 0;
                    int offset2 = 0;
                    transferPair.splitAndTransfer(start, splitLength);
                    ArrowBuf toOffsetBuffer = toVector.getOffsetBuffer();
                    StructVector dataVector1 = (StructVector)toVector.getDataVector();
                    for (int i = 0; i < splitLength; ++i) {
                        dataLength1 = offsetBuffer.getInt((long)((start + i + 1) * 4)) - offsetBuffer.getInt((long)((start + i) * 4));
                        dataLength2 = toOffsetBuffer.getInt((long)((i + 1) * 4)) - toOffsetBuffer.getInt((long)(i * 4));
                        Assert.assertEquals((String)("Different data lengths at index: " + i + " and start: " + start), (long)dataLength1, (long)dataLength2);
                        offset1 = offsetBuffer.getInt((long)((start + i) * 4));
                        offset2 = toOffsetBuffer.getInt((long)(i * 4));
                        for (int j = 0; j < dataLength1; ++j) {
                            Assert.assertEquals((String)("Different data at indexes: " + offset1 + " and " + offset2), (Object)dataVector.getObject(offset1), (Object)dataVector1.getObject(offset2));
                            ++offset1;
                            ++offset2;
                        }
                    }
                }
            }
        }
    }

    @Test
    public void testMapWithListValue() throws Exception {
        try (MapVector mapVector = MapVector.empty((String)"sourceVector", (BufferAllocator)this.allocator, (boolean)false);){
            UnionMapWriter mapWriter = mapVector.getWriter();
            mapWriter.allocate();
            mapWriter.setPosition(0);
            mapWriter.startMap();
            mapWriter.startEntry();
            mapWriter.key().bigInt().writeBigInt(1L);
            BaseWriter.ListWriter valueWriter = mapWriter.value().list();
            valueWriter.startList();
            valueWriter.bigInt().writeBigInt(50L);
            valueWriter.bigInt().writeBigInt(100L);
            valueWriter.bigInt().writeBigInt(200L);
            valueWriter.endList();
            mapWriter.endEntry();
            mapWriter.startEntry();
            mapWriter.key().bigInt().writeBigInt(2L);
            valueWriter = mapWriter.value().list();
            valueWriter.startList();
            valueWriter.bigInt().writeBigInt(75L);
            valueWriter.bigInt().writeBigInt(125L);
            valueWriter.bigInt().writeBigInt(150L);
            valueWriter.bigInt().writeBigInt(175L);
            valueWriter.endList();
            mapWriter.endEntry();
            mapWriter.endMap();
            mapWriter.setPosition(1);
            mapWriter.startMap();
            mapWriter.startEntry();
            mapWriter.key().bigInt().writeBigInt(3L);
            valueWriter = mapWriter.value().list();
            valueWriter.startList();
            valueWriter.bigInt().writeBigInt(10L);
            valueWriter.endList();
            mapWriter.endEntry();
            mapWriter.startEntry();
            mapWriter.key().bigInt().writeBigInt(4L);
            valueWriter = mapWriter.value().list();
            valueWriter.startList();
            valueWriter.bigInt().writeBigInt(15L);
            valueWriter.bigInt().writeBigInt(20L);
            valueWriter.endList();
            mapWriter.endEntry();
            mapWriter.startEntry();
            mapWriter.key().bigInt().writeBigInt(5L);
            valueWriter = mapWriter.value().list();
            valueWriter.startList();
            valueWriter.bigInt().writeBigInt(25L);
            valueWriter.bigInt().writeBigInt(30L);
            valueWriter.bigInt().writeBigInt(35L);
            valueWriter.endList();
            mapWriter.endEntry();
            mapWriter.endMap();
            Assert.assertEquals((long)1L, (long)mapVector.getLastSet());
            mapWriter.setValueCount(2);
            Assert.assertEquals((long)2L, (long)mapVector.getValueCount());
            List result = mapVector.getObject(0);
            ArrayList resultSet = (ArrayList)result;
            Assert.assertEquals((long)2L, (long)resultSet.size());
            Map resultStruct = (Map)resultSet.get(0);
            Assert.assertEquals((Object)1L, this.getResultKey(resultStruct));
            ArrayList list = (ArrayList)this.getResultValue(resultStruct);
            Assert.assertEquals((long)3L, (long)list.size());
            Assert.assertEquals((Object)new Long(50L), list.get(0));
            Assert.assertEquals((Object)new Long(100L), list.get(1));
            Assert.assertEquals((Object)new Long(200L), list.get(2));
            resultStruct = (Map)resultSet.get(1);
            list = (ArrayList)this.getResultValue(resultStruct);
            Assert.assertEquals((long)4L, (long)list.size());
            Assert.assertEquals((Object)new Long(75L), list.get(0));
            Assert.assertEquals((Object)new Long(125L), list.get(1));
            Assert.assertEquals((Object)new Long(150L), list.get(2));
            Assert.assertEquals((Object)new Long(175L), list.get(3));
            result = mapVector.getObject(1);
            resultSet = (ArrayList)result;
            resultStruct = (Map)resultSet.get(0);
            Assert.assertEquals((Object)3L, this.getResultKey(resultStruct));
            list = (ArrayList)this.getResultValue(resultStruct);
            Assert.assertEquals((long)1L, (long)list.size());
            Assert.assertEquals((Object)new Long(10L), list.get(0));
            resultStruct = (Map)resultSet.get(1);
            Assert.assertEquals((Object)4L, this.getResultKey(resultStruct));
            list = (ArrayList)this.getResultValue(resultStruct);
            Assert.assertEquals((long)2L, (long)list.size());
            Assert.assertEquals((Object)new Long(15L), list.get(0));
            Assert.assertEquals((Object)new Long(20L), list.get(1));
            resultStruct = (Map)resultSet.get(2);
            Assert.assertEquals((Object)5L, this.getResultKey(resultStruct));
            list = (ArrayList)this.getResultValue(resultStruct);
            Assert.assertEquals((long)3L, (long)list.size());
            Assert.assertEquals((Object)new Long(25L), list.get(0));
            Assert.assertEquals((Object)new Long(30L), list.get(1));
            Assert.assertEquals((Object)new Long(35L), list.get(2));
            Assert.assertFalse((boolean)mapVector.isNull(0));
            Assert.assertFalse((boolean)mapVector.isNull(1));
            ArrowBuf offsetBuffer = mapVector.getOffsetBuffer();
            Assert.assertEquals((long)0L, (long)offsetBuffer.getInt(0L));
            Assert.assertEquals((long)2L, (long)offsetBuffer.getInt(4L));
            Assert.assertEquals((long)5L, (long)offsetBuffer.getInt(8L));
        }
    }

    @Test
    public void testMapWithMapValue() throws Exception {
        try (MapVector mapVector = MapVector.empty((String)"sourceVector", (BufferAllocator)this.allocator, (boolean)false);){
            UnionMapWriter mapWriter = mapVector.getWriter();
            mapWriter.setPosition(0);
            mapWriter.writeNull();
            mapWriter.setPosition(1);
            mapWriter.startMap();
            mapWriter.startEntry();
            mapWriter.key().bigInt().writeBigInt(1L);
            BaseWriter.MapWriter valueWriter = mapWriter.value().map(false);
            valueWriter.startMap();
            this.writeEntry(valueWriter, 50L, 100L);
            this.writeEntry(valueWriter, 200L, 400L);
            valueWriter.endMap();
            mapWriter.endEntry();
            mapWriter.startEntry();
            mapWriter.key().bigInt().writeBigInt(2L);
            valueWriter = mapWriter.value().map(false);
            valueWriter.startMap();
            this.writeEntry(valueWriter, 75L, 175L);
            this.writeEntry(valueWriter, 150L, 250L);
            valueWriter.endMap();
            mapWriter.endEntry();
            mapWriter.endMap();
            mapWriter.setPosition(2);
            mapWriter.startMap();
            mapWriter.startEntry();
            mapWriter.key().bigInt().writeBigInt(3L);
            valueWriter = mapWriter.value().map(true);
            valueWriter.startMap();
            this.writeEntry(valueWriter, 10L, 20L);
            valueWriter.endMap();
            mapWriter.endEntry();
            mapWriter.startEntry();
            mapWriter.key().bigInt().writeBigInt(4L);
            valueWriter = mapWriter.value().map(false);
            valueWriter.startMap();
            this.writeEntry(valueWriter, 15L, 20L);
            valueWriter.endMap();
            mapWriter.endEntry();
            mapWriter.startEntry();
            mapWriter.key().bigInt().writeBigInt(5L);
            valueWriter = mapWriter.value().map(false);
            valueWriter.startMap();
            this.writeEntry(valueWriter, 25L, 30L);
            this.writeEntry(valueWriter, 35L, (Long)null);
            valueWriter.endMap();
            mapWriter.endEntry();
            mapWriter.endMap();
            Assert.assertEquals((long)2L, (long)mapVector.getLastSet());
            mapWriter.setValueCount(3);
            Assert.assertEquals((long)3L, (long)mapVector.getValueCount());
            List result = mapVector.getObject(0);
            Assert.assertNull((Object)result);
            result = mapVector.getObject(1);
            ArrayList resultSet = (ArrayList)result;
            Assert.assertEquals((long)2L, (long)resultSet.size());
            Map resultStruct = (Map)resultSet.get(0);
            Assert.assertEquals((Object)1L, this.getResultKey(resultStruct));
            ArrayList list = (ArrayList)this.getResultValue(resultStruct);
            Assert.assertEquals((long)2L, (long)list.size());
            Map innerMap = (Map)list.get(0);
            Assert.assertEquals((Object)50L, this.getResultKey(innerMap));
            Assert.assertEquals((Object)100L, this.getResultValue(innerMap));
            innerMap = (Map)list.get(1);
            Assert.assertEquals((Object)200L, this.getResultKey(innerMap));
            Assert.assertEquals((Object)400L, this.getResultValue(innerMap));
            resultStruct = (Map)resultSet.get(1);
            Assert.assertEquals((Object)2L, this.getResultKey(resultStruct));
            list = (ArrayList)this.getResultValue(resultStruct);
            Assert.assertEquals((long)2L, (long)list.size());
            innerMap = (Map)list.get(0);
            Assert.assertEquals((Object)75L, this.getResultKey(innerMap));
            Assert.assertEquals((Object)175L, this.getResultValue(innerMap));
            innerMap = (Map)list.get(1);
            Assert.assertEquals((Object)150L, this.getResultKey(innerMap));
            Assert.assertEquals((Object)250L, this.getResultValue(innerMap));
            result = mapVector.getObject(2);
            resultSet = (ArrayList)result;
            Assert.assertEquals((long)3L, (long)resultSet.size());
            resultStruct = (Map)resultSet.get(0);
            Assert.assertEquals((Object)3L, this.getResultKey(resultStruct));
            list = (ArrayList)this.getResultValue(resultStruct);
            Assert.assertEquals((long)1L, (long)list.size());
            innerMap = (Map)list.get(0);
            Assert.assertEquals((Object)10L, this.getResultKey(innerMap));
            Assert.assertEquals((Object)20L, this.getResultValue(innerMap));
            resultStruct = (Map)resultSet.get(1);
            Assert.assertEquals((Object)4L, this.getResultKey(resultStruct));
            list = (ArrayList)this.getResultValue(resultStruct);
            Assert.assertEquals((long)1L, (long)list.size());
            innerMap = (Map)list.get(0);
            Assert.assertEquals((Object)15L, this.getResultKey(innerMap));
            Assert.assertEquals((Object)20L, this.getResultValue(innerMap));
            resultStruct = (Map)resultSet.get(2);
            Assert.assertEquals((Object)5L, this.getResultKey(resultStruct));
            list = (ArrayList)this.getResultValue(resultStruct);
            Assert.assertEquals((long)2L, (long)list.size());
            innerMap = (Map)list.get(0);
            Assert.assertEquals((Object)25L, this.getResultKey(innerMap));
            Assert.assertEquals((Object)30L, this.getResultValue(innerMap));
            innerMap = (Map)list.get(1);
            Assert.assertEquals((Object)35L, this.getResultKey(innerMap));
            Assert.assertNull(innerMap.get("value"));
            Assert.assertTrue((boolean)mapVector.isNull(0));
            Assert.assertFalse((boolean)mapVector.isNull(1));
            Assert.assertFalse((boolean)mapVector.isNull(2));
            ArrowBuf offsetBuffer = mapVector.getOffsetBuffer();
            Assert.assertEquals((long)0L, (long)offsetBuffer.getInt(0L));
            Assert.assertEquals((long)0L, (long)offsetBuffer.getInt(4L));
            Assert.assertEquals((long)2L, (long)offsetBuffer.getInt(8L));
            Assert.assertEquals((long)5L, (long)offsetBuffer.getInt(12L));
        }
    }

    @Test
    public void testMapWithMapKeyAndMapValue() throws Exception {
        try (MapVector mapVector = MapVector.empty((String)"sourceVector", (BufferAllocator)this.allocator, (boolean)false);){
            UnionMapWriter mapWriter = mapVector.getWriter();
            mapWriter.setPosition(0);
            mapWriter.startMap();
            mapWriter.startEntry();
            BaseWriter.MapWriter keyWriter = mapWriter.key().map(false);
            keyWriter.startMap();
            this.writeEntry(keyWriter, 5, 10);
            this.writeEntry(keyWriter, 20, 40);
            keyWriter.endMap();
            BaseWriter.MapWriter valueWriter = mapWriter.value().map(false);
            valueWriter.startMap();
            this.writeEntry(valueWriter, 50L, 100L);
            this.writeEntry(valueWriter, 200L, 400L);
            valueWriter.endMap();
            mapWriter.endEntry();
            mapWriter.startEntry();
            keyWriter = mapWriter.key().map(false);
            keyWriter.startMap();
            this.writeEntry(keyWriter, 50, 100);
            keyWriter.endMap();
            valueWriter = mapWriter.value().map(false);
            valueWriter.startMap();
            this.writeEntry(valueWriter, 75L, 175L);
            this.writeEntry(valueWriter, 150L, 250L);
            valueWriter.endMap();
            mapWriter.endEntry();
            mapWriter.endMap();
            mapWriter.setPosition(1);
            mapWriter.startMap();
            mapWriter.startEntry();
            keyWriter = mapWriter.key().map(false);
            keyWriter.startMap();
            this.writeEntry(keyWriter, 1, 2);
            keyWriter.endMap();
            valueWriter = mapWriter.value().map(true);
            valueWriter.startMap();
            this.writeEntry(valueWriter, 10L, 20L);
            valueWriter.endMap();
            mapWriter.endEntry();
            mapWriter.startEntry();
            keyWriter = mapWriter.key().map(false);
            keyWriter.startMap();
            this.writeEntry(keyWriter, 30, 40);
            keyWriter.endMap();
            valueWriter = mapWriter.value().map(false);
            valueWriter.startMap();
            this.writeEntry(valueWriter, 15L, 20L);
            valueWriter.endMap();
            mapWriter.endEntry();
            mapWriter.startEntry();
            keyWriter = mapWriter.key().map(false);
            keyWriter.startMap();
            this.writeEntry(keyWriter, 50, 60);
            this.writeEntry(keyWriter, 70, (Integer)null);
            keyWriter.endMap();
            valueWriter = mapWriter.value().map(false);
            valueWriter.startMap();
            this.writeEntry(valueWriter, 25L, 30L);
            this.writeEntry(valueWriter, 35L, (Long)null);
            valueWriter.endMap();
            mapWriter.endEntry();
            mapWriter.startEntry();
            keyWriter = mapWriter.key().map(false);
            keyWriter.startMap();
            this.writeEntry(keyWriter, 5, (Integer)null);
            keyWriter.endMap();
            valueWriter = mapWriter.value().map(false);
            valueWriter.writeNull();
            mapWriter.endEntry();
            mapWriter.endMap();
            Assert.assertEquals((long)1L, (long)mapVector.getLastSet());
            mapWriter.setValueCount(2);
            Assert.assertEquals((long)2L, (long)mapVector.getValueCount());
            List result = mapVector.getObject(0);
            ArrayList resultSet = (ArrayList)result;
            Assert.assertEquals((long)2L, (long)resultSet.size());
            Map resultStruct = (Map)resultSet.get(0);
            ArrayList list = (ArrayList)this.getResultKey(resultStruct);
            Assert.assertEquals((long)2L, (long)list.size());
            Map innerMap = (Map)list.get(0);
            Assert.assertEquals((Object)5, this.getResultKey(innerMap));
            Assert.assertEquals((Object)10, this.getResultValue(innerMap));
            innerMap = (Map)list.get(1);
            Assert.assertEquals((Object)20, this.getResultKey(innerMap));
            Assert.assertEquals((Object)40, this.getResultValue(innerMap));
            list = (ArrayList)this.getResultValue(resultStruct);
            Assert.assertEquals((long)2L, (long)list.size());
            innerMap = (Map)list.get(0);
            Assert.assertEquals((Object)50L, this.getResultKey(innerMap));
            Assert.assertEquals((Object)100L, this.getResultValue(innerMap));
            innerMap = (Map)list.get(1);
            Assert.assertEquals((Object)200L, this.getResultKey(innerMap));
            Assert.assertEquals((Object)400L, this.getResultValue(innerMap));
            resultStruct = (Map)resultSet.get(1);
            list = (ArrayList)this.getResultKey(resultStruct);
            Assert.assertEquals((long)1L, (long)list.size());
            innerMap = (Map)list.get(0);
            Assert.assertEquals((Object)50, this.getResultKey(innerMap));
            Assert.assertEquals((Object)100, this.getResultValue(innerMap));
            list = (ArrayList)this.getResultValue(resultStruct);
            Assert.assertEquals((long)2L, (long)list.size());
            innerMap = (Map)list.get(0);
            Assert.assertEquals((Object)75L, this.getResultKey(innerMap));
            Assert.assertEquals((Object)175L, this.getResultValue(innerMap));
            innerMap = (Map)list.get(1);
            Assert.assertEquals((Object)150L, this.getResultKey(innerMap));
            Assert.assertEquals((Object)250L, this.getResultValue(innerMap));
            result = mapVector.getObject(1);
            resultSet = (ArrayList)result;
            Assert.assertEquals((long)4L, (long)resultSet.size());
            resultStruct = (Map)resultSet.get(0);
            list = (ArrayList)this.getResultKey(resultStruct);
            Assert.assertEquals((long)1L, (long)list.size());
            innerMap = (Map)list.get(0);
            Assert.assertEquals((Object)1, this.getResultKey(innerMap));
            Assert.assertEquals((Object)2, this.getResultValue(innerMap));
            list = (ArrayList)this.getResultValue(resultStruct);
            Assert.assertEquals((long)1L, (long)list.size());
            innerMap = (Map)list.get(0);
            Assert.assertEquals((Object)10L, this.getResultKey(innerMap));
            Assert.assertEquals((Object)20L, this.getResultValue(innerMap));
            resultStruct = (Map)resultSet.get(1);
            list = (ArrayList)this.getResultKey(resultStruct);
            Assert.assertEquals((long)1L, (long)list.size());
            innerMap = (Map)list.get(0);
            Assert.assertEquals((Object)30, this.getResultKey(innerMap));
            Assert.assertEquals((Object)40, this.getResultValue(innerMap));
            list = (ArrayList)this.getResultValue(resultStruct);
            Assert.assertEquals((long)1L, (long)list.size());
            innerMap = (Map)list.get(0);
            Assert.assertEquals((Object)15L, this.getResultKey(innerMap));
            Assert.assertEquals((Object)20L, this.getResultValue(innerMap));
            resultStruct = (Map)resultSet.get(2);
            list = (ArrayList)this.getResultKey(resultStruct);
            Assert.assertEquals((long)2L, (long)list.size());
            innerMap = (Map)list.get(0);
            Assert.assertEquals((Object)50, this.getResultKey(innerMap));
            Assert.assertEquals((Object)60, this.getResultValue(innerMap));
            innerMap = (Map)list.get(1);
            Assert.assertEquals((Object)70, this.getResultKey(innerMap));
            Assert.assertNull(innerMap.get("value"));
            list = (ArrayList)this.getResultValue(resultStruct);
            Assert.assertEquals((long)2L, (long)list.size());
            innerMap = (Map)list.get(0);
            Assert.assertEquals((Object)25L, this.getResultKey(innerMap));
            Assert.assertEquals((Object)30L, this.getResultValue(innerMap));
            innerMap = (Map)list.get(1);
            Assert.assertEquals((Object)35L, this.getResultKey(innerMap));
            Assert.assertNull(innerMap.get("value"));
            resultStruct = (Map)resultSet.get(3);
            list = (ArrayList)this.getResultKey(resultStruct);
            Assert.assertEquals((long)1L, (long)list.size());
            innerMap = (Map)list.get(0);
            Assert.assertEquals((Object)5, this.getResultKey(innerMap));
            Assert.assertNull(innerMap.get("value"));
            Assert.assertNull(resultStruct.get("value"));
            Assert.assertFalse((boolean)mapVector.isNull(0));
            Assert.assertFalse((boolean)mapVector.isNull(1));
            ArrowBuf offsetBuffer = mapVector.getOffsetBuffer();
            Assert.assertEquals((long)0L, (long)offsetBuffer.getInt(0L));
            Assert.assertEquals((long)2L, (long)offsetBuffer.getInt(4L));
            Assert.assertEquals((long)6L, (long)offsetBuffer.getInt(8L));
        }
    }

    private void writeEntry(BaseWriter.MapWriter writer, long key, Long value) {
        writer.startEntry();
        writer.key().bigInt().writeBigInt(key);
        if (value != null) {
            writer.value().bigInt().writeBigInt(value.longValue());
        }
        writer.endEntry();
    }

    private void writeEntry(BaseWriter.MapWriter writer, int key, Integer value) {
        writer.startEntry();
        writer.key().integer().writeInt(key);
        if (value != null) {
            writer.value().integer().writeInt(value.intValue());
        }
        writer.endEntry();
    }

    @Test
    public void testClearAndReuse() {
        try (MapVector vector = MapVector.empty((String)"map", (BufferAllocator)this.allocator, (boolean)false);){
            vector.allocateNew();
            UnionMapWriter mapWriter = vector.getWriter();
            mapWriter.startMap();
            mapWriter.startEntry();
            mapWriter.key().bigInt().writeBigInt(1L);
            mapWriter.value().integer().writeInt(11);
            mapWriter.endEntry();
            mapWriter.endMap();
            mapWriter.startMap();
            mapWriter.startEntry();
            mapWriter.key().bigInt().writeBigInt(2L);
            mapWriter.value().integer().writeInt(22);
            mapWriter.endEntry();
            mapWriter.endMap();
            mapWriter.setValueCount(2);
            List result = vector.getObject(0);
            ArrayList resultSet = (ArrayList)result;
            Map resultStruct = (Map)resultSet.get(0);
            Assert.assertEquals((Object)1L, this.getResultKey(resultStruct));
            Assert.assertEquals((Object)11, this.getResultValue(resultStruct));
            result = vector.getObject(1);
            resultSet = (ArrayList)result;
            resultStruct = (Map)resultSet.get(0);
            Assert.assertEquals((Object)2L, this.getResultKey(resultStruct));
            Assert.assertEquals((Object)22, this.getResultValue(resultStruct));
            vector.clear();
            mapWriter = new UnionMapWriter(vector);
            mapWriter.startMap();
            mapWriter.startEntry();
            mapWriter.key().bigInt().writeBigInt(3L);
            mapWriter.value().integer().writeInt(33);
            mapWriter.endEntry();
            mapWriter.startEntry();
            mapWriter.key().bigInt().writeBigInt(4L);
            mapWriter.value().integer().writeInt(44);
            mapWriter.endEntry();
            mapWriter.endMap();
            mapWriter.startMap();
            mapWriter.startEntry();
            mapWriter.key().bigInt().writeBigInt(5L);
            mapWriter.value().integer().writeInt(55);
            mapWriter.endEntry();
            mapWriter.endMap();
            mapWriter.setValueCount(2);
            result = vector.getObject(0);
            resultSet = (ArrayList)result;
            resultStruct = (Map)resultSet.get(0);
            Assert.assertEquals((Object)3L, this.getResultKey(resultStruct));
            Assert.assertEquals((Object)33, this.getResultValue(resultStruct));
            resultStruct = (Map)resultSet.get(1);
            Assert.assertEquals((Object)4L, this.getResultKey(resultStruct));
            Assert.assertEquals((Object)44, this.getResultValue(resultStruct));
            result = vector.getObject(1);
            resultSet = (ArrayList)result;
            resultStruct = (Map)resultSet.get(0);
            Assert.assertEquals((Object)5L, this.getResultKey(resultStruct));
            Assert.assertEquals((Object)55, this.getResultValue(resultStruct));
        }
    }
}

