/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.vector;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.OutOfMemoryException;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.BaseValueVector;
import org.apache.arrow.vector.BitVectorHelper;
import org.apache.arrow.vector.LargeVarBinaryVector;
import org.apache.arrow.vector.LargeVarCharVector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.VectorLoader;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.VectorUnloader;
import org.apache.arrow.vector.holders.NullableLargeVarCharHolder;
import org.apache.arrow.vector.ipc.message.ArrowRecordBatch;
import org.apache.arrow.vector.testing.ValueVectorDataPopulator;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.arrow.vector.util.OversizedAllocationException;
import org.apache.arrow.vector.util.TransferPair;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;

public class TestLargeVarCharVector {
    private static final byte[] STR1 = "AAAAA1".getBytes();
    private static final byte[] STR2 = "BBBBBBBBB2".getBytes();
    private static final byte[] STR3 = "CCCC3".getBytes();
    private static final byte[] STR4 = "DDDDDDDD4".getBytes();
    private static final byte[] STR5 = "EEE5".getBytes();
    private static final byte[] STR6 = "FFFFF6".getBytes();
    private BufferAllocator allocator;

    @Before
    public void prepare() {
        this.allocator = new RootAllocator(Integer.MAX_VALUE);
    }

    @After
    public void shutdown() {
        this.allocator.close();
    }

    @Test
    public void testTransfer() {
        try (BufferAllocator childAllocator1 = this.allocator.newChildAllocator("child1", 1000000L, 1000000L);
             BufferAllocator childAllocator2 = this.allocator.newChildAllocator("child2", 1000000L, 1000000L);
             LargeVarCharVector v1 = new LargeVarCharVector("v1", childAllocator1);
             LargeVarCharVector v2 = new LargeVarCharVector("v2", childAllocator2);){
            v1.allocateNew();
            v1.setSafe(4094, "hello world".getBytes(), 0, 11);
            v1.setValueCount(4001);
            long memoryBeforeTransfer = childAllocator1.getAllocatedMemory();
            v1.makeTransferPair((ValueVector)v2).transfer();
            Assert.assertEquals((long)0L, (long)childAllocator1.getAllocatedMemory());
            Assert.assertEquals((long)memoryBeforeTransfer, (long)childAllocator2.getAllocatedMemory());
        }
    }

    @Test
    public void testCopyValueSafe() {
        try (LargeVarCharVector largeVarCharVector = new LargeVarCharVector("myvector", this.allocator);
             LargeVarCharVector newLargeVarCharVector = new LargeVarCharVector("newvector", this.allocator);){
            int i;
            largeVarCharVector.allocateNew(10000L, 1000);
            int valueCount = 500;
            this.populateLargeVarcharVector(largeVarCharVector, 500, null);
            TransferPair tp = largeVarCharVector.makeTransferPair((ValueVector)newLargeVarCharVector);
            for (i = 0; i < 500; ++i) {
                tp.copyValueSafe(i, i);
            }
            newLargeVarCharVector.setValueCount(500);
            for (i = 0; i < 500; ++i) {
                boolean expectedSet;
                boolean bl = expectedSet = i % 3 == 0;
                if (expectedSet) {
                    Assert.assertFalse((boolean)largeVarCharVector.isNull(i));
                    Assert.assertFalse((boolean)newLargeVarCharVector.isNull(i));
                    Assert.assertArrayEquals((byte[])largeVarCharVector.get(i), (byte[])newLargeVarCharVector.get(i));
                    continue;
                }
                Assert.assertTrue((boolean)newLargeVarCharVector.isNull(i));
            }
        }
    }

    @Test
    public void testSplitAndTransferNon() {
        try (LargeVarCharVector largeVarCharVector = new LargeVarCharVector("myvector", this.allocator);){
            largeVarCharVector.allocateNew(10000L, 1000);
            int valueCount = 500;
            this.populateLargeVarcharVector(largeVarCharVector, 500, null);
            TransferPair tp = largeVarCharVector.getTransferPair(this.allocator);
            try (LargeVarCharVector newLargeVarCharVector = (LargeVarCharVector)tp.getTo();){
                tp.splitAndTransfer(0, 0);
                Assert.assertEquals((long)0L, (long)newLargeVarCharVector.getValueCount());
            }
        }
    }

    @Test
    public void testSplitAndTransferAll() {
        try (LargeVarCharVector largeVarCharVector = new LargeVarCharVector("myvector", this.allocator);){
            largeVarCharVector.allocateNew(10000L, 1000);
            int valueCount = 500;
            this.populateLargeVarcharVector(largeVarCharVector, 500, null);
            TransferPair tp = largeVarCharVector.getTransferPair(this.allocator);
            try (LargeVarCharVector newLargeVarCharVector = (LargeVarCharVector)tp.getTo();){
                tp.splitAndTransfer(0, 500);
                Assert.assertEquals((long)500L, (long)newLargeVarCharVector.getValueCount());
            }
        }
    }

    @Test
    public void testInvalidStartIndex() {
        try (LargeVarCharVector largeVarCharVector = new LargeVarCharVector("myvector", this.allocator);
             LargeVarCharVector newLargeVarCharVector = new LargeVarCharVector("newvector", this.allocator);){
            largeVarCharVector.allocateNew(10000L, 1000);
            int valueCount = 500;
            this.populateLargeVarcharVector(largeVarCharVector, 500, null);
            TransferPair tp = largeVarCharVector.makeTransferPair((ValueVector)newLargeVarCharVector);
            IllegalArgumentException e = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> tp.splitAndTransfer(500, 10));
            Assert.assertEquals((Object)"Invalid startIndex: 500", (Object)e.getMessage());
        }
    }

    @Test
    public void testInvalidLength() {
        try (LargeVarCharVector largeVarCharVector = new LargeVarCharVector("myvector", this.allocator);
             LargeVarCharVector newLargeVarCharVector = new LargeVarCharVector("newvector", this.allocator);){
            largeVarCharVector.allocateNew(10000L, 1000);
            int valueCount = 500;
            this.populateLargeVarcharVector(largeVarCharVector, 500, null);
            TransferPair tp = largeVarCharVector.makeTransferPair((ValueVector)newLargeVarCharVector);
            IllegalArgumentException e = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> tp.splitAndTransfer(0, 1000));
            Assert.assertEquals((Object)"Invalid length: 1000", (Object)e.getMessage());
        }
    }

    @Test
    public void testSizeOfValueBuffer() {
        try (LargeVarCharVector vector = new LargeVarCharVector("", this.allocator);){
            int valueCount = 100;
            int currentSize = 0;
            vector.setInitialCapacity(valueCount);
            vector.allocateNew();
            vector.setValueCount(valueCount);
            for (int i = 0; i < valueCount; ++i) {
                currentSize += i;
                vector.setSafe(i, new byte[i]);
            }
            Assert.assertEquals((long)currentSize, (long)vector.sizeOfValueBuffer());
        }
    }

    @Test
    public void testSetLastSetUsage() {
        byte[] STR1 = "AAAAA1".getBytes();
        byte[] STR2 = "BBBBBBBBB2".getBytes();
        byte[] STR3 = "CCCC3".getBytes();
        byte[] STR4 = "DDDDDDDD4".getBytes();
        byte[] STR5 = "EEE5".getBytes();
        byte[] STR6 = "FFFFF6".getBytes();
        try (LargeVarCharVector vector = new LargeVarCharVector("myvector", this.allocator);){
            vector.allocateNew(10240L, 1024);
            TestLargeVarCharVector.setBytes(0, STR1, vector);
            TestLargeVarCharVector.setBytes(1, STR2, vector);
            TestLargeVarCharVector.setBytes(2, STR3, vector);
            TestLargeVarCharVector.setBytes(3, STR4, vector);
            TestLargeVarCharVector.setBytes(4, STR5, vector);
            TestLargeVarCharVector.setBytes(5, STR6, vector);
            Assert.assertEquals((long)-1L, (long)vector.getLastSet());
            Assert.assertArrayEquals((byte[])STR1, (byte[])vector.get(0));
            Assert.assertArrayEquals((byte[])STR2, (byte[])vector.get(1));
            Assert.assertArrayEquals((byte[])STR3, (byte[])vector.get(2));
            Assert.assertArrayEquals((byte[])STR4, (byte[])vector.get(3));
            Assert.assertArrayEquals((byte[])STR5, (byte[])vector.get(4));
            Assert.assertArrayEquals((byte[])STR6, (byte[])vector.get(5));
            vector.setLastSet(5);
            vector.setValueCount(20);
            Assert.assertEquals((long)19L, (long)vector.getLastSet());
            Assert.assertArrayEquals((byte[])STR1, (byte[])vector.get(0));
            Assert.assertArrayEquals((byte[])STR2, (byte[])vector.get(1));
            Assert.assertArrayEquals((byte[])STR3, (byte[])vector.get(2));
            Assert.assertArrayEquals((byte[])STR4, (byte[])vector.get(3));
            Assert.assertArrayEquals((byte[])STR5, (byte[])vector.get(4));
            Assert.assertArrayEquals((byte[])STR6, (byte[])vector.get(5));
            Assert.assertEquals((long)0L, (long)vector.getValueLength(6));
            Assert.assertEquals((long)0L, (long)vector.getValueLength(7));
            Assert.assertEquals((long)0L, (long)vector.getValueLength(8));
            Assert.assertEquals((long)0L, (long)vector.getValueLength(9));
            Assert.assertEquals((long)0L, (long)vector.getValueLength(10));
            Assert.assertEquals((long)0L, (long)vector.getValueLength(11));
            Assert.assertEquals((long)0L, (long)vector.getValueLength(12));
            Assert.assertEquals((long)0L, (long)vector.getValueLength(13));
            Assert.assertEquals((long)0L, (long)vector.getValueLength(14));
            Assert.assertEquals((long)0L, (long)vector.getValueLength(15));
            Assert.assertEquals((long)0L, (long)vector.getValueLength(16));
            Assert.assertEquals((long)0L, (long)vector.getValueLength(17));
            Assert.assertEquals((long)0L, (long)vector.getValueLength(18));
            Assert.assertEquals((long)0L, (long)vector.getValueLength(19));
            Assert.assertEquals((long)0L, (long)vector.offsetBuffer.getLong(0L));
            Assert.assertEquals((long)6L, (long)vector.offsetBuffer.getLong(8L));
            Assert.assertEquals((long)16L, (long)vector.offsetBuffer.getLong(16L));
            Assert.assertEquals((long)21L, (long)vector.offsetBuffer.getLong(24L));
            Assert.assertEquals((long)30L, (long)vector.offsetBuffer.getLong(32L));
            Assert.assertEquals((long)34L, (long)vector.offsetBuffer.getLong(40L));
            Assert.assertEquals((long)40L, (long)vector.offsetBuffer.getLong(48L));
            Assert.assertEquals((long)40L, (long)vector.offsetBuffer.getLong(56L));
            Assert.assertEquals((long)40L, (long)vector.offsetBuffer.getLong(64L));
            Assert.assertEquals((long)40L, (long)vector.offsetBuffer.getLong(72L));
            Assert.assertEquals((long)40L, (long)vector.offsetBuffer.getLong(80L));
            Assert.assertEquals((long)40L, (long)vector.offsetBuffer.getLong(88L));
            Assert.assertEquals((long)40L, (long)vector.offsetBuffer.getLong(96L));
            Assert.assertEquals((long)40L, (long)vector.offsetBuffer.getLong(104L));
            Assert.assertEquals((long)40L, (long)vector.offsetBuffer.getLong(112L));
            Assert.assertEquals((long)40L, (long)vector.offsetBuffer.getLong(120L));
            Assert.assertEquals((long)40L, (long)vector.offsetBuffer.getLong(128L));
            Assert.assertEquals((long)40L, (long)vector.offsetBuffer.getLong(136L));
            Assert.assertEquals((long)40L, (long)vector.offsetBuffer.getLong(144L));
            Assert.assertEquals((long)40L, (long)vector.offsetBuffer.getLong(152L));
            vector.set(19, STR6);
            Assert.assertArrayEquals((byte[])STR6, (byte[])vector.get(19));
            Assert.assertEquals((long)40L, (long)vector.offsetBuffer.getLong(152L));
            Assert.assertEquals((long)46L, (long)vector.offsetBuffer.getLong(160L));
        }
    }

    @Test(expected=OutOfMemoryException.class)
    public void testVectorAllocateNew() {
        try (RootAllocator smallAllocator = new RootAllocator(200L);){
            LargeVarCharVector vector = new LargeVarCharVector("vec", (BufferAllocator)smallAllocator);
            Throwable throwable = null;
            try {
                vector.allocateNew();
            }
            catch (Throwable throwable2) {
                try {
                    throwable = throwable2;
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    TestLargeVarCharVector.$closeResource(throwable, (AutoCloseable)vector);
                    throw throwable3;
                }
            }
            TestLargeVarCharVector.$closeResource(throwable, (AutoCloseable)vector);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=OversizedAllocationException.class)
    public void testLargeVariableVectorReallocation() {
        LargeVarCharVector vector = new LargeVarCharVector("vector", this.allocator);
        long expectedAllocationInBytes = BaseValueVector.MAX_ALLOCATION_SIZE;
        int expectedOffsetSize = 10;
        try {
            vector.allocateNew(expectedAllocationInBytes, 10);
            Assert.assertTrue((10 <= vector.getValueCapacity() ? 1 : 0) != 0);
            Assert.assertTrue((expectedAllocationInBytes <= vector.getDataBuffer().capacity() ? 1 : 0) != 0);
            vector.reAlloc();
            Assert.assertTrue((20 <= vector.getValueCapacity() ? 1 : 0) != 0);
            Assert.assertTrue((expectedAllocationInBytes * 2L <= vector.getDataBuffer().capacity() ? 1 : 0) != 0);
        }
        finally {
            vector.close();
        }
        try {
            vector.allocateNew(BaseValueVector.MAX_ALLOCATION_SIZE / 2L, 0);
            vector.reAlloc();
            vector.reAlloc();
        }
        finally {
            vector.close();
        }
    }

    @Test
    public void testSplitAndTransfer() {
        try (LargeVarCharVector largeVarCharVector = new LargeVarCharVector("myvector", this.allocator);){
            largeVarCharVector.allocateNew(10000L, 1000);
            int valueCount = 500;
            String[] compareArray = new String[500];
            this.populateLargeVarcharVector(largeVarCharVector, 500, compareArray);
            TransferPair tp = largeVarCharVector.getTransferPair(this.allocator);
            try (LargeVarCharVector newLargeVarCharVector = (LargeVarCharVector)tp.getTo();){
                int[][] startLengths;
                for (int[] startLength : startLengths = new int[][]{{0, 201}, {201, 0}, {201, 200}, {401, 99}}) {
                    int start = startLength[0];
                    int length = startLength[1];
                    tp.splitAndTransfer(start, length);
                    for (int i = 0; i < length; ++i) {
                        boolean expectedSet;
                        boolean bl = expectedSet = (start + i) % 3 == 0;
                        if (expectedSet) {
                            byte[] expectedValue = compareArray[start + i].getBytes();
                            Assert.assertFalse((boolean)newLargeVarCharVector.isNull(i));
                            Assert.assertArrayEquals((byte[])expectedValue, (byte[])newLargeVarCharVector.get(i));
                            continue;
                        }
                        Assert.assertTrue((boolean)newLargeVarCharVector.isNull(i));
                    }
                }
            }
        }
    }

    @Test
    public void testReallocAfterVectorTransfer() {
        byte[] STR1 = "AAAAA1".getBytes();
        byte[] STR2 = "BBBBBBBBB2".getBytes();
        try (LargeVarCharVector vector = new LargeVarCharVector("vector", this.allocator);){
            int i;
            vector.allocateNew(40960L, 4096);
            int valueCapacity = vector.getValueCapacity();
            Assert.assertTrue((valueCapacity >= 4096 ? 1 : 0) != 0);
            for (i = 0; i < valueCapacity; ++i) {
                if ((i & 1) == 1) {
                    vector.set(i, STR1);
                    continue;
                }
                vector.set(i, STR2);
            }
            for (i = 0; i < valueCapacity; ++i) {
                if ((i & 1) == 1) {
                    Assert.assertArrayEquals((byte[])STR1, (byte[])vector.get(i));
                    continue;
                }
                Assert.assertArrayEquals((byte[])STR2, (byte[])vector.get(i));
            }
            vector.setSafe(valueCapacity, STR2, 0, STR2.length);
            Assert.assertTrue((vector.getValueCapacity() >= 2 * valueCapacity ? 1 : 0) != 0);
            while (vector.getByteCapacity() < 10 * vector.getValueCapacity()) {
                vector.reallocDataBuffer();
            }
            for (i = valueCapacity; i < vector.getValueCapacity(); ++i) {
                if ((i & 1) == 1) {
                    vector.set(i, STR1);
                    continue;
                }
                vector.set(i, STR2);
            }
            valueCapacity = vector.getValueCapacity();
            for (i = 0; i < valueCapacity; ++i) {
                if ((i & 1) == 1) {
                    Assert.assertArrayEquals((byte[])STR1, (byte[])vector.get(i));
                    continue;
                }
                Assert.assertArrayEquals((byte[])STR2, (byte[])vector.get(i));
            }
            vector.setSafe(valueCapacity + 10, STR2, 0, STR2.length);
            Assert.assertTrue((vector.getValueCapacity() >= 2 * valueCapacity ? 1 : 0) != 0);
            while (vector.getByteCapacity() < 10 * vector.getValueCapacity()) {
                vector.reallocDataBuffer();
            }
            for (i = valueCapacity; i < vector.getValueCapacity(); ++i) {
                if ((i & 1) == 1) {
                    vector.set(i, STR1);
                    continue;
                }
                vector.set(i, STR2);
            }
            valueCapacity = vector.getValueCapacity();
            for (i = 0; i < valueCapacity; ++i) {
                if ((i & 1) == 1) {
                    Assert.assertArrayEquals((byte[])STR1, (byte[])vector.get(i));
                    continue;
                }
                Assert.assertArrayEquals((byte[])STR2, (byte[])vector.get(i));
            }
            TransferPair transferPair = vector.getTransferPair(this.allocator);
            transferPair.transfer();
            try (LargeVarCharVector toVector = (LargeVarCharVector)transferPair.getTo();){
                valueCapacity = toVector.getValueCapacity();
                for (int i2 = 0; i2 < valueCapacity; ++i2) {
                    if ((i2 & 1) == 1) {
                        Assert.assertArrayEquals((byte[])STR1, (byte[])toVector.get(i2));
                        continue;
                    }
                    Assert.assertArrayEquals((byte[])STR2, (byte[])toVector.get(i2));
                }
            }
        }
    }

    @Test
    public void testVectorLoadUnload() {
        try (LargeVarCharVector vector1 = new LargeVarCharVector("myvector", this.allocator);){
            ValueVectorDataPopulator.setVector(vector1, (byte[][])new byte[][]{STR1, STR2, STR3, STR4, STR5, STR6});
            Assert.assertEquals((long)5L, (long)vector1.getLastSet());
            vector1.setValueCount(15);
            Assert.assertEquals((long)14L, (long)vector1.getLastSet());
            Assert.assertArrayEquals((byte[])STR1, (byte[])vector1.get(0));
            Assert.assertArrayEquals((byte[])STR2, (byte[])vector1.get(1));
            Assert.assertArrayEquals((byte[])STR3, (byte[])vector1.get(2));
            Assert.assertArrayEquals((byte[])STR4, (byte[])vector1.get(3));
            Assert.assertArrayEquals((byte[])STR5, (byte[])vector1.get(4));
            Assert.assertArrayEquals((byte[])STR6, (byte[])vector1.get(5));
            Field field = vector1.getField();
            String fieldName = field.getName();
            ArrayList<Field> fields = new ArrayList<Field>();
            ArrayList<LargeVarCharVector> fieldVectors = new ArrayList<LargeVarCharVector>();
            fields.add(field);
            fieldVectors.add(vector1);
            Schema schema = new Schema(fields);
            VectorSchemaRoot schemaRoot1 = new VectorSchemaRoot(schema, fieldVectors, vector1.getValueCount());
            VectorUnloader vectorUnloader = new VectorUnloader(schemaRoot1);
            try (ArrowRecordBatch recordBatch = vectorUnloader.getRecordBatch();
                 VectorSchemaRoot schemaRoot2 = VectorSchemaRoot.create((Schema)schema, (BufferAllocator)this.allocator);){
                VectorLoader vectorLoader = new VectorLoader(schemaRoot2);
                vectorLoader.load(recordBatch);
                LargeVarCharVector vector2 = (LargeVarCharVector)schemaRoot2.getVector(fieldName);
                Assert.assertEquals((long)14L, (long)vector2.getLastSet());
                vector2.setValueCount(25);
                Assert.assertEquals((long)24L, (long)vector2.getLastSet());
                Assert.assertArrayEquals((byte[])STR1, (byte[])vector2.get(0));
                Assert.assertArrayEquals((byte[])STR2, (byte[])vector2.get(1));
                Assert.assertArrayEquals((byte[])STR3, (byte[])vector2.get(2));
                Assert.assertArrayEquals((byte[])STR4, (byte[])vector2.get(3));
                Assert.assertArrayEquals((byte[])STR5, (byte[])vector2.get(4));
                Assert.assertArrayEquals((byte[])STR6, (byte[])vector2.get(5));
            }
        }
    }

    @Test
    public void testFillEmptiesUsage() {
        try (LargeVarCharVector vector = new LargeVarCharVector("myvector", this.allocator);){
            vector.allocateNew(10240L, 1024);
            TestLargeVarCharVector.setBytes(0, STR1, vector);
            TestLargeVarCharVector.setBytes(1, STR2, vector);
            TestLargeVarCharVector.setBytes(2, STR3, vector);
            TestLargeVarCharVector.setBytes(3, STR4, vector);
            TestLargeVarCharVector.setBytes(4, STR5, vector);
            TestLargeVarCharVector.setBytes(5, STR6, vector);
            Assert.assertEquals((long)-1L, (long)vector.getLastSet());
            Assert.assertArrayEquals((byte[])STR1, (byte[])vector.get(0));
            Assert.assertArrayEquals((byte[])STR2, (byte[])vector.get(1));
            Assert.assertArrayEquals((byte[])STR3, (byte[])vector.get(2));
            Assert.assertArrayEquals((byte[])STR4, (byte[])vector.get(3));
            Assert.assertArrayEquals((byte[])STR5, (byte[])vector.get(4));
            Assert.assertArrayEquals((byte[])STR6, (byte[])vector.get(5));
            vector.setLastSet(5);
            vector.fillEmpties(10);
            Assert.assertEquals((long)9L, (long)vector.getLastSet());
            Assert.assertArrayEquals((byte[])STR1, (byte[])vector.get(0));
            Assert.assertArrayEquals((byte[])STR2, (byte[])vector.get(1));
            Assert.assertArrayEquals((byte[])STR3, (byte[])vector.get(2));
            Assert.assertArrayEquals((byte[])STR4, (byte[])vector.get(3));
            Assert.assertArrayEquals((byte[])STR5, (byte[])vector.get(4));
            Assert.assertArrayEquals((byte[])STR6, (byte[])vector.get(5));
            Assert.assertEquals((long)0L, (long)vector.getValueLength(6));
            Assert.assertEquals((long)0L, (long)vector.getValueLength(7));
            Assert.assertEquals((long)0L, (long)vector.getValueLength(8));
            Assert.assertEquals((long)0L, (long)vector.getValueLength(9));
            TestLargeVarCharVector.setBytes(10, STR1, vector);
            TestLargeVarCharVector.setBytes(11, STR2, vector);
            vector.setLastSet(11);
            vector.setValueCount(15);
            Assert.assertEquals((long)14L, (long)vector.getLastSet());
            Assert.assertArrayEquals((byte[])STR1, (byte[])vector.get(0));
            Assert.assertArrayEquals((byte[])STR2, (byte[])vector.get(1));
            Assert.assertArrayEquals((byte[])STR3, (byte[])vector.get(2));
            Assert.assertArrayEquals((byte[])STR4, (byte[])vector.get(3));
            Assert.assertArrayEquals((byte[])STR5, (byte[])vector.get(4));
            Assert.assertArrayEquals((byte[])STR6, (byte[])vector.get(5));
            Assert.assertEquals((long)0L, (long)vector.getValueLength(6));
            Assert.assertEquals((long)0L, (long)vector.getValueLength(7));
            Assert.assertEquals((long)0L, (long)vector.getValueLength(8));
            Assert.assertEquals((long)0L, (long)vector.getValueLength(9));
            Assert.assertArrayEquals((byte[])STR1, (byte[])vector.get(10));
            Assert.assertArrayEquals((byte[])STR2, (byte[])vector.get(11));
            Assert.assertEquals((long)0L, (long)vector.getValueLength(12));
            Assert.assertEquals((long)0L, (long)vector.getValueLength(13));
            Assert.assertEquals((long)0L, (long)vector.getValueLength(14));
            Assert.assertEquals((long)0L, (long)vector.offsetBuffer.getLong(0L));
            Assert.assertEquals((long)6L, (long)vector.offsetBuffer.getLong(8L));
            Assert.assertEquals((long)16L, (long)vector.offsetBuffer.getLong(16L));
            Assert.assertEquals((long)21L, (long)vector.offsetBuffer.getLong(24L));
            Assert.assertEquals((long)30L, (long)vector.offsetBuffer.getLong(32L));
            Assert.assertEquals((long)34L, (long)vector.offsetBuffer.getLong(40L));
            Assert.assertEquals((long)40L, (long)vector.offsetBuffer.getLong(48L));
            Assert.assertEquals((long)40L, (long)vector.offsetBuffer.getLong(56L));
            Assert.assertEquals((long)40L, (long)vector.offsetBuffer.getLong(64L));
            Assert.assertEquals((long)40L, (long)vector.offsetBuffer.getLong(72L));
            Assert.assertEquals((long)40L, (long)vector.offsetBuffer.getLong(80L));
            Assert.assertEquals((long)46L, (long)vector.offsetBuffer.getLong(88L));
            Assert.assertEquals((long)56L, (long)vector.offsetBuffer.getLong(96L));
            Assert.assertEquals((long)56L, (long)vector.offsetBuffer.getLong(104L));
            Assert.assertEquals((long)56L, (long)vector.offsetBuffer.getLong(112L));
            Assert.assertEquals((long)56L, (long)vector.offsetBuffer.getLong(120L));
        }
    }

    @Test
    public void testGetBufferAddress1() {
        try (LargeVarCharVector vector = new LargeVarCharVector("myvector", this.allocator);){
            ValueVectorDataPopulator.setVector(vector, (byte[][])new byte[][]{STR1, STR2, STR3, STR4, STR5, STR6});
            vector.setValueCount(15);
            Assert.assertArrayEquals((byte[])STR1, (byte[])vector.get(0));
            Assert.assertArrayEquals((byte[])STR2, (byte[])vector.get(1));
            Assert.assertArrayEquals((byte[])STR3, (byte[])vector.get(2));
            Assert.assertArrayEquals((byte[])STR4, (byte[])vector.get(3));
            Assert.assertArrayEquals((byte[])STR5, (byte[])vector.get(4));
            Assert.assertArrayEquals((byte[])STR6, (byte[])vector.get(5));
            List buffers = vector.getFieldBuffers();
            long bitAddress = vector.getValidityBufferAddress();
            long offsetAddress = vector.getOffsetBufferAddress();
            long dataAddress = vector.getDataBufferAddress();
            Assert.assertEquals((long)3L, (long)buffers.size());
            Assert.assertEquals((long)bitAddress, (long)((ArrowBuf)buffers.get(0)).memoryAddress());
            Assert.assertEquals((long)offsetAddress, (long)((ArrowBuf)buffers.get(1)).memoryAddress());
            Assert.assertEquals((long)dataAddress, (long)((ArrowBuf)buffers.get(2)).memoryAddress());
        }
    }

    @Test
    public void testSetNullableLargeVarCharHolder() {
        try (LargeVarCharVector vector = new LargeVarCharVector("", this.allocator);){
            vector.allocateNew(100L, 10);
            NullableLargeVarCharHolder nullHolder = new NullableLargeVarCharHolder();
            nullHolder.isSet = 0;
            NullableLargeVarCharHolder stringHolder = new NullableLargeVarCharHolder();
            stringHolder.isSet = 1;
            String str = "hello";
            ArrowBuf buf = this.allocator.buffer(16L);
            buf.setBytes(0L, str.getBytes());
            stringHolder.start = 0L;
            stringHolder.end = str.length();
            stringHolder.buffer = buf;
            vector.set(0, nullHolder);
            vector.set(1, stringHolder);
            Assert.assertTrue((boolean)vector.isNull(0));
            Assert.assertEquals((Object)str, (Object)new String(vector.get(1)));
            buf.close();
        }
    }

    @Test
    public void testSetNullableLargeVarCharHolderSafe() {
        try (LargeVarCharVector vector = new LargeVarCharVector("", this.allocator);){
            vector.allocateNew(5L, 1);
            NullableLargeVarCharHolder nullHolder = new NullableLargeVarCharHolder();
            nullHolder.isSet = 0;
            NullableLargeVarCharHolder stringHolder = new NullableLargeVarCharHolder();
            stringHolder.isSet = 1;
            String str = "hello world";
            ArrowBuf buf = this.allocator.buffer(16L);
            buf.setBytes(0L, str.getBytes());
            stringHolder.start = 0L;
            stringHolder.end = str.length();
            stringHolder.buffer = buf;
            vector.setSafe(0, stringHolder);
            vector.setSafe(1, nullHolder);
            Assert.assertEquals((Object)str, (Object)new String(vector.get(0)));
            Assert.assertTrue((boolean)vector.isNull(1));
            buf.close();
        }
    }

    @Test
    public void testGetNullFromLargeVariableWidthVector() {
        try (LargeVarCharVector largeVarCharVector = new LargeVarCharVector("largevarcharvec", this.allocator);
             LargeVarBinaryVector largeVarBinaryVector = new LargeVarBinaryVector("largevarbinary", this.allocator);){
            largeVarCharVector.allocateNew(10L, 1);
            largeVarBinaryVector.allocateNew(10L, 1);
            largeVarCharVector.setNull(0);
            largeVarBinaryVector.setNull(0);
            Assert.assertNull((Object)largeVarCharVector.get(0));
            Assert.assertNull((Object)largeVarBinaryVector.get(0));
        }
    }

    @Test
    public void testLargeVariableWidthVectorNullHashCode() {
        try (LargeVarCharVector largeVarChVec = new LargeVarCharVector("large var char vector", this.allocator);){
            largeVarChVec.allocateNew(100L, 1);
            largeVarChVec.setValueCount(1);
            largeVarChVec.set(0, "abc".getBytes());
            largeVarChVec.setNull(0);
            Assert.assertEquals((long)0L, (long)largeVarChVec.hashCode(0));
        }
    }

    @Test
    public void testUnloadLargeVariableWidthVector() {
        try (LargeVarCharVector largeVarCharVector = new LargeVarCharVector("var char", this.allocator);){
            largeVarCharVector.allocateNew(5L, 2);
            largeVarCharVector.setValueCount(2);
            largeVarCharVector.set(0, "abcd".getBytes());
            List bufs = largeVarCharVector.getFieldBuffers();
            Assert.assertEquals((long)3L, (long)bufs.size());
            ArrowBuf offsetBuf = (ArrowBuf)bufs.get(1);
            ArrowBuf dataBuf = (ArrowBuf)bufs.get(2);
            Assert.assertEquals((long)24L, (long)offsetBuf.writerIndex());
            Assert.assertEquals((long)4L, (long)offsetBuf.getLong(8L));
            Assert.assertEquals((long)4L, (long)offsetBuf.getLong(16L));
            Assert.assertEquals((long)4L, (long)dataBuf.writerIndex());
        }
    }

    @Test
    public void testNullableType() {
        try (LargeVarCharVector vector = new LargeVarCharVector("", this.allocator);){
            vector.setInitialCapacity(512);
            vector.allocateNew();
            Assert.assertTrue((vector.getValueCapacity() >= 512 ? 1 : 0) != 0);
            int initialCapacity = vector.getValueCapacity();
            try {
                vector.set(initialCapacity, "foo".getBytes(StandardCharsets.UTF_8));
                Assert.fail((String)"Expected out of bounds exception");
            }
            catch (Exception exception) {
                // empty catch block
            }
            vector.reAlloc();
            Assert.assertTrue((vector.getValueCapacity() >= 2 * initialCapacity ? 1 : 0) != 0);
            vector.set(initialCapacity, "foo".getBytes(StandardCharsets.UTF_8));
            Assert.assertEquals((Object)"foo", (Object)new String(vector.get(initialCapacity), StandardCharsets.UTF_8));
        }
    }

    private void populateLargeVarcharVector(LargeVarCharVector vector, int valueCount, String[] values) {
        for (int i = 0; i < valueCount; i += 3) {
            String s = String.format("%010d", i);
            vector.set(i, s.getBytes());
            if (values == null) continue;
            values[i] = s;
        }
        vector.setValueCount(valueCount);
    }

    public static void setBytes(int index, byte[] bytes, LargeVarCharVector vector) {
        long currentOffset = vector.offsetBuffer.getLong((long)index * 8L);
        BitVectorHelper.setBit((ArrowBuf)vector.validityBuffer, (long)index);
        vector.offsetBuffer.setLong((long)(index + 1) * 8L, currentOffset + (long)bytes.length);
        vector.valueBuffer.setBytes(currentOffset, bytes, 0, (long)bytes.length);
    }
}

