/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.vector;

import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.LargeVarBinaryVector;
import org.apache.arrow.vector.holders.NullableLargeVarBinaryHolder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestLargeVarBinaryVector {
    private BufferAllocator allocator;

    @Before
    public void prepare() {
        this.allocator = new RootAllocator(Integer.MAX_VALUE);
    }

    @After
    public void shutdown() {
        this.allocator.close();
    }

    @Test
    public void testSetNullableLargeVarBinaryHolder() {
        try (LargeVarBinaryVector vector = new LargeVarBinaryVector("", this.allocator);){
            vector.allocateNew(100L, 10);
            NullableLargeVarBinaryHolder nullHolder = new NullableLargeVarBinaryHolder();
            nullHolder.isSet = 0;
            NullableLargeVarBinaryHolder binHolder = new NullableLargeVarBinaryHolder();
            binHolder.isSet = 1;
            String str = "hello";
            ArrowBuf buf = this.allocator.buffer(16L);
            buf.setBytes(0L, str.getBytes());
            binHolder.start = 0L;
            binHolder.end = str.length();
            binHolder.buffer = buf;
            vector.set(0, nullHolder);
            vector.set(1, binHolder);
            Assert.assertTrue((boolean)vector.isNull(0));
            Assert.assertEquals((Object)str, (Object)new String(vector.get(1)));
            buf.close();
        }
    }

    @Test
    public void testSetNullableLargeVarBinaryHolderSafe() {
        try (LargeVarBinaryVector vector = new LargeVarBinaryVector("", this.allocator);){
            vector.allocateNew(5L, 1);
            NullableLargeVarBinaryHolder nullHolder = new NullableLargeVarBinaryHolder();
            nullHolder.isSet = 0;
            NullableLargeVarBinaryHolder binHolder = new NullableLargeVarBinaryHolder();
            binHolder.isSet = 1;
            String str = "hello world";
            ArrowBuf buf = this.allocator.buffer(16L);
            buf.setBytes(0L, str.getBytes());
            binHolder.start = 0L;
            binHolder.end = str.length();
            binHolder.buffer = buf;
            vector.setSafe(0, binHolder);
            vector.setSafe(1, nullHolder);
            Assert.assertEquals((Object)str, (Object)new String(vector.get(0)));
            Assert.assertTrue((boolean)vector.isNull(1));
            buf.close();
        }
    }
}

