/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.vector;

import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.DirtyRootAllocator;
import org.apache.arrow.vector.FixedSizeBinaryVector;
import org.apache.arrow.vector.holders.FixedSizeBinaryHolder;
import org.apache.arrow.vector.holders.NullableFixedSizeBinaryHolder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;

public class TestFixedSizeBinaryVector {
    private static final int numValues = 123;
    private static final int typeWidth = 9;
    private static final int smallDataSize = 6;
    private static final int largeDataSize = 12;
    private static byte[][] values;
    private ArrowBuf[] bufs = new ArrowBuf[123];
    private FixedSizeBinaryHolder[] holders = new FixedSizeBinaryHolder[123];
    private NullableFixedSizeBinaryHolder[] nullableHolders = new NullableFixedSizeBinaryHolder[123];
    private static byte[] smallValue;
    private ArrowBuf smallBuf;
    private FixedSizeBinaryHolder smallHolder;
    private NullableFixedSizeBinaryHolder smallNullableHolder;
    private static byte[] largeValue;
    private ArrowBuf largeBuf;
    private FixedSizeBinaryHolder largeHolder;
    private NullableFixedSizeBinaryHolder largeNullableHolder;
    private BufferAllocator allocator;
    private FixedSizeBinaryVector vector;

    private static void failWithException(String message) throws Exception {
        throw new Exception(message);
    }

    @Before
    public void init() throws Exception {
        this.allocator = new DirtyRootAllocator(Integer.MAX_VALUE, 100);
        this.vector = new FixedSizeBinaryVector("fixedSizeBinary", this.allocator, 9);
        this.vector.allocateNew();
        for (int i = 0; i < 123; ++i) {
            this.bufs[i] = this.allocator.buffer(9L);
            this.bufs[i].setBytes(0L, values[i]);
            this.holders[i] = new FixedSizeBinaryHolder();
            this.holders[i].byteWidth = 9;
            this.holders[i].buffer = this.bufs[i];
            this.nullableHolders[i] = new NullableFixedSizeBinaryHolder();
            this.nullableHolders[i].byteWidth = 9;
            this.nullableHolders[i].buffer = this.bufs[i];
            this.nullableHolders[i].isSet = 1;
        }
        this.smallBuf = this.allocator.buffer(6L);
        this.smallBuf.setBytes(0L, smallValue);
        this.smallHolder = new FixedSizeBinaryHolder();
        this.smallHolder.byteWidth = 6;
        this.smallHolder.buffer = this.smallBuf;
        this.smallNullableHolder = new NullableFixedSizeBinaryHolder();
        this.smallNullableHolder.byteWidth = 6;
        this.smallNullableHolder.buffer = this.smallBuf;
        this.largeBuf = this.allocator.buffer(12L);
        this.largeBuf.setBytes(0L, largeValue);
        this.largeHolder = new FixedSizeBinaryHolder();
        this.largeHolder.byteWidth = 9;
        this.largeHolder.buffer = this.largeBuf;
        this.largeNullableHolder = new NullableFixedSizeBinaryHolder();
        this.largeNullableHolder.byteWidth = 9;
        this.largeNullableHolder.buffer = this.largeBuf;
    }

    @After
    public void terminate() throws Exception {
        for (int i = 0; i < 123; ++i) {
            this.bufs[i].close();
        }
        this.smallBuf.close();
        this.largeBuf.close();
        this.vector.close();
        this.allocator.close();
    }

    @Test
    public void testSetUsingByteArray() {
        int i;
        for (i = 0; i < 123; ++i) {
            this.vector.set(i, values[i]);
        }
        this.vector.setValueCount(123);
        for (i = 0; i < 123; ++i) {
            Assert.assertArrayEquals((byte[])values[i], (byte[])this.vector.getObject(i));
        }
    }

    @Test
    public void testSetUsingNull() {
        byte[] value = null;
        int i = 0;
        while (i < 123) {
            int index = i++;
            Exception e = (Exception)Assertions.assertThrows(NullPointerException.class, () -> this.vector.set(index, value));
            Assert.assertEquals((Object)"expecting a valid byte array", (Object)e.getMessage());
        }
    }

    @Test
    public void testSetUsingHolder() {
        int i;
        for (i = 0; i < 123; ++i) {
            this.vector.set(i, this.holders[i]);
        }
        this.vector.setValueCount(123);
        for (i = 0; i < 123; ++i) {
            Assert.assertArrayEquals((byte[])values[i], (byte[])this.vector.getObject(i));
        }
    }

    @Test
    public void testSetUsingNullableHolder() {
        int i;
        for (i = 0; i < 123; ++i) {
            this.vector.set(i, this.nullableHolders[i]);
        }
        this.vector.setValueCount(123);
        for (i = 0; i < 123; ++i) {
            Assert.assertArrayEquals((byte[])values[i], (byte[])this.vector.getObject(i));
        }
    }

    @Test
    public void testGetUsingNullableHolder() {
        int i;
        for (i = 0; i < 123; ++i) {
            this.vector.set(i, this.holders[i]);
        }
        this.vector.setValueCount(123);
        for (i = 0; i < 123; ++i) {
            this.vector.get(i, this.nullableHolders[i]);
            Assert.assertEquals((long)9L, (long)this.nullableHolders[i].byteWidth);
            Assert.assertTrue((this.nullableHolders[i].isSet > 0 ? 1 : 0) != 0);
            byte[] actual = new byte[9];
            this.nullableHolders[i].buffer.getBytes(0L, actual, 0, 9);
            Assert.assertArrayEquals((byte[])values[i], (byte[])actual);
        }
    }

    @Test
    public void testSetWithInvalidInput() throws Exception {
        String errorMsg = "input data needs to be at least 9 bytes";
        try {
            this.vector.set(0, smallValue);
            TestFixedSizeBinaryVector.failWithException(errorMsg);
        }
        catch (AssertionError assertionError) {
            // empty catch block
        }
        try {
            this.vector.set(0, this.smallHolder);
            TestFixedSizeBinaryVector.failWithException(errorMsg);
        }
        catch (AssertionError assertionError) {
            // empty catch block
        }
        try {
            this.vector.set(0, this.smallNullableHolder);
            TestFixedSizeBinaryVector.failWithException(errorMsg);
        }
        catch (AssertionError assertionError) {
            // empty catch block
        }
        try {
            this.vector.set(0, this.smallBuf);
            TestFixedSizeBinaryVector.failWithException(errorMsg);
        }
        catch (AssertionError assertionError) {
            // empty catch block
        }
        this.vector.set(0, largeValue);
        this.vector.set(0, this.largeHolder);
        this.vector.set(0, this.largeNullableHolder);
        this.vector.set(0, this.largeBuf);
    }

    @Test
    public void setSetSafeWithInvalidInput() throws Exception {
        String errorMsg = "input data needs to be at least 9 bytes";
        try {
            this.vector.setSafe(0, smallValue);
            TestFixedSizeBinaryVector.failWithException(errorMsg);
        }
        catch (AssertionError assertionError) {
            // empty catch block
        }
        try {
            this.vector.setSafe(0, this.smallHolder);
            TestFixedSizeBinaryVector.failWithException(errorMsg);
        }
        catch (AssertionError assertionError) {
            // empty catch block
        }
        try {
            this.vector.setSafe(0, this.smallNullableHolder);
            TestFixedSizeBinaryVector.failWithException(errorMsg);
        }
        catch (AssertionError assertionError) {
            // empty catch block
        }
        try {
            this.vector.setSafe(0, this.smallBuf);
            TestFixedSizeBinaryVector.failWithException(errorMsg);
        }
        catch (AssertionError assertionError) {
            // empty catch block
        }
        this.vector.setSafe(0, largeValue);
        this.vector.setSafe(0, this.largeHolder);
        this.vector.setSafe(0, this.largeNullableHolder);
        this.vector.setSafe(0, this.largeBuf);
    }

    @Test
    public void testGetNull() {
        this.vector.setNull(0);
        Assert.assertNull((Object)this.vector.get(0));
    }

    static {
        int i;
        values = new byte[123][9];
        for (i = 0; i < 123; ++i) {
            for (int j = 0; j < 9; ++j) {
                TestFixedSizeBinaryVector.values[i][j] = (byte)i;
            }
        }
        smallValue = new byte[6];
        for (i = 0; i < 6; ++i) {
            TestFixedSizeBinaryVector.smallValue[i] = (byte)i;
        }
        largeValue = new byte[12];
        for (i = 0; i < 12; ++i) {
            TestFixedSizeBinaryVector.largeValue[i] = (byte)i;
        }
    }
}

