/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.vector;

import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.time.Duration;
import java.time.Period;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.BitVector;
import org.apache.arrow.vector.DecimalVector;
import org.apache.arrow.vector.Float4Vector;
import org.apache.arrow.vector.Float8Vector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.IntervalDayVector;
import org.apache.arrow.vector.IntervalYearVector;
import org.apache.arrow.vector.SmallIntVector;
import org.apache.arrow.vector.TestUtils;
import org.apache.arrow.vector.TimeMicroVector;
import org.apache.arrow.vector.TimeMilliVector;
import org.apache.arrow.vector.TimeStampMicroVector;
import org.apache.arrow.vector.TinyIntVector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.types.Types;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestCopyFrom {
    private static final String EMPTY_SCHEMA_PATH = "";
    private BufferAllocator allocator;

    @Before
    public void init() {
        this.allocator = new RootAllocator(Long.MAX_VALUE);
    }

    @After
    public void terminate() throws Exception {
        this.allocator.close();
    }

    @Test
    public void testCopyFromWithNulls() {
        try (VarCharVector vector = TestUtils.newVector(VarCharVector.class, EMPTY_SCHEMA_PATH, Types.MinorType.VARCHAR, this.allocator);
             VarCharVector vector2 = TestUtils.newVector(VarCharVector.class, EMPTY_SCHEMA_PATH, Types.MinorType.VARCHAR, this.allocator);){
            int i;
            vector.allocateNew();
            Assert.assertTrue((vector.getValueCapacity() >= 1 ? 1 : 0) != 0);
            Assert.assertEquals((long)0L, (long)vector.getValueCount());
            int initialCapacity = vector.getValueCapacity();
            for (int i2 = 0; i2 < initialCapacity; ++i2) {
                if (i2 % 3 == 0) continue;
                byte[] b = Integer.toString(i2).getBytes();
                vector.setSafe(i2, b, 0, b.length);
            }
            int capacity = vector.getValueCapacity();
            Assert.assertEquals((long)initialCapacity, (long)capacity);
            vector.setValueCount(initialCapacity);
            for (i = 0; i < initialCapacity; ++i) {
                if (i % 3 == 0) {
                    Assert.assertNull((Object)vector.getObject(i));
                    continue;
                }
                Assert.assertEquals((String)("unexpected value at index: " + i), (Object)Integer.toString(i), (Object)vector.getObject(i).toString());
            }
            vector2.setInitialCapacity(initialCapacity);
            vector2.allocateNew();
            capacity = vector2.getValueCapacity();
            Assert.assertEquals((long)initialCapacity, (long)capacity);
            for (i = 0; i < initialCapacity; ++i) {
                vector2.copyFromSafe(i, i, (ValueVector)vector);
                if (i % 3 == 0) {
                    Assert.assertNull((Object)vector2.getObject(i));
                    continue;
                }
                Assert.assertEquals((String)("unexpected value at index: " + i), (Object)Integer.toString(i), (Object)vector2.getObject(i).toString());
            }
            capacity = vector2.getValueCapacity();
            Assert.assertEquals((long)initialCapacity, (long)capacity);
            vector2.setValueCount(initialCapacity);
            for (i = 0; i < initialCapacity; ++i) {
                if (i % 3 == 0) {
                    Assert.assertNull((Object)vector2.getObject(i));
                    continue;
                }
                Assert.assertEquals((String)("unexpected value at index: " + i), (Object)Integer.toString(i), (Object)vector2.getObject(i).toString());
            }
        }
    }

    @Test
    public void testCopyFromWithNulls1() {
        try (VarCharVector vector = TestUtils.newVector(VarCharVector.class, EMPTY_SCHEMA_PATH, Types.MinorType.VARCHAR, this.allocator);
             VarCharVector vector2 = TestUtils.newVector(VarCharVector.class, EMPTY_SCHEMA_PATH, Types.MinorType.VARCHAR, this.allocator);){
            int i;
            vector.allocateNew();
            Assert.assertTrue((vector.getValueCapacity() >= 1 ? 1 : 0) != 0);
            Assert.assertEquals((long)0L, (long)vector.getValueCount());
            int initialCapacity = vector.getValueCapacity();
            for (int i2 = 0; i2 < initialCapacity; ++i2) {
                if (i2 % 3 == 0) continue;
                byte[] b = Integer.toString(i2).getBytes();
                vector.setSafe(i2, b, 0, b.length);
            }
            int capacity = vector.getValueCapacity();
            Assert.assertEquals((long)initialCapacity, (long)capacity);
            vector.setValueCount(initialCapacity);
            for (i = 0; i < initialCapacity; ++i) {
                if (i % 3 == 0) {
                    Assert.assertNull((Object)vector.getObject(i));
                    continue;
                }
                Assert.assertEquals((String)("unexpected value at index: " + i), (Object)Integer.toString(i), (Object)vector.getObject(i).toString());
            }
            vector2.allocateNew((long)(initialCapacity / 4 * 10), initialCapacity / 4);
            capacity = vector2.getValueCapacity();
            Assert.assertTrue((capacity >= initialCapacity / 4 ? 1 : 0) != 0);
            Assert.assertTrue((capacity < initialCapacity / 2 ? 1 : 0) != 0);
            for (i = 0; i < initialCapacity; ++i) {
                vector2.copyFromSafe(i, i, (ValueVector)vector);
                if (i % 3 == 0) {
                    Assert.assertNull((Object)vector2.getObject(i));
                    continue;
                }
                Assert.assertEquals((String)("unexpected value at index: " + i), (Object)Integer.toString(i), (Object)vector2.getObject(i).toString());
            }
            capacity = vector2.getValueCapacity();
            Assert.assertTrue((capacity >= initialCapacity ? 1 : 0) != 0);
            vector2.setValueCount(initialCapacity);
            for (i = 0; i < initialCapacity; ++i) {
                if (i % 3 == 0) {
                    Assert.assertNull((Object)vector2.getObject(i));
                    continue;
                }
                Assert.assertEquals((String)("unexpected value at index: " + i), (Object)Integer.toString(i), (Object)vector2.getObject(i).toString());
            }
        }
    }

    @Test
    public void testCopyFromWithNulls2() {
        try (IntVector vector1 = new IntVector(EMPTY_SCHEMA_PATH, this.allocator);
             IntVector vector2 = new IntVector(EMPTY_SCHEMA_PATH, this.allocator);){
            int i;
            vector1.allocateNew();
            Assert.assertTrue((vector1.getValueCapacity() >= 3970 ? 1 : 0) != 0);
            Assert.assertEquals((long)0L, (long)vector1.getValueCount());
            int initialCapacity = vector1.getValueCapacity();
            for (i = 0; i < initialCapacity; ++i) {
                if ((i & 1) == 0) continue;
                vector1.setSafe(i, 1000 + i);
            }
            vector1.setValueCount(initialCapacity);
            Assert.assertEquals((long)initialCapacity, (long)vector1.getValueCapacity());
            Assert.assertEquals((long)initialCapacity, (long)vector1.getValueCount());
            for (i = 0; i < initialCapacity; ++i) {
                if ((i & 1) == 0) {
                    Assert.assertNull((Object)vector1.getObject(i));
                    continue;
                }
                Assert.assertEquals((String)("unexpected value at index: " + i), (long)(1000 + i), (long)vector1.get(i));
            }
            vector2.allocateNew(initialCapacity / 4);
            Assert.assertTrue((vector2.getValueCapacity() >= initialCapacity / 4 ? 1 : 0) != 0);
            Assert.assertTrue((vector2.getValueCapacity() < initialCapacity / 2 ? 1 : 0) != 0);
            for (i = 0; i < initialCapacity; ++i) {
                vector2.copyFromSafe(i, i, (ValueVector)vector1);
            }
            Assert.assertTrue((vector2.getValueCapacity() >= initialCapacity ? 1 : 0) != 0);
            vector2.setValueCount(initialCapacity * 2);
            Assert.assertEquals((long)(initialCapacity * 2), (long)vector2.getValueCount());
            Assert.assertTrue((vector2.getValueCapacity() >= initialCapacity * 2 ? 1 : 0) != 0);
            for (i = 0; i < initialCapacity * 2; ++i) {
                if ((i & 1) == 0 || i >= initialCapacity) {
                    Assert.assertNull((Object)vector2.getObject(i));
                    continue;
                }
                Assert.assertEquals((String)("unexpected value at index: " + i), (long)(1000 + i), (long)vector2.get(i));
            }
        }
    }

    @Test
    public void testCopyFromWithNulls3() {
        try (BigIntVector vector1 = new BigIntVector(EMPTY_SCHEMA_PATH, this.allocator);
             BigIntVector vector2 = new BigIntVector(EMPTY_SCHEMA_PATH, this.allocator);){
            int i;
            vector1.allocateNew();
            Assert.assertTrue((vector1.getValueCapacity() >= 3970 ? 1 : 0) != 0);
            Assert.assertEquals((long)0L, (long)vector1.getValueCount());
            int initialCapacity = vector1.getValueCapacity();
            for (i = 0; i < initialCapacity; ++i) {
                if ((i & 1) == 0) continue;
                vector1.setSafe(i, 10000000000L + (long)i);
            }
            vector1.setValueCount(initialCapacity);
            Assert.assertEquals((long)initialCapacity, (long)vector1.getValueCapacity());
            Assert.assertEquals((long)initialCapacity, (long)vector1.getValueCount());
            for (i = 0; i < initialCapacity; ++i) {
                if ((i & 1) == 0) {
                    Assert.assertNull((Object)vector1.getObject(i));
                    continue;
                }
                Assert.assertEquals((String)("unexpected value at index: " + i), (long)(10000000000L + (long)i), (long)vector1.get(i));
            }
            vector2.allocateNew(initialCapacity / 4);
            Assert.assertTrue((vector2.getValueCapacity() >= initialCapacity / 4 ? 1 : 0) != 0);
            Assert.assertTrue((vector2.getValueCapacity() < initialCapacity / 2 ? 1 : 0) != 0);
            for (i = 0; i < initialCapacity; ++i) {
                vector2.copyFromSafe(i, i, (ValueVector)vector1);
            }
            Assert.assertTrue((vector2.getValueCapacity() >= initialCapacity ? 1 : 0) != 0);
            vector2.setValueCount(initialCapacity * 2);
            Assert.assertEquals((long)(initialCapacity * 2), (long)vector2.getValueCount());
            Assert.assertTrue((vector2.getValueCapacity() >= initialCapacity * 2 ? 1 : 0) != 0);
            for (i = 0; i < initialCapacity * 2; ++i) {
                if ((i & 1) == 0 || i >= initialCapacity) {
                    Assert.assertNull((Object)vector2.getObject(i));
                    continue;
                }
                Assert.assertEquals((String)("unexpected value at index: " + i), (long)(10000000000L + (long)i), (long)vector2.get(i));
            }
        }
    }

    @Test
    public void testCopyFromWithNulls4() {
        try (BitVector vector1 = new BitVector(EMPTY_SCHEMA_PATH, this.allocator);
             BitVector vector2 = new BitVector(EMPTY_SCHEMA_PATH, this.allocator);){
            int i;
            vector1.setInitialCapacity(4096);
            vector1.allocateNew();
            Assert.assertEquals((long)4096L, (long)vector1.getValueCapacity());
            Assert.assertEquals((long)0L, (long)vector1.getValueCount());
            int counter = 0;
            for (i = 0; i < 4096; ++i) {
                if ((i & 1) == 0) continue;
                if (!(counter & true)) {
                    vector1.setSafe(i, 1);
                } else {
                    vector1.setSafe(i, 0);
                }
                ++counter;
            }
            vector1.setValueCount(4096);
            Assert.assertEquals((long)4096L, (long)vector1.getValueCapacity());
            Assert.assertEquals((long)4096L, (long)vector1.getValueCount());
            counter = 0;
            for (i = 0; i < 4096; ++i) {
                if ((i & 1) == 0) {
                    Assert.assertNull((Object)vector1.getObject(i));
                    continue;
                }
                if ((counter & 1) == 0) {
                    Assert.assertTrue((boolean)vector1.getObject(i));
                } else {
                    Assert.assertFalse((boolean)vector1.getObject(i));
                }
                ++counter;
            }
            vector2.allocateNew(1024);
            Assert.assertEquals((long)1024L, (long)vector2.getValueCapacity());
            for (i = 0; i < 4096; ++i) {
                vector2.copyFromSafe(i, i, (ValueVector)vector1);
            }
            Assert.assertEquals((long)4096L, (long)vector2.getValueCapacity());
            vector2.setValueCount(8192);
            Assert.assertEquals((long)8192L, (long)vector2.getValueCount());
            Assert.assertEquals((long)8192L, (long)vector2.getValueCapacity());
            counter = 0;
            for (i = 0; i < 8192; ++i) {
                if ((i & 1) == 0 || i >= 4096) {
                    Assert.assertNull((Object)vector2.getObject(i));
                    continue;
                }
                if ((counter & 1) == 0) {
                    Assert.assertTrue((boolean)vector2.getObject(i));
                } else {
                    Assert.assertFalse((boolean)vector2.getObject(i));
                }
                ++counter;
            }
        }
    }

    @Test
    public void testCopyFromWithNulls5() {
        try (Float4Vector vector1 = new Float4Vector(EMPTY_SCHEMA_PATH, this.allocator);
             Float4Vector vector2 = new Float4Vector(EMPTY_SCHEMA_PATH, this.allocator);){
            int i;
            vector1.allocateNew();
            Assert.assertTrue((vector1.getValueCapacity() >= 3970 ? 1 : 0) != 0);
            Assert.assertEquals((long)0L, (long)vector1.getValueCount());
            int initialCapacity = vector1.getValueCapacity();
            for (i = 0; i < initialCapacity; ++i) {
                if ((i & 1) == 0) continue;
                vector1.setSafe(i, 100.25f + (float)i);
            }
            vector1.setValueCount(initialCapacity);
            Assert.assertEquals((long)initialCapacity, (long)vector1.getValueCapacity());
            Assert.assertEquals((long)initialCapacity, (long)vector1.getValueCount());
            for (i = 0; i < initialCapacity; ++i) {
                if ((i & 1) == 0) {
                    Assert.assertNull((Object)vector1.getObject(i));
                    continue;
                }
                Assert.assertEquals((String)("unexpected value at index: " + i), (float)(100.25f + (float)i), (float)vector1.get(i), (float)0.0f);
            }
            vector2.allocateNew(initialCapacity / 4);
            Assert.assertTrue((vector2.getValueCapacity() >= initialCapacity / 4 ? 1 : 0) != 0);
            Assert.assertTrue((vector2.getValueCapacity() < initialCapacity / 2 ? 1 : 0) != 0);
            for (i = 0; i < initialCapacity; ++i) {
                vector2.copyFromSafe(i, i, (ValueVector)vector1);
            }
            Assert.assertTrue((vector2.getValueCapacity() >= initialCapacity ? 1 : 0) != 0);
            vector2.setValueCount(initialCapacity * 2);
            Assert.assertEquals((long)(initialCapacity * 2), (long)vector2.getValueCount());
            Assert.assertTrue((vector2.getValueCapacity() >= initialCapacity * 2 ? 1 : 0) != 0);
            for (i = 0; i < initialCapacity * 2; ++i) {
                if ((i & 1) == 0 || i >= initialCapacity) {
                    Assert.assertNull((Object)vector2.getObject(i));
                    continue;
                }
                Assert.assertEquals((String)("unexpected value at index: " + i), (float)(100.25f + (float)i * 1.0f), (float)vector2.get(i), (float)0.0f);
            }
        }
    }

    @Test
    public void testCopyFromWithNulls6() {
        try (Float8Vector vector1 = new Float8Vector(EMPTY_SCHEMA_PATH, this.allocator);
             Float8Vector vector2 = new Float8Vector(EMPTY_SCHEMA_PATH, this.allocator);){
            int i;
            vector1.allocateNew();
            Assert.assertTrue((vector1.getValueCapacity() >= 3970 ? 1 : 0) != 0);
            Assert.assertEquals((long)0L, (long)vector1.getValueCount());
            int initialCapacity = vector1.getValueCapacity();
            for (i = 0; i < initialCapacity; ++i) {
                if ((i & 1) == 0) continue;
                vector1.setSafe(i, 123456.7865 + (double)i);
            }
            vector1.setValueCount(initialCapacity);
            Assert.assertEquals((long)initialCapacity, (long)vector1.getValueCapacity());
            Assert.assertEquals((long)initialCapacity, (long)vector1.getValueCount());
            for (i = 0; i < initialCapacity; ++i) {
                if ((i & 1) == 0) {
                    Assert.assertNull((Object)vector1.getObject(i));
                    continue;
                }
                Assert.assertEquals((String)("unexpected value at index: " + i), (double)(123456.7865 + (double)i), (double)vector1.get(i), (double)0.0);
            }
            vector2.allocateNew(initialCapacity / 4);
            Assert.assertTrue((vector2.getValueCapacity() >= initialCapacity / 4 ? 1 : 0) != 0);
            Assert.assertTrue((vector2.getValueCapacity() < initialCapacity / 2 ? 1 : 0) != 0);
            for (i = 0; i < initialCapacity; ++i) {
                vector2.copyFromSafe(i, i, (ValueVector)vector1);
            }
            Assert.assertTrue((vector2.getValueCapacity() >= initialCapacity ? 1 : 0) != 0);
            vector2.setValueCount(initialCapacity * 2);
            Assert.assertEquals((long)(initialCapacity * 2), (long)vector2.getValueCount());
            Assert.assertTrue((vector2.getValueCapacity() >= initialCapacity * 2 ? 1 : 0) != 0);
            for (i = 0; i < initialCapacity * 2; ++i) {
                if ((i & 1) == 0 || i >= initialCapacity) {
                    Assert.assertNull((Object)vector2.getObject(i));
                    continue;
                }
                Assert.assertEquals((String)("unexpected value at index: " + i), (double)(123456.7865 + (double)i), (double)vector2.get(i), (double)0.0);
            }
        }
    }

    @Test
    public void testCopyFromWithNulls7() {
        try (IntervalDayVector vector1 = new IntervalDayVector(EMPTY_SCHEMA_PATH, this.allocator);
             IntervalDayVector vector2 = new IntervalDayVector(EMPTY_SCHEMA_PATH, this.allocator);){
            Duration d;
            int i;
            vector1.allocateNew();
            Assert.assertTrue((vector1.getValueCapacity() >= 3970 ? 1 : 0) != 0);
            Assert.assertEquals((long)0L, (long)vector1.getValueCount());
            int initialCapacity = vector1.getValueCapacity();
            int days = 10;
            int milliseconds = 10000;
            for (i = 0; i < initialCapacity; ++i) {
                if ((i & 1) == 0) continue;
                vector1.setSafe(i, 10 + i, 10000 + i);
            }
            vector1.setValueCount(initialCapacity);
            Assert.assertEquals((long)initialCapacity, (long)vector1.getValueCapacity());
            Assert.assertEquals((long)initialCapacity, (long)vector1.getValueCount());
            for (i = 0; i < initialCapacity; ++i) {
                if ((i & 1) == 0) {
                    Assert.assertNull((Object)vector1.getObject(i));
                    continue;
                }
                d = vector1.getObject(i);
                Assert.assertEquals((long)(10 + i), (long)d.toDays());
                Assert.assertEquals((long)(10000 + i), (long)d.minusDays(10 + i).toMillis());
            }
            vector2.allocateNew(initialCapacity / 4);
            Assert.assertTrue((vector2.getValueCapacity() >= initialCapacity / 4 ? 1 : 0) != 0);
            Assert.assertTrue((vector2.getValueCapacity() < initialCapacity / 2 ? 1 : 0) != 0);
            for (i = 0; i < initialCapacity; ++i) {
                vector2.copyFromSafe(i, i, (ValueVector)vector1);
            }
            Assert.assertTrue((vector2.getValueCapacity() >= initialCapacity ? 1 : 0) != 0);
            vector2.setValueCount(initialCapacity * 2);
            Assert.assertEquals((long)(initialCapacity * 2), (long)vector2.getValueCount());
            Assert.assertTrue((vector2.getValueCapacity() >= initialCapacity * 2 ? 1 : 0) != 0);
            for (i = 0; i < initialCapacity * 2; ++i) {
                if ((i & 1) == 0 || i >= initialCapacity) {
                    Assert.assertNull((Object)vector2.getObject(i));
                    continue;
                }
                d = vector2.getObject(i);
                Assert.assertEquals((long)(10 + i), (long)d.toDays());
                Assert.assertEquals((long)(10000 + i), (long)d.minusDays(10 + i).toMillis());
            }
        }
    }

    @Test
    public void testCopyFromWithNulls8() {
        try (IntervalYearVector vector1 = new IntervalYearVector(EMPTY_SCHEMA_PATH, this.allocator);
             IntervalYearVector vector2 = new IntervalYearVector(EMPTY_SCHEMA_PATH, this.allocator);){
            int i;
            vector1.allocateNew();
            Assert.assertTrue((vector1.getValueCapacity() >= 3970 ? 1 : 0) != 0);
            Assert.assertEquals((long)0L, (long)vector1.getValueCount());
            int initialCapacity = vector1.getValueCapacity();
            int interval = 30;
            Period[] periods = new Period[4096];
            for (i = 0; i < initialCapacity; ++i) {
                if ((i & 1) == 0) continue;
                vector1.setSafe(i, 30 + i);
                int years = (30 + i) / 12;
                int months = (30 + i) % 12;
                periods[i] = Period.ofYears(years).plusMonths(months).normalized();
            }
            vector1.setValueCount(initialCapacity);
            Assert.assertEquals((long)initialCapacity, (long)vector1.getValueCapacity());
            Assert.assertEquals((long)initialCapacity, (long)vector1.getValueCount());
            for (i = 0; i < initialCapacity; ++i) {
                if ((i & 1) == 0) {
                    Assert.assertNull((Object)vector1.getObject(i));
                    continue;
                }
                Period p = vector1.getObject(i).normalized();
                Assert.assertEquals((long)(30 + i), (long)vector1.get(i));
                Assert.assertEquals((Object)periods[i], (Object)p);
            }
            vector2.allocateNew(initialCapacity / 4);
            Assert.assertTrue((vector2.getValueCapacity() >= initialCapacity / 4 ? 1 : 0) != 0);
            Assert.assertTrue((vector2.getValueCapacity() < initialCapacity / 2 ? 1 : 0) != 0);
            for (i = 0; i < initialCapacity; ++i) {
                vector2.copyFromSafe(i, i, (ValueVector)vector1);
            }
            Assert.assertTrue((vector2.getValueCapacity() >= initialCapacity ? 1 : 0) != 0);
            vector2.setValueCount(initialCapacity * 2);
            Assert.assertEquals((long)(initialCapacity * 2), (long)vector2.getValueCount());
            Assert.assertTrue((vector2.getValueCapacity() >= initialCapacity * 2 ? 1 : 0) != 0);
            for (i = 0; i < initialCapacity * 2; ++i) {
                if ((i & 1) == 0 || i >= initialCapacity) {
                    Assert.assertNull((Object)vector2.getObject(i));
                    continue;
                }
                Period p = vector2.getObject(i).normalized();
                Assert.assertEquals((Object)periods[i], (Object)p);
            }
        }
    }

    @Test
    public void testCopyFromWithNulls9() {
        try (SmallIntVector vector1 = new SmallIntVector(EMPTY_SCHEMA_PATH, this.allocator);
             SmallIntVector vector2 = new SmallIntVector(EMPTY_SCHEMA_PATH, this.allocator);){
            int i;
            vector1.allocateNew();
            Assert.assertTrue((vector1.getValueCapacity() >= 3970 ? 1 : 0) != 0);
            Assert.assertEquals((long)0L, (long)vector1.getValueCount());
            int initialCapacity = vector1.getValueCapacity();
            int val = 1000;
            for (i = 0; i < initialCapacity; ++i) {
                if ((i & 1) == 0) continue;
                vector1.setSafe(i, 1000 + (short)i);
            }
            vector1.setValueCount(initialCapacity);
            Assert.assertEquals((long)initialCapacity, (long)vector1.getValueCapacity());
            Assert.assertEquals((long)initialCapacity, (long)vector1.getValueCount());
            for (i = 0; i < initialCapacity; ++i) {
                if ((i & 1) == 0) {
                    Assert.assertNull((Object)vector1.getObject(i));
                    continue;
                }
                Assert.assertEquals((String)("unexpected value at index: " + i), (long)(1000 + (short)i), (long)vector1.get(i));
            }
            vector2.allocateNew(initialCapacity / 4);
            Assert.assertTrue((vector2.getValueCapacity() >= initialCapacity / 4 ? 1 : 0) != 0);
            Assert.assertTrue((vector2.getValueCapacity() < initialCapacity / 2 ? 1 : 0) != 0);
            for (i = 0; i < initialCapacity; ++i) {
                vector2.copyFromSafe(i, i, (ValueVector)vector1);
            }
            Assert.assertTrue((vector2.getValueCapacity() >= initialCapacity ? 1 : 0) != 0);
            vector2.setValueCount(initialCapacity * 2);
            Assert.assertEquals((long)(initialCapacity * 2), (long)vector2.getValueCount());
            Assert.assertTrue((vector2.getValueCapacity() >= initialCapacity * 2 ? 1 : 0) != 0);
            for (i = 0; i < initialCapacity * 2; ++i) {
                if ((i & 1) == 0 || i >= initialCapacity) {
                    Assert.assertNull((Object)vector2.getObject(i));
                    continue;
                }
                Assert.assertEquals((String)("unexpected value at index: " + i), (long)(1000 + (short)i), (long)vector2.get(i));
            }
        }
    }

    @Test
    public void testCopyFromWithNulls10() {
        try (TimeMicroVector vector1 = new TimeMicroVector(EMPTY_SCHEMA_PATH, this.allocator);
             TimeMicroVector vector2 = new TimeMicroVector(EMPTY_SCHEMA_PATH, this.allocator);){
            int i;
            vector1.allocateNew();
            Assert.assertTrue((vector1.getValueCapacity() >= 3970 ? 1 : 0) != 0);
            Assert.assertEquals((long)0L, (long)vector1.getValueCount());
            int initialCapacity = vector1.getValueCapacity();
            long val = 100485765432L;
            for (i = 0; i < initialCapacity; ++i) {
                if ((i & 1) == 0) continue;
                vector1.setSafe(i, 100485765432L + (long)i);
            }
            vector1.setValueCount(initialCapacity);
            Assert.assertEquals((long)initialCapacity, (long)vector1.getValueCapacity());
            Assert.assertEquals((long)initialCapacity, (long)vector1.getValueCount());
            for (i = 0; i < initialCapacity; ++i) {
                if ((i & 1) == 0) {
                    Assert.assertNull((Object)vector1.getObject(i));
                    continue;
                }
                Assert.assertEquals((String)("unexpected value at index: " + i), (long)(100485765432L + (long)i), (long)vector1.get(i));
            }
            vector2.allocateNew(initialCapacity / 4);
            Assert.assertTrue((vector2.getValueCapacity() >= initialCapacity / 4 ? 1 : 0) != 0);
            Assert.assertTrue((vector2.getValueCapacity() < initialCapacity / 2 ? 1 : 0) != 0);
            for (i = 0; i < initialCapacity; ++i) {
                vector2.copyFromSafe(i, i, (ValueVector)vector1);
            }
            Assert.assertTrue((vector2.getValueCapacity() >= initialCapacity ? 1 : 0) != 0);
            vector2.setValueCount(initialCapacity * 2);
            Assert.assertEquals((long)(initialCapacity * 2), (long)vector2.getValueCount());
            Assert.assertTrue((vector2.getValueCapacity() >= initialCapacity * 2 ? 1 : 0) != 0);
            for (i = 0; i < initialCapacity * 2; ++i) {
                if ((i & 1) == 0 || i >= initialCapacity) {
                    Assert.assertNull((Object)vector2.getObject(i));
                    continue;
                }
                Assert.assertEquals((String)("unexpected value at index: " + i), (long)(100485765432L + (long)i), (long)vector2.get(i));
            }
        }
    }

    @Test
    public void testCopyFromWithNulls11() {
        try (TimeMilliVector vector1 = new TimeMilliVector(EMPTY_SCHEMA_PATH, this.allocator);
             TimeMilliVector vector2 = new TimeMilliVector(EMPTY_SCHEMA_PATH, this.allocator);){
            int i;
            vector1.allocateNew();
            Assert.assertTrue((vector1.getValueCapacity() >= 3970 ? 1 : 0) != 0);
            Assert.assertEquals((long)0L, (long)vector1.getValueCount());
            int initialCapacity = vector1.getValueCapacity();
            int val = 1000;
            for (i = 0; i < initialCapacity; ++i) {
                if ((i & 1) == 0) continue;
                vector1.setSafe(i, 1000 + i);
            }
            vector1.setValueCount(initialCapacity);
            Assert.assertEquals((long)initialCapacity, (long)vector1.getValueCapacity());
            Assert.assertEquals((long)initialCapacity, (long)vector1.getValueCount());
            for (i = 0; i < initialCapacity; ++i) {
                if ((i & 1) == 0) {
                    Assert.assertNull((Object)vector1.getObject(i));
                    continue;
                }
                Assert.assertEquals((String)("unexpected value at index: " + i), (long)(1000 + i), (long)vector1.get(i));
            }
            vector2.allocateNew(initialCapacity / 4);
            Assert.assertTrue((vector2.getValueCapacity() >= initialCapacity / 4 ? 1 : 0) != 0);
            Assert.assertTrue((vector2.getValueCapacity() < initialCapacity / 2 ? 1 : 0) != 0);
            for (i = 0; i < initialCapacity; ++i) {
                vector2.copyFromSafe(i, i, (ValueVector)vector1);
            }
            Assert.assertTrue((vector2.getValueCapacity() >= initialCapacity ? 1 : 0) != 0);
            vector2.setValueCount(initialCapacity * 2);
            Assert.assertEquals((long)(initialCapacity * 2), (long)vector2.getValueCount());
            Assert.assertTrue((vector2.getValueCapacity() >= initialCapacity * 2 ? 1 : 0) != 0);
            for (i = 0; i < initialCapacity * 2; ++i) {
                if ((i & 1) == 0 || i >= initialCapacity) {
                    Assert.assertNull((Object)vector2.getObject(i));
                    continue;
                }
                Assert.assertEquals((String)("unexpected value at index: " + i), (long)(1000 + i), (long)vector2.get(i));
            }
        }
    }

    @Test
    public void testCopyFromWithNulls12() {
        try (TinyIntVector vector1 = new TinyIntVector(EMPTY_SCHEMA_PATH, this.allocator);
             TinyIntVector vector2 = new TinyIntVector(EMPTY_SCHEMA_PATH, this.allocator);){
            int i;
            vector1.allocateNew();
            Assert.assertTrue((vector1.getValueCapacity() >= 3970 ? 1 : 0) != 0);
            Assert.assertEquals((long)0L, (long)vector1.getValueCount());
            int initialCapacity = vector1.getValueCapacity();
            int val = -128;
            for (i = 0; i < initialCapacity; ++i) {
                if ((i & 1) == 0) continue;
                vector1.setSafe(i, (byte)val);
                val = (byte)(val + 1);
            }
            vector1.setValueCount(initialCapacity);
            Assert.assertEquals((long)initialCapacity, (long)vector1.getValueCapacity());
            Assert.assertEquals((long)initialCapacity, (long)vector1.getValueCount());
            val = -128;
            for (i = 0; i < initialCapacity; ++i) {
                if ((i & 1) == 0) {
                    Assert.assertNull((Object)vector1.getObject(i));
                    continue;
                }
                Assert.assertEquals((String)("unexpected value at index: " + i), (long)val, (long)vector1.get(i));
                val = (byte)(val + 1);
            }
            vector2.allocateNew(initialCapacity / 4);
            Assert.assertTrue((vector2.getValueCapacity() >= initialCapacity / 4 ? 1 : 0) != 0);
            for (i = 0; i < initialCapacity; ++i) {
                vector2.copyFromSafe(i, i, (ValueVector)vector1);
            }
            Assert.assertTrue((vector2.getValueCapacity() >= initialCapacity ? 1 : 0) != 0);
            vector2.setValueCount(initialCapacity * 2);
            Assert.assertEquals((long)(initialCapacity * 2), (long)vector2.getValueCount());
            Assert.assertTrue((vector2.getValueCapacity() >= initialCapacity * 2 ? 1 : 0) != 0);
            val = -128;
            for (i = 0; i < initialCapacity * 2; ++i) {
                if ((i & 1) == 0 || i >= initialCapacity) {
                    Assert.assertNull((Object)vector2.getObject(i));
                    continue;
                }
                Assert.assertEquals((String)("unexpected value at index: " + i), (long)val, (long)vector2.get(i));
                val = (byte)(val + 1);
            }
        }
    }

    @Test
    public void testCopyFromWithNulls13() {
        try (DecimalVector vector1 = new DecimalVector(EMPTY_SCHEMA_PATH, this.allocator, 30, 16);
             DecimalVector vector2 = new DecimalVector(EMPTY_SCHEMA_PATH, this.allocator, 30, 16);){
            BigDecimal decimal;
            int i;
            vector1.allocateNew();
            Assert.assertTrue((vector1.getValueCapacity() >= 3970 ? 1 : 0) != 0);
            Assert.assertEquals((long)0L, (long)vector1.getValueCount());
            int initialCapacity = vector1.getValueCapacity();
            double baseValue = 1.0456789765487654E11;
            BigDecimal[] decimals = new BigDecimal[4096];
            for (i = 0; i < initialCapacity; ++i) {
                if ((i & 1) == 0) continue;
                decimal = new BigDecimal(1.0456789765487654E11 + (double)i);
                vector1.setSafe(i, decimal);
                decimals[i] = decimal;
            }
            vector1.setValueCount(initialCapacity);
            Assert.assertEquals((long)initialCapacity, (long)vector1.getValueCapacity());
            Assert.assertEquals((long)initialCapacity, (long)vector1.getValueCount());
            for (i = 0; i < initialCapacity; ++i) {
                if ((i & 1) == 0) {
                    Assert.assertNull((Object)vector1.getObject(i));
                    continue;
                }
                decimal = vector1.getObject(i);
                Assert.assertEquals((Object)decimals[i], (Object)decimal);
            }
            vector2.allocateNew(initialCapacity / 4);
            Assert.assertTrue((vector2.getValueCapacity() >= initialCapacity / 4 ? 1 : 0) != 0);
            Assert.assertTrue((vector2.getValueCapacity() < initialCapacity / 2 ? 1 : 0) != 0);
            for (i = 0; i < initialCapacity; ++i) {
                vector2.copyFromSafe(i, i, (ValueVector)vector1);
            }
            Assert.assertTrue((vector2.getValueCapacity() >= initialCapacity ? 1 : 0) != 0);
            vector2.setValueCount(initialCapacity * 2);
            Assert.assertEquals((long)(initialCapacity * 2), (long)vector2.getValueCount());
            Assert.assertTrue((vector2.getValueCapacity() >= initialCapacity * 2 ? 1 : 0) != 0);
            for (i = 0; i < initialCapacity * 2; ++i) {
                if ((i & 1) == 0 || i >= initialCapacity) {
                    Assert.assertNull((Object)vector2.getObject(i));
                    continue;
                }
                decimal = vector2.getObject(i);
                Assert.assertEquals((Object)decimals[i], (Object)decimal);
            }
        }
    }

    @Test
    public void testCopyFromWithNulls14() {
        try (TimeStampMicroVector vector1 = new TimeStampMicroVector(EMPTY_SCHEMA_PATH, this.allocator);
             TimeStampMicroVector vector2 = new TimeStampMicroVector(EMPTY_SCHEMA_PATH, this.allocator);){
            int i;
            vector1.allocateNew();
            Assert.assertTrue((vector1.getValueCapacity() >= 3970 ? 1 : 0) != 0);
            Assert.assertEquals((long)0L, (long)vector1.getValueCount());
            int initialCapacity = vector1.getValueCapacity();
            long val = 20145678912L;
            for (i = 0; i < initialCapacity; ++i) {
                if ((i & 1) == 0) continue;
                vector1.setSafe(i, 20145678912L + (long)i);
            }
            vector1.setValueCount(initialCapacity);
            Assert.assertEquals((long)initialCapacity, (long)vector1.getValueCapacity());
            Assert.assertEquals((long)initialCapacity, (long)vector1.getValueCount());
            for (i = 0; i < initialCapacity; ++i) {
                if ((i & 1) == 0) {
                    Assert.assertNull((Object)vector1.getObject(i));
                    continue;
                }
                Assert.assertEquals((String)("unexpected value at index: " + i), (long)(20145678912L + (long)i), (long)vector1.get(i));
            }
            vector2.allocateNew(initialCapacity / 4);
            Assert.assertTrue((vector2.getValueCapacity() >= initialCapacity / 4 ? 1 : 0) != 0);
            Assert.assertTrue((vector2.getValueCapacity() < initialCapacity / 2 ? 1 : 0) != 0);
            for (i = 0; i < initialCapacity; ++i) {
                vector2.copyFromSafe(i, i, (ValueVector)vector1);
            }
            Assert.assertTrue((vector2.getValueCapacity() >= initialCapacity ? 1 : 0) != 0);
            vector2.setValueCount(initialCapacity * 2);
            Assert.assertEquals((long)(initialCapacity * 2), (long)vector2.getValueCount());
            Assert.assertTrue((vector2.getValueCapacity() >= initialCapacity * 2 ? 1 : 0) != 0);
            for (i = 0; i < initialCapacity * 2; ++i) {
                if ((i & 1) == 0 || i >= initialCapacity) {
                    Assert.assertNull((Object)vector2.getObject(i));
                    continue;
                }
                Assert.assertEquals((String)("unexpected value at index: " + i), (long)(20145678912L + (long)i), (long)vector2.get(i));
            }
        }
    }

    @Test
    public void testCopySafeArrow7837() {
        try (VarCharVector vc1 = new VarCharVector("vc1", this.allocator);
             VarCharVector vc2 = new VarCharVector("vc2", this.allocator);){
            vc2.setInitialCapacity(20, 0.5);
            vc1.setSafe(0, "1234567890".getBytes(Charset.forName("utf-8")));
            Assert.assertFalse((boolean)vc1.isNull(0));
            Assert.assertEquals((Object)vc1.getObject(0).toString(), (Object)"1234567890");
            vc2.copyFromSafe(0, 0, (ValueVector)vc1);
            Assert.assertFalse((boolean)vc2.isNull(0));
            Assert.assertEquals((Object)vc2.getObject(0).toString(), (Object)"1234567890");
            vc2.copyFromSafe(0, 5, (ValueVector)vc1);
            Assert.assertTrue((boolean)vc2.isNull(1));
            Assert.assertTrue((boolean)vc2.isNull(2));
            Assert.assertTrue((boolean)vc2.isNull(3));
            Assert.assertTrue((boolean)vc2.isNull(4));
            Assert.assertFalse((boolean)vc2.isNull(5));
            Assert.assertEquals((Object)vc2.getObject(5).toString(), (Object)"1234567890");
        }
    }
}

