/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.vector;

import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.complex.ListVector;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.util.CallBack;
import org.junit.Assert;
import org.junit.Test;

public class TestBufferOwnershipTransfer {
    @Test
    public void testTransferFixedWidth() {
        RootAllocator allocator = new RootAllocator(Integer.MAX_VALUE);
        BufferAllocator childAllocator1 = allocator.newChildAllocator("child1", 100000L, 100000L);
        BufferAllocator childAllocator2 = allocator.newChildAllocator("child2", 100000L, 100000L);
        IntVector v1 = new IntVector("v1", childAllocator1);
        v1.allocateNew();
        v1.setValueCount(4095);
        long totalAllocatedMemory = childAllocator1.getAllocatedMemory();
        IntVector v2 = new IntVector("v2", childAllocator2);
        v1.makeTransferPair((ValueVector)v2).transfer();
        Assert.assertEquals((long)0L, (long)childAllocator1.getAllocatedMemory());
        Assert.assertEquals((long)totalAllocatedMemory, (long)childAllocator2.getAllocatedMemory());
        v1.close();
        v2.close();
        childAllocator1.close();
        childAllocator2.close();
        allocator.close();
    }

    @Test
    public void testTransferVariableWidth() {
        RootAllocator allocator = new RootAllocator(Integer.MAX_VALUE);
        BufferAllocator childAllocator1 = allocator.newChildAllocator("child1", 100000L, 100000L);
        BufferAllocator childAllocator2 = allocator.newChildAllocator("child2", 100000L, 100000L);
        VarCharVector v1 = new VarCharVector("v1", childAllocator1);
        v1.allocateNew();
        v1.setSafe(4094, "hello world".getBytes(), 0, 11);
        v1.setValueCount(4001);
        VarCharVector v2 = new VarCharVector("v2", childAllocator2);
        long memoryBeforeTransfer = childAllocator1.getAllocatedMemory();
        v1.makeTransferPair((ValueVector)v2).transfer();
        Assert.assertEquals((long)0L, (long)childAllocator1.getAllocatedMemory());
        Assert.assertEquals((long)memoryBeforeTransfer, (long)childAllocator2.getAllocatedMemory());
        v1.close();
        v2.close();
        childAllocator1.close();
        childAllocator2.close();
        allocator.close();
    }

    private static CallBack newTriggerCallback(final Pointer<Boolean> trigger) {
        trigger.value = false;
        return new CallBack(){

            public void doWork() {
                trigger.value = true;
            }
        };
    }

    @Test
    public void emptyListTransferShouldNotTriggerSchemaChange() {
        RootAllocator allocator = new RootAllocator(Integer.MAX_VALUE);
        Pointer<Boolean> trigger1 = new Pointer<Boolean>();
        Pointer<Boolean> trigger2 = new Pointer<Boolean>();
        ListVector v1 = new ListVector("v1", (BufferAllocator)allocator, FieldType.nullable((ArrowType)ArrowType.Null.INSTANCE), TestBufferOwnershipTransfer.newTriggerCallback(trigger1));
        ListVector v2 = new ListVector("v2", (BufferAllocator)allocator, FieldType.nullable((ArrowType)ArrowType.Null.INSTANCE), TestBufferOwnershipTransfer.newTriggerCallback(trigger2));
        try {
            v1.makeTransferPair((ValueVector)v2).transfer();
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof UnsupportedOperationException));
            Assert.assertTrue((boolean)e.getMessage().contains("Operation not supported on NO_OP Reference Manager"));
        }
        Assert.assertFalse((boolean)((Boolean)trigger1.value));
        Assert.assertFalse((boolean)((Boolean)trigger2.value));
        v1.close();
        v2.close();
        allocator.close();
    }

    private static class Pointer<T> {
        T value;

        private Pointer() {
        }
    }
}

