/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.vector;

import java.util.stream.IntStream;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.memory.util.hash.ArrowBufHasher;
import org.apache.arrow.memory.util.hash.MurmurHasher;
import org.apache.arrow.vector.BitVector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.testing.ValueVectorDataPopulator;
import org.apache.arrow.vector.util.TransferPair;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestBitVector {
    private static final String EMPTY_SCHEMA_PATH = "";
    private BufferAllocator allocator;

    @Before
    public void init() {
        this.allocator = new RootAllocator(Long.MAX_VALUE);
    }

    @After
    public void terminate() throws Exception {
        this.allocator.close();
    }

    @Test
    public void testBitVectorCopyFromSafe() {
        int size = 20;
        try (BitVector src = new BitVector(EMPTY_SCHEMA_PATH, this.allocator);
             BitVector dst = new BitVector(EMPTY_SCHEMA_PATH, this.allocator);){
            int i;
            src.allocateNew(20);
            dst.allocateNew(10);
            for (i = 0; i < 20; ++i) {
                src.set(i, i % 2);
            }
            src.setValueCount(20);
            for (i = 0; i < 20; ++i) {
                dst.copyFromSafe(i, i, (ValueVector)src);
            }
            dst.setValueCount(20);
            for (i = 0; i < 20; ++i) {
                Assert.assertEquals((Object)src.getObject(i), (Object)dst.getObject(i));
            }
        }
    }

    @Test
    public void testSplitAndTransfer() throws Exception {
        try (BitVector sourceVector = new BitVector("bitvector", this.allocator);){
            int i;
            sourceVector.allocateNew(40);
            for (i = 0; i < 40; ++i) {
                if ((i & 1) == 1) {
                    sourceVector.set(i, 1);
                    continue;
                }
                sourceVector.set(i, 0);
            }
            sourceVector.setValueCount(40);
            for (i = 0; i < 40; ++i) {
                int result = sourceVector.get(i);
                if ((i & 1) == 1) {
                    Assert.assertEquals((Object)Integer.toString(1), (Object)Integer.toString(result));
                    continue;
                }
                Assert.assertEquals((Object)Integer.toString(0), (Object)Integer.toString(result));
            }
            try (BitVector toVector = new BitVector("toVector", this.allocator);){
                int[][] transferLengths;
                TransferPair transferPair = sourceVector.makeTransferPair((ValueVector)toVector);
                for (int[] transferLength : transferLengths = new int[][]{{0, 8}, {8, 10}, {18, 0}, {18, 8}, {26, 0}, {26, 14}}) {
                    int start = transferLength[0];
                    int length = transferLength[1];
                    transferPair.splitAndTransfer(start, length);
                    for (int i2 = 0; i2 < length; ++i2) {
                        int actual = toVector.get(i2);
                        int expected = sourceVector.get(start + i2);
                        Assert.assertEquals((String)("different data values not expected --> sourceVector index: " + (start + i2) + " toVector index: " + i2), (long)expected, (long)actual);
                    }
                }
            }
        }
    }

    @Test
    public void testSplitAndTransfer1() throws Exception {
        try (BitVector sourceVector = new BitVector("bitvector", this.allocator);){
            int i;
            sourceVector.allocateNew(8190);
            for (i = 0; i < 8190; ++i) {
                sourceVector.set(i, 1);
            }
            sourceVector.setValueCount(8190);
            for (i = 0; i < 8190; ++i) {
                int result = sourceVector.get(i);
                Assert.assertEquals((Object)Integer.toString(1), (Object)Integer.toString(result));
            }
            try (BitVector toVector = new BitVector("toVector", this.allocator);){
                int[][] transferLengths;
                TransferPair transferPair = sourceVector.makeTransferPair((ValueVector)toVector);
                for (int[] transferLength : transferLengths = new int[][]{{0, 4095}, {4095, 4095}}) {
                    int start = transferLength[0];
                    int length = transferLength[1];
                    transferPair.splitAndTransfer(start, length);
                    for (int i2 = 0; i2 < length; ++i2) {
                        int actual = toVector.get(i2);
                        int expected = sourceVector.get(start + i2);
                        Assert.assertEquals((String)("different data values not expected --> sourceVector index: " + (start + i2) + " toVector index: " + i2), (long)expected, (long)actual);
                    }
                }
            }
        }
    }

    @Test
    public void testSplitAndTransfer2() throws Exception {
        try (BitVector sourceVector = new BitVector("bitvector", this.allocator);){
            int i;
            sourceVector.allocateNew(32);
            for (i = 0; i < 32; ++i) {
                if ((i & 1) == 1) {
                    sourceVector.set(i, 1);
                    continue;
                }
                sourceVector.set(i, 0);
            }
            sourceVector.setValueCount(32);
            for (i = 0; i < 32; ++i) {
                int result = sourceVector.get(i);
                if ((i & 1) == 1) {
                    Assert.assertEquals((Object)Integer.toString(1), (Object)Integer.toString(result));
                    continue;
                }
                Assert.assertEquals((Object)Integer.toString(0), (Object)Integer.toString(result));
            }
            try (BitVector toVector = new BitVector("toVector", this.allocator);){
                int[][] transferLengths;
                TransferPair transferPair = sourceVector.makeTransferPair((ValueVector)toVector);
                for (int[] transferLength : transferLengths = new int[][]{{5, 22}, {5, 24}, {5, 25}, {5, 27}, {0, 31}, {5, 7}, {2, 3}}) {
                    int start = transferLength[0];
                    int length = transferLength[1];
                    transferPair.splitAndTransfer(start, length);
                    for (int i2 = 0; i2 < length; ++i2) {
                        int actual = toVector.get(i2);
                        int expected = sourceVector.get(start + i2);
                        Assert.assertEquals((String)("different data values not expected --> sourceVector index: " + (start + i2) + " toVector index: " + i2), (long)expected, (long)actual);
                    }
                }
            }
        }
    }

    @Test
    public void testReallocAfterVectorTransfer1() {
        try (BitVector vector = new BitVector(EMPTY_SCHEMA_PATH, this.allocator);){
            int i;
            vector.allocateNew(4096);
            int valueCapacity = vector.getValueCapacity();
            Assert.assertEquals((long)4096L, (long)valueCapacity);
            for (i = 0; i < valueCapacity; ++i) {
                if ((i & 1) != 1) continue;
                vector.setToOne(i);
            }
            for (i = 0; i < valueCapacity; ++i) {
                if ((i & 1) == 1) {
                    Assert.assertEquals((String)("unexpected cleared bit at index: " + i), (long)1L, (long)vector.get(i));
                    continue;
                }
                Assert.assertTrue((String)("unexpected set bit at index: " + i), (boolean)vector.isNull(i));
            }
            vector.setSafeToOne(valueCapacity);
            Assert.assertEquals((long)(valueCapacity * 2), (long)vector.getValueCapacity());
            for (i = valueCapacity; i < valueCapacity * 2; ++i) {
                if ((i & 1) != 1) continue;
                vector.setToOne(i);
            }
            for (i = 0; i < valueCapacity * 2; ++i) {
                if ((i & 1) == 1 || i == valueCapacity) {
                    Assert.assertEquals((String)("unexpected cleared bit at index: " + i), (long)1L, (long)vector.get(i));
                    continue;
                }
                Assert.assertTrue((String)("unexpected set bit at index: " + i), (boolean)vector.isNull(i));
            }
            vector.setSafeToOne(valueCapacity * 2);
            Assert.assertEquals((long)(valueCapacity * 4), (long)vector.getValueCapacity());
            for (i = valueCapacity * 2; i < valueCapacity * 4; ++i) {
                if ((i & 1) != 1) continue;
                vector.setToOne(i);
            }
            for (i = 0; i < valueCapacity * 4; ++i) {
                if ((i & 1) == 1 || i == valueCapacity || i == valueCapacity * 2) {
                    Assert.assertEquals((String)("unexpected cleared bit at index: " + i), (long)1L, (long)vector.get(i));
                    continue;
                }
                Assert.assertTrue((String)("unexpected set bit at index: " + i), (boolean)vector.isNull(i));
            }
            TransferPair transferPair = vector.getTransferPair(this.allocator);
            transferPair.transfer();
            BitVector toVector = (BitVector)transferPair.getTo();
            Assert.assertEquals((long)(valueCapacity * 4), (long)toVector.getValueCapacity());
            toVector.setSafeToOne(valueCapacity * 4);
            for (int i2 = 0; i2 < toVector.getValueCapacity(); ++i2) {
                if (i2 <= valueCapacity * 4) {
                    if ((i2 & 1) == 1 || i2 == valueCapacity || i2 == valueCapacity * 2 || i2 == valueCapacity * 4) {
                        Assert.assertEquals((String)("unexpected cleared bit at index: " + i2), (long)1L, (long)toVector.get(i2));
                        continue;
                    }
                    Assert.assertTrue((String)("unexpected set bit at index: " + i2), (boolean)toVector.isNull(i2));
                    continue;
                }
                Assert.assertTrue((String)("unexpected set bit at index: " + i2), (boolean)toVector.isNull(i2));
            }
            toVector.close();
        }
    }

    @Test
    public void testReallocAfterVectorTransfer2() {
        try (BitVector vector = new BitVector(EMPTY_SCHEMA_PATH, this.allocator);){
            int i;
            vector.allocateNew(4096);
            int valueCapacity = vector.getValueCapacity();
            Assert.assertEquals((long)4096L, (long)valueCapacity);
            for (i = 0; i < valueCapacity; ++i) {
                if ((i & 1) != 1) continue;
                vector.set(i, 1);
            }
            for (i = 0; i < valueCapacity; ++i) {
                if ((i & 1) == 1) {
                    Assert.assertFalse((String)("unexpected cleared bit at index: " + i), (boolean)vector.isNull(i));
                    continue;
                }
                Assert.assertTrue((String)("unexpected set bit at index: " + i), (boolean)vector.isNull(i));
            }
            vector.setSafe(valueCapacity, 1, 1);
            Assert.assertEquals((long)(valueCapacity * 2), (long)vector.getValueCapacity());
            for (i = valueCapacity; i < valueCapacity * 2; ++i) {
                if ((i & 1) != 1) continue;
                vector.set(i, 1);
            }
            for (i = 0; i < valueCapacity * 2; ++i) {
                if ((i & 1) == 1 || i == valueCapacity) {
                    Assert.assertFalse((String)("unexpected cleared bit at index: " + i), (boolean)vector.isNull(i));
                    continue;
                }
                Assert.assertTrue((String)("unexpected set bit at index: " + i), (boolean)vector.isNull(i));
            }
            vector.setSafe(valueCapacity * 2, 1, 1);
            Assert.assertEquals((long)(valueCapacity * 4), (long)vector.getValueCapacity());
            for (i = valueCapacity * 2; i < valueCapacity * 4; ++i) {
                if ((i & 1) != 1) continue;
                vector.set(i, 1);
            }
            for (i = 0; i < valueCapacity * 4; ++i) {
                if ((i & 1) == 1 || i == valueCapacity || i == valueCapacity * 2) {
                    Assert.assertFalse((String)("unexpected cleared bit at index: " + i), (boolean)vector.isNull(i));
                    continue;
                }
                Assert.assertTrue((String)("unexpected set bit at index: " + i), (boolean)vector.isNull(i));
            }
            TransferPair transferPair = vector.getTransferPair(this.allocator);
            transferPair.transfer();
            BitVector toVector = (BitVector)transferPair.getTo();
            Assert.assertEquals((long)(valueCapacity * 4), (long)toVector.getValueCapacity());
            toVector.setSafe(valueCapacity * 4, 1, 1);
            for (int i2 = 0; i2 < toVector.getValueCapacity(); ++i2) {
                if (i2 <= valueCapacity * 4) {
                    if ((i2 & 1) == 1 || i2 == valueCapacity || i2 == valueCapacity * 2 || i2 == valueCapacity * 4) {
                        Assert.assertFalse((String)("unexpected cleared bit at index: " + i2), (boolean)toVector.isNull(i2));
                        continue;
                    }
                    Assert.assertTrue((String)("unexpected set bit at index: " + i2), (boolean)toVector.isNull(i2));
                    continue;
                }
                Assert.assertTrue((String)("unexpected set bit at index: " + i2), (boolean)toVector.isNull(i2));
            }
            toVector.close();
        }
    }

    @Test
    public void testBitVector() {
        try (BitVector vector = new BitVector(EMPTY_SCHEMA_PATH, this.allocator);){
            int i;
            vector.allocateNew(1024);
            vector.setValueCount(1024);
            vector.set(0, 1);
            vector.set(1, 0);
            vector.set(100, 0);
            vector.set(1022, 1);
            vector.setValueCount(1024);
            Assert.assertEquals((long)1L, (long)vector.get(0));
            Assert.assertEquals((long)0L, (long)vector.get(1));
            Assert.assertEquals((long)0L, (long)vector.get(100));
            Assert.assertEquals((long)1L, (long)vector.get(1022));
            Assert.assertEquals((long)1020L, (long)vector.getNullCount());
            vector.set(0, 1);
            vector.set(0, 1);
            vector.set(1, 0);
            vector.set(1, 0);
            Assert.assertEquals((long)1L, (long)vector.get(0));
            Assert.assertEquals((long)0L, (long)vector.get(1));
            vector.set(0, 0);
            vector.set(1, 1);
            Assert.assertEquals((long)0L, (long)vector.get(0));
            Assert.assertEquals((long)1L, (long)vector.get(1));
            Assert.assertEquals((long)1020L, (long)vector.getNullCount());
            Assert.assertTrue((boolean)vector.isNull(3));
            vector.setNull(0);
            vector.setNull(1);
            vector.setNull(100);
            vector.setNull(1022);
            Assert.assertEquals((long)1024L, (long)vector.getNullCount());
            for (i = 0; i < 1024; ++i) {
                Assert.assertEquals((long)(1024 - i), (long)vector.getNullCount());
                vector.set(i, 1);
            }
            Assert.assertEquals((long)0L, (long)vector.getNullCount());
            vector.allocateNew(1015);
            vector.setValueCount(1015);
            Assert.assertEquals((long)1015L, (long)vector.getNullCount());
            vector.set(0, 1);
            vector.set(1014, 1);
            Assert.assertEquals((long)1013L, (long)vector.getNullCount());
            vector.zeroVector();
            Assert.assertEquals((long)1015L, (long)vector.getNullCount());
            for (i = 0; i < 1015; ++i) {
                Assert.assertEquals((long)(1015 - i), (long)vector.getNullCount());
                vector.set(i, 1);
            }
            Assert.assertEquals((long)0L, (long)vector.getNullCount());
        }
    }

    @Test
    public void testBitVectorRangeSetAllOnes() {
        this.validateRange(1000, 0, 1000);
        this.validateRange(1000, 0, 1);
        this.validateRange(1000, 1, 2);
        this.validateRange(1000, 5, 6);
        this.validateRange(1000, 5, 10);
        this.validateRange(1000, 5, 150);
        this.validateRange(1000, 5, 27);
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 8; ++j) {
                this.validateRange(1000, 10 + i, 27 + j);
                this.validateRange(1000, i, j);
            }
        }
    }

    private void validateRange(int length, int start, int count) {
        String desc = "[" + start + ", " + (start + count) + ") ";
        try (BitVector bitVector = new BitVector("bits", this.allocator);){
            int i;
            bitVector.reset();
            bitVector.allocateNew(length);
            bitVector.setRangeToOne(start, count);
            for (i = 0; i < start; ++i) {
                Assert.assertTrue((String)(desc + i), (boolean)bitVector.isNull(i));
            }
            for (i = start; i < start + count; ++i) {
                Assert.assertEquals((String)(desc + i), (long)1L, (long)bitVector.get(i));
            }
            for (i = start + count; i < length; ++i) {
                Assert.assertTrue((String)(desc + i), (boolean)bitVector.isNull(i));
            }
        }
    }

    @Test
    public void testBitVectorHashCode() {
        int size = 6;
        try (BitVector vector = new BitVector(EMPTY_SCHEMA_PATH, this.allocator);){
            ValueVectorDataPopulator.setVector(vector, 0, 1, null, 0, 1, null);
            int[] hashCodes = new int[6];
            IntStream.range(0, 6).forEach(i -> {
                hashCodes[i] = vector.hashCode(i);
            });
            Assert.assertTrue((hashCodes[0] == hashCodes[3] ? 1 : 0) != 0);
            Assert.assertTrue((hashCodes[1] == hashCodes[4] ? 1 : 0) != 0);
            Assert.assertTrue((hashCodes[2] == hashCodes[5] ? 1 : 0) != 0);
            Assert.assertFalse((hashCodes[0] == hashCodes[1] ? 1 : 0) != 0);
            Assert.assertFalse((hashCodes[0] == hashCodes[2] ? 1 : 0) != 0);
            Assert.assertFalse((hashCodes[1] == hashCodes[2] ? 1 : 0) != 0);
            MurmurHasher hasher = new MurmurHasher();
            IntStream.range(0, 6).forEach(i -> {
                hashCodes[i] = vector.hashCode(i, (ArrowBufHasher)hasher);
            });
            Assert.assertTrue((hashCodes[0] == hashCodes[3] ? 1 : 0) != 0);
            Assert.assertTrue((hashCodes[1] == hashCodes[4] ? 1 : 0) != 0);
            Assert.assertTrue((hashCodes[2] == hashCodes[5] ? 1 : 0) != 0);
            Assert.assertFalse((hashCodes[0] == hashCodes[1] ? 1 : 0) != 0);
            Assert.assertFalse((hashCodes[0] == hashCodes[2] ? 1 : 0) != 0);
            Assert.assertFalse((hashCodes[1] == hashCodes[2] ? 1 : 0) != 0);
        }
    }
}

