/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.vector;

import java.math.BigDecimal;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.DecimalVector;
import org.apache.arrow.vector.FixedSizeBinaryVector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.LargeVarCharVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.holders.NullableDecimalHolder;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ITTestLargeVector {
    private static final Logger logger = LoggerFactory.getLogger(ITTestLargeVector.class);

    @Test
    public void testLargeLongVector() {
        logger.trace("Testing large big int vector.");
        long bufSize = 0x100000000L;
        int vecLength = 0x20000000;
        try (RootAllocator allocator = new RootAllocator(Long.MAX_VALUE);
             BigIntVector largeVec = new BigIntVector("vec", (BufferAllocator)allocator);){
            int i;
            largeVec.allocateNew(0x20000000);
            logger.trace("Successfully allocated a vector with capacity {}", (Object)0x20000000);
            for (i = 0; i < 0x20000000; ++i) {
                largeVec.set(i, (long)i * 10L);
                if ((i + 1) % 10000 != 0) continue;
                logger.trace("Successfully written {} values", (Object)(i + 1));
            }
            logger.trace("Successfully written {} values", (Object)0x20000000);
            for (i = 0; i < 0x20000000; ++i) {
                long val = largeVec.get(i);
                Assert.assertEquals((long)((long)i * 10L), (long)val);
                if ((i + 1) % 10000 != 0) continue;
                logger.trace("Successfully read {} values", (Object)(i + 1));
            }
            logger.trace("Successfully read {} values", (Object)0x20000000);
        }
        logger.trace("Successfully released the large vector.");
    }

    @Test
    public void testLargeIntVector() {
        logger.trace("Testing large int vector.");
        long bufSize = 0x100000000L;
        int vecLength = 0x40000000;
        try (RootAllocator allocator = new RootAllocator(Long.MAX_VALUE);
             IntVector largeVec = new IntVector("vec", (BufferAllocator)allocator);){
            int i;
            largeVec.allocateNew(0x40000000);
            logger.trace("Successfully allocated a vector with capacity {}", (Object)0x40000000);
            for (i = 0; i < 0x40000000; ++i) {
                largeVec.set(i, i);
                if ((i + 1) % 10000 != 0) continue;
                logger.trace("Successfully written {} values", (Object)(i + 1));
            }
            logger.trace("Successfully written {} values", (Object)0x40000000);
            for (i = 0; i < 0x40000000; ++i) {
                long val = largeVec.get(i);
                Assert.assertEquals((long)i, (long)val);
                if ((i + 1) % 10000 != 0) continue;
                logger.trace("Successfully read {} values", (Object)(i + 1));
            }
            logger.trace("Successfully read {} values", (Object)0x40000000);
        }
        logger.trace("Successfully released the large vector.");
    }

    @Test
    public void testLargeDecimalVector() {
        logger.trace("Testing large decimal vector.");
        long bufSize = 0x100000000L;
        int vecLength = 0x10000000;
        try (RootAllocator allocator = new RootAllocator(Long.MAX_VALUE);
             DecimalVector largeVec = new DecimalVector("vec", (BufferAllocator)allocator, 38, 0);){
            int i;
            largeVec.allocateNew(0x10000000);
            logger.trace("Successfully allocated a vector with capacity {}", (Object)0x10000000);
            for (i = 0; i < 0x10000000; ++i) {
                largeVec.set(i, 0L);
                if ((i + 1) % 10000 != 0) continue;
                logger.trace("Successfully written {} values", (Object)(i + 1));
            }
            logger.trace("Successfully written {} values", (Object)0x10000000);
            for (i = 0; i < 0x10000000; ++i) {
                ArrowBuf buf = largeVec.get(i);
                Assert.assertEquals((long)buf.capacity(), (long)16L);
                Assert.assertEquals((long)0L, (long)buf.getLong(0L));
                Assert.assertEquals((long)0L, (long)buf.getLong(8L));
                if ((i + 1) % 10000 != 0) continue;
                logger.trace("Successfully read {} values", (Object)(i + 1));
            }
            logger.trace("Successfully read {} values", (Object)0x10000000);
            largeVec.set(0xFFFFFFF, 12345L);
            Assert.assertEquals((long)12345L, (long)largeVec.getObject(0xFFFFFFF).longValue());
            NullableDecimalHolder holder = new NullableDecimalHolder();
            holder.buffer = largeVec.valueBuffer;
            holder.isSet = 1;
            holder.start = 0xFFFFFFFL * (long)largeVec.getTypeWidth();
            Assert.assertTrue((holder.start > Integer.MAX_VALUE ? 1 : 0) != 0);
            largeVec.set(0, holder);
            BigDecimal decimal = largeVec.getObject(0);
            Assert.assertEquals((long)12345L, (long)decimal.longValue());
            logger.trace("Successfully setting values from large offsets");
        }
        logger.trace("Successfully released the large vector.");
    }

    @Test
    public void testLargeFixedSizeBinaryVector() {
        logger.trace("Testing large fixed size binary vector.");
        long bufSize = 0x100000000L;
        int typeWidth = 8;
        int vecLength = 0x20000000;
        try (RootAllocator allocator = new RootAllocator(Long.MAX_VALUE);
             FixedSizeBinaryVector largeVec = new FixedSizeBinaryVector("vec", (BufferAllocator)allocator, 8);){
            int i;
            largeVec.allocateNew(0x20000000);
            logger.trace("Successfully allocated a vector with capacity {}", (Object)0x20000000);
            byte[] value = new byte[]{97, 98, 99, 100, 101, 102, 103, 104};
            for (i = 0; i < 0x20000000; ++i) {
                largeVec.set(i, value);
                if ((i + 1) % 10000 != 0) continue;
                logger.trace("Successfully written {} values", (Object)(i + 1));
            }
            logger.trace("Successfully written {} values", (Object)0x20000000);
            for (i = 0; i < 0x20000000; ++i) {
                byte[] buf = largeVec.get(i);
                Assert.assertEquals((long)8L, (long)buf.length);
                Assert.assertArrayEquals((byte[])buf, (byte[])value);
                if ((i + 1) % 10000 != 0) continue;
                logger.trace("Successfully read {} values", (Object)(i + 1));
            }
            logger.trace("Successfully read {} values", (Object)0x20000000);
        }
        logger.trace("Successfully released the large vector.");
    }

    @Test
    public void testLargeVarCharVector() {
        logger.trace("Testing large var char vector.");
        long bufSize = 0x100000000L;
        int vecLength = 0x40000000;
        String strElement = "a";
        try (RootAllocator allocator = new RootAllocator(Long.MAX_VALUE);
             VarCharVector largeVec = new VarCharVector("vec", (BufferAllocator)allocator);){
            int i;
            largeVec.allocateNew(0x40000000);
            logger.trace("Successfully allocated a vector with capacity 1073741824");
            for (i = 0; i < 0x40000000; ++i) {
                largeVec.setSafe(i, "a".getBytes());
                if ((i + 1) % 10000 != 0) continue;
                logger.trace("Successfully written " + (i + 1) + " values");
            }
            largeVec.setValueCount(0x40000000);
            Assert.assertTrue((largeVec.getOffsetBuffer().readableBytes() > Integer.MAX_VALUE ? 1 : 0) != 0);
            Assert.assertTrue((largeVec.getDataBuffer().readableBytes() < Integer.MAX_VALUE ? 1 : 0) != 0);
            logger.trace("Successfully written 1073741824 values");
            for (i = 0; i < 0x40000000; ++i) {
                byte[] val = largeVec.get(i);
                Assert.assertEquals((Object)"a", (Object)new String(val));
                if ((i + 1) % 10000 != 0) continue;
                logger.trace("Successfully read " + (i + 1) + " values");
            }
            logger.trace("Successfully read 1073741824 values");
        }
        logger.trace("Successfully released the large vector.");
    }

    @Test
    public void testLargeLargeVarCharVector() {
        logger.trace("Testing large large var char vector.");
        long bufSize = 0x100000000L;
        int vecLength = 0x20000000;
        String strElement = "9876543210";
        try (RootAllocator allocator = new RootAllocator(Long.MAX_VALUE);
             LargeVarCharVector largeVec = new LargeVarCharVector("vec", (BufferAllocator)allocator);){
            int i;
            largeVec.allocateNew(0x20000000);
            logger.trace("Successfully allocated a vector with capacity 536870912");
            for (i = 0; i < 0x20000000; ++i) {
                largeVec.setSafe(i, "9876543210".getBytes());
                if ((i + 1) % 10000 != 0) continue;
                logger.trace("Successfully written " + (i + 1) + " values");
            }
            largeVec.setValueCount(0x20000000);
            Assert.assertTrue((largeVec.getOffsetBuffer().readableBytes() > Integer.MAX_VALUE ? 1 : 0) != 0);
            Assert.assertTrue((largeVec.getDataBuffer().readableBytes() > Integer.MAX_VALUE ? 1 : 0) != 0);
            logger.trace("Successfully written 536870912 values");
            for (i = 0; i < 0x20000000; ++i) {
                byte[] val = largeVec.get(i);
                Assert.assertEquals((Object)"9876543210", (Object)new String(val));
                if ((i + 1) % 10000 != 0) continue;
                logger.trace("Successfully read " + (i + 1) + " values");
            }
            logger.trace("Successfully read 536870912 values");
        }
        logger.trace("Successfully released the large vector.");
    }
}

