/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util.component;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelException;
import org.apache.camel.ComponentConfiguration;
import org.apache.camel.Endpoint;
import org.apache.camel.impl.UriEndpointComponent;
import org.apache.camel.spi.EndpointCompleter;
import org.apache.camel.spi.Metadata;
import org.apache.camel.util.IntrospectionSupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.component.ApiCollection;
import org.apache.camel.util.component.ApiMethod;
import org.apache.camel.util.component.ApiMethodHelper;

public abstract class AbstractApiComponent<E extends Enum<E>, T, S extends ApiCollection<E, T>>
extends UriEndpointComponent
implements EndpointCompleter {
    @Metadata(label="advanced")
    protected T configuration;
    protected final S collection;
    protected final Class<E> apiNameClass;

    public AbstractApiComponent(Class<? extends Endpoint> endpointClass, Class<E> apiNameClass, S collection) {
        super(endpointClass);
        this.collection = collection;
        this.apiNameClass = apiNameClass;
    }

    public AbstractApiComponent(CamelContext context, Class<? extends Endpoint> endpointClass, Class<E> apiNameClass, S collection) {
        super(context, endpointClass);
        this.collection = collection;
        this.apiNameClass = apiNameClass;
    }

    @Override
    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        String methodName;
        String apiNameStr;
        String[] pathElements = remaining.split("/");
        switch (pathElements.length) {
            case 1: {
                apiNameStr = "";
                methodName = pathElements[0];
                break;
            }
            case 2: {
                apiNameStr = pathElements[0];
                methodName = pathElements[1];
                break;
            }
            default: {
                throw new CamelException("Invalid URI path [" + remaining + "], must be of the format " + ((ApiCollection)this.collection).getApiNames() + "/<operation-name>");
            }
        }
        try {
            E apiName = this.getApiName(apiNameStr);
            T endpointConfiguration = this.createEndpointConfiguration(apiName);
            Endpoint endpoint = this.createEndpoint(uri, methodName, apiName, endpointConfiguration);
            this.setProperties(endpoint, parameters);
            endpoint.configureProperties(parameters);
            return endpoint;
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof IllegalArgumentException) {
                throw new CamelException("Invalid URI path prefix [" + remaining + "], must be one of " + ((ApiCollection)this.collection).getApiNames());
            }
            throw e;
        }
    }

    protected abstract E getApiName(String var1) throws IllegalArgumentException;

    protected abstract Endpoint createEndpoint(String var1, String var2, E var3, T var4);

    protected T createEndpointConfiguration(E name) throws Exception {
        HashMap<String, Object> componentProperties = new HashMap<String, Object>();
        if (this.configuration != null) {
            IntrospectionSupport.getProperties(this.configuration, componentProperties, null, false);
        }
        Object endpointConfiguration = ((ApiCollection)this.collection).getEndpointConfiguration(name);
        IntrospectionSupport.setProperties(endpointConfiguration, componentProperties);
        return endpointConfiguration;
    }

    public T getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(T configuration) {
        this.configuration = configuration;
    }

    @Override
    public List<String> completeEndpointPath(ComponentConfiguration configuration, String completionText) {
        ArrayList<String> result;
        block11: {
            Map apiHelpers;
            int pathEnd;
            boolean useDefaultName;
            block13: {
                int prefixEnd;
                block12: {
                    result = new ArrayList<String>();
                    Set<String> apiNames = ((ApiCollection)this.collection).getApiNames();
                    useDefaultName = apiNames.size() == 1 && apiNames.contains("");
                    completionText = ObjectHelper.isEmpty(completionText) ? "" : completionText;
                    prefixEnd = completionText.indexOf(47);
                    pathEnd = completionText.lastIndexOf(63);
                    apiHelpers = ((ApiCollection)this.collection).getApiHelpers();
                    if (prefixEnd != -1 || pathEnd != -1) break block12;
                    if (useDefaultName) {
                        Set<Class<ApiMethod>> apiMethods = ((ApiCollection)this.collection).getApiMethods().keySet();
                        Class<ApiMethod> apiMethod = apiMethods.iterator().next();
                        ApiMethodHelper<ApiMethod> helper = apiHelpers.values().iterator().next();
                        this.getCompletedMethods(result, completionText, apiMethod, helper);
                    } else {
                        for (String name : apiNames) {
                            if (name.isEmpty() && !name.startsWith(completionText)) continue;
                            result.add(name);
                        }
                    }
                    break block11;
                }
                if (prefixEnd == -1 || pathEnd != -1) break block13;
                E apiName = this.getApiNameOrNull(completionText.substring(0, prefixEnd));
                if (apiName == null) break block11;
                ApiMethodHelper<ApiMethod> helper = apiHelpers.get(apiName);
                completionText = completionText.substring(prefixEnd + 1);
                for (Map.Entry entry : ((ApiCollection)this.collection).getApiMethods().entrySet()) {
                    if (!((Enum)entry.getValue()).equals(apiName)) continue;
                    this.getCompletedMethods(result, completionText, entry.getKey(), helper);
                    break block11;
                }
                break block11;
            }
            int lastParam = completionText.lastIndexOf(38);
            String optionText = lastParam != -1 ? completionText.substring(lastParam + 1) : completionText.substring(pathEnd);
            String methodName = null;
            ApiMethodHelper<ApiMethod> helper = null;
            if (useDefaultName) {
                methodName = completionText.substring(0, pathEnd);
                helper = apiHelpers.values().iterator().next();
            } else {
                String[] pathElements = completionText.substring(0, pathEnd).split("/");
                if (pathElements.length == 2) {
                    E apiName = this.getApiNameOrNull(pathElements[0]);
                    methodName = pathElements[1];
                    helper = ((ApiCollection)this.collection).getHelper(apiName);
                }
            }
            if (helper == null || ObjectHelper.isEmpty(methodName)) break block11;
            Set<String> existingOptions = configuration.getParameters().keySet();
            try {
                List<Object> arguments = helper.getArguments(methodName);
                int nArgs = arguments.size();
                HashSet<String> options = new HashSet<String>();
                for (int i = 1; i < nArgs; i += 2) {
                    options.add((String)arguments.get(i));
                }
                options.removeAll(existingOptions);
                for (String option : options) {
                    if (!option.startsWith(optionText)) continue;
                    result.add(option);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return result;
    }

    protected E getApiNameOrNull(String nameStr) {
        try {
            return this.getApiName(nameStr);
        }
        catch (IllegalArgumentException ignore) {
            return null;
        }
    }

    protected void getCompletedMethods(List<String> result, String completionText, Class<? extends ApiMethod> apiMethod, ApiMethodHelper<? extends ApiMethod> helper) {
        ApiMethod[] methods;
        for (ApiMethod method : methods = apiMethod.getEnumConstants()) {
            String name = method.getName();
            if (!name.startsWith(completionText)) continue;
            result.add(name);
        }
        Map<String, Set<String>> aliases = helper.getAliases();
        for (String alias : aliases.keySet()) {
            if (!alias.startsWith(completionText)) continue;
            result.add(alias);
        }
    }
}

