/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.strategy;

import java.io.File;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Exchange;
import org.apache.camel.LoggingLevel;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.GenericFileEndpoint;
import org.apache.camel.component.file.GenericFileExclusiveReadLockStrategy;
import org.apache.camel.component.file.GenericFileOperations;
import org.apache.camel.component.file.strategy.FileChangedExclusiveReadLockStrategy;
import org.apache.camel.spi.IdempotentRepository;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.CamelLogger;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileIdempotentChangedRepositoryReadLockStrategy
extends ServiceSupport
implements GenericFileExclusiveReadLockStrategy<File>,
CamelContextAware {
    private static final transient Logger LOG = LoggerFactory.getLogger(FileIdempotentChangedRepositoryReadLockStrategy.class);
    private final FileChangedExclusiveReadLockStrategy changed;
    private GenericFileEndpoint<File> endpoint;
    private LoggingLevel readLockLoggingLevel = LoggingLevel.WARN;
    private CamelContext camelContext;
    private IdempotentRepository<String> idempotentRepository;
    private boolean removeOnRollback = true;
    private boolean removeOnCommit;

    public FileIdempotentChangedRepositoryReadLockStrategy() {
        this.changed = new FileChangedExclusiveReadLockStrategy();
        this.changed.setMarkerFiler(false);
        this.changed.setDeleteOrphanLockFiles(false);
    }

    @Override
    public void prepareOnStartup(GenericFileOperations<File> operations, GenericFileEndpoint<File> endpoint) throws Exception {
        this.endpoint = endpoint;
        LOG.info("Using FileIdempotentRepositoryReadLockStrategy: {} on endpoint: {}", (Object)this.idempotentRepository, (Object)endpoint);
        this.changed.prepareOnStartup(operations, endpoint);
    }

    @Override
    public boolean acquireExclusiveReadLock(GenericFileOperations<File> operations, GenericFile<File> file, Exchange exchange) throws Exception {
        File path = file.getFile();
        if (!path.exists()) {
            return false;
        }
        String key = this.asKey(file);
        boolean answer = this.idempotentRepository.add(key);
        if (!answer) {
            CamelLogger.log(LOG, this.readLockLoggingLevel, "Cannot acquire read lock. Will skip the file: " + file);
        }
        if (answer && !(answer = this.changed.acquireExclusiveReadLock(operations, file, exchange))) {
            this.idempotentRepository.remove(key);
        }
        return answer;
    }

    @Override
    public void releaseExclusiveReadLockOnAbort(GenericFileOperations<File> operations, GenericFile<File> file, Exchange exchange) throws Exception {
        this.changed.releaseExclusiveReadLockOnAbort(operations, file, exchange);
    }

    @Override
    public void releaseExclusiveReadLockOnRollback(GenericFileOperations<File> operations, GenericFile<File> file, Exchange exchange) throws Exception {
        String key = this.asKey(file);
        if (this.removeOnRollback) {
            this.idempotentRepository.remove(key);
        } else {
            this.idempotentRepository.confirm(key);
        }
        this.changed.releaseExclusiveReadLockOnRollback(operations, file, exchange);
    }

    @Override
    public void releaseExclusiveReadLockOnCommit(GenericFileOperations<File> operations, GenericFile<File> file, Exchange exchange) throws Exception {
        String key = this.asKey(file);
        if (this.removeOnCommit) {
            this.idempotentRepository.remove(key);
        } else {
            this.idempotentRepository.confirm(key);
        }
        this.changed.releaseExclusiveReadLockOnCommit(operations, file, exchange);
    }

    @Override
    public void setTimeout(long timeout) {
        this.changed.setTimeout(timeout);
    }

    @Override
    public void setCheckInterval(long checkInterval) {
        this.changed.setCheckInterval(checkInterval);
    }

    @Override
    public void setReadLockLoggingLevel(LoggingLevel readLockLoggingLevel) {
        this.readLockLoggingLevel = readLockLoggingLevel;
        this.changed.setReadLockLoggingLevel(readLockLoggingLevel);
    }

    @Override
    public void setMarkerFiler(boolean markerFile) {
    }

    @Override
    public void setDeleteOrphanLockFiles(boolean deleteOrphanLockFiles) {
    }

    public void setMinLength(long minLength) {
        this.changed.setMinLength(minLength);
    }

    public void setMinAge(long minAge) {
        this.changed.setMinAge(minAge);
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public IdempotentRepository<String> getIdempotentRepository() {
        return this.idempotentRepository;
    }

    public void setIdempotentRepository(IdempotentRepository<String> idempotentRepository) {
        this.idempotentRepository = idempotentRepository;
    }

    public boolean isRemoveOnRollback() {
        return this.removeOnRollback;
    }

    public void setRemoveOnRollback(boolean removeOnRollback) {
        this.removeOnRollback = removeOnRollback;
    }

    public boolean isRemoveOnCommit() {
        return this.removeOnCommit;
    }

    public void setRemoveOnCommit(boolean removeOnCommit) {
        this.removeOnCommit = removeOnCommit;
    }

    protected String asKey(GenericFile<File> file) {
        String key = file.getAbsoluteFilePath();
        if (this.endpoint.getIdempotentKey() != null) {
            Exchange dummy = this.endpoint.createExchange(file);
            key = this.endpoint.getIdempotentKey().evaluate(dummy, String.class);
        }
        return key;
    }

    @Override
    protected void doStart() throws Exception {
        ObjectHelper.notNull(this.camelContext, "camelContext", this);
        ObjectHelper.notNull(this.idempotentRepository, "idempotentRepository", this);
        this.camelContext.addService(this.idempotentRepository, true);
    }

    @Override
    protected void doStop() throws Exception {
    }
}

