/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.xml;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathVariableResolver;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageVariableResolver
implements XPathVariableResolver {
    private static final Logger LOG = LoggerFactory.getLogger(MessageVariableResolver.class);
    private Map<String, Object> variables = new HashMap<String, Object>();
    private final ThreadLocal<Exchange> exchange;

    public MessageVariableResolver(ThreadLocal<Exchange> exchange) {
        this.exchange = exchange;
    }

    @Override
    public Object resolveVariable(QName name) {
        Message out;
        String uri = name.getNamespaceURI();
        String localPart = name.getLocalPart();
        Object answer = null;
        Message in = this.exchange.get().getIn();
        if (uri == null || uri.length() == 0) {
            answer = this.variables.get(localPart);
            if (answer == null) {
                Message message = in;
                if (message != null) {
                    answer = message.getHeader(localPart);
                }
                if (answer == null) {
                    answer = this.exchange.get().getProperty(localPart);
                }
            }
        } else if (uri.equals("http://camel.apache.org/xml/variables/system-properties")) {
            try {
                answer = System.getProperty(localPart);
            }
            catch (Exception e) {
                LOG.debug("Security exception evaluating system property: " + localPart + ". Reason: " + e, e);
            }
        } else if (uri.equals("http://camel.apache.org/xml/variables/environment-variables")) {
            answer = System.getenv().get(localPart);
        } else if (uri.equals("http://camel.apache.org/xml/variables/exchange-property")) {
            answer = this.exchange.get().getProperty(localPart);
        } else if (uri.equals("http://camel.apache.org/xml/in/")) {
            answer = in.getHeader(localPart);
            if (answer == null && localPart.equals("body")) {
                answer = in.getBody();
            }
        } else if (uri.equals("http://camel.apache.org/xml/out/") && this.exchange.get().hasOut() && (answer = (out = this.exchange.get().getOut()).getHeader(localPart)) == null && localPart.equals("body")) {
            answer = out.getBody();
        }
        if (answer == null) {
            return "";
        }
        return answer;
    }

    public void addVariable(String localPart, Object value) {
        this.variables.put(localPart, value);
    }
}

