/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.io.kryo.jena;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.aksw.jenax.io.kryo.jena.ByteArrayUtils;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFFormat;

public abstract class RiotSerializerBase<T>
extends Serializer<T> {
    protected Lang lang;
    protected RDFFormat format;

    public RiotSerializerBase(Lang lang, RDFFormat format) {
        this.lang = lang;
        this.format = format;
    }

    protected abstract void writeActual(T var1, OutputStream var2);

    protected abstract T readActual(InputStream var1);

    public final void write(Kryo kryo, Output output, T obj) {
        ByteArrayOutputStream tmp = new ByteArrayOutputStream();
        this.writeActual(obj, tmp);
        byte[] bytes = tmp.toByteArray();
        ByteArrayUtils.write(output, bytes);
    }

    public final T read(Kryo kryo, Input input, Class<T> objClass) {
        byte[] bytes = ByteArrayUtils.read(input);
        ByteArrayInputStream tmp = new ByteArrayInputStream(bytes);
        T result = this.readActual(tmp);
        return result;
    }
}

