/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.io.kryo.jena;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.google.gson.Gson;
import java.util.function.Function;
import org.aksw.jena_sparql_api.io.json.RDFNodeJsonUtils;
import org.apache.jena.rdf.model.RDFNode;

public class RDFNodeSerializer<T extends RDFNode>
extends Serializer<T> {
    protected Gson gson;
    protected Function<? super RDFNode, T> fn;

    public RDFNodeSerializer(Function<? super RDFNode, T> fn, Gson gson) {
        this.fn = fn;
        this.gson = gson;
    }

    public T read(Kryo kryo, Input input, Class<T> clazz) {
        String jsonNodeLdString = input.readString();
        RDFNode rdfNode = RDFNodeJsonUtils.toRDFNode((String)jsonNodeLdString, (Gson)this.gson);
        RDFNode result = (RDFNode)this.fn.apply((RDFNode)rdfNode);
        return (T)result;
    }

    public void write(Kryo kryo, Output output, T rdfNode) {
        String jsonNodeLdString = RDFNodeJsonUtils.toJsonNodeString(rdfNode, (Gson)this.gson);
        output.writeString(jsonNodeLdString);
    }
}

