/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.io.kryo.jena;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.TypeMapper;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.vocabulary.XSD;

public class GenericNodeSerializerCustom
extends Serializer<Node> {
    public static final int TYPE_MASK = 240;
    public static final int TYPE_IRI = 16;
    public static final int TYPE_BNODE = 32;
    public static final int TYPE_LITERAL = 48;
    public static final int TYPE_VAR = 64;
    public static final int TYPE_TRIPLE = 80;
    public static final int SUBTYPE_MASK = 15;
    public static final int LITERAL_HAS_LANG = 1;
    public static final int LITERAL_HAS_DTYPE = 2;
    protected TypeMapper typeMapper;

    public GenericNodeSerializerCustom() {
        this(TypeMapper.getInstance());
    }

    public GenericNodeSerializerCustom(TypeMapper typeMapper) {
        this.typeMapper = typeMapper;
    }

    public void write(Kryo kryo, Output output, Node node) {
        if (node.isURI()) {
            output.writeByte(16);
            output.writeString(node.getURI());
        } else if (node.isLiteral()) {
            String lex = node.getLiteralLexicalForm();
            String lang = node.getLiteralLanguage();
            String dt = node.getLiteralDatatypeURI();
            if (lang != null && !lang.isEmpty()) {
                output.writeByte(49);
                output.writeString(lex);
                output.writeString(lang);
            } else if (dt != null && !dt.isEmpty() && !dt.equals(XSD.xstring.getURI())) {
                output.writeByte(50);
                output.writeString(lex);
                output.writeString(dt);
            } else {
                output.writeByte(48);
                output.writeString(lex);
            }
        } else if (node.isBlank()) {
            output.writeByte(32);
            output.writeString(node.getBlankNodeLabel());
        } else if (node.isVariable()) {
            output.writeByte(64);
            output.writeString(node.getName());
        } else if (node.isNodeTriple()) {
            output.writeByte(80);
            kryo.writeObject(output, (Object)node.getTriple());
        } else {
            throw new RuntimeException("Unknown node type: " + node);
        }
    }

    public Node read(Kryo kryo, Input input, Class<Node> cls) {
        Node result;
        byte type = input.readByte();
        int typeVal = type & 0xF0;
        block0 : switch (typeVal) {
            case 16: {
                String v1 = input.readString();
                result = NodeFactory.createURI((String)v1);
                break;
            }
            case 48: {
                int subTypeVal = type & 0xF;
                switch (subTypeVal) {
                    case 0: {
                        String v1 = input.readString();
                        result = NodeFactory.createLiteral((String)v1);
                        break block0;
                    }
                    case 1: {
                        String v1 = input.readString();
                        String v2 = input.readString();
                        result = NodeFactory.createLiteral((String)v1, (String)v2);
                        break block0;
                    }
                    case 2: {
                        String v1 = input.readString();
                        String v2 = input.readString();
                        RDFDatatype dtype = this.typeMapper.getSafeTypeByName(v2);
                        result = NodeFactory.createLiteral((String)v1, (RDFDatatype)dtype);
                        break block0;
                    }
                }
                throw new RuntimeException("Unknown literal sub-type: " + subTypeVal);
            }
            case 32: {
                String v1 = input.readString();
                result = NodeFactory.createBlankNode((String)v1);
                break;
            }
            case 64: {
                String v1 = input.readString();
                result = Var.alloc((String)v1);
                break;
            }
            case 80: {
                Triple t = (Triple)kryo.readObject(input, Triple.class);
                result = NodeFactory.createTripleNode((Triple)t);
                break;
            }
            default: {
                throw new RuntimeException("Unknown node type: " + typeVal);
            }
        }
        return result;
    }
}

