/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.sparql.relation.api;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.aksw.jena_sparql_api.concepts.BinaryRelationImpl;
import org.aksw.jena_sparql_api.concepts.Concept;
import org.aksw.jenax.sparql.relation.api.GeneralizedBinaryRelation;
import org.aksw.jenax.sparql.relation.api.Relation;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.core.BasicPattern;
import org.apache.jena.sparql.core.PathBlock;
import org.apache.jena.sparql.core.TriplePath;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.graph.NodeTransform;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementGroup;
import org.apache.jena.sparql.syntax.ElementPathBlock;
import org.apache.jena.sparql.syntax.ElementTriplesBlock;

public interface BinaryRelation
extends GeneralizedBinaryRelation {
    public Var getSourceVar();

    public Var getTargetVar();

    @Override
    default public Set<Var> getSourceVars() {
        return Collections.singleton(this.getSourceVar());
    }

    @Override
    default public Set<Var> getTargetVars() {
        return Collections.singleton(this.getTargetVar());
    }

    default public Set<Var> getMarkedVars() {
        LinkedHashSet<Var> result = new LinkedHashSet<Var>(Arrays.asList(this.getSourceVar(), this.getTargetVar()));
        return result;
    }

    default public Set<Var> getIntermediaryVars() {
        Set<Var> mentionedVars = this.getVarsMentioned();
        Set<Var> markedVars = this.getMarkedVars();
        Sets.SetView result = Sets.difference(mentionedVars, markedVars);
        return result;
    }

    default public BinaryRelation reverse() {
        BinaryRelationImpl result = new BinaryRelationImpl(this.getElement(), this.getTargetVar(), this.getSourceVar());
        return result;
    }

    default public boolean isEmpty() {
        boolean result;
        Element e = this.getElement();
        if (e instanceof ElementGroup) {
            ElementGroup g = (ElementGroup)e;
            result = g.getElements().isEmpty();
        } else {
            result = false;
        }
        return result;
    }

    default public Concept getSourceConcept() {
        Concept result = new Concept(this.getElement(), this.getSourceVar());
        return result;
    }

    default public Concept getTargetConcept() {
        Concept result = new Concept(this.getElement(), this.getTargetVar());
        return result;
    }

    @Override
    default public BinaryRelation applyNodeTransform(NodeTransform nodeTransform) {
        BinaryRelation result = Relation.applyDefaultNodeTransform(this, nodeTransform).toBinaryRelation();
        return result;
    }

    default public TriplePath getAsTripleOrTriplePath() {
        Triple t = this.getAsTriple();
        TriplePath result = t != null ? new TriplePath(t) : this.getAsTriplePath();
        return result;
    }

    default public TriplePath getAsTriplePath() {
        ElementPathBlock epb;
        PathBlock pb;
        List tps;
        TriplePath result = null;
        Element elt = this.getElement();
        if (elt instanceof ElementPathBlock && (tps = (pb = (epb = (ElementPathBlock)elt).getPattern()).getList()).size() == 1) {
            result = (TriplePath)tps.get(0);
        }
        return result;
    }

    default public Triple getAsTriple() {
        ElementTriplesBlock block;
        BasicPattern bp;
        List tps;
        Triple result = null;
        Element elt = this.getElement();
        if (elt instanceof ElementTriplesBlock && (tps = (bp = (block = (ElementTriplesBlock)elt).getPattern()).getList()).size() == 1) {
            result = (Triple)tps.get(0);
        }
        return result;
    }
}

