/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.concepts;

import com.google.common.collect.Streams;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.aksw.jenax.arq.util.syntax.ElementUtils;
import org.aksw.jenax.arq.util.var.Vars;
import org.aksw.jenax.sparql.relation.api.UnaryRelation;
import org.aksw.jenax.stmt.parser.prologue.SparqlPrologueParserImpl;
import org.aksw.jenax.stmt.parser.query.SparqlQueryParserImpl;
import org.aksw.jenax.stmt.parser.query.SparqlQueryParserWrapperSelectShortForm;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Query;
import org.apache.jena.query.Syntax;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.core.Prologue;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.graph.NodeTransform;
import org.apache.jena.sparql.lang.ParserSPARQL11;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementData;
import org.apache.jena.sparql.syntax.ElementGroup;
import org.apache.jena.sparql.syntax.ElementTriplesBlock;

public class Concept
implements UnaryRelation {
    private Element element;
    private Var var;
    public static final Concept TOP = Concept.create("", "s");
    public static final Concept BOTTOM = Concept.create("", "s");

    public static Concept parse(String str) {
        return Concept.parse(str, null);
    }

    public static Concept createFromQuery(Query query) {
        if (!query.isSelectType()) {
            throw new RuntimeException("Query must be of select type");
        }
        if (query.getProjectVars().size() != 1) {
            throw new RuntimeException("Query must have exactly 1 result variable");
        }
        Var var = (Var)query.getProjectVars().get(0);
        Concept result = new Concept(query.getQueryPattern(), var);
        return result;
    }

    public static Concept parse(String str, PrefixMapping pm) {
        pm = pm == null ? PrefixMapping.Extended : pm;
        SparqlQueryParserWrapperSelectShortForm parser = SparqlQueryParserWrapperSelectShortForm.wrap((Function)SparqlQueryParserImpl.create((Syntax)Syntax.syntaxARQ, (Prologue)new Prologue(pm)));
        Query query = (Query)parser.apply((Object)str);
        Concept result = Concept.createFromQuery(query);
        return result;
    }

    public static Concept parseOld(String str, PrefixMapping pm) {
        String[] splits = str.split("\\|", 2);
        if (splits.length != 2) {
            throw new RuntimeException("Invalid string: " + str);
        }
        String varName = splits[0].trim();
        if (varName.charAt(0) != '?') {
            throw new RuntimeException("var name must start with '?'");
        }
        varName = varName.substring(1);
        Concept result = Concept.create(splits[1], varName, pm);
        return result;
    }

    public static Concept create(String prologueStr, String varName, String elementStr) {
        SparqlQueryParserImpl queryParser = SparqlQueryParserImpl.create((Syntax)Syntax.syntaxSPARQL_10);
        Concept result = Concept.create(prologueStr, varName, elementStr, (Function<String, Query>)queryParser);
        return result;
    }

    public static Concept create(String prologueStr, String varName, String elementStr, Function<String, Query> queryParser) {
        SparqlPrologueParserImpl prologueParser = new SparqlPrologueParserImpl(queryParser);
        Prologue prologue = (Prologue)prologueParser.apply((Object)prologueStr);
        PrefixMapping prefixMapping = prologue.getPrefixMapping();
        Concept result = Concept.create(elementStr, varName, prefixMapping);
        return result;
    }

    public static Concept create(String elementStr, String varName) {
        Concept result = Concept.create(elementStr, varName, (PrefixMapping)null);
        return result;
    }

    public static Concept create(String elementStr, String varName, PrefixMapping prefixMapping) {
        ElementGroup group;
        List elements;
        Var var = Var.alloc((String)varName);
        Element element = Concept.parseElement(elementStr, prefixMapping);
        if (element instanceof ElementGroup && (elements = (group = (ElementGroup)element).getElements()).size() == 1) {
            element = (Element)elements.get(0);
        }
        Concept result = new Concept(element, var);
        return result;
    }

    public static Concept createIris(String varName, String ... iris) {
        List<Node> nodes = Arrays.asList(iris).stream().map(NodeFactory::createURI).collect(Collectors.toList());
        return Concept.create(Var.alloc((String)varName), nodes);
    }

    public static Concept createNodes(Node ... nodes) {
        return Concept.create(Arrays.asList(nodes));
    }

    public static Concept create(Iterable<Node> nodes) {
        return Concept.create(Vars.s, nodes);
    }

    public static Concept create(String varName, Node ... nodes) {
        return Concept.create(Var.alloc((String)varName), nodes);
    }

    public static Concept create(Var var, Node ... nodes) {
        return Concept.create(var, Arrays.asList(nodes));
    }

    public static Concept create(Var var, Iterable<Node> nodes) {
        ElementData elt = new ElementData(Collections.singletonList(var), Streams.stream(nodes).map(n -> BindingFactory.binding((Var)var, (Node)n)).collect(Collectors.toList()));
        return new Concept((Element)elt, Vars.s);
    }

    public static Element parseElement(String elementStr, PrefixMapping prefixMapping) {
        boolean isEnclosed;
        Object tmp = elementStr.trim();
        boolean bl = isEnclosed = ((String)tmp).startsWith("{") && ((String)tmp).endsWith("}");
        if (!isEnclosed) {
            tmp = "{" + (String)tmp + "}";
        }
        tmp = "SELECT * " + (String)tmp;
        Query query = new Query();
        if (prefixMapping != null) {
            query.setPrefixMapping(prefixMapping);
        }
        ParserSPARQL11 parser = new ParserSPARQL11();
        parser.parse(query, (String)tmp);
        Element result = query.getQueryPattern();
        return result;
    }

    @Override
    public Concept applyNodeTransform(NodeTransform nodeTransform) {
        Var tmpVar = (Var)nodeTransform.apply((Object)this.var);
        Element e = ElementUtils.applyNodeTransform((Element)this.element, (NodeTransform)nodeTransform);
        Var v = tmpVar == null ? this.var : tmpVar;
        Concept result = new Concept(e, v);
        return result;
    }

    public Concept(Element element, Var var) {
        this.element = element;
        this.var = var;
    }

    public Concept(List<Element> elements, Var var) {
        ElementGroup group = new ElementGroup();
        for (Element item : elements) {
            if (item instanceof ElementTriplesBlock) {
                ElementTriplesBlock tmp = (ElementTriplesBlock)item;
                for (Triple t : tmp.getPattern()) {
                    group.addTriplePattern(t);
                }
                continue;
            }
            group.addElement(item);
        }
        this.element = group;
        this.var = var;
    }

    @Override
    public Element getElement() {
        return this.element;
    }

    @Override
    public List<Element> getElements() {
        return ElementUtils.toElementList((Element)this.element);
    }

    @Override
    public Var getVar() {
        return this.var;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.element == null ? 0 : this.element.hashCode());
        result = 31 * result + (this.var == null ? 0 : this.var.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Concept other = (Concept)obj;
        if (this.element == null ? other.element != null : !this.element.equals((Object)other.element)) {
            return false;
        }
        return !(this.var == null ? other.var != null : !this.var.equals((Object)other.var));
    }

    public String toString() {
        return "Concept [element=" + this.element + ", var=" + this.var + "]";
    }
}

