/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.io.input;

import com.google.common.collect.AbstractIterator;
import java.io.IOException;
import java.util.Iterator;
import org.aksw.commons.io.buffer.array.ArrayOps;
import org.aksw.commons.io.input.SequentialReader;

public class SequentialReaderIterator<T>
extends AbstractIterator<T> {
    protected SequentialReader<T[]> reader;
    protected ArrayOps<T[]> arrayOps;
    protected T[] array;
    protected int arrayLength;
    protected int currentOffset;
    protected int currentDataLength;

    public SequentialReaderIterator(ArrayOps<T[]> arrayOps, SequentialReader<T[]> reader) {
        this.arrayOps = arrayOps;
        this.reader = reader;
        this.arrayLength = 4096;
        this.array = arrayOps.create(this.arrayLength);
        this.currentDataLength = 0;
        this.currentOffset = 0;
    }

    public static <T> Iterator<T> create(ArrayOps<T[]> arrayOps, SequentialReader<T[]> reader) {
        return new SequentialReaderIterator<T>(arrayOps, reader);
    }

    protected T computeNext() {
        Object tmp;
        if (this.currentOffset >= this.currentDataLength) {
            try {
                this.currentDataLength = this.reader.read(this.array, 0, this.arrayLength);
                this.currentOffset = 0;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.currentDataLength == -1) {
            tmp = this.endOfData();
        } else {
            tmp = this.arrayOps.get(this.array, this.currentOffset);
            if (tmp == null) {
                throw new NullPointerException("Unexpected null value");
            }
        }
        ++this.currentOffset;
        Object result = tmp;
        return (T)result;
    }
}

