/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.io.input;

import java.io.IOException;
import java.util.Iterator;
import java.util.stream.Stream;
import org.aksw.commons.io.buffer.array.ArrayOps;
import org.aksw.commons.io.input.SequentialReader;
import org.aksw.commons.util.closeable.AutoCloseableWithLeakDetectionBase;

public class SequentialReaderFromStream<T>
extends AutoCloseableWithLeakDetectionBase
implements SequentialReader<T[]> {
    protected ArrayOps<T[]> arrayOps;
    protected Stream<T> stream = null;
    protected Iterator<T> iterator = null;

    public SequentialReaderFromStream(ArrayOps<T[]> arrayOps, Stream<T> stream) {
        this.arrayOps = arrayOps;
        this.stream = stream;
        this.iterator = stream.iterator();
    }

    public void closeActual() throws IOException {
        if (this.stream != null) {
            this.stream.close();
        }
    }

    @Override
    public int read(T[] array, int position, int length) throws IOException {
        int i;
        this.ensureOpen();
        for (i = 0; i < length && this.iterator.hasNext(); ++i) {
            T value = this.iterator.next();
            this.arrayOps.set(array, position + i, value);
        }
        int result = i == 0 && length > 0 ? -1 : i;
        return result;
    }
}

