/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.io.cache;

import com.google.common.base.Preconditions;
import com.google.common.collect.ContiguousSet;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeMap;
import com.google.common.collect.TreeRangeSet;
import com.google.common.math.LongMath;
import com.google.common.primitives.Ints;
import java.io.IOException;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.function.LongSupplier;
import org.aksw.commons.io.cache.AdvancedRangeCacheImpl;
import org.aksw.commons.io.cache.RangeRequestWorkerImpl;
import org.aksw.commons.io.input.SequentialReader;
import org.aksw.commons.io.slice.Slice;
import org.aksw.commons.io.slice.SliceAccessor;
import org.aksw.commons.util.closeable.AutoCloseableWithLeakDetectionBase;
import org.aksw.commons.util.lock.LockUtils;
import org.aksw.commons.util.range.RangeUtils;
import org.aksw.commons.util.slot.Slot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SequentialReaderFromSliceImpl<A>
extends AutoCloseableWithLeakDetectionBase
implements SequentialReader<A> {
    private static final Logger logger = LoggerFactory.getLogger(SequentialReaderFromSliceImpl.class);
    protected Slice<A> slice;
    protected AdvancedRangeCacheImpl<A> cache;
    protected SliceAccessor<A> pageRange;
    protected Range<Long> requestRange;
    protected long nextCheckpointOffset;
    protected long currentOffset;
    protected int maxReadAheadItemCount = 100;
    protected Map<RangeRequestWorkerImpl<A>, Slot<Long>> workerToSlot = new IdentityHashMap<RangeRequestWorkerImpl<A>, Slot<Long>>();
    protected long maxRedundantFetchSize = 1000L;

    public SequentialReaderFromSliceImpl(AdvancedRangeCacheImpl<A> cache, Range<Long> requestRange) {
        this.requestRange = requestRange;
        this.cache = cache;
        this.slice = cache.getSlice();
        this.pageRange = this.slice.newSliceAccessor();
        ContiguousSet set = ContiguousSet.create(requestRange, (DiscreteDomain)DiscreteDomain.longs());
        this.nextCheckpointOffset = this.currentOffset = ((Long)set.first()).longValue();
    }

    public long getNextCheckpointOffset() {
        return this.nextCheckpointOffset;
    }

    public SliceAccessor<A> getPageRange() {
        return this.pageRange;
    }

    protected void checkpoint(long n) {
        Preconditions.checkArgument((n >= 0L ? 1 : 0) != 0, (Object)"Argument must not be negative");
        this.clearPassedSlots();
        long start = this.nextCheckpointOffset;
        long end = start + n;
        Range claimAheadRange = Range.closedOpen((Comparable)Long.valueOf(start), (Comparable)Long.valueOf(end));
        LockUtils.runWithLock((Lock)this.cache.getExecutorCreationReadLock(), () -> {
            LockUtils.runWithLock((Lock)this.slice.getReadWriteLock().readLock(), () -> {
                RangeSet<Long> gaps = this.slice.getGaps((Range<Long>)claimAheadRange);
                this.processGaps(gaps, start, end);
            });
            this.nextCheckpointOffset = end;
        });
    }

    public SequentialReaderFromSliceImpl(AdvancedRangeCacheImpl<A> cache, long nextCheckpointOffset, LongSupplier offsetSupplier) {
        this.cache = cache;
        this.slice = cache.getSlice();
        this.pageRange = this.slice.newSliceAccessor();
        this.nextCheckpointOffset = nextCheckpointOffset;
    }

    public void clearPassedSlots() {
        long currentOffset = this.nextCheckpointOffset;
        Iterator<Slot<Long>> it = this.workerToSlot.values().iterator();
        while (it.hasNext()) {
            Slot<Long> slot = it.next();
            Long value = (Long)slot.getSupplier().get();
            if (value >= currentOffset) continue;
            logger.debug("Clearing slot for offset " + slot.getSupplier().get() + " because current offset " + currentOffset + " is higher");
            slot.close();
            it.remove();
        }
    }

    protected void scheduleWorkerToGaps(RangeSet<Long> gaps) {
        HashMap<Long, RangeRequestWorkerImpl<A>> offsetToWorker = new HashMap<Long, RangeRequestWorkerImpl<A>>();
        TreeMap<Long, Long> offsetToEndpoint = new TreeMap<Long, Long>();
        for (RangeRequestWorkerImpl<A> e : this.cache.getExecutors()) {
            Long priorEndpoint;
            long workerEnd;
            long workerStart = e.getCurrentOffset();
            if (workerStart == (workerEnd = e.getEndOffset()) || (priorEndpoint = (Long)offsetToEndpoint.get(workerStart)) != null && priorEndpoint >= workerEnd) continue;
            offsetToWorker.put(workerStart, e);
            offsetToEndpoint.put(workerStart, workerEnd);
        }
        NavigableMap workerSchedules = RangeUtils.scheduleRangeSupply(offsetToEndpoint, gaps, (long)this.maxRedundantFetchSize, (long)this.cache.requestLimit);
        for (Map.Entry schedule : workerSchedules.entrySet()) {
            RangeRequestWorkerImpl worker;
            long start = (Long)schedule.getKey();
            long end = (Long)schedule.getValue();
            long length = end - start;
            Map.Entry workerRange = offsetToEndpoint.floorEntry(start);
            Long workerStart = workerRange == null || (Long)workerRange.getValue() < end ? null : workerRange.getKey();
            RangeRequestWorkerImpl rangeRequestWorkerImpl = worker = workerStart == null ? null : (RangeRequestWorkerImpl)offsetToWorker.get(workerStart);
            if (worker == null) {
                Map.Entry<RangeRequestWorkerImpl<A>, Slot<Long>> workerAndSlot = this.cache.newExecutor(start, length);
                this.workerToSlot.put(workerAndSlot.getKey(), workerAndSlot.getValue());
                continue;
            }
            Slot<Long> slot = this.workerToSlot.get(worker);
            if (slot == null) {
                slot = worker.newDemandSlot();
                this.workerToSlot.put(worker, slot);
            }
            slot.set((Object)end);
        }
    }

    protected void processGaps(RangeSet<Long> gaps, long start, long end) {
        this.scheduleWorkerToGaps(gaps);
    }

    protected void closeActual() {
        logger.debug("Releasing slots: " + this.workerToSlot);
        this.workerToSlot.values().forEach(Slot::close);
        this.workerToSlot.clear();
        this.pageRange.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int read(A tgt, int tgtOffset, int length) throws IOException {
        this.ensureOpen();
        if (length == 0) {
            return 0;
        }
        long requestedEndOffset = this.currentOffset + (long)length;
        long maxEndOffset = LongMath.saturatedAdd((long)((Long)ContiguousSet.create(this.requestRange, (DiscreteDomain)DiscreteDomain.longs()).last()), (long)1L);
        long effectiveEndOffset = Math.min(requestedEndOffset, maxEndOffset);
        if (this.currentOffset >= effectiveEndOffset) {
            return -1;
        }
        Range totalReadRange = Range.closedOpen((Comparable)Long.valueOf(this.currentOffset), (Comparable)Long.valueOf(effectiveEndOffset));
        if (effectiveEndOffset >= this.nextCheckpointOffset) {
            try {
                int numItemsUntilRequestRangeEnd = Ints.saturatedCast((long)(effectiveEndOffset - this.nextCheckpointOffset));
                int n = Math.min(length + this.maxReadAheadItemCount, numItemsUntilRequestRangeEnd);
                this.checkpoint(n);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        this.pageRange.claimByOffsetRange(this.currentOffset, effectiveEndOffset);
        ReadWriteLock rwl = this.slice.getReadWriteLock();
        Lock readLock = rwl.readLock();
        readLock.lock();
        try {
            int result;
            RangeSet<Long> loadedRanges = this.slice.getLoadedRanges();
            TreeRangeMap failedRanges = TreeRangeMap.create();
            Range entry = null;
            List failures = null;
            long maximumSize = this.slice.getMaximumKnownSize();
            if (this.currentOffset >= maximumSize) {
                result = -1;
            } else {
                failures = (List)failedRanges.get((Comparable)Long.valueOf(this.currentOffset));
                entry = loadedRanges.rangeContaining((Comparable)Long.valueOf(this.currentOffset));
                if (entry == null && failures == null) {
                    Lock writeLock = rwl.writeLock();
                    readLock.unlock();
                    writeLock.lock();
                    try {
                        long knownMaxSize;
                        while ((entry = loadedRanges.rangeContaining((Comparable)Long.valueOf(this.currentOffset))) == null && ((knownMaxSize = this.slice.getMaximumKnownSize()) < 0L || this.currentOffset < knownMaxSize)) {
                            boolean enableSanityCheck = false;
                            if (enableSanityCheck) {
                                TreeRangeSet sanityCheck = TreeRangeSet.create((Iterable)loadedRanges.asRanges());
                                Range f = sanityCheck.rangeContaining((Comparable)Long.valueOf(this.currentOffset));
                                System.out.println(String.format("%s.rangeContaining(%d) -> %s", sanityCheck, this.currentOffset, f));
                                if (entry == null && f != null) {
                                    throw new RuntimeException("bug in our range set view found: offset " + this.currentOffset + " incorrectly not in " + f);
                                }
                            }
                            try {
                                if (logger.isTraceEnabled()) {
                                    logger.trace(String.format("Awaiting data at offset %d for entry %s of a slice of known max size %d with loaded ranges %s", this.currentOffset, entry, knownMaxSize, this.slice.getLoadedRanges()));
                                }
                                this.slice.getHasDataCondition().await();
                                if (!logger.isTraceEnabled()) continue;
                                logger.trace("Woke up after awaiting more data");
                            }
                            catch (InterruptedException e) {
                                throw new RuntimeException(e);
                            }
                        }
                    }
                    finally {
                        readLock.lock();
                        writeLock.unlock();
                    }
                }
            }
            if (failures != null && !failures.isEmpty()) {
                throw new RuntimeException("Attempt to read a range of data marked with an error", (Throwable)failures.get(0));
            }
            if (entry == null) {
                this.close();
                result = -1;
                return result;
            }
            Range range = totalReadRange.intersection(entry);
            ContiguousSet cset = ContiguousSet.create((Range)range, (DiscreteDomain)DiscreteDomain.longs());
            int readLength = cset.size();
            if (readLength == 0) {
                result = -1;
                return result;
            }
            long startAbs = (Long)cset.first();
            long endAbs = startAbs + (long)readLength;
            result = this.pageRange.unsafeRead(tgt, tgtOffset, this.currentOffset, readLength);
            if (result < 0) return result;
            this.currentOffset += (long)result;
            return result;
        }
        finally {
            readLock.unlock();
        }
    }
}

