/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.io.cache;

import com.google.common.collect.Range;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.MoreExecutors;
import java.time.Duration;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.aksw.commons.io.cache.RangeRequestWorkerImpl;
import org.aksw.commons.io.cache.SequentialReaderFromSliceImpl;
import org.aksw.commons.io.input.SequentialReader;
import org.aksw.commons.io.input.SequentialReaderSource;
import org.aksw.commons.io.slice.Slice;
import org.aksw.commons.util.slot.Slot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdvancedRangeCacheImpl<T>
implements SequentialReaderSource<T> {
    private static final Logger logger = LoggerFactory.getLogger(AdvancedRangeCacheImpl.class);
    protected SequentialReaderSource<T> dataSource;
    protected Slice<T> slice;
    protected ReentrantLock workerCreationLock = new ReentrantLock();
    protected Set<RangeRequestWorkerImpl<T>> executors = Collections.synchronizedSet(Sets.newIdentityHashSet());
    protected long requestLimit;
    protected Duration terminationDelay;
    protected int workerBulkSize;
    protected ExecutorService executorService = MoreExecutors.getExitingExecutorService((ThreadPoolExecutor)((ThreadPoolExecutor)Executors.newCachedThreadPool()));

    public AdvancedRangeCacheImpl(SequentialReaderSource<T> dataSource, Slice<T> slice, long requestLimit, int workerBulkSize, Duration terminationDelay) {
        this.dataSource = dataSource;
        this.slice = slice;
        this.requestLimit = requestLimit;
        this.workerBulkSize = workerBulkSize;
        this.terminationDelay = terminationDelay;
    }

    public static <A> AdvancedRangeCacheImpl<A> create(SequentialReaderSource<A> dataSource, Slice<A> slice, long requestLimit, int workerBulkSize, Duration terminationDelay) {
        return new AdvancedRangeCacheImpl<A>(dataSource, slice, requestLimit, workerBulkSize, terminationDelay);
    }

    public SequentialReaderSource<T> getDataSource() {
        return this.dataSource;
    }

    public Slice<T> getSlice() {
        return this.slice;
    }

    public Set<RangeRequestWorkerImpl<T>> getExecutors() {
        return this.executors;
    }

    public Lock getExecutorCreationReadLock() {
        return this.workerCreationLock;
    }

    public Map.Entry<RangeRequestWorkerImpl<T>, Slot<Long>> newExecutor(long offset, long initialLength) {
        RangeRequestWorkerImpl worker = new RangeRequestWorkerImpl(this, offset, this.requestLimit, this.workerBulkSize, this.terminationDelay);
        Slot<Long> slot = worker.newDemandSlot();
        slot.set((Object)(offset + initialLength));
        this.executors.add(worker);
        logger.debug(String.format("New worker created with initial schedule of offset %1$d and length %2$d", offset, initialLength));
        this.executorService.submit(worker);
        return new AbstractMap.SimpleEntry<RangeRequestWorkerImpl<T>, Slot<Long>>(worker, slot);
    }

    void removeExecutor(RangeRequestWorkerImpl<T> worker) {
        this.executors.remove(worker);
    }

    @Override
    public SequentialReader<T> newInputStream(Range<Long> range) {
        SequentialReaderFromSliceImpl result = new SequentialReaderFromSliceImpl(this, range);
        return result;
    }

    public static class Builder<A> {
        protected SequentialReaderSource<A> dataSource;
        protected Slice<A> slice;
        protected int workerBulkSize;
        protected long requestLimit;
        protected Duration terminationDelay;

        public static <A> Builder<A> create() {
            return new Builder<A>();
        }

        public SequentialReaderSource<A> getDataSource() {
            return this.dataSource;
        }

        public Builder<A> setDataSource(SequentialReaderSource<A> dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public Slice<A> getSlice() {
            return this.slice;
        }

        public Builder<A> setSlice(Slice<A> slice) {
            this.slice = slice;
            return this;
        }

        public long getRequestLimit() {
            return this.requestLimit;
        }

        public Builder<A> setRequestLimit(long requestLimit) {
            this.requestLimit = requestLimit;
            return this;
        }

        public int getWorkerBulkSize() {
            return this.workerBulkSize;
        }

        public Builder<A> setWorkerBulkSize(int workerBulkSize) {
            this.workerBulkSize = workerBulkSize;
            return this;
        }

        public Duration getTerminationDelay() {
            return this.terminationDelay;
        }

        public Builder<A> setTerminationDelay(Duration terminationDelay) {
            this.terminationDelay = terminationDelay;
            return this;
        }

        public AdvancedRangeCacheImpl<A> build() {
            return AdvancedRangeCacheImpl.create(this.dataSource, this.slice, this.requestLimit, this.workerBulkSize, this.terminationDelay);
        }
    }
}

