/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.io.cache;

import java.time.Duration;
import org.aksw.commons.io.cache.AdvancedRangeCacheConfig;

public class AdvancedRangeCacheConfigImpl
implements AdvancedRangeCacheConfig {
    protected int pageSize;
    protected long maxRequestSize;
    protected Duration terminationDelay;
    protected int internalWorkerSize;

    public AdvancedRangeCacheConfigImpl() {
    }

    public AdvancedRangeCacheConfigImpl(int pageSize, int maxRequestSize, Duration terminationDelay, int internalWorkerSize) {
        this.pageSize = pageSize;
        this.maxRequestSize = maxRequestSize;
        this.terminationDelay = terminationDelay;
        this.internalWorkerSize = internalWorkerSize;
    }

    public static AdvancedRangeCacheConfigImpl createDefault() {
        return new AdvancedRangeCacheConfigImpl(10000, 10000, Duration.ofSeconds(2L), 128);
    }

    @Override
    public int getPageSize() {
        return this.pageSize;
    }

    public AdvancedRangeCacheConfigImpl setPageSize(int pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Override
    public long getMaxRequestSize() {
        return this.maxRequestSize;
    }

    public AdvancedRangeCacheConfigImpl setMaxRequestSize(long maxRequestSize) {
        this.maxRequestSize = maxRequestSize;
        return this;
    }

    @Override
    public Duration getTerminationDelay() {
        return this.terminationDelay;
    }

    public AdvancedRangeCacheConfigImpl setTerminationDelay(Duration terminationDelay) {
        this.terminationDelay = terminationDelay;
        return this;
    }

    @Override
    public int getInternalWorkerSize() {
        return this.internalWorkerSize;
    }

    public void setInternalWorkerSize(int internalWorkerSize) {
        this.internalWorkerSize = internalWorkerSize;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.internalWorkerSize;
        result = 31 * result + (int)(this.maxRequestSize ^ this.maxRequestSize >>> 32);
        result = 31 * result + this.pageSize;
        result = 31 * result + (this.terminationDelay == null ? 0 : this.terminationDelay.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AdvancedRangeCacheConfigImpl other = (AdvancedRangeCacheConfigImpl)obj;
        if (this.internalWorkerSize != other.internalWorkerSize) {
            return false;
        }
        if (this.maxRequestSize != other.maxRequestSize) {
            return false;
        }
        if (this.pageSize != other.pageSize) {
            return false;
        }
        return !(this.terminationDelay == null ? other.terminationDelay != null : !this.terminationDelay.equals(other.terminationDelay));
    }

    public String toString() {
        return "AdvancedRangeCacheConfigImpl [pageSize=" + this.pageSize + ", maxRequestSize=" + this.maxRequestSize + ", terminationDelay=" + this.terminationDelay + ", internalWorkerSize=" + this.internalWorkerSize + "]";
    }
}

