/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.io.buffer.range;

import com.google.common.collect.ContiguousSet;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import com.google.common.primitives.Ints;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.aksw.commons.collection.rangeset.RangeSetOps;
import org.aksw.commons.collection.rangeset.RangeSetUnion;
import org.aksw.commons.io.buffer.array.ArrayOps;
import org.aksw.commons.io.buffer.plain.Buffer;
import org.aksw.commons.io.buffer.range.RangeBuffer;

public class RangeBufferUnion<A>
implements RangeBuffer<A> {
    protected RangeBuffer<A> first;
    protected RangeBuffer<A> second;
    protected RangeSet<Long> unionRanges;

    public RangeBufferUnion(RangeBuffer<A> first, RangeBuffer<A> second) {
        this.first = first;
        this.second = second;
        this.unionRanges = RangeSetUnion.create(first.getRanges(), second.getRanges());
    }

    public static <A> RangeBufferUnion<A> create(RangeBuffer<A> first, RangeBuffer<A> second) {
        return new RangeBufferUnion<A>(first, second);
    }

    @Override
    public void write(long offsetInBuffer, A arrayWithItemsOfTypeT, int arrOffset, int arrLength) throws IOException {
        this.first.write(offsetInBuffer, arrayWithItemsOfTypeT, arrOffset, arrLength);
    }

    @Override
    public void put(long offset, Object item) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ArrayOps<A> getArrayOps() {
        return this.first.getArrayOps();
    }

    @Override
    public RangeSet<Long> getCoveredRanges(Range<Long> localRange) {
        RangeSet<Long> firstCovers = this.first.getCoveredRanges(localRange);
        RangeSet<Long> secondCovers = this.second.getCoveredRanges(localRange);
        RangeSetUnion result = RangeSetOps.union(firstCovers, secondCovers);
        return result;
    }

    @Override
    public int readInto(A tgt, int tgtOffset, long srcOffset, int length) throws IOException {
        int i;
        long end = srcOffset + (long)length;
        Range totalLocalReadRange = Range.closedOpen((Comparable)Long.valueOf(srcOffset), (Comparable)Long.valueOf(end));
        TreeRangeSet gaps = TreeRangeSet.create();
        gaps.add(totalLocalReadRange);
        List<RangeBuffer> buffers = Arrays.asList(this.first, this.second);
        ArrayList<TreeRangeSet> readSchedules = new ArrayList<TreeRangeSet>();
        for (i = 0; i < buffers.size() && !gaps.isEmpty(); ++i) {
            TreeRangeSet schedule = TreeRangeSet.create();
            readSchedules.add(schedule);
            RangeBuffer buffer = buffers.get(i);
            for (Range gap : new ArrayList(gaps.asRanges())) {
                RangeSet<Long> contribs = buffer.getCoveredRanges((Range<Long>)gap);
                gaps.removeAll(contribs);
                schedule.addAll(contribs);
            }
        }
        if (!gaps.isEmpty()) {
            throw new RuntimeException("Attempt to read over gaps at: " + (RangeSet)gaps);
        }
        for (i = 0; i < readSchedules.size(); ++i) {
            RangeBuffer buffer = buffers.get(i);
            RangeSet schedule = (RangeSet)readSchedules.get(i);
            for (Range range : schedule.asRanges()) {
                ContiguousSet tmp = ContiguousSet.create((Range)range, (DiscreteDomain)DiscreteDomain.longs());
                long readStart = (Long)tmp.first();
                int tgtPos = Ints.checkedCast((long)(readStart - srcOffset));
                int l = tmp.size();
                int tgtStart = tgtOffset + tgtPos;
                buffer.readInto(tgt, tgtStart, readStart, l);
                if (this.first.getArrayOps().get(tgt, tgtStart) != null) continue;
                throw new NullPointerException("Unexpected null read");
            }
        }
        return length;
    }

    @Override
    public Object get(long index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getCapacity() {
        return this.first.getCapacity();
    }

    @Override
    public RangeSet<Long> getRanges() {
        return this.unionRanges;
    }

    @Override
    public Long getOffsetInRanges() {
        long s;
        long f = this.first.getOffsetInRanges();
        Long result = f == (s = this.second.getOffsetInRanges().longValue()) ? Long.valueOf(f) : null;
        return result;
    }

    public String toString() {
        return this.getRanges().toString();
    }

    @Override
    public Buffer<A> getBackingBuffer() {
        return null;
    }
}

