/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.io.buffer.plain;

import com.google.common.math.LongMath;
import java.io.IOException;
import org.aksw.commons.io.buffer.array.ArrayOps;
import org.aksw.commons.io.buffer.plain.Buffer;

public class SubBuffer<A>
implements Buffer<A> {
    protected Buffer<A> backend;
    protected long start;
    protected long length;

    public SubBuffer(Buffer<A> backend, long start, long length) {
        this.backend = backend;
        this.start = start;
        this.length = length;
    }

    @Override
    public void write(long offsetInBuffer, A arrayWithItemsOfTypeT, int arrOffset, int arrLength) throws IOException {
        if (offsetInBuffer - this.start + (long)arrLength > this.length) {
            throw new RuntimeException("Attempt to read beyond buffer capacity");
        }
        this.backend.write(LongMath.checkedAdd((long)this.start, (long)offsetInBuffer), arrayWithItemsOfTypeT, arrOffset, arrLength);
    }

    @Override
    public int readInto(A tgt, int tgtOffset, long srcOffset, int length) throws IOException {
        return this.backend.readInto(tgt, tgtOffset, LongMath.checkedAdd((long)this.start, (long)srcOffset), length);
    }

    @Override
    public long getCapacity() {
        return this.length;
    }

    @Override
    public ArrayOps<A> getArrayOps() {
        return this.backend.getArrayOps();
    }

    @Override
    public Buffer<A> slice(long offset, long length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void put(long offset, Object item) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object get(long index) {
        throw new UnsupportedOperationException();
    }
}

