/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.io.buffer.array;

import com.google.common.primitives.Ints;
import org.aksw.commons.io.buffer.array.ArrayOps;
import org.aksw.commons.io.buffer.plain.Buffer;

public class ArrayBuffer<A>
implements Buffer<A> {
    protected ArrayOps<A> arrayOps;
    protected A array;

    public ArrayBuffer(ArrayOps<A> arrayOps, int size) {
        this(arrayOps, arrayOps.create(size));
    }

    public ArrayBuffer(ArrayOps<A> arrayOps, A array) {
        this.arrayOps = arrayOps;
        this.array = array;
    }

    public static <A> ArrayBuffer<A> create(ArrayOps<A> arrayOps, int size) {
        return new ArrayBuffer<int>((ArrayOps<int>)arrayOps, size);
    }

    public static <A> ArrayBuffer<A> create(ArrayOps<A> arrayOps, A array) {
        return new ArrayBuffer<A>(arrayOps, array);
    }

    @Override
    public void write(long offsetInBuffer, A arrayWithItemsOfTypeT, int arrOffset, int arrLength) {
        int offsetInBufferInt = Ints.checkedCast((long)offsetInBuffer);
        this.arrayOps.copy(arrayWithItemsOfTypeT, arrOffset, this.array, offsetInBufferInt, arrLength);
    }

    @Override
    public long getCapacity() {
        return this.arrayOps.length(this.array);
    }

    @Override
    public ArrayOps<A> getArrayOps() {
        return this.arrayOps;
    }

    @Override
    public int readInto(A tgt, int tgtOffset, long srcOffset, int length) {
        int srcOffsetInt = Ints.checkedCast((long)srcOffset);
        this.arrayOps.copy(this.array, srcOffsetInt, tgt, tgtOffset, length);
        return length;
    }

    @Override
    public void put(long offset, Object item) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object get(long index) {
        throw new UnsupportedOperationException();
    }
}

