/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.api.runtime.event.impl;

import java.util.UUID;
import org.activiti.api.model.shared.event.RuntimeEvent;

public abstract class RuntimeEventImpl<ENTITY_TYPE, EVENT_TYPE extends Enum<?>>
implements RuntimeEvent<ENTITY_TYPE, EVENT_TYPE> {
    private String id;
    private Long timestamp;
    private String processInstanceId;
    private String processDefinitionId;
    private String processDefinitionKey;
    private Integer processDefinitionVersion;
    private String businessKey;
    private String parentProcessInstanceId;
    private ENTITY_TYPE entity;

    public RuntimeEventImpl() {
        this.id = UUID.randomUUID().toString();
        this.timestamp = System.currentTimeMillis();
    }

    public RuntimeEventImpl(ENTITY_TYPE entity) {
        this();
        this.entity = entity;
    }

    public RuntimeEventImpl(String id, Long timestamp, ENTITY_TYPE entity) {
        this.id = id;
        this.timestamp = timestamp;
        this.entity = entity;
    }

    public String getId() {
        return this.id;
    }

    public ENTITY_TYPE getEntity() {
        return this.entity;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public String getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    public Integer getProcessDefinitionVersion() {
        return this.processDefinitionVersion;
    }

    public String getBusinessKey() {
        return this.businessKey;
    }

    public String getParentProcessInstanceId() {
        return this.parentProcessInstanceId;
    }

    public void setParentProcessInstanceId(String parentProcessInstanceId) {
        this.parentProcessInstanceId = parentProcessInstanceId;
    }

    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    public void setProcessDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
    }

    public void setProcessDefinitionVersion(Integer processDefinitionVersion) {
        this.processDefinitionVersion = processDefinitionVersion;
    }

    public void setBusinessKey(String businessKey) {
        this.businessKey = businessKey;
    }

    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public String toString() {
        return "id='" + this.id + "', timestamp=" + this.timestamp + ", entity=" + this.entity;
    }
}

