/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.spring.boot;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.activiti.spring.boot.ActivitiProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.ResourcePatternResolver;

public class ProcessDefinitionResourceFinder {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessDefinitionResourceFinder.class);
    private ActivitiProperties activitiProperties;
    private ResourcePatternResolver resourceLoader;

    public ProcessDefinitionResourceFinder(ActivitiProperties activitiProperties, ResourcePatternResolver resourceLoader) {
        this.activitiProperties = activitiProperties;
        this.resourceLoader = resourceLoader;
    }

    public List<Resource> discoverProcessDefinitionResources() throws IOException {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        if (this.activitiProperties.isCheckProcessDefinitions()) {
            for (String suffix : this.activitiProperties.getProcessDefinitionLocationSuffixes()) {
                String path = this.activitiProperties.getProcessDefinitionLocationPrefix() + suffix;
                resources.addAll(Arrays.asList(this.resourceLoader.getResources(path)));
            }
            if (resources.isEmpty()) {
                LOGGER.info("No process definitions were found for auto-deployment in the location `" + this.activitiProperties.getProcessDefinitionLocationPrefix() + "`");
            } else {
                List resourcesNames = resources.stream().map(Resource::getFilename).collect(Collectors.toList());
                LOGGER.info("The following process definition files will be deployed: " + resourcesNames);
            }
        }
        return resources;
    }
}

